/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.util.containers.Queue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.MemberDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorByExpressionSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperCall;
import org.jetbrains.jet.lang.psi.JetDelegatorToSuperClass;
import org.jetbrains.jet.lang.psi.JetDelegatorToThisCall;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetElementImpl;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetNamedDeclarationStub;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwnerStub;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.ControlFlowAnalyzer;
import org.jetbrains.jet.lang.resolve.DeclarationsChecker;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.ObservableBindingTrace;
import org.jetbrains.jet.lang.resolve.ScriptBodyResolver;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.TraceEntryFilter;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.util.CallMaker;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeUtils;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.DelegatedPropertyUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.util.Box;
import org.jetbrains.jet.util.lazy.ReenteringLazyValueComputationException;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class BodyResolver {
    @NotNull
    private BodiesResolveContext context;
    @NotNull
    private TopDownAnalysisParameters topDownAnalysisParameters;
    @NotNull
    private DescriptorResolver descriptorResolver;
    @NotNull
    private ScriptBodyResolver scriptBodyResolverResolver;
    @NotNull
    private ExpressionTypingServices expressionTypingServices;
    @NotNull
    private CallResolver callResolver;
    @NotNull
    private ObservableBindingTrace trace;
    @NotNull
    private ControlFlowAnalyzer controlFlowAnalyzer;
    @NotNull
    private DeclarationsChecker declarationsChecker;

    public void setTopDownAnalysisParameters(@NotNull TopDownAnalysisParameters topDownAnalysisParameters) {
        this.topDownAnalysisParameters = topDownAnalysisParameters;
    }

    public void setDescriptorResolver(@NotNull DescriptorResolver descriptorResolver) {
        this.descriptorResolver = descriptorResolver;
    }

    public void setScriptBodyResolverResolver(@NotNull ScriptBodyResolver scriptBodyResolverResolver) {
        this.scriptBodyResolverResolver = scriptBodyResolverResolver;
    }

    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        this.expressionTypingServices = expressionTypingServices;
    }

    public void setCallResolver(@NotNull CallResolver callResolver) {
        this.callResolver = callResolver;
    }

    public void setTrace(@NotNull BindingTrace trace) {
        this.trace = new ObservableBindingTrace(trace);
    }

    public void setControlFlowAnalyzer(@NotNull ControlFlowAnalyzer controlFlowAnalyzer) {
        this.controlFlowAnalyzer = controlFlowAnalyzer;
    }

    public void setDeclarationsChecker(@NotNull DeclarationsChecker declarationsChecker) {
        this.declarationsChecker = declarationsChecker;
    }

    public void setContext(@NotNull BodiesResolveContext context) {
        this.context = context;
    }

    private void resolveBehaviorDeclarationBodies(@NotNull BodiesResolveContext bodiesResolveContext) {
        this.context = bodiesResolveContext;
        this.resolveDelegationSpecifierLists();
        this.resolveClassAnnotations();
        this.resolvePropertyDeclarationBodies();
        this.resolveAnonymousInitializers();
        this.resolvePrimaryConstructorParameters();
        this.resolveFunctionBodies();
        this.scriptBodyResolverResolver.resolveScriptBodies();
        if (!this.topDownAnalysisParameters.isDeclaredLocally()) {
            this.computeDeferredTypes();
        }
    }

    public void resolveBodies() {
        this.resolveBehaviorDeclarationBodies(this.context);
        this.controlFlowAnalyzer.process(this.context);
        this.declarationsChecker.process(this.context);
    }

    private void resolveDelegationSpecifierLists() {
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            this.resolveDelegationSpecifierList(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<JetNamedDeclarationStub, MutableClassDescriptor> entry : this.context.getObjects().entrySet()) {
            this.resolveDelegationSpecifierList((JetClassOrObject)((Object)entry.getKey()), entry.getValue());
        }
    }

    private void resolveDelegationSpecifierList(JetClassOrObject jetClass, MutableClassDescriptor descriptor) {
        this.resolveDelegationSpecifierList(jetClass, descriptor, descriptor.getUnsubstitutedPrimaryConstructor(), descriptor.getScopeForSupertypeResolution(), descriptor.getScopeForMemberResolution());
    }

    public void resolveDelegationSpecifierList(@NotNull JetClassOrObject jetClass, final @NotNull ClassDescriptor descriptor, final @Nullable ConstructorDescriptor primaryConstructor, @NotNull JetScope scopeForSupertypeResolution, final @NotNull JetScope scopeForMemberResolution) {
        if (!this.context.completeAnalysisNeeded(jetClass)) {
            return;
        }
        final JetScope scopeForConstructor = primaryConstructor == null ? null : FunctionDescriptorUtil.getFunctionInnerScope(scopeForSupertypeResolution, primaryConstructor, this.trace);
        final ExpressionTypingServices typeInferrer = this.expressionTypingServices;
        final LinkedHashMap<JetTypeReference, JetType> supertypes = Maps.newLinkedHashMap();
        JetVisitorVoid visitor = new JetVisitorVoid(){

            private void recordSupertype(JetTypeReference typeReference, JetType supertype) {
                if (supertype == null) {
                    return;
                }
                supertypes.put(typeReference, supertype);
            }

            @Override
            public void visitDelegationByExpressionSpecifier(JetDelegatorByExpressionSpecifier specifier) {
                JetScope scope;
                JetType type;
                JetExpression delegateExpression;
                ClassDescriptor classDescriptor;
                ClassifierDescriptor declarationDescriptor;
                if (descriptor.getKind() == ClassKind.TRAIT) {
                    BodyResolver.this.trace.report(Errors.DELEGATION_IN_TRAIT.on(specifier));
                }
                JetType supertype = BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, specifier.getTypeReference());
                this.recordSupertype(specifier.getTypeReference(), supertype);
                if (supertype != null && (declarationDescriptor = supertype.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor && (classDescriptor = (ClassDescriptor)declarationDescriptor).getKind() != ClassKind.TRAIT) {
                    BodyResolver.this.trace.report(Errors.DELEGATION_NOT_TO_TRAIT.on(specifier.getTypeReference()));
                }
                if ((delegateExpression = specifier.getDelegateExpression()) != null && (type = typeInferrer.getType(scope = scopeForConstructor == null ? scopeForMemberResolution : scopeForConstructor, delegateExpression, TypeUtils.NO_EXPECTED_TYPE, DataFlowInfo.EMPTY, BodyResolver.this.trace)) != null && supertype != null && !JetTypeChecker.INSTANCE.isSubtypeOf(type, supertype)) {
                    BodyResolver.this.trace.report(Errors.TYPE_MISMATCH.on(delegateExpression, supertype, type));
                }
            }

            @Override
            public void visitDelegationToSuperCallSpecifier(JetDelegatorToSuperCall call) {
                JetTypeReference typeReference;
                JetElementImpl elementToMark;
                JetValueArgumentList valueArgumentList = call.getValueArgumentList();
                JetElementImpl jetElementImpl = elementToMark = valueArgumentList == null ? call : valueArgumentList;
                if (descriptor.getKind() == ClassKind.TRAIT) {
                    BodyResolver.this.trace.report(Errors.SUPERTYPE_INITIALIZED_IN_TRAIT.on(elementToMark));
                }
                if ((typeReference = call.getTypeReference()) == null) {
                    return;
                }
                if (primaryConstructor == null) {
                    assert (descriptor.getKind() == ClassKind.TRAIT);
                    this.recordSupertype(typeReference, BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                    return;
                }
                OverloadResolutionResults<FunctionDescriptor> results = BodyResolver.this.callResolver.resolveFunctionCall(BodyResolver.this.trace, scopeForConstructor, CallMaker.makeCall(ReceiverValue.NO_RECEIVER, null, call), TypeUtils.NO_EXPECTED_TYPE, DataFlowInfo.EMPTY);
                if (results.isSuccess()) {
                    JetType supertype = results.getResultingDescriptor().getReturnType();
                    this.recordSupertype(typeReference, supertype);
                    ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(supertype);
                    if (classDescriptor != null && classDescriptor.getKind() == ClassKind.TRAIT) {
                        BodyResolver.this.trace.report(Errors.CONSTRUCTOR_IN_TRAIT.on(elementToMark));
                    }
                } else {
                    this.recordSupertype(typeReference, BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                }
            }

            @Override
            public void visitDelegationToSuperClassSpecifier(JetDelegatorToSuperClass specifier) {
                JetTypeReference typeReference = specifier.getTypeReference();
                JetType supertype = BodyResolver.this.trace.getBindingContext().get(BindingContext.TYPE, typeReference);
                this.recordSupertype(typeReference, supertype);
                if (supertype == null) {
                    return;
                }
                ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(supertype);
                if (classDescriptor == null) {
                    return;
                }
                if (descriptor.getKind() != ClassKind.TRAIT && !classDescriptor.getConstructors().isEmpty() && !ErrorUtils.isError(classDescriptor.getTypeConstructor()) && classDescriptor.getKind() != ClassKind.TRAIT) {
                    BodyResolver.this.trace.report(Errors.SUPERTYPE_NOT_INITIALIZED.on(specifier));
                }
            }

            @Override
            public void visitDelegationToThisCall(JetDelegatorToThisCall thisCall) {
                throw new IllegalStateException("This-calls should be prohibited by the parser");
            }

            @Override
            public void visitJetElement(JetElement element) {
                throw new UnsupportedOperationException(element.getText() + " : " + element);
            }
        };
        for (JetDelegationSpecifier delegationSpecifier : jetClass.getDelegationSpecifiers()) {
            delegationSpecifier.accept(visitor);
        }
        Set<TypeConstructor> parentEnum = Collections.emptySet();
        if (jetClass instanceof JetEnumEntry) {
            parentEnum = Collections.singleton(((ClassDescriptor)descriptor.getContainingDeclaration().getContainingDeclaration()).getTypeConstructor());
        }
        this.checkSupertypeList(descriptor, supertypes, parentEnum);
    }

    private void checkSupertypeList(@NotNull ClassDescriptor supertypeOwner, @NotNull Map<JetTypeReference, JetType> supertypes, @NotNull Set<TypeConstructor> allowedFinalSupertypes) {
        HashSet<TypeConstructor> typeConstructors = Sets.newHashSet();
        boolean classAppeared = false;
        for (Map.Entry<JetTypeReference, JetType> entry : supertypes.entrySet()) {
            TypeConstructor constructor;
            JetTypeReference typeReference = entry.getKey();
            JetType supertype = entry.getValue();
            ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(supertype);
            if (classDescriptor != null) {
                if (classDescriptor.getKind() != ClassKind.TRAIT) {
                    if (supertypeOwner.getKind() == ClassKind.ENUM_CLASS) {
                        this.trace.report(Errors.CLASS_IN_SUPERTYPE_FOR_ENUM.on(typeReference));
                    }
                    if (classAppeared) {
                        this.trace.report(Errors.MANY_CLASSES_IN_SUPERTYPE_LIST.on(typeReference));
                    } else {
                        classAppeared = true;
                    }
                }
            } else {
                this.trace.report(Errors.SUPERTYPE_NOT_A_CLASS_OR_TRAIT.on(typeReference));
            }
            if (!typeConstructors.add(constructor = supertype.getConstructor())) {
                this.trace.report(Errors.SUPERTYPE_APPEARS_TWICE.on(typeReference));
            }
            if (!constructor.isSealed() || allowedFinalSupertypes.contains(constructor)) continue;
            this.trace.report(Errors.FINAL_SUPERTYPE.on(typeReference));
        }
    }

    private void resolveClassAnnotations() {
    }

    private void resolveAnonymousInitializers() {
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            this.resolveAnonymousInitializers(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<JetNamedDeclarationStub, MutableClassDescriptor> entry : this.context.getObjects().entrySet()) {
            this.resolveAnonymousInitializers((JetClassOrObject)((Object)entry.getKey()), entry.getValue());
        }
    }

    private void resolveAnonymousInitializers(JetClassOrObject jetClassOrObject, MutableClassDescriptor classDescriptor) {
        this.resolveAnonymousInitializers(jetClassOrObject, classDescriptor.getUnsubstitutedPrimaryConstructor(), classDescriptor.getScopeForInitializers());
    }

    public void resolveAnonymousInitializers(JetClassOrObject jetClassOrObject, @Nullable ConstructorDescriptor primaryConstructor, @NotNull JetScope scopeForInitializers) {
        if (!this.context.completeAnalysisNeeded(jetClassOrObject)) {
            return;
        }
        List<JetClassInitializer> anonymousInitializers = jetClassOrObject.getAnonymousInitializers();
        if (primaryConstructor != null) {
            for (JetClassInitializer anonymousInitializer : anonymousInitializers) {
                this.expressionTypingServices.getType(scopeForInitializers, anonymousInitializer.getBody(), TypeUtils.NO_EXPECTED_TYPE, DataFlowInfo.EMPTY, this.trace);
            }
        } else {
            for (JetClassInitializer anonymousInitializer : anonymousInitializers) {
                this.trace.report(Errors.ANONYMOUS_INITIALIZER_IN_TRAIT.on(anonymousInitializer));
            }
        }
    }

    private void resolvePrimaryConstructorParameters() {
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            JetClass klass = entry.getKey();
            MutableClassDescriptor classDescriptor = entry.getValue();
            ConstructorDescriptor unsubstitutedPrimaryConstructor = classDescriptor.getUnsubstitutedPrimaryConstructor();
            if (unsubstitutedPrimaryConstructor == null) continue;
            WritableScopeImpl parameterScope = new WritableScopeImpl(classDescriptor.getScopeForSupertypeResolution(), unsubstitutedPrimaryConstructor, RedeclarationHandler.DO_NOTHING, "Scope with value parameters of a constructor");
            for (ValueParameterDescriptor valueParameterDescriptor : unsubstitutedPrimaryConstructor.getValueParameters()) {
                parameterScope.addVariableDescriptor(valueParameterDescriptor);
            }
            parameterScope.changeLockLevel(WritableScope.LockLevel.READING);
            this.checkDefaultParameterValues(klass.getPrimaryConstructorParameters(), unsubstitutedPrimaryConstructor.getValueParameters(), parameterScope);
        }
    }

    private void resolvePropertyDeclarationBodies() {
        HashSet<JetProperty> processed = Sets.newHashSet();
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            JetClass jetClass = entry.getKey();
            if (!this.context.completeAnalysisNeeded(jetClass)) continue;
            MutableClassDescriptor classDescriptor = entry.getValue();
            for (JetProperty property : jetClass.getProperties()) {
                JetExpression delegateExpression;
                ConstructorDescriptor primaryConstructor;
                PropertyDescriptor propertyDescriptor = this.context.getProperties().get(property);
                assert (propertyDescriptor != null);
                BodyResolver.computeDeferredType(propertyDescriptor.getReturnType());
                JetExpression initializer = property.getInitializer();
                JetScope propertyScope = this.getScopeForProperty(property);
                if (initializer != null && (primaryConstructor = classDescriptor.getUnsubstitutedPrimaryConstructor()) != null) {
                    this.resolvePropertyInitializer(property, propertyDescriptor, initializer, propertyScope);
                }
                if ((delegateExpression = property.getDelegateExpression()) != null) {
                    assert (initializer == null) : "Initializer should be null for delegated property : " + property.getText();
                    this.resolvePropertyDelegate(property, propertyDescriptor, delegateExpression, classDescriptor.getScopeForMemberResolution(), propertyScope);
                }
                this.resolvePropertyAccessors(property, propertyDescriptor);
                processed.add(property);
            }
        }
        for (Map.Entry<JetTypeParameterListOwnerStub, MemberDescriptor> entry : this.context.getProperties().entrySet()) {
            JetExpression delegateExpression;
            JetProperty property = (JetProperty)entry.getKey();
            if (!this.context.completeAnalysisNeeded(property) || processed.contains(property)) continue;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getValue();
            BodyResolver.computeDeferredType(propertyDescriptor.getReturnType());
            JetExpression initializer = property.getInitializer();
            JetScope propertyScope = this.getScopeForProperty(property);
            if (initializer != null) {
                this.resolvePropertyInitializer(property, propertyDescriptor, initializer, propertyScope);
            }
            if ((delegateExpression = property.getDelegateExpression()) != null) {
                assert (initializer == null) : "Initializer should be null for delegated property : " + property.getText();
                this.resolvePropertyDelegate(property, propertyDescriptor, delegateExpression, propertyScope, propertyScope);
            }
            this.resolvePropertyAccessors(property, propertyDescriptor);
        }
    }

    private JetScope makeScopeForPropertyAccessor(@NotNull JetPropertyAccessor accessor, @NotNull PropertyDescriptor descriptor) {
        JetScope accessorDeclaringScope = this.context.getDeclaringScopes().apply(accessor);
        assert (accessorDeclaringScope != null) : "Scope for accessor " + accessor.getText() + " should exists";
        return JetScopeUtils.makeScopeForPropertyAccessor(descriptor, accessorDeclaringScope, this.descriptorResolver, this.trace);
    }

    public void resolvePropertyAccessors(JetProperty property, PropertyDescriptor propertyDescriptor) {
        ObservableBindingTrace fieldAccessTrackingTrace = this.createFieldTrackingTrace(propertyDescriptor);
        JetPropertyAccessor getter = property.getGetter();
        PropertyGetterDescriptor getterDescriptor = propertyDescriptor.getGetter();
        if (getter != null && getterDescriptor != null) {
            JetScope accessorScope = this.makeScopeForPropertyAccessor(getter, propertyDescriptor);
            this.resolveFunctionBody(fieldAccessTrackingTrace, getter, getterDescriptor, accessorScope);
        }
        JetPropertyAccessor setter = property.getSetter();
        PropertySetterDescriptor setterDescriptor = propertyDescriptor.getSetter();
        if (setter != null && setterDescriptor != null) {
            JetScope accessorScope = this.makeScopeForPropertyAccessor(setter, propertyDescriptor);
            this.resolveFunctionBody(fieldAccessTrackingTrace, setter, setterDescriptor, accessorScope);
        }
    }

    private ObservableBindingTrace createFieldTrackingTrace(final PropertyDescriptor propertyDescriptor) {
        return new ObservableBindingTrace(this.trace).addHandler(BindingContext.REFERENCE_TARGET, new ObservableBindingTrace.RecordHandler<JetReferenceExpression, DeclarationDescriptor>(){

            @Override
            public void handleRecord(WritableSlice<JetReferenceExpression, DeclarationDescriptor> slice, JetReferenceExpression expression, DeclarationDescriptor descriptor) {
                JetSimpleNameExpression simpleNameExpression;
                if (expression instanceof JetSimpleNameExpression && (simpleNameExpression = (JetSimpleNameExpression)expression).getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER && descriptor == propertyDescriptor) {
                    BodyResolver.this.trace.record(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
                }
            }
        });
    }

    public void resolvePropertyDelegate(@NotNull JetProperty jetProperty, @NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression delegateExpression, @NotNull JetScope parentScopeForAccessor, @NotNull JetScope propertyScope) {
        JetPropertyAccessor setter;
        JetPropertyAccessor getter = jetProperty.getGetter();
        if (getter != null) {
            this.trace.report(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY.on(getter));
        }
        if ((setter = jetProperty.getSetter()) != null) {
            this.trace.report(Errors.ACCESSOR_FOR_DELEGATED_PROPERTY.on(setter));
        }
        JetScope propertyDeclarationInnerScope = this.descriptorResolver.getPropertyDeclarationInnerScopeForInitializer(propertyScope, propertyDescriptor.getTypeParameters(), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, this.trace);
        TemporaryBindingTrace traceToResolveDelegatedProperty = TemporaryBindingTrace.create(this.trace, "Trace to resolve delegated property");
        JetScope accessorScope = JetScopeUtils.makeScopeForPropertyAccessor(propertyDescriptor, parentScopeForAccessor, this.descriptorResolver, this.trace);
        JetExpression calleeExpression = JetPsiUtil.getCalleeExpressionIfAny(delegateExpression);
        ConstraintSystemCompleter completer = this.createConstraintSystemCompleter(jetProperty, propertyDescriptor, delegateExpression, accessorScope);
        if (calleeExpression != null) {
            traceToResolveDelegatedProperty.record(BindingContext.CONSTRAINT_SYSTEM_COMPLETER, calleeExpression, completer);
        }
        JetType delegateType = this.expressionTypingServices.safeGetType(propertyDeclarationInnerScope, delegateExpression, TypeUtils.NO_EXPECTED_TYPE, DataFlowInfo.EMPTY, traceToResolveDelegatedProperty);
        traceToResolveDelegatedProperty.commit(new TraceEntryFilter(){

            @Override
            public boolean accept(@NotNull WritableSlice<?, ?> slice, Object key) {
                return slice != BindingContext.CONSTRAINT_SYSTEM_COMPLETER;
            }
        }, true);
        DelegatedPropertyUtils.resolveDelegatedPropertyGetMethod(propertyDescriptor, delegateExpression, delegateType, this.expressionTypingServices, this.trace, accessorScope);
        if (jetProperty.isVar()) {
            DelegatedPropertyUtils.resolveDelegatedPropertySetMethod(propertyDescriptor, delegateExpression, delegateType, this.expressionTypingServices, this.trace, accessorScope);
        }
    }

    private ConstraintSystemCompleter createConstraintSystemCompleter(JetProperty property, final PropertyDescriptor propertyDescriptor, final JetExpression delegateExpression, final JetScope accessorScope) {
        final JetType expectedType = property.getTypeRef() != null ? propertyDescriptor.getType() : TypeUtils.NO_EXPECTED_TYPE;
        return new ConstraintSystemCompleter(){

            @Override
            public void completeConstraintSystem(@NotNull ConstraintSystem constraintSystem, @NotNull ResolvedCall<?> resolvedCall) {
                FunctionDescriptor descriptor;
                List<ValueParameterDescriptor> valueParameters;
                JetType returnType = resolvedCall.getCandidateDescriptor().getReturnType();
                if (returnType == null) {
                    return;
                }
                TemporaryBindingTrace traceToResolveConventionMethods = TemporaryBindingTrace.create(BodyResolver.this.trace, "Trace to resolve delegated property convention methods");
                OverloadResolutionResults<FunctionDescriptor> getMethodResults = DelegatedPropertyUtils.getDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, returnType, BodyResolver.this.expressionTypingServices, traceToResolveConventionMethods, accessorScope, true);
                if (this.conventionMethodFound(getMethodResults)) {
                    FunctionDescriptor descriptor2 = getMethodResults.getResultingDescriptor();
                    JetType returnTypeOfGetMethod = descriptor2.getReturnType();
                    if (returnTypeOfGetMethod != null) {
                        constraintSystem.addSupertypeConstraint(expectedType, returnTypeOfGetMethod, ConstraintPosition.FROM_COMPLETER);
                    }
                    this.addConstraintForThisValue(constraintSystem, descriptor2);
                }
                if (!propertyDescriptor.isVar()) {
                    return;
                }
                OverloadResolutionResults<FunctionDescriptor> setMethodResults = DelegatedPropertyUtils.getDelegatedPropertyConventionMethod(propertyDescriptor, delegateExpression, returnType, BodyResolver.this.expressionTypingServices, traceToResolveConventionMethods, accessorScope, false);
                if (this.conventionMethodFound(setMethodResults) && (valueParameters = (descriptor = setMethodResults.getResultingDescriptor()).getValueParameters()).size() == 3) {
                    ValueParameterDescriptor valueParameterForThis = valueParameters.get(2);
                    constraintSystem.addSubtypeConstraint(expectedType, valueParameterForThis.getType(), ConstraintPosition.FROM_COMPLETER);
                    this.addConstraintForThisValue(constraintSystem, descriptor);
                }
            }

            private boolean conventionMethodFound(@NotNull OverloadResolutionResults<FunctionDescriptor> results) {
                return results.isSuccess() || results.isSingleResult() && results.getResultCode() == OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH;
            }

            private void addConstraintForThisValue(ConstraintSystem constraintSystem, FunctionDescriptor resultingDescriptor) {
                ReceiverParameterDescriptor receiverParameter = propertyDescriptor.getReceiverParameter();
                ReceiverParameterDescriptor thisObject = propertyDescriptor.getExpectedThisObject();
                JetType typeOfThis = receiverParameter != null ? receiverParameter.getType() : (thisObject != null ? thisObject.getType() : KotlinBuiltIns.getInstance().getNullableNothingType());
                List<ValueParameterDescriptor> valueParameters = resultingDescriptor.getValueParameters();
                if (valueParameters.isEmpty()) {
                    return;
                }
                ValueParameterDescriptor valueParameterForThis = valueParameters.get(0);
                constraintSystem.addSubtypeConstraint(typeOfThis, valueParameterForThis.getType(), ConstraintPosition.FROM_COMPLETER);
            }
        };
    }

    public void resolvePropertyInitializer(@NotNull JetProperty property, @NotNull PropertyDescriptor propertyDescriptor, @NotNull JetExpression initializer, @NotNull JetScope scope) {
        JetScope propertyDeclarationInnerScope = this.descriptorResolver.getPropertyDeclarationInnerScopeForInitializer(scope, propertyDescriptor.getTypeParameters(), ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER, this.trace);
        JetType expectedTypeForInitializer = property.getTypeRef() != null ? propertyDescriptor.getType() : TypeUtils.NO_EXPECTED_TYPE;
        this.expressionTypingServices.getType(propertyDeclarationInnerScope, initializer, expectedTypeForInitializer, DataFlowInfo.EMPTY, this.trace);
    }

    @NotNull
    private JetScope getScopeForProperty(@NotNull JetProperty property) {
        JetScope scope = this.context.getDeclaringScopes().apply(property);
        assert (scope != null) : "Scope for property " + property.getText() + " should exists";
        return scope;
    }

    private void resolveFunctionBodies() {
        for (Map.Entry<JetNamedFunction, SimpleFunctionDescriptor> entry : this.context.getFunctions().entrySet()) {
            JetNamedFunction declaration = entry.getKey();
            SimpleFunctionDescriptor descriptor = entry.getValue();
            BodyResolver.computeDeferredType(descriptor.getReturnType());
            JetScope declaringScope = this.context.getDeclaringScopes().apply(declaration);
            assert (declaringScope != null);
            this.resolveFunctionBody(this.trace, declaration, descriptor, declaringScope);
            assert (descriptor.getReturnType() != null);
        }
    }

    public void resolveFunctionBody(@NotNull BindingTrace trace, @NotNull JetDeclarationWithBody function, @NotNull FunctionDescriptor functionDescriptor, @NotNull JetScope declaringScope) {
        if (!this.context.completeAnalysisNeeded(function)) {
            return;
        }
        JetExpression bodyExpression = function.getBodyExpression();
        JetScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(declaringScope, functionDescriptor, trace);
        if (bodyExpression != null) {
            this.expressionTypingServices.checkFunctionReturnType(functionInnerScope, function, functionDescriptor, DataFlowInfo.EMPTY, null, trace);
        }
        List<JetParameter> valueParameters = function.getValueParameters();
        List<ValueParameterDescriptor> valueParameterDescriptors = functionDescriptor.getValueParameters();
        this.checkDefaultParameterValues(valueParameters, valueParameterDescriptors, functionInnerScope);
        assert (functionDescriptor.getReturnType() != null);
    }

    private void checkDefaultParameterValues(List<JetParameter> valueParameters, List<ValueParameterDescriptor> valueParameterDescriptors, JetScope declaringScope) {
        for (int i = 0; i < valueParameters.size(); ++i) {
            JetParameter jetParameter;
            JetExpression defaultValue;
            ValueParameterDescriptor valueParameterDescriptor = valueParameterDescriptors.get(i);
            if (!valueParameterDescriptor.hasDefaultValue() || (defaultValue = (jetParameter = valueParameters.get(i)).getDefaultValue()) == null) continue;
            this.expressionTypingServices.getType(declaringScope, defaultValue, valueParameterDescriptor.getType(), DataFlowInfo.EMPTY, this.trace);
        }
    }

    private static void computeDeferredType(JetType type) {
        DeferredType deferredType;
        if (type instanceof DeferredType && !(deferredType = (DeferredType)type).isComputed()) {
            deferredType.getActualType();
        }
    }

    private void computeDeferredTypes() {
        Collection<Box<DeferredType>> deferredTypes = this.trace.getKeys(BindingContext.DEFERRED_TYPE);
        if (deferredTypes != null) {
            final Queue<DeferredType> queue = new Queue<DeferredType>(deferredTypes.size() + 1);
            this.trace.addHandler(BindingContext.DEFERRED_TYPE, new ObservableBindingTrace.RecordHandler<Box<DeferredType>, Boolean>(){

                @Override
                public void handleRecord(WritableSlice<Box<DeferredType>, Boolean> deferredTypeKeyDeferredTypeWritableSlice, Box<DeferredType> key, Boolean value) {
                    queue.addLast(key.getData());
                }
            });
            for (Box<DeferredType> deferredType : deferredTypes) {
                queue.addLast(deferredType.getData());
            }
            while (!queue.isEmpty()) {
                DeferredType deferredType = (DeferredType)queue.pullFirst();
                if (deferredType.isComputed()) continue;
                try {
                    deferredType.getActualType();
                }
                catch (ReenteringLazyValueComputationException reenteringLazyValueComputationException) {}
            }
        }
    }
}

