/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringFactory;
import org.jetbrains.annotations.NotNull;

public class CharSequenceSubSequence
implements CharSequence {
    private final CharSequence myChars;
    private final int myStart;
    private final int myEnd;

    public CharSequenceSubSequence(@NotNull CharSequence chars, int start, int end) {
        if (chars == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/text/CharSequenceSubSequence.<init> must not be null");
        }
        if (start < 0 || end > chars.length() || start > end) {
            throw new IndexOutOfBoundsException("chars sequence.length:" + chars.length() + ", start:" + start + ", end:" + end);
        }
        this.myChars = chars;
        this.myStart = start;
        this.myEnd = end;
    }

    @Override
    public final int length() {
        return this.myEnd - this.myStart;
    }

    @Override
    public final char charAt(int index) {
        return this.myChars.charAt(index + this.myStart);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start == this.myStart && end == this.myEnd) {
            return this;
        }
        return new CharSequenceSubSequence(this.myChars, this.myStart + start, this.myStart + end);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String toString() {
        String string;
        if (this.myChars instanceof String) {
            string = ((String)this.myChars).substring(this.myStart, this.myEnd);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/util/text/CharSequenceSubSequence.toString must not return null");
            return string;
        }
        string = StringFactory.createShared(CharArrayUtil.fromSequence(this.myChars, this.myStart, this.myEnd));
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/util/text/CharSequenceSubSequence.toString must not return null");
    }
}

