/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.util.ReflectionCache;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.pico.DefaultPicoContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.DefaultLifecycleStrategy;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.MonitoringComponentAdapterFactory;
import org.picocontainer.monitors.DefaultComponentMonitor;

public class IdeaPicoContainer
extends DefaultPicoContainer {
    public IdeaPicoContainer(PicoContainer parent) {
        super(new MyComponentAdapterFactory(), parent);
    }

    @Override
    public ComponentAdapter getComponentAdapterOfType(Class componentType) {
        return super.getComponentAdapterOfType(componentType);
    }

    @Override
    public List getComponentAdaptersOfType(Class componentType) {
        if (componentType == null) {
            return Collections.emptyList();
        }
        if (componentType == String.class) {
            return Collections.emptyList();
        }
        ArrayList<ComponentAdapter> result = new ArrayList<ComponentAdapter>();
        Map<String, ComponentAdapter> cache = this.getAssignablesCache();
        ComponentAdapter cacheHit = cache.get(componentType.getName());
        if (cacheHit != null) {
            result.add(cacheHit);
        }
        for (ComponentAdapter componentAdapter : this.getNonAssignableAdapters()) {
            if (componentAdapter instanceof AssignableToComponentAdapter) {
                AssignableToComponentAdapter assignableToComponentAdapter = (AssignableToComponentAdapter)componentAdapter;
                if (!assignableToComponentAdapter.isAssignableTo(componentType)) continue;
                result.add(assignableToComponentAdapter);
                continue;
            }
            if (!ReflectionCache.isAssignable(componentType, componentAdapter.getComponentImplementation())) continue;
            result.add(componentAdapter);
        }
        return result;
    }

    private static class MyComponentAdapterFactory
    extends MonitoringComponentAdapterFactory {
        private final LifecycleStrategy myLifecycleStrategy = new DefaultLifecycleStrategy(new DefaultComponentMonitor());

        private MyComponentAdapterFactory() {
        }
    }
}

