/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class IOUtil {
    private static final Charset UTF_16BE_CHARSET = Charset.forName("UTF-16BE");
    public static final Charset US_ASCII = Charset.forName("US-ASCII");

    public static String readString(DataInput stream) throws IOException {
        int length = stream.readInt();
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return "";
        }
        byte[] bytes = new byte[length * 2];
        stream.readFully(bytes);
        return new String(bytes, 0, length * 2, UTF_16BE_CHARSET);
    }

    public static void writeString(String s, DataOutput stream) throws IOException {
        if (s == null) {
            stream.writeInt(-1);
            return;
        }
        stream.writeInt(s.length());
        if (s.isEmpty()) {
            return;
        }
        char[] chars = s.toCharArray();
        byte[] bytes = new byte[chars.length * 2];
        int i = 0;
        int i2 = 0;
        while (i < chars.length) {
            char aChar = chars[i];
            bytes[i2] = (byte)(aChar >>> 8 & 0xFF);
            bytes[i2 + 1] = (byte)(aChar & 0xFF);
            ++i;
            i2 += 2;
        }
        stream.write(bytes);
    }

    public static byte[] allocReadWriteUTFBuffer() {
        return new byte[256];
    }

    public static void writeUTFFast(byte[] buffer, DataOutput storage, @NotNull String value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/io/IOUtil.writeUTFFast must not be null");
        }
        int len = value.length();
        if (len < 255) {
            buffer[0] = (byte)len;
            boolean isAscii = true;
            for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                if (c < '\u0000' || c >= '\u0080') {
                    isAscii = false;
                    break;
                }
                buffer[i + 1] = (byte)c;
            }
            if (isAscii) {
                storage.write(buffer, 0, len + 1);
                return;
            }
        }
        storage.writeByte(-1);
        try {
            storage.writeUTF(value);
        }
        catch (UTFDataFormatException e) {
            storage.writeUTF("LONGER_THAN_64K");
            IOUtil.writeString(value, storage);
        }
    }

    public static String readUTFFast(byte[] buffer, DataInput storage) throws IOException {
        int len = 0xFF & storage.readByte();
        if (len == 255) {
            String result = storage.readUTF();
            if ("LONGER_THAN_64K".equals(result)) {
                return IOUtil.readString(storage);
            }
            return result;
        }
        storage.readFully(buffer, 0, len);
        return new String(buffer, 0, len, US_ASCII);
    }

    public static boolean isAscii(String str) {
        int length = str.length();
        for (int i = 0; i != length; ++i) {
            char c = str.charAt(i);
            if (IOUtil.isAscii(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAscii(char c) {
        return c >= '\u0000' && c < '\u0080';
    }
}

