/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.EmptyListIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

class LockFreeCopyOnWriteArrayList<E>
implements List<E>,
RandomAccess {
    private volatile Object[] array = ArrayUtil.EMPTY_OBJECT_ARRAY;
    private static final AtomicFieldUpdater<LockFreeCopyOnWriteArrayList, Object[]> ARRAY_UPDATER = AtomicFieldUpdater.forFieldOfType(LockFreeCopyOnWriteArrayList.class, Object[].class);
    public static final AtomicInteger RETRIES = new AtomicInteger();

    LockFreeCopyOnWriteArrayList() {
    }

    private boolean replaceArray(@NotNull Object[] oldArray, @NotNull Object[] newArray) {
        if (oldArray == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/LockFreeCopyOnWriteArrayList.replaceArray must not be null");
        }
        if (newArray == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/LockFreeCopyOnWriteArrayList.replaceArray must not be null");
        }
        return ARRAY_UPDATER.compareAndSet(this, oldArray, newArray);
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static int indexOf(Object o, @NotNull Object[] elements, int index, int fence) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/LockFreeCopyOnWriteArrayList.indexOf must not be null");
        }
        if (o == null) {
            for (int i = index; i < fence; ++i) {
                if (elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i < fence; ++i) {
                if (!o.equals(elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    private static int lastIndexOf(Object o, @NotNull Object[] elements, int index) {
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/LockFreeCopyOnWriteArrayList.lastIndexOf must not be null");
        }
        if (o == null) {
            for (int i = index; i >= 0; --i) {
                if (elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i >= 0; --i) {
                if (!o.equals(elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        Object[] elements = this.array;
        return LockFreeCopyOnWriteArrayList.indexOf(o, elements, 0, elements.length) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        Object[] elements = this.array;
        return LockFreeCopyOnWriteArrayList.indexOf(o, elements, 0, elements.length);
    }

    @Override
    public int lastIndexOf(Object o) {
        Object[] elements = this.array;
        return LockFreeCopyOnWriteArrayList.lastIndexOf(o, elements, elements.length - 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Object[] toArray() {
        Object[] objectArray;
        Object[] elements = this.array;
        if (elements.length == 0) {
            objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/util/containers/LockFreeCopyOnWriteArrayList.toArray must not return null");
            return objectArray;
        }
        objectArray = Arrays.copyOf(elements, elements.length, Object[].class);
        if (objectArray != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/containers/LockFreeCopyOnWriteArrayList.toArray must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        T[] TArray;
        if (a == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/LockFreeCopyOnWriteArrayList.toArray must not be null");
        }
        Object[] elements = this.array;
        int len = elements.length;
        if (a.length < len) {
            TArray = Arrays.copyOf(elements, len, a.getClass());
            if (TArray == null) throw new IllegalStateException("@NotNull method com/intellij/util/containers/LockFreeCopyOnWriteArrayList.toArray must not return null");
            return TArray;
        }
        System.arraycopy(elements, 0, a, 0, len);
        if (a.length > len) {
            a[len] = null;
        }
        TArray = a;
        if (a != null) return TArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/containers/LockFreeCopyOnWriteArrayList.toArray must not return null");
    }

    private E get(Object[] a, int index) {
        return (E)a[index];
    }

    @Override
    public E get(int index) {
        return this.get(this.array, index);
    }

    @Override
    public E set(int index, E element) {
        E oldValue;
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements, newElements = (oldValue = this.get(elements = this.array, index)) == element ? elements : LockFreeCopyOnWriteArrayList.createArraySet(elements, index, element))) {
        }
        return oldValue;
    }

    private static Object[] createArraySet(Object[] elements, int index, Object element) {
        int len = elements.length;
        Object[] newElements = Arrays.copyOf(elements, len, Object[].class);
        newElements[index] = element;
        return newElements;
    }

    @Override
    public boolean add(E e) {
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements = this.array, newElements = this.createArrayAdd(elements, e))) {
            this.logRetry();
        }
        return true;
    }

    private Object[] createArrayAdd(Object[] elements, E e) {
        int len = elements.length;
        Object[] newElements = new Object[len + 1];
        if (len != 0) {
            System.arraycopy(elements, 0, newElements, 0, len);
        }
        newElements[len] = e;
        return newElements;
    }

    @Override
    public void add(int index, E element) {
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements = this.array, newElements = this.createArrayAdd(elements, index, element))) {
        }
    }

    private Object[] createArrayAdd(Object[] elements, int index, E element) {
        int len = elements.length;
        if (index > len || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
        }
        int numMoved = len - index;
        Object[] newElements = new Object[len + 1];
        if (index != 0) {
            System.arraycopy(elements, 0, newElements, 0, index);
        }
        if (numMoved != 0) {
            System.arraycopy(elements, index, newElements, index + 1, numMoved);
        }
        newElements[index] = element;
        return newElements;
    }

    @Override
    public E remove(int index) {
        Object[] elements;
        while (true) {
            Object[] newElements;
            if (this.replaceArray(elements = this.array, newElements = LockFreeCopyOnWriteArrayList.createArrayRemove(elements, index))) break;
            this.logRetry();
        }
        E oldValue = this.get(elements, index);
        return oldValue;
    }

    private static Object[] createArrayRemove(Object[] elements, int index) {
        Object[] newElements;
        int len = elements.length;
        int numMoved = len - index - 1;
        Object[] objectArray = newElements = len == 1 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : new Object[len - 1];
        if (index != 0) {
            System.arraycopy(elements, 0, newElements, 0, index);
        }
        if (numMoved != 0) {
            System.arraycopy(elements, index + 1, newElements, index, numMoved);
        }
        return newElements;
    }

    @Override
    public boolean remove(Object o) {
        Object[] newElements;
        Object[] elements;
        do {
            if ((newElements = LockFreeCopyOnWriteArrayList.createArrayRemove(elements = this.array, o)) == null) {
                return false;
            }
            this.logRetry();
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    private void logRetry() {
    }

    private static Object[] createArrayRemove(Object[] elements, Object o) {
        int i;
        int len = elements.length;
        if (len == 0) {
            return null;
        }
        int newLen = len - 1;
        Object[] newElements = newLen == 0 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : new Object[newLen];
        for (i = newLen; i != 0; --i) {
            Object element = elements[i];
            if (LockFreeCopyOnWriteArrayList.eq(o, element)) {
                System.arraycopy(elements, 0, newElements, 0, i);
                break;
            }
            newElements[i - 1] = element;
        }
        if (i == 0 && !LockFreeCopyOnWriteArrayList.eq(o, elements[0])) {
            return null;
        }
        return newElements;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/LockFreeCopyOnWriteArrayList.containsAll must not be null");
        }
        Object[] elements = this.array;
        int len = elements.length;
        for (Object e : c) {
            if (LockFreeCopyOnWriteArrayList.indexOf(e, elements, 0, len) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        Object[] newElements;
        Object[] elements;
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/LockFreeCopyOnWriteArrayList.removeAll must not be null");
        }
        do {
            if ((newElements = LockFreeCopyOnWriteArrayList.createArrayRemoveAll(elements = this.array, c)) != null) continue;
            return false;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    private static Object[] createArrayRemoveAll(Object[] elements, @NotNull Collection<?> c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/LockFreeCopyOnWriteArrayList.createArrayRemoveAll must not be null");
        }
        int len = elements.length;
        if (len == 0) {
            return null;
        }
        int newLen = 0;
        Object[] temp = new Object[len];
        for (Object element : elements) {
            if (c.contains(element)) continue;
            temp[newLen++] = element;
        }
        if (newLen == len) {
            return null;
        }
        return Arrays.copyOf(temp, newLen, Object[].class);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        Object[] newElements;
        Object[] elements;
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/LockFreeCopyOnWriteArrayList.retainAll must not be null");
        }
        do {
            if ((newElements = LockFreeCopyOnWriteArrayList.createArrayRetainAll(elements = this.array, c)) != null) continue;
            return false;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    private static Object[] createArrayRetainAll(Object[] elements, @NotNull Collection<?> c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/LockFreeCopyOnWriteArrayList.createArrayRetainAll must not be null");
        }
        int len = elements.length;
        if (len == 0) {
            return null;
        }
        int newlen = 0;
        Object[] temp = new Object[len];
        for (Object element : elements) {
            if (!c.contains(element)) continue;
            temp[newlen++] = element;
        }
        if (newlen == len) {
            return null;
        }
        return Arrays.copyOf(temp, newlen, Object[].class);
    }

    @Override
    public void clear() {
        this.array = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        Object[] newElements;
        Object[] elements;
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/containers/LockFreeCopyOnWriteArrayList.addAll must not be null");
        }
        Object[] cs = c.toArray();
        if (cs.length == 0) {
            return false;
        }
        do {
            if ((newElements = LockFreeCopyOnWriteArrayList.createArrayAddAll(elements = this.array, cs)) != null) continue;
            return false;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    private static Object[] createArrayAddAll(Object[] elements, Object[] cs) {
        int len = elements.length;
        Object[] newElements = Arrays.copyOf(elements, len + cs.length, Object[].class);
        System.arraycopy(cs, 0, newElements, len, cs.length);
        return newElements;
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> c) {
        Object[] newElements;
        Object[] elements;
        if (c == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/containers/LockFreeCopyOnWriteArrayList.addAll must not be null");
        }
        Object[] cs = c.toArray();
        if (cs.length == 0) {
            return false;
        }
        while (!this.replaceArray(elements = this.array, newElements = LockFreeCopyOnWriteArrayList.createArrayAddAll(elements, index, cs))) {
        }
        return true;
    }

    private static Object[] createArrayAddAll(Object[] elements, int index, Object[] cs) {
        Object[] newElements;
        int len = elements.length;
        if (index > len || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
        }
        int numMoved = len - index;
        if (numMoved == 0) {
            newElements = Arrays.copyOf(elements, len + cs.length, Object[].class);
        } else {
            newElements = new Object[len + cs.length];
            System.arraycopy(elements, 0, newElements, 0, index);
            System.arraycopy(elements, index, newElements, index + cs.length, numMoved);
        }
        System.arraycopy(cs, 0, newElements, index, cs.length);
        return newElements;
    }

    public String toString() {
        return Arrays.toString(this.array);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        Iterator it = list.iterator();
        for (Object element : this.array) {
            if (it.hasNext() && LockFreeCopyOnWriteArrayList.eq(element, it.next())) continue;
            return false;
        }
        return !it.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Object obj : this.array) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Iterator<E> iterator() {
        Iterator<Object> iterator;
        Object[] elements = this.array;
        if (elements.length == 0) {
            iterator = EmptyIterator.getInstance();
            if (iterator == null) throw new IllegalStateException("@NotNull method com/intellij/util/containers/LockFreeCopyOnWriteArrayList.iterator must not return null");
            return iterator;
        }
        iterator = new COWIterator(elements, 0);
        if (iterator != null) return iterator;
        throw new IllegalStateException("@NotNull method com/intellij/util/containers/LockFreeCopyOnWriteArrayList.iterator must not return null");
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        ListIterator<E> listIterator = this.listIterator(0);
        if (listIterator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/LockFreeCopyOnWriteArrayList.listIterator must not return null");
        }
        return listIterator;
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        Object[] elements = this.array;
        int len = elements.length;
        if (index < 0 || index > len) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        ListIterator listIterator = elements.length == 0 ? EmptyListIterator.getInstance() : new COWIterator(elements, index);
        if (listIterator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/containers/LockFreeCopyOnWriteArrayList.listIterator must not return null");
        }
        return listIterator;
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    private static class COWIterator<E>
    implements ListIterator<E> {
        private final Object[] snapshot;
        private int cursor;

        private COWIterator(Object[] elements, int initialCursor) {
            this.cursor = initialCursor;
            this.snapshot = elements;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.snapshot.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[this.cursor++];
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return (E)this.snapshot[--this.cursor];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }
    }
}

