/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.NotNull;

public class ReflectionUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ReflectionUtil");

    private ReflectionUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static <T> Constructor<T> getDefaultConstructor(Class<T> aClass) {
        Constructor<T> constructor;
        Constructor<T> constructor2;
        try {
            Constructor<T> constructor3 = aClass.getConstructor(new Class[0]);
            constructor3.setAccessible(true);
            constructor2 = constructor3;
        }
        catch (NoSuchMethodException e) {
            LOG.error("No default constructor in " + aClass, e);
            constructor = null;
            throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionUtil.getDefaultConstructor must not return null");
        }
        constructor = constructor2;
        if (constructor2 != null) return constructor;
        throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionUtil.getDefaultConstructor must not return null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static <T> T createInstance(Constructor<T> constructor, Object ... args) {
        T t;
        T t2;
        try {
            t2 = constructor.newInstance(args);
        }
        catch (InstantiationException e) {
            LOG.error(e);
            t = null;
            throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionUtil.createInstance must not return null");
        }
        catch (IllegalAccessException e) {
            LOG.error(e);
            t = null;
            throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionUtil.createInstance must not return null");
        }
        catch (InvocationTargetException e) {
            LOG.error(e);
            t = null;
            throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionUtil.createInstance must not return null");
        }
        t = t2;
        if (t2 != null) return t;
        throw new IllegalStateException("@NotNull method com/intellij/util/ReflectionUtil.createInstance must not return null");
    }
}

