/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiLambdaExpressionImpl
extends ExpressionPsiElement
implements PsiLambdaExpression {
    public PsiLambdaExpressionImpl() {
        super(JavaElementType.LAMBDA_EXPRESSION);
    }

    @Override
    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList psiParameterList = PsiTreeUtil.getRequiredChildOfType(this, PsiParameterList.class);
        if (psiParameterList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl.getParameterList must not return null");
        }
        return psiParameterList;
    }

    @Override
    public int getChildRole(ASTNode child) {
        IElementType elType = child.getElementType();
        if (elType == JavaTokenType.ARROW) {
            return 252;
        }
        if (elType == JavaElementType.PARAMETER_LIST) {
            return 14;
        }
        if (elType == JavaElementType.CODE_BLOCK) {
            return 18;
        }
        return 64;
    }

    @Override
    public PsiElement getBody() {
        PsiElement element = this.getLastChild();
        return element instanceof PsiExpression || element instanceof PsiCodeBlock ? element : null;
    }

    @Override
    @Nullable
    public PsiType getFunctionalInterfaceType() {
        return LambdaUtil.getFunctionalInterfaceType(this, true);
    }

    @Override
    public boolean isVoidCompatible() {
        PsiElement body = this.getBody();
        if (body != null) {
            try {
                ControlFlow controlFlow = ControlFlowFactory.getInstance(this.getProject()).getControlFlow(body, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                int startOffset = controlFlow.getStartOffset(body);
                int endOffset = controlFlow.getEndOffset(body);
                return startOffset != -1 && endOffset != -1 && !ControlFlowUtil.canCompleteNormally(controlFlow, startOffset, endOffset);
            }
            catch (AnalysisCanceledException e) {
                return true;
            }
        }
        return true;
    }

    @Override
    public PsiType getType() {
        return new PsiLambdaExpressionType(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitLambdaExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl.processDeclarations must not be null");
        }
        return PsiImplUtil.processDeclarationsInLambda(this, processor, state, lastParent, place);
    }

    @Override
    public String toString() {
        return "PsiLambdaExpression:" + this.getText();
    }

    @Override
    public boolean hasFormalParameterTypes() {
        PsiParameter[] parameters;
        for (PsiParameter parameter : parameters = this.getParameterList().getParameters()) {
            if (parameter.getTypeElement() != null) continue;
            return false;
        }
        return parameters.length > 0;
    }
}

