/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.project.DumbService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsMethodImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiParameterStub;
import com.intellij.psi.impl.java.stubs.impl.PsiParameterStubImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ClsParameterImpl
extends ClsRepositoryPsiElement<PsiParameterStub>
implements PsiParameter {
    private PsiTypeElement myType;
    private String myName;
    private volatile String myMirrorName;

    public ClsParameterImpl(@NotNull PsiParameterStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsParameterImpl.<init> must not be null");
        }
        super(stub);
        this.myType = null;
        this.myMirrorName = null;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public String getName() {
        if (this.myName == null) {
            if (DumbService.getInstance(this.getProject()).isDumb()) {
                return null;
            }
            ClsMethodImpl method = (ClsMethodImpl)this.getDeclarationScope();
            PsiMethod sourceMethod = method.getSourceMirrorMethod();
            if (sourceMethod == null) {
                PsiParameterStubImpl parameterStub = (PsiParameterStubImpl)this.getStub();
                if (!parameterStub.isAutoGeneratedName()) {
                    return parameterStub.getName();
                }
                return null;
            }
            assert (sourceMethod != method);
            this.myName = sourceMethod.getParameterList().getParameters()[this.getIndex()].getName();
        }
        return this.myName;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsParameterImpl.setName must not be null");
        }
        throw new IncorrectOperationException(CAN_NOT_MODIFY_MESSAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public PsiTypeElement getTypeElement() {
        Object object = LAZY_BUILT_LOCK;
        // MONITORENTER : object
        if (this.myType == null) {
            PsiParameterStub stub = (PsiParameterStub)this.getStub();
            String typeText = TypeInfo.createTypeText(stub.getType(false));
            assert (typeText != null) : stub;
            this.myType = new ClsTypeElementImpl(this, typeText, '\u0000');
        }
        PsiTypeElement psiTypeElement = this.myType;
        // MONITOREXIT : object
        if (psiTypeElement != null) return psiTypeElement;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParameterImpl.getTypeElement must not return null");
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = this.getTypeElement().getType();
        if (psiType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParameterImpl.getType must not return null");
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        StubElement<PsiModifierList> child = ((PsiParameterStub)this.getStub()).findChildStubByType(JavaStubElementTypes.MODIFIER_LIST);
        assert (child != null);
        PsiModifierList psiModifierList = child.getPsi();
        if (psiModifierList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParameterImpl.getModifierList must not return null");
        }
        return psiModifierList;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsParameterImpl.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    public PsiExpression getInitializer() {
        return null;
    }

    @Override
    public boolean hasInitializer() {
        return false;
    }

    @Override
    public Object computeConstantValue() {
        return null;
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        PsiAnnotation[] annotations;
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsParameterImpl.appendMirrorText must not be null");
        }
        for (PsiAnnotation annotation : annotations = this.getModifierList().getAnnotations()) {
            ClsParameterImpl.appendText(annotation, indentLevel, buffer);
            buffer.append(' ');
        }
        ClsParameterImpl.appendText(this.getTypeElement(), indentLevel, buffer, " ");
        buffer.append(this.getMirrorName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMirrorName() {
        String mirrorName = this.myMirrorName;
        if (mirrorName == null) {
            mirrorName = this.calcNiceParameterName();
            Object object = LAZY_BUILT_LOCK;
            synchronized (object) {
                if (this.myMirrorName == null) {
                    this.myMirrorName = mirrorName;
                }
            }
        }
        return mirrorName;
    }

    private String calcNiceParameterName() {
        String name;
        PsiParameterStubImpl stub = (PsiParameterStubImpl)this.getStub();
        if (!stub.isAutoGeneratedName() || DumbService.getInstance(this.getProject()).isDumb()) {
            name = stub.getName();
        } else {
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance(this.getProject());
            String[] nameSuggestions = codeStyleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)this.getType()).names;
            name = "p";
            if (nameSuggestions.length > 0) {
                name = nameSuggestions[0];
            }
            PsiParameter[] parameters = ((PsiParameterList)this.getParent()).getParameters();
            block0: while (true) {
                PsiParameter[] arr$ = parameters;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    if (i$ >= len$) continue block0;
                    PsiParameter parameter = arr$[i$];
                    if (parameter == this) break block0;
                    String name1 = ((ClsParameterImpl)parameter).getMirrorName();
                    if (name.equals(name1)) {
                        name = ClsParameterImpl.nextName(name);
                        continue block0;
                    }
                    ++i$;
                }
                break;
            }
        }
        assert (name != null) : stub;
        return name;
    }

    private static String nextName(String name) {
        char c;
        int count;
        for (count = 0; count != name.length() && '0' <= (c = name.charAt(name.length() - count - 1)) && c <= '9'; ++count) {
        }
        try {
            int n = count > 0 ? Integer.parseInt(name.substring(name.length() - count)) : 0;
            return name.substring(0, name.length() - count) + ++n;
        }
        catch (NumberFormatException e) {
            assert (false) : e.getMessage();
            return null;
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsParameterImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiParameter mirror = (PsiParameter)SourceTreeToPsiMap.treeToPsiNotNull(element);
        ClsParameterImpl.setMirror(this.getModifierList(), mirror.getModifierList());
        ClsParameterImpl.setMirror(this.getTypeElement(), mirror.getTypeElement());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsParameterImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitParameter(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiElement getDeclarationScope() {
        PsiElement psiElement = this.getParent().getParent();
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParameterImpl.getDeclarationScope must not return null");
        }
        return psiElement;
    }

    private int getIndex() {
        PsiParameterStub stub = (PsiParameterStub)this.getStub();
        return stub.getParentStub().getChildrenStubs().indexOf(stub);
    }

    @Override
    public boolean isVarArgs() {
        PsiParameterList paramList = (PsiParameterList)this.getParent();
        PsiMethod method = (PsiMethod)paramList.getParent();
        return method.isVarArgs() && this.getIndex() == paramList.getParametersCount() - 1;
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ClsParameterImpl.createLayeredIcon(this, PlatformIcons.PARAMETER_ICON, 0);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        LocalSearchScope localSearchScope = new LocalSearchScope(this.getDeclarationScope());
        if (localSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsParameterImpl.getUseScope must not return null");
        }
        return localSearchScope;
    }

    @Override
    public PsiType getTypeNoResolve() {
        return this.getType();
    }

    @Override
    public String toString() {
        return "PsiParameter";
    }
}

