/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.compiled.ClsCustomNavigationPolicy;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsEnumConstantImpl;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.compiled.ClsMemberImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.source.ClassInnerStuffCache;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsClassImpl
extends ClsMemberImpl<PsiClassStub<?>>
implements Queryable,
PsiQualifiedNamedElement,
PsiExtensibleClass {
    public static final Key<PsiClass> DELEGATE_KEY = Key.create("DELEGATE");
    private final ClassInnerStuffCache myInnersCache = new ClassInnerStuffCache(this);

    public ClsClassImpl(PsiClassStub stub) {
        super(stub);
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        ArrayList children = ContainerUtil.newArrayList();
        ContainerUtil.addAll(children, this.getChildren(this.getDocComment(), this.getModifierList(), this.getNameIdentifier(), this.getExtendsList(), this.getImplementsList()));
        ContainerUtil.addAll(children, this.getOwnFields());
        ContainerUtil.addAll(children, this.getOwnMethods());
        ContainerUtil.addAll(children, this.getOwnInnerClasses());
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(children);
        if (psiElementArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getChildren must not return null");
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiTypeParameterList getTypeParameterList() {
        PsiTypeParameterList psiTypeParameterList = ((PsiClassStub)this.getStub()).findChildStubByType(JavaStubElementTypes.TYPE_PARAMETER_LIST).getPsi();
        if (psiTypeParameterList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getTypeParameterList must not return null");
        }
        return psiTypeParameterList;
    }

    @Override
    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters(this);
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        String string = ((PsiClassStub)this.getStub()).getQualifiedName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getQualifiedName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = ((PsiClassStub)this.getStub()).findChildStubByType(JavaStubElementTypes.MODIFIER_LIST).getPsi();
        if (psiModifierList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getModifierList must not return null");
        }
        return psiModifierList;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    @NotNull
    public PsiReferenceList getExtendsList() {
        PsiReferenceList psiReferenceList = ((PsiClassStub)this.getStub()).findChildStubByType(JavaStubElementTypes.EXTENDS_LIST).getPsi();
        if (psiReferenceList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getExtendsList must not return null");
        }
        return psiReferenceList;
    }

    @Override
    @NotNull
    public PsiReferenceList getImplementsList() {
        PsiReferenceList psiReferenceList = ((PsiClassStub)this.getStub()).findChildStubByType(JavaStubElementTypes.IMPLEMENTS_LIST).getPsi();
        if (psiReferenceList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getImplementsList must not return null");
        }
        return psiReferenceList;
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getExtendsListTypes(this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getExtendsListTypes must not return null");
        }
        return psiClassTypeArray;
    }

    @Override
    @NotNull
    public PsiClassType[] getImplementsListTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getImplementsListTypes(this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getImplementsListTypes must not return null");
        }
        return psiClassTypeArray;
    }

    @Override
    public PsiClass getSuperClass() {
        return PsiClassImplUtil.getSuperClass(this);
    }

    @Override
    public PsiClass[] getInterfaces() {
        return PsiClassImplUtil.getInterfaces(this);
    }

    @Override
    @NotNull
    public PsiClass[] getSupers() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getSupers(this);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getSupers must not return null");
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public PsiClassType[] getSuperTypes() {
        PsiClassType[] psiClassTypeArray = PsiClassImplUtil.getSuperTypes(this);
        if (psiClassTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getSuperTypes must not return null");
        }
        return psiClassTypeArray;
    }

    @Override
    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : null;
    }

    @Override
    @NotNull
    public Collection<HierarchicalMethodSignature> getVisibleSignatures() {
        Collection<HierarchicalMethodSignature> collection = PsiSuperMethodImplUtil.getVisibleSignatures(this);
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getVisibleSignatures must not return null");
        }
        return collection;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        PsiField[] psiFieldArray = this.myInnersCache.getFields();
        if (psiFieldArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getFields must not return null");
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getMethods() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getMethods();
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getConstructors() {
        PsiMethod[] psiMethodArray = this.myInnersCache.getConstructors();
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getConstructors must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiClass[] getInnerClasses() {
        PsiClass[] psiClassArray = this.myInnersCache.getInnerClasses();
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getInnerClasses must not return null");
        }
        return psiClassArray;
    }

    @Override
    @NotNull
    public List<PsiField> getOwnFields() {
        List<PsiElement> list = Arrays.asList(((PsiClassStub)this.getStub()).getChildrenByType(Constants.FIELD_BIT_SET, PsiField.ARRAY_FACTORY));
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getOwnFields must not return null");
        }
        return list;
    }

    @Override
    @NotNull
    public List<PsiMethod> getOwnMethods() {
        List<PsiElement> list = Arrays.asList(((PsiClassStub)this.getStub()).getChildrenByType(Constants.METHOD_BIT_SET, PsiMethod.ARRAY_FACTORY));
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getOwnMethods must not return null");
        }
        return list;
    }

    @Override
    @NotNull
    public List<PsiClass> getOwnInnerClasses() {
        List<PsiElement> list = Arrays.asList(((PsiClassStub)this.getStub()).getChildrenByType(JavaStubElementTypes.CLASS, PsiClass.ARRAY_FACTORY));
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getOwnInnerClasses must not return null");
        }
        return list;
    }

    @Override
    @NotNull
    public PsiClassInitializer[] getInitializers() {
        if (PsiClassInitializer.EMPTY_ARRAY == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getInitializers must not return null");
        }
        return PsiClassInitializer.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters(this);
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getTypeParameters must not return null");
        }
        return psiTypeParameterArray;
    }

    @Override
    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = PsiClassImplUtil.getAllFields(this);
        if (psiFieldArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getAllFields must not return null");
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getAllMethods() {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.getAllMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getAllMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiClass[] getAllInnerClasses() {
        PsiClass[] psiClassArray = PsiClassImplUtil.getAllInnerClasses(this);
        if (psiClassArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getAllInnerClasses must not return null");
        }
        return psiClassArray;
    }

    @Override
    public PsiField findFieldByName(String name, boolean checkBases) {
        return this.myInnersCache.findFieldByName(name, checkBases);
    }

    @Override
    public PsiMethod findMethodBySignature(PsiMethod patternMethod, boolean checkBases) {
        return PsiClassImplUtil.findMethodBySignature(this, patternMethod, checkBases);
    }

    @Override
    @NotNull
    public PsiMethod[] findMethodsBySignature(PsiMethod patternMethod, boolean checkBases) {
        PsiMethod[] psiMethodArray = PsiClassImplUtil.findMethodsBySignature(this, patternMethod, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.findMethodsBySignature must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public PsiMethod[] findMethodsByName(String name, boolean checkBases) {
        PsiMethod[] psiMethodArray = this.myInnersCache.findMethodsByName(name, checkBases);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.findMethodsByName must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> findMethodsAndTheirSubstitutorsByName(String name, boolean checkBases) {
        List<Pair<PsiMethod, PsiSubstitutor>> list = PsiClassImplUtil.findMethodsAndTheirSubstitutorsByName(this, name, checkBases);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.findMethodsAndTheirSubstitutorsByName must not return null");
        }
        return list;
    }

    @Override
    @NotNull
    public List<Pair<PsiMethod, PsiSubstitutor>> getAllMethodsAndTheirSubstitutors() {
        List<Pair<PsiMethod, PsiSubstitutor>> list = PsiClassImplUtil.getAllWithSubstitutorsByMap(this, PsiClassImplUtil.MemberType.METHOD);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getAllMethodsAndTheirSubstitutors must not return null");
        }
        return list;
    }

    @Override
    public PsiClass findInnerClassByName(String name, boolean checkBases) {
        return this.myInnersCache.findInnerClassByName(name, checkBases);
    }

    @Override
    public boolean isDeprecated() {
        return ((PsiClassStub)this.getStub()).isDeprecated();
    }

    public String getSourceFileName() {
        String sfn = ((PsiClassStub)this.getStub()).getSourceFileName();
        return sfn != null ? sfn : this.obtainSourceFileNameFromClassFileName();
    }

    @NonNls
    private String obtainSourceFileNameFromClassFileName() {
        String name = this.getContainingFile().getName();
        int i = name.indexOf(36);
        if (i < 0 && (i = name.indexOf(46)) < 0) {
            i = name.length();
        }
        return name.substring(0, i) + ".java";
    }

    @Override
    public PsiJavaToken getLBrace() {
        return null;
    }

    @Override
    public PsiJavaToken getRBrace() {
        return null;
    }

    @Override
    public boolean isInterface() {
        return ((PsiClassStub)this.getStub()).isInterface();
    }

    @Override
    public boolean isAnnotationType() {
        return ((PsiClassStub)this.getStub()).isAnnotationType();
    }

    @Override
    public boolean isEnum() {
        return ((PsiClassStub)this.getStub()).isEnum();
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull @NonNls StringBuilder buffer) {
        int i;
        if (buffer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.appendMirrorText must not be null");
        }
        ClsClassImpl.appendText(this.getDocComment(), indentLevel, buffer, "go_to_next_line_and_indent");
        ClsClassImpl.appendText(this.getModifierList(), indentLevel, buffer);
        buffer.append(this.isEnum() ? "enum " : (this.isAnnotationType() ? "@interface " : (this.isInterface() ? "interface " : "class ")));
        ClsClassImpl.appendText(this.getNameIdentifier(), indentLevel, buffer, " ");
        ClsClassImpl.appendText(this.getTypeParameterList(), indentLevel, buffer, " ");
        ClsClassImpl.appendText(this.getExtendsList(), indentLevel, buffer, " ");
        ClsClassImpl.appendText(this.getImplementsList(), indentLevel, buffer, " ");
        buffer.append('{');
        int newIndentLevel = indentLevel + this.getIndentSize();
        List<PsiField> fields = this.getOwnFields();
        List<PsiMethod> methods = this.getOwnMethods();
        List<PsiClass> classes = this.getOwnInnerClasses();
        if (fields.size() > 0) {
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            for (i = 0; i < fields.size(); ++i) {
                PsiField field = fields.get(i);
                ClsClassImpl.appendText(field, newIndentLevel, buffer);
                if (field instanceof ClsEnumConstantImpl) {
                    if (i < fields.size() - 1 && fields.get(i + 1) instanceof ClsEnumConstantImpl) {
                        buffer.append(", ");
                        continue;
                    }
                    buffer.append(';');
                    if (i >= fields.size() - 1) continue;
                    buffer.append('\n');
                    ClsClassImpl.goNextLine(newIndentLevel, buffer);
                    continue;
                }
                if (i >= fields.size() - 1) continue;
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
            }
        } else if (this.isEnum() && methods.size() + classes.size() > 0) {
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            buffer.append(";");
        }
        if (methods.size() > 0) {
            if (this.isEnum() || fields.size() > 0) {
                buffer.append('\n');
            }
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            for (i = 0; i < methods.size(); ++i) {
                ClsClassImpl.appendText(methods.get(i), newIndentLevel, buffer);
                if (i >= methods.size() - 1) continue;
                buffer.append('\n');
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
            }
        }
        if (classes.size() > 0) {
            if (fields.size() + methods.size() > 0) {
                buffer.append('\n');
            }
            ClsClassImpl.goNextLine(newIndentLevel, buffer);
            for (i = 0; i < classes.size(); ++i) {
                ClsClassImpl.appendText(classes.get(i), newIndentLevel, buffer);
                if (i >= classes.size() - 1) continue;
                buffer.append('\n');
                ClsClassImpl.goNextLine(newIndentLevel, buffer);
            }
        }
        ClsClassImpl.goNextLine(indentLevel, buffer);
        buffer.append('}');
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiClass mirror = (PsiClass)SourceTreeToPsiMap.treeToPsiNotNull(element);
        ClsClassImpl.setMirrorIfPresent(this.getDocComment(), mirror.getDocComment());
        ClsClassImpl.setMirror(this.getModifierList(), mirror.getModifierList());
        ClsClassImpl.setMirror(this.getNameIdentifier(), mirror.getNameIdentifier());
        ClsClassImpl.setMirror(this.getTypeParameterList(), mirror.getTypeParameterList());
        ClsClassImpl.setMirror(this.getExtendsList(), mirror.getExtendsList());
        ClsClassImpl.setMirror(this.getImplementsList(), mirror.getImplementsList());
        ClsClassImpl.setMirrors(this.getOwnFields(), (PsiElement[])mirror.getFields());
        ClsClassImpl.setMirrors(this.getOwnMethods(), (PsiElement[])mirror.getMethods());
        ClsClassImpl.setMirrors(this.getOwnInnerClasses(), (PsiElement[])mirror.getInnerClasses());
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitClass(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    @NonNls
    public String toString() {
        return "PsiClass:" + this.getName();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.processDeclarations must not be null");
        }
        return PsiClassImplUtil.processDeclarationsInClass(this, processor, state, null, lastParent, place, false);
    }

    @Override
    public PsiElement getScope() {
        return this.getParent();
    }

    @Override
    public boolean isInheritorDeep(PsiClass baseClass, PsiClass classToByPass) {
        return InheritanceImplUtil.isInheritorDeep(this, baseClass, classToByPass);
    }

    @Override
    public boolean isInheritor(@NotNull PsiClass baseClass, boolean checkDeep) {
        if (baseClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.isInheritor must not be null");
        }
        return InheritanceImplUtil.isInheritor(this, baseClass, checkDeep);
    }

    @Nullable
    public PsiClass getSourceMirrorClass() {
        PsiClass delegate = this.getUserData(DELEGATE_KEY);
        if (delegate instanceof ClsClassImpl) {
            return ((ClsClassImpl)delegate).getSourceMirrorClass();
        }
        String name = this.getName();
        PsiElement parent = this.getParent();
        if (parent instanceof PsiFile) {
            if (!(parent instanceof PsiClassOwner)) {
                return null;
            }
            PsiClassOwner fileNavigationElement = (PsiClassOwner)parent.getNavigationElement();
            if (fileNavigationElement == parent) {
                return null;
            }
            for (PsiClass aClass : fileNavigationElement.getClasses()) {
                if (!name.equals(aClass.getName())) continue;
                return aClass;
            }
        } else if (parent != null) {
            PsiClass[] innerClasses;
            ClsClassImpl parentClass = (ClsClassImpl)parent;
            PsiClass parentSourceMirror = parentClass.getSourceMirrorClass();
            if (parentSourceMirror == null) {
                return null;
            }
            for (PsiClass innerClass : innerClasses = parentSourceMirror.getInnerClasses()) {
                if (!name.equals(innerClass.getName())) continue;
                return innerClass;
            }
        } else {
            throw new PsiInvalidElementAccessException(this);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement sourceFile;
        PsiElement parent;
        PsiElement psiElement;
        for (ClsCustomNavigationPolicy customNavigationPolicy : Extensions.getExtensions(ClsCustomNavigationPolicy.EP_NAME)) {
            PsiElement navigationElement = customNavigationPolicy.getNavigationElement(this);
            if (navigationElement == null) continue;
            psiElement = navigationElement;
            if (psiElement == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getNavigationElement must not return null");
            return psiElement;
        }
        PsiClass aClass = this.getSourceMirrorClass();
        if (aClass != null) {
            psiElement = aClass.getNavigationElement();
            if (psiElement == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getNavigationElement must not return null");
            return psiElement;
        }
        if ("package-info".equals(this.getName()) && (parent = this.getParent()) instanceof ClsFileImpl && (sourceFile = parent.getNavigationElement()) instanceof PsiJavaFile) {
            psiElement = sourceFile;
            if (psiElement == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getNavigationElement must not return null");
            return psiElement;
        }
        psiElement = this;
        if (psiElement != null) return psiElement;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getNavigationElement must not return null");
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public Icon getElementIcon(int flags) {
        return PsiClassImplUtil.getClassIcon(flags, this);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isClassEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiClassImplUtil.getClassUseScope(this);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsClassImpl.getUseScope must not return null");
        }
        return searchScope;
    }

    @Override
    public PsiQualifiedNamedElement getContainer() {
        PsiDirectory dir;
        PsiFile file = this.getContainingFile();
        return file == null ? null : ((dir = file.getContainingDirectory()) == null ? null : JavaDirectoryService.getInstance().getPackage(dir));
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsClassImpl.putInfo must not be null");
        }
        PsiClassImpl.putInfo(this, info);
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }
}

