/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Joiner;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class CharMatcher
implements Predicate<Character> {
    public static final CharMatcher BREAKING_WHITESPACE = CharMatcher.anyOf("\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000").or(CharMatcher.inRange('\u2000', '\u2006')).or(CharMatcher.inRange('\u2008', '\u200a')).withToString("CharMatcher.BREAKING_WHITESPACE").precomputed();
    public static final CharMatcher ASCII = CharMatcher.inRange('\u0000', '\u007f').withToString("CharMatcher.ASCII");
    public static final CharMatcher DIGIT;
    public static final CharMatcher JAVA_DIGIT;
    public static final CharMatcher JAVA_LETTER;
    public static final CharMatcher JAVA_LETTER_OR_DIGIT;
    public static final CharMatcher JAVA_UPPER_CASE;
    public static final CharMatcher JAVA_LOWER_CASE;
    public static final CharMatcher JAVA_ISO_CONTROL;
    public static final CharMatcher INVISIBLE;
    public static final CharMatcher SINGLE_WIDTH;
    public static final CharMatcher ANY;
    public static final CharMatcher NONE;
    public static final CharMatcher WHITESPACE;

    public static CharMatcher is(final char match) {
        return new CharMatcher(){

            @Override
            public boolean matches(char c) {
                return c == match;
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                return other.matches(match) ? other : super.or(other);
            }

            @Override
            void setBits(LookupTable table) {
                table.set(match);
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }

            @Override
            public String toString() {
                return "CharMatcher.is(" + Integer.toHexString(match) + ")";
            }
        };
    }

    public static CharMatcher anyOf(CharSequence sequence) {
        switch (sequence.length()) {
            case 0: {
                return NONE;
            }
            case 1: {
                return CharMatcher.is(sequence.charAt(0));
            }
            case 2: {
                final char match1 = sequence.charAt(0);
                final char match2 = sequence.charAt(1);
                return new CharMatcher(){

                    @Override
                    public boolean matches(char c) {
                        return c == match1 || c == match2;
                    }

                    @Override
                    void setBits(LookupTable table) {
                        table.set(match1);
                        table.set(match2);
                    }

                    @Override
                    public CharMatcher precomputed() {
                        return this;
                    }
                };
            }
        }
        final char[] chars = ((Object)sequence).toString().toCharArray();
        Arrays.sort(chars);
        return new CharMatcher(){

            @Override
            public boolean matches(char c) {
                return Arrays.binarySearch(chars, c) >= 0;
            }

            @Override
            void setBits(LookupTable table) {
                for (char c : chars) {
                    table.set(c);
                }
            }

            @Override
            public String toString() {
                return "CharMatcher.anyOf(\"" + chars + "\")";
            }
        };
    }

    public static CharMatcher inRange(final char startInclusive, final char endInclusive) {
        Preconditions.checkArgument(endInclusive >= startInclusive);
        return new CharMatcher(){

            @Override
            public boolean matches(char c) {
                return startInclusive <= c && c <= endInclusive;
            }

            @Override
            void setBits(LookupTable table) {
                char c;
                char c2 = startInclusive;
                do {
                    table.set(c2);
                    c = c2;
                    c2 = (char)(c2 + '\u0001');
                } while (c != endInclusive);
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }

            @Override
            public String toString() {
                return "CharMatcher.inRange(" + Integer.toHexString(startInclusive) + ", " + Integer.toHexString(endInclusive) + ")";
            }
        };
    }

    protected CharMatcher() {
    }

    public abstract boolean matches(char var1);

    public CharMatcher or(CharMatcher other) {
        return new Or(Arrays.asList(this, Preconditions.checkNotNull(other)));
    }

    public CharMatcher precomputed() {
        return Platform.precomputeCharMatcher(this);
    }

    CharMatcher precomputedInternal() {
        final LookupTable table = new LookupTable();
        this.setBits(table);
        final CharMatcher outer = this;
        return new CharMatcher(){

            @Override
            public boolean matches(char c) {
                return table.get(c);
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }

            @Override
            public String toString() {
                return outer.toString();
            }
        };
    }

    CharMatcher withToString(final String toString) {
        final CharMatcher delegate = this;
        return new CharMatcher(){

            @Override
            public boolean matches(char c) {
                return delegate.matches(c);
            }

            @Override
            void setBits(LookupTable table) {
                delegate.setBits(table);
            }

            @Override
            public String toString() {
                return toString;
            }
        };
    }

    void setBits(LookupTable table) {
        char c;
        char c2 = '\u0000';
        do {
            if (this.matches(c2)) {
                table.set(c2);
            }
            c = c2;
            c2 = (char)(c2 + '\u0001');
        } while (c != 65535);
    }

    public int indexIn(CharSequence sequence, int start) {
        int length = sequence.length();
        Preconditions.checkPositionIndex(start, length);
        for (int i = start; i < length; ++i) {
            if (!this.matches(sequence.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean apply(Character character) {
        return this.matches(character.charValue());
    }

    public String toString() {
        return super.toString();
    }

    static {
        CharMatcher digit = CharMatcher.inRange('0', '9');
        String zeroes = "\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10";
        for (char base : zeroes.toCharArray()) {
            digit = digit.or(CharMatcher.inRange(base, (char)(base + 9)));
        }
        DIGIT = digit.withToString("CharMatcher.DIGIT").precomputed();
        JAVA_DIGIT = new CharMatcher(){

            @Override
            public boolean matches(char c) {
                return Character.isDigit(c);
            }

            @Override
            public String toString() {
                return "CharMatcher.JAVA_DIGIT";
            }
        };
        JAVA_LETTER = new CharMatcher(){

            @Override
            public boolean matches(char c) {
                return Character.isLetter(c);
            }

            @Override
            public String toString() {
                return "CharMatcher.JAVA_LETTER";
            }
        };
        JAVA_LETTER_OR_DIGIT = new CharMatcher(){

            @Override
            public boolean matches(char c) {
                return Character.isLetterOrDigit(c);
            }

            @Override
            public String toString() {
                return "CharMatcher.JAVA_LETTER_OR_DIGIT";
            }
        };
        JAVA_UPPER_CASE = new CharMatcher(){

            @Override
            public boolean matches(char c) {
                return Character.isUpperCase(c);
            }

            @Override
            public String toString() {
                return "CharMatcher.JAVA_UPPER_CASE";
            }
        };
        JAVA_LOWER_CASE = new CharMatcher(){

            @Override
            public boolean matches(char c) {
                return Character.isLowerCase(c);
            }

            @Override
            public String toString() {
                return "CharMatcher.JAVA_LOWER_CASE";
            }
        };
        JAVA_ISO_CONTROL = CharMatcher.inRange('\u0000', '\u001f').or(CharMatcher.inRange('\u007f', '\u009f')).withToString("CharMatcher.JAVA_ISO_CONTROL");
        INVISIBLE = CharMatcher.inRange('\u0000', ' ').or(CharMatcher.inRange('\u007f', '\u00a0')).or(CharMatcher.is('\u00ad')).or(CharMatcher.inRange('\u0600', '\u0603')).or(CharMatcher.anyOf("\u06dd\u070f\u1680\u17b4\u17b5\u180e")).or(CharMatcher.inRange('\u2000', '\u200f')).or(CharMatcher.inRange('\u2028', '\u202f')).or(CharMatcher.inRange('\u205f', '\u2064')).or(CharMatcher.inRange('\u206a', '\u206f')).or(CharMatcher.is('\u3000')).or(CharMatcher.inRange('\ud800', '\uf8ff')).or(CharMatcher.anyOf("\ufeff\ufff9\ufffa\ufffb")).withToString("CharMatcher.INVISIBLE").precomputed();
        SINGLE_WIDTH = CharMatcher.inRange('\u0000', '\u04f9').or(CharMatcher.is('\u05be')).or(CharMatcher.inRange('\u05d0', '\u05ea')).or(CharMatcher.is('\u05f3')).or(CharMatcher.is('\u05f4')).or(CharMatcher.inRange('\u0600', '\u06ff')).or(CharMatcher.inRange('\u0750', '\u077f')).or(CharMatcher.inRange('\u0e00', '\u0e7f')).or(CharMatcher.inRange('\u1e00', '\u20af')).or(CharMatcher.inRange('\u2100', '\u213a')).or(CharMatcher.inRange('\ufb50', '\ufdff')).or(CharMatcher.inRange('\ufe70', '\ufeff')).or(CharMatcher.inRange('\uff61', '\uffdc')).withToString("CharMatcher.SINGLE_WIDTH").precomputed();
        ANY = new CharMatcher(){

            @Override
            public boolean matches(char c) {
                return true;
            }

            @Override
            public int indexIn(CharSequence sequence, int start) {
                int length = sequence.length();
                Preconditions.checkPositionIndex(start, length);
                return start == length ? -1 : start;
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                Preconditions.checkNotNull(other);
                return this;
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }

            @Override
            public String toString() {
                return "CharMatcher.ANY";
            }
        };
        NONE = new CharMatcher(){

            @Override
            public boolean matches(char c) {
                return false;
            }

            @Override
            public int indexIn(CharSequence sequence, int start) {
                int length = sequence.length();
                Preconditions.checkPositionIndex(start, length);
                return -1;
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                return Preconditions.checkNotNull(other);
            }

            @Override
            void setBits(LookupTable table) {
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }

            @Override
            public String toString() {
                return "CharMatcher.NONE";
            }
        };
        WHITESPACE = new CharMatcher(){
            private final char[] table = new char[]{'\u0001', '\u0000', '\u00a0', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\t', '\n', '\u000b', '\f', '\r', '\u0000', '\u0000', '\u2028', '\u2029', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u202f', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', ' ', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u3000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0085', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u205f', '\u1680', '\u0000', '\u0000', '\u180e', '\u0000', '\u0000', '\u0000'};

            @Override
            public boolean matches(char c) {
                return this.table[c % 79] == c;
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }

            @Override
            public String toString() {
                return "CharMatcher.WHITESPACE";
            }
        };
    }

    private static final class LookupTable {
        int[] data = new int[2048];

        private LookupTable() {
        }

        void set(char index) {
            int n = index >> 5;
            this.data[n] = this.data[n] | '\u0001' << index;
        }

        boolean get(char index) {
            return (this.data[index >> 5] & '\u0001' << index) != 0;
        }
    }

    private static class Or
    extends CharMatcher {
        List<CharMatcher> components;

        Or(List<CharMatcher> components) {
            this.components = components;
        }

        @Override
        public boolean matches(char c) {
            for (CharMatcher matcher : this.components) {
                if (!matcher.matches(c)) continue;
                return true;
            }
            return false;
        }

        @Override
        public CharMatcher or(CharMatcher other) {
            ArrayList<CharMatcher> newComponents = new ArrayList<CharMatcher>(this.components);
            newComponents.add(Preconditions.checkNotNull(other));
            return new Or(newComponents);
        }

        @Override
        void setBits(LookupTable table) {
            for (CharMatcher matcher : this.components) {
                matcher.setBits(table);
            }
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder("CharMatcher.or(");
            Joiner.on(", ").appendTo(builder, this.components);
            return builder.append(')').toString();
        }
    }
}

