/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.client;

import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;
import org.jetbrains.kotlin.daemon.common.NetworkUtilsKt;
import org.jetbrains.kotlin.daemon.common.RmiFriendlyCompilationCanceledException;
import org.jetbrains.kotlin.incremental.components.LookupInfo;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.load.kotlin.incremental.components.JvmPackagePartProto;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B3\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J \u0010\"\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010#2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001eH\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001e0#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001e0#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001a\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u001eH\u0016J(\u0010*\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020\u001eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010.\u001a\u00020\u001a2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000#H\u0016J\b\u00101\u001a\u00020\u0013H\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/daemon/client/CompilerCallbackServicesFacadeServer;", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "Ljava/rmi/server/UnicastRemoteObject;", "incrementalCompilationComponents", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCompilationComponents;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "compilationCanceledStatus", "Lorg/jetbrains/kotlin/progress/CompilationCanceledStatus;", "port", "", "(Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCompilationComponents;Lorg/jetbrains/kotlin/incremental/components/LookupTracker;Lorg/jetbrains/kotlin/progress/CompilationCanceledStatus;I)V", "getCompilationCanceledStatus", "()Lorg/jetbrains/kotlin/progress/CompilationCanceledStatus;", "getIncrementalCompilationComponents", "()Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCompilationComponents;", "getLookupTracker", "()Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "lookupTracker_isDoNothing", "", "compilationCanceledStatus_checkCanceled", "Ljava/lang/Void;", "hasCompilationCanceledStatus", "hasIncrementalCaches", "hasLookupTracker", "incrementalCache_close", "", "target", "Lorg/jetbrains/kotlin/modules/TargetId;", "incrementalCache_getClassFilePath", "", "internalClassName", "incrementalCache_getModuleMappingData", "", "incrementalCache_getMultifileFacadeParts", "", "internalName", "incrementalCache_getObsoleteMultifileClassFacades", "incrementalCache_getObsoletePackageParts", "incrementalCache_getPackagePartData", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/JvmPackagePartProto;", "partInternalName", "incrementalCache_registerInline", "fromPath", "jvmSignature", "toPath", "lookupTracker_record", "lookups", "Lorg/jetbrains/kotlin/incremental/components/LookupInfo;", "lookupTracker_requiresPosition", "kotlin-compiler-runner"})
public class CompilerCallbackServicesFacadeServer
extends UnicastRemoteObject
implements CompilerCallbackServicesFacade {
    private final boolean lookupTracker_isDoNothing;
    @Nullable
    private final IncrementalCompilationComponents incrementalCompilationComponents;
    @Nullable
    private final LookupTracker lookupTracker;
    @Nullable
    private final CompilationCanceledStatus compilationCanceledStatus;

    public boolean hasIncrementalCaches() {
        return this.incrementalCompilationComponents != null;
    }

    public boolean hasLookupTracker() {
        return this.incrementalCompilationComponents != null;
    }

    public boolean hasCompilationCanceledStatus() {
        return this.compilationCanceledStatus != null;
    }

    @NotNull
    public Collection<String> incrementalCache_getObsoletePackageParts(@NotNull TargetId target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        IncrementalCompilationComponents incrementalCompilationComponents = this.incrementalCompilationComponents;
        if (incrementalCompilationComponents == null) {
            Intrinsics.throwNpe();
        }
        return incrementalCompilationComponents.getIncrementalCache(target).getObsoletePackageParts();
    }

    @NotNull
    public Collection<String> incrementalCache_getObsoleteMultifileClassFacades(@NotNull TargetId target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        IncrementalCompilationComponents incrementalCompilationComponents = this.incrementalCompilationComponents;
        if (incrementalCompilationComponents == null) {
            Intrinsics.throwNpe();
        }
        return incrementalCompilationComponents.getIncrementalCache(target).getObsoleteMultifileClasses();
    }

    @Nullable
    public Collection<String> incrementalCache_getMultifileFacadeParts(@NotNull TargetId target, @NotNull String internalName) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)internalName, (String)"internalName");
        IncrementalCompilationComponents incrementalCompilationComponents = this.incrementalCompilationComponents;
        if (incrementalCompilationComponents == null) {
            Intrinsics.throwNpe();
        }
        return incrementalCompilationComponents.getIncrementalCache(target).getStableMultifileFacadeParts(internalName);
    }

    @Nullable
    public JvmPackagePartProto incrementalCache_getPackagePartData(@NotNull TargetId target, @NotNull String partInternalName) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)partInternalName, (String)"partInternalName");
        IncrementalCompilationComponents incrementalCompilationComponents = this.incrementalCompilationComponents;
        if (incrementalCompilationComponents == null) {
            Intrinsics.throwNpe();
        }
        return incrementalCompilationComponents.getIncrementalCache(target).getPackagePartData(partInternalName);
    }

    @Nullable
    public byte[] incrementalCache_getModuleMappingData(@NotNull TargetId target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        IncrementalCompilationComponents incrementalCompilationComponents = this.incrementalCompilationComponents;
        if (incrementalCompilationComponents == null) {
            Intrinsics.throwNpe();
        }
        return incrementalCompilationComponents.getIncrementalCache(target).getModuleMappingData();
    }

    public void incrementalCache_registerInline(@NotNull TargetId target, @NotNull String fromPath, @NotNull String jvmSignature, @NotNull String toPath) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)fromPath, (String)"fromPath");
        Intrinsics.checkParameterIsNotNull((Object)jvmSignature, (String)"jvmSignature");
        Intrinsics.checkParameterIsNotNull((Object)toPath, (String)"toPath");
    }

    @NotNull
    public String incrementalCache_getClassFilePath(@NotNull TargetId target, @NotNull String internalClassName) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)internalClassName, (String)"internalClassName");
        IncrementalCompilationComponents incrementalCompilationComponents = this.incrementalCompilationComponents;
        if (incrementalCompilationComponents == null) {
            Intrinsics.throwNpe();
        }
        return incrementalCompilationComponents.getIncrementalCache(target).getClassFilePath(internalClassName);
    }

    public void incrementalCache_close(@NotNull TargetId target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        IncrementalCompilationComponents incrementalCompilationComponents = this.incrementalCompilationComponents;
        if (incrementalCompilationComponents == null) {
            Intrinsics.throwNpe();
        }
        incrementalCompilationComponents.getIncrementalCache(target).close();
    }

    public boolean lookupTracker_requiresPosition() {
        LookupTracker lookupTracker = this.lookupTracker;
        if (lookupTracker == null) {
            Intrinsics.throwNpe();
        }
        return lookupTracker.getRequiresPosition();
    }

    public void lookupTracker_record(@NotNull Collection<LookupInfo> lookups) {
        Intrinsics.checkParameterIsNotNull(lookups, (String)"lookups");
        LookupTracker lookupTracker = this.lookupTracker;
        if (lookupTracker == null) {
            Intrinsics.throwNpe();
        }
        LookupTracker lookupTracker2 = lookupTracker;
        for (LookupInfo it : lookups) {
            lookupTracker2.record(it.getFilePath(), it.getPosition(), it.getScopeFqName(), it.getScopeKind(), it.getName());
        }
    }

    public boolean lookupTracker_isDoNothing() {
        return this.lookupTracker_isDoNothing;
    }

    @Nullable
    public Void compilationCanceledStatus_checkCanceled() {
        try {
            CompilationCanceledStatus compilationCanceledStatus = this.compilationCanceledStatus;
            if (compilationCanceledStatus == null) {
                Intrinsics.throwNpe();
            }
            compilationCanceledStatus.checkCanceled();
            return null;
        }
        catch (Exception e) {
            if (ExceptionUtilsKt.isProcessCanceledException((Throwable)e)) {
                throw (Throwable)new RmiFriendlyCompilationCanceledException();
            }
            throw (Throwable)e;
        }
    }

    @Nullable
    public final IncrementalCompilationComponents getIncrementalCompilationComponents() {
        return this.incrementalCompilationComponents;
    }

    @Nullable
    public final LookupTracker getLookupTracker() {
        return this.lookupTracker;
    }

    @Nullable
    public final CompilationCanceledStatus getCompilationCanceledStatus() {
        return this.compilationCanceledStatus;
    }

    public CompilerCallbackServicesFacadeServer(@Nullable IncrementalCompilationComponents incrementalCompilationComponents, @Nullable LookupTracker lookupTracker, @Nullable CompilationCanceledStatus compilationCanceledStatus, int port) {
        super(port, (RMIClientSocketFactory)LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), (RMIServerSocketFactory)LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        this.incrementalCompilationComponents = incrementalCompilationComponents;
        this.lookupTracker = lookupTracker;
        this.compilationCanceledStatus = compilationCanceledStatus;
        this.lookupTracker_isDoNothing = this.lookupTracker == LookupTracker.DO_NOTHING.INSTANCE;
    }

    public /* synthetic */ CompilerCallbackServicesFacadeServer(IncrementalCompilationComponents incrementalCompilationComponents, LookupTracker lookupTracker, CompilationCanceledStatus compilationCanceledStatus, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            incrementalCompilationComponents = null;
        }
        if ((n2 & 2) != 0) {
            lookupTracker = null;
        }
        if ((n2 & 4) != 0) {
            compilationCanceledStatus = null;
        }
        if ((n2 & 8) != 0) {
            n = NetworkUtilsKt.getSOCKET_ANY_FREE_PORT();
        }
        this(incrementalCompilationComponents, lookupTracker, compilationCanceledStatus, n);
    }

    public CompilerCallbackServicesFacadeServer() {
        this(null, null, null, 0, 15, null);
    }
}

