/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.kotlin.compilerRunner.CompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.CompilerOutputParser;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunner$WhenMappings;
import org.jetbrains.kotlin.compilerRunner.KotlinLogger;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.client.DaemonReportMessage;
import org.jetbrains.kotlin.daemon.client.DaemonReportingTargets;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.WallAndThreadAndMemoryTotalProfiler;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J'\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0019J%\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0004J\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0018\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010 J9\u0010!\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010\u0018\u001a\u00028\u00002\b\b\u0002\u0010'\u001a\u00020(H\u0005\u00a2\u0006\u0002\u0010)J'\u0010*\u001a\u00020+2\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0014H\u0004\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u000202H\u0004J%\u00103\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u0006X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00020\u0006X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerRunner;", "Env", "Lorg/jetbrains/kotlin/compilerRunner/CompilerEnvironment;", "", "()V", "INTERNAL_ERROR", "", "getINTERNAL_ERROR", "()Ljava/lang/String;", "K2JS_COMPILER", "getK2JS_COMPILER", "K2JVM_COMPILER", "getK2JVM_COMPILER", "K2METADATA_COMPILER", "getK2METADATA_COMPILER", "log", "Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "getLog", "()Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "compileWithDaemon", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "compilerClassName", "compilerArgs", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "environment", "(Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;Lorg/jetbrains/kotlin/compilerRunner/CompilerEnvironment;)Lorg/jetbrains/kotlin/cli/common/ExitCode;", "compileWithDaemonOrFallback", "exitCodeFromProcessExitCode", "code", "", "getDaemonConnection", "Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "(Lorg/jetbrains/kotlin/compilerRunner/CompilerEnvironment;)Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "newDaemonConnection", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "clientAliveFlagFile", "Ljava/io/File;", "sessionAliveFlagFile", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "(Lorg/jetbrains/kotlin/daemon/common/CompilerId;Ljava/io/File;Ljava/io/File;Lorg/jetbrains/kotlin/compilerRunner/CompilerEnvironment;Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;)Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "processCompilerOutput", "", "stream", "Ljava/io/ByteArrayOutputStream;", "exitCode", "(Lorg/jetbrains/kotlin/compilerRunner/CompilerEnvironment;Ljava/io/ByteArrayOutputStream;Lorg/jetbrains/kotlin/cli/common/ExitCode;)V", "reportInternalCompilerError", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "runCompiler", "kotlin-compiler-runner"})
public abstract class KotlinCompilerRunner<Env extends CompilerEnvironment> {
    @NotNull
    private final String K2JVM_COMPILER = "org.jetbrains.kotlin.cli.jvm.K2JVMCompiler";
    @NotNull
    private final String K2JS_COMPILER = "org.jetbrains.kotlin.cli.js.K2JSCompiler";
    @NotNull
    private final String K2METADATA_COMPILER = "org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler";
    @NotNull
    private final String INTERNAL_ERROR = ExitCode.INTERNAL_ERROR.toString();

    @NotNull
    protected final String getK2JVM_COMPILER() {
        return this.K2JVM_COMPILER;
    }

    @NotNull
    protected final String getK2JS_COMPILER() {
        return this.K2JS_COMPILER;
    }

    @NotNull
    protected final String getK2METADATA_COMPILER() {
        return this.K2METADATA_COMPILER;
    }

    @NotNull
    protected final String getINTERNAL_ERROR() {
        return this.INTERNAL_ERROR;
    }

    @NotNull
    protected abstract KotlinLogger getLog();

    @Nullable
    protected abstract CompileServiceSession getDaemonConnection(@NotNull Env var1);

    @Nullable
    protected final synchronized CompileServiceSession newDaemonConnection(@NotNull CompilerId compilerId, @NotNull File clientAliveFlagFile, @NotNull File sessionAliveFlagFile, @NotNull Env environment, @NotNull DaemonOptions daemonOptions) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull((Object)clientAliveFlagFile, (String)"clientAliveFlagFile");
        Intrinsics.checkParameterIsNotNull((Object)sessionAliveFlagFile, (String)"sessionAliveFlagFile");
        Intrinsics.checkParameterIsNotNull(environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        String[] stringArray = new String[]{};
        boolean bl = true;
        boolean bl2 = true;
        DaemonJVMOptions daemonJVMOptions = DaemonParamsKt.configureDaemonJVMOptions((String[])stringArray, (boolean)bl2, (boolean)bl);
        ArrayList daemonReportMessages = new ArrayList();
        DaemonReportingTargets daemonReportingTargets = new DaemonReportingTargets(null, daemonReportMessages, null, null, 13, null);
        Profiler profiler = daemonOptions.getReportPerf() ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
        CompileServiceSession connection2 = (CompileServiceSession)profiler.withMeasure(null, (Function0)new Function0<CompileServiceSession>(compilerId, clientAliveFlagFile, daemonJVMOptions, daemonOptions, daemonReportingTargets, sessionAliveFlagFile){
            final /* synthetic */ CompilerId $compilerId;
            final /* synthetic */ File $clientAliveFlagFile;
            final /* synthetic */ DaemonJVMOptions $daemonJVMOptions;
            final /* synthetic */ DaemonOptions $daemonOptions;
            final /* synthetic */ DaemonReportingTargets $daemonReportingTargets;
            final /* synthetic */ File $sessionAliveFlagFile;

            @Nullable
            public final CompileServiceSession invoke() {
                return KotlinCompilerClient.INSTANCE.connectAndLease(this.$compilerId, this.$clientAliveFlagFile, this.$daemonJVMOptions, this.$daemonOptions, this.$daemonReportingTargets, true, true, this.$sessionAliveFlagFile);
            }
            {
                this.$compilerId = compilerId;
                this.$clientAliveFlagFile = file;
                this.$daemonJVMOptions = daemonJVMOptions;
                this.$daemonOptions = daemonOptions;
                this.$daemonReportingTargets = daemonReportingTargets;
                this.$sessionAliveFlagFile = file2;
                super(0);
            }
        });
        if (connection2 == null || this.getLog().isDebugEnabled()) {
            for (DaemonReportMessage message : daemonReportMessages) {
                CompilerMessageSeverity compilerMessageSeverity;
                switch (KotlinCompilerRunner$WhenMappings.$EnumSwitchMapping$0[message.getCategory().ordinal()]) {
                    case 1: {
                        compilerMessageSeverity = CompilerMessageSeverity.INFO;
                        break;
                    }
                    case 2: {
                        compilerMessageSeverity = CompilerMessageSeverity.INFO;
                        break;
                    }
                    case 3: {
                        compilerMessageSeverity = CompilerMessageSeverity.EXCEPTION;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                CompilerMessageSeverity severity = compilerMessageSeverity;
                ((CompilerEnvironment)environment).getMessageCollector().report(severity, message.getMessage(), CompilerMessageLocation.NO_LOCATION);
            }
        }
        newDaemonConnection.1 reportTotalAndThreadPerf$ = newDaemonConnection.1.INSTANCE;
        reportTotalAndThreadPerf$.invoke("Daemon connect", daemonOptions, ((CompilerEnvironment)environment).getMessageCollector(), profiler);
        return connection2;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ CompileServiceSession newDaemonConnection$default(KotlinCompilerRunner kotlinCompilerRunner, CompilerId compilerId, File file, File file2, CompilerEnvironment compilerEnvironment, DaemonOptions daemonOptions, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: newDaemonConnection");
        }
        if ((n & 0x10) != 0) {
            daemonOptions = DaemonParamsKt.configureDaemonOptions();
        }
        return kotlinCompilerRunner.newDaemonConnection(compilerId, file, file2, compilerEnvironment, daemonOptions);
    }

    protected final void processCompilerOutput(@NotNull Env environment, @NotNull ByteArrayOutputStream stream, @Nullable ExitCode exitCode) {
        Intrinsics.checkParameterIsNotNull(environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        BufferedReader reader = new BufferedReader(new StringReader(stream.toString()));
        CompilerOutputParser.INSTANCE.parseCompilerMessagesFromReader(((CompilerEnvironment)environment).getMessageCollector(), reader, ((CompilerEnvironment)environment).getOutputItemsCollector());
        if (Intrinsics.areEqual((Object)ExitCode.INTERNAL_ERROR, (Object)exitCode)) {
            this.reportInternalCompilerError(((CompilerEnvironment)environment).getMessageCollector());
        }
    }

    @NotNull
    protected final ExitCode reportInternalCompilerError(@NotNull MessageCollector messageCollector) {
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        messageCollector.report(CompilerMessageSeverity.ERROR, "Compiler terminated with internal error", CompilerMessageLocation.NO_LOCATION);
        return ExitCode.INTERNAL_ERROR;
    }

    @NotNull
    protected final ExitCode runCompiler(@NotNull String compilerClassName, @NotNull CommonCompilerArguments compilerArgs, @NotNull Env environment) {
        ExitCode exitCode;
        Intrinsics.checkParameterIsNotNull((Object)compilerClassName, (String)"compilerClassName");
        Intrinsics.checkParameterIsNotNull((Object)compilerArgs, (String)"compilerArgs");
        Intrinsics.checkParameterIsNotNull(environment, (String)"environment");
        try {
            exitCode = this.compileWithDaemonOrFallback(compilerClassName, compilerArgs, environment);
        }
        catch (Throwable e) {
            MessageCollectorUtil.reportException((MessageCollector)((CompilerEnvironment)environment).getMessageCollector(), (Throwable)e);
            exitCode = this.reportInternalCompilerError(((CompilerEnvironment)environment).getMessageCollector());
        }
        return exitCode;
    }

    @NotNull
    protected abstract ExitCode compileWithDaemonOrFallback(@NotNull String var1, @NotNull CommonCompilerArguments var2, @NotNull Env var3);

    @Nullable
    protected abstract ExitCode compileWithDaemon(@NotNull String var1, @NotNull CommonCompilerArguments var2, @NotNull Env var3);

    @NotNull
    protected final ExitCode exitCodeFromProcessExitCode(int code) {
        Object object;
        block2: {
            Object[] objectArray;
            Object[] objectArray2 = objectArray = (Object[])ExitCode.values();
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object2 = objectArray2[i];
                ExitCode it = (ExitCode)object2;
                if (!(it.getCode() == code)) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        ExitCode exitCode = (ExitCode)object;
        if (exitCode != null) {
            return exitCode;
        }
        this.getLog().debug("Could not find exit code by value: " + code);
        return code == 0 ? ExitCode.OK : ExitCode.COMPILATION_ERROR;
    }
}

