/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.client;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.rubygrapefruit.platform.Native;
import net.rubygrapefruit.platform.ProcessLauncher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.daemon.client.BasicCompilerServicesWithResultsFacadeServer;
import org.jetbrains.kotlin.daemon.client.CompilationServices;
import org.jetbrains.kotlin.daemon.client.CompilerCallbackServicesFacadeServer;
import org.jetbrains.kotlin.daemon.client.DaemonReportMessage;
import org.jetbrains.kotlin.daemon.client.DaemonReportingTargets;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient$ClientOptions$mappers$1;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient$WhenMappings;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClientKt;
import org.jetbrains.kotlin.daemon.client.RemoteOutputStreamServer;
import org.jetbrains.kotlin.daemon.common.BoolPropMapper;
import org.jetbrains.kotlin.daemon.common.ClientUtilsKt;
import org.jetbrains.kotlin.daemon.common.CompilationOptions;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.CompilerMode;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBase;
import org.jetbrains.kotlin.daemon.common.CompilerServicesFacadeBaseKt;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptionsMemoryComparator;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.NetworkUtilsKt;
import org.jetbrains.kotlin.daemon.common.OptionsGroup;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.PropMapper;
import org.jetbrains.kotlin.daemon.common.RemoteOperationsTracer;
import org.jetbrains.kotlin.daemon.common.RemoteOutputStream;
import org.jetbrains.kotlin.daemon.common.ReportCategory;
import org.jetbrains.kotlin.daemon.common.ReportSeverity;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001RB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JQ\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010 J\u0087\u0001\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a2\u0006\u0010!\u001a\u00020\"2\"\b\u0002\u0010#\u001a\u001c\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0&\u0012\u0004\u0012\u00020'\u0018\u00010$2\b\b\u0002\u0010(\u001a\u00020)2\b\b\u0002\u0010*\u001a\u00020+2\b\b\u0002\u0010\u001d\u001a\u00020\b2\b\b\u0002\u0010,\u001a\u00020-\u00a2\u0006\u0002\u0010.J\b\u0010/\u001a\u000200H\u0002J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0002J:\u00102\u001a\u0004\u0018\u00010\u00152\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020%2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\b\b\u0002\u0010<\u001a\u00020\u0010J<\u00102\u001a\u0004\u0018\u00010\u00152\u0006\u00103\u001a\u0002042\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\b\b\u0002\u0010<\u001a\u00020\u00102\b\b\u0002\u0010=\u001a\u00020\u0010J\u000e\u0010>\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010&Jk\u0010?\u001a\u00020\b2\u0006\u0010@\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u001c2\u0006\u0010D\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\b2\b\b\u0002\u0010,\u001a\u00020-2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001f\u00a2\u0006\u0002\u0010EJ!\u0010F\u001a\u00020'2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001a\"\u00020\u0004H\u0007\u00a2\u0006\u0002\u0010GJ\u000e\u0010H\u001a\u00020'2\u0006\u00103\u001a\u000204J\u0016\u0010H\u001a\u00020'2\u0006\u00103\u001a\u0002042\u0006\u00108\u001a\u000209J(\u0010I\u001a\u00020'2\u0006\u00103\u001a\u0002042\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002JH\u0010J\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u0002070K2\u0006\u0010L\u001a\u00020%2\u0006\u00103\u001a\u0002042\u0006\u00106\u001a\u0002072\u0018\u0010M\u001a\u0014\u0012\u0004\u0012\u00020N\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020'0$H\u0002J&\u0010M\u001a\u00020'*\u00020;2\u0006\u0010O\u001a\u00020N2\u0006\u0010P\u001a\u00020\u00042\b\b\u0002\u0010Q\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006S"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient;", "", "()V", "COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY", "", "getCOMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY", "()Ljava/lang/String;", "DAEMON_CONNECT_CYCLE_ATTEMPTS", "", "getDAEMON_CONNECT_CYCLE_ATTEMPTS", "()I", "DAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "", "getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS", "()J", "verboseReporting", "", "getVerboseReporting", "()Z", "compile", "compilerService", "Lorg/jetbrains/kotlin/daemon/common/CompileService;", "sessionId", "targetPlatform", "Lorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;", "args", "", "out", "Ljava/io/OutputStream;", "port", "operationsTracer", "Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Ljava/io/OutputStream;ILorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)I", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "outputsCollector", "Lkotlin/Function2;", "Ljava/io/File;", "", "", "compilerMode", "Lorg/jetbrains/kotlin/daemon/common/CompilerMode;", "reportSeverity", "Lorg/jetbrains/kotlin/daemon/common/ReportSeverity;", "profiler", "Lorg/jetbrains/kotlin/daemon/common/Profiler;", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Lkotlin/jvm/functions/Function2;Lorg/jetbrains/kotlin/daemon/common/CompilerMode;Lorg/jetbrains/kotlin/daemon/common/ReportSeverity;ILorg/jetbrains/kotlin/daemon/common/Profiler;)I", "configureClientOptions", "Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "opts", "connectToCompileService", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "clientAliveFlagFile", "daemonJVMOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonJVMOptions;", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "reportingTargets", "Lorg/jetbrains/kotlin/daemon/client/DaemonReportingTargets;", "autostart", "checkId", "detectCompilerClasspath", "incrementalCompile", "compileService", "callbackServices", "Lorg/jetbrains/kotlin/daemon/client/CompilationServices;", "compilerOut", "daemonOut", "(Lorg/jetbrains/kotlin/daemon/common/CompileService;ILorg/jetbrains/kotlin/daemon/common/CompileService$TargetPlatform;[Ljava/lang/String;Lorg/jetbrains/kotlin/daemon/client/CompilationServices;Ljava/io/OutputStream;Ljava/io/OutputStream;ILorg/jetbrains/kotlin/daemon/common/Profiler;Lorg/jetbrains/kotlin/daemon/common/RemoteOperationsTracer;)I", "main", "([Ljava/lang/String;)V", "shutdownCompileService", "startDaemon", "tryFindSuitableDaemonOrNewOpts", "Lkotlin/Pair;", "registryDir", "report", "Lorg/jetbrains/kotlin/daemon/common/DaemonReportCategory;", "category", "message", "source", "ClientOptions", "kotlin-compiler-runner"})
public final class KotlinCompilerClient {
    private static final long DAEMON_DEFAULT_STARTUP_TIMEOUT_MS = 10000L;
    private static final int DAEMON_CONNECT_CYCLE_ATTEMPTS = 3;
    private static final boolean verboseReporting;
    @NotNull
    private static final String COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY = "kotlin.daemon.client.options";
    public static final KotlinCompilerClient INSTANCE;

    public final long getDAEMON_DEFAULT_STARTUP_TIMEOUT_MS() {
        return DAEMON_DEFAULT_STARTUP_TIMEOUT_MS;
    }

    public final int getDAEMON_CONNECT_CYCLE_ATTEMPTS() {
        return DAEMON_CONNECT_CYCLE_ATTEMPTS;
    }

    public final boolean getVerboseReporting() {
        return verboseReporting;
    }

    @Nullable
    public final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart, boolean checkId) {
        Object object;
        String p1;
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkParameterIsNotNull((Object)reportingTargets, (String)"reportingTargets");
        Object object2 = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_CLIENT_ALIVE_PATH_PROPERTY());
        if (object2 == null || (object2 = DaemonParamsKt.trimQuotes((String)(p1 = (object = object2)))) == null || (object2 = (String)AddToStdlibKt.check((Object)object2, (Function1)connectToCompileService.flagFile.2.INSTANCE)) == null || (object2 = (File)AddToStdlibKt.check((Object)new File(p1 = (String)(object = object2)), (Function1)connectToCompileService.flagFile.4.INSTANCE)) == null) {
            object2 = ClientUtilsKt.makeAutodeletingFlagFile$default(null, (File)new File(DaemonParamsKt.getRunFilesPathOrDefault((DaemonOptions)daemonOptions)), (int)1, null);
        }
        Object flagFile2 = object2;
        return this.connectToCompileService(compilerId, (File)flagFile2, daemonJVMOptions, daemonOptions, reportingTargets, autostart);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            bl2 = true;
        }
        return kotlinCompilerClient.connectToCompileService(compilerId, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final CompileService connectToCompileService(@NotNull CompilerId compilerId, @NotNull File clientAliveFlagFile, @NotNull DaemonJVMOptions daemonJVMOptions, @NotNull DaemonOptions daemonOptions, @NotNull DaemonReportingTargets reportingTargets, boolean autostart) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        Intrinsics.checkParameterIsNotNull((Object)clientAliveFlagFile, (String)"clientAliveFlagFile");
        Intrinsics.checkParameterIsNotNull((Object)daemonJVMOptions, (String)"daemonJVMOptions");
        Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkParameterIsNotNull((Object)reportingTargets, (String)"reportingTargets");
        int attempts = 0;
        try {
            while (attempts++ < DAEMON_CONNECT_CYCLE_ATTEMPTS) {
                void newJVMOptions;
                void service;
                Pair<CompileService, DaemonJVMOptions> pair = this.tryFindSuitableDaemonOrNewOpts(new File(daemonOptions.getRunFilesPath()), compilerId, daemonJVMOptions, (Function2<? super DaemonReportCategory, ? super String, Unit>)((Function2)new Function2<DaemonReportCategory, String, Unit>(reportingTargets){
                    final /* synthetic */ DaemonReportingTargets $reportingTargets;

                    public final void invoke(@NotNull DaemonReportCategory cat, @NotNull String msg) {
                        Intrinsics.checkParameterIsNotNull((Object)cat, (String)"cat");
                        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                        KotlinCompilerClient.report$default(KotlinCompilerClient.INSTANCE, this.$reportingTargets, cat, msg, null, 4, null);
                    }
                    {
                        this.$reportingTargets = daemonReportingTargets;
                        super(2);
                    }
                }));
                CompileService compileService = (CompileService)pair.component1();
                DaemonJVMOptions daemonJVMOptions2 = (DaemonJVMOptions)pair.component2();
                pair = null;
                if (service != null) {
                    service.registerClient(clientAliveFlagFile.getAbsolutePath());
                    KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.DEBUG, "connected to the daemon", null, 4, null);
                    return service;
                }
                KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.DEBUG, "no suitable daemon found", null, 4, null);
                if (!autostart) continue;
                this.startDaemon(compilerId, (DaemonJVMOptions)newJVMOptions, daemonOptions, reportingTargets);
                KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.DEBUG, "new daemon started, trying to find it", null, 4, null);
            }
        }
        catch (Throwable e) {
            KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.EXCEPTION, e.toString(), null, 4, null);
        }
        return null;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ CompileService connectToCompileService$default(KotlinCompilerClient kotlinCompilerClient, CompilerId compilerId, File file, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets daemonReportingTargets, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return kotlinCompilerClient.connectToCompileService(compilerId, file, daemonJVMOptions, daemonOptions, daemonReportingTargets, bl);
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId, @NotNull DaemonOptions daemonOptions) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
            Intrinsics.checkParameterIsNotNull((Object)daemonOptions, (String)"daemonOptions");
            CompileService compileService = this.connectToCompileService(compilerId, new DaemonJVMOptions(null, null, null, null, 15, null), daemonOptions, new DaemonReportingTargets(System.out, null, null, null, 14, null), false, false);
            if (compileService == null) break block0;
            compileService.shutdown();
        }
    }

    public final void shutdownCompileService(@NotNull CompilerId compilerId) {
        Intrinsics.checkParameterIsNotNull((Object)compilerId, (String)"compilerId");
        this.shutdownCompileService(compilerId, new DaemonOptions(null, 0L, 0, 0, 0L, 0L, false, false, 255, null));
    }

    public final int compile(@NotNull CompileService compilerService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull OutputStream out, int port, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull((Object)compilerService, (String)"compilerService");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        RemoteOutputStreamServer outStrm = new RemoteOutputStreamServer(out, port);
        return ((Number)compilerService.remoteCompile(sessionId, targetPlatform, args, (CompilerCallbackServicesFacade)new CompilerCallbackServicesFacadeServer(null, null, port, 3, null), (RemoteOutputStream)outStrm, CompileService.OutputFormat.PLAIN, (RemoteOutputStream)outStrm, operationsTracer).get()).intValue();
    }

    public static /* bridge */ /* synthetic */ int compile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, OutputStream outputStream, int n2, RemoteOperationsTracer remoteOperationsTracer, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            n2 = NetworkUtilsKt.getSOCKET_ANY_FREE_PORT();
        }
        if ((n3 & 0x40) != 0) {
            remoteOperationsTracer = null;
        }
        return kotlinCompilerClient.compile(compileService, n, targetPlatform, stringArray, outputStream, n2, remoteOperationsTracer);
    }

    public final int incrementalCompile(@NotNull CompileService compileService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull CompilationServices callbackServices, @NotNull OutputStream compilerOut, @NotNull OutputStream daemonOut, int port, @NotNull Profiler profiler, @Nullable RemoteOperationsTracer operationsTracer) {
        Intrinsics.checkParameterIsNotNull((Object)compileService, (String)"compileService");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)callbackServices, (String)"callbackServices");
        Intrinsics.checkParameterIsNotNull((Object)compilerOut, (String)"compilerOut");
        Intrinsics.checkParameterIsNotNull((Object)daemonOut, (String)"daemonOut");
        Intrinsics.checkParameterIsNotNull((Object)profiler, (String)"profiler");
        return ((Number)profiler.withMeasure((Object)this, (Function0)new Function0<Integer>(compileService, sessionId, targetPlatform, args, callbackServices, port, compilerOut, daemonOut, operationsTracer){
            final /* synthetic */ CompileService $compileService;
            final /* synthetic */ int $sessionId;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ String[] $args;
            final /* synthetic */ CompilationServices $callbackServices;
            final /* synthetic */ int $port;
            final /* synthetic */ OutputStream $compilerOut;
            final /* synthetic */ OutputStream $daemonOut;
            final /* synthetic */ RemoteOperationsTracer $operationsTracer;

            public final int invoke() {
                return ((Number)this.$compileService.remoteIncrementalCompile(this.$sessionId, this.$targetPlatform, this.$args, (CompilerCallbackServicesFacade)new CompilerCallbackServicesFacadeServer(this.$callbackServices.getIncrementalCompilationComponents(), this.$callbackServices.getCompilationCanceledStatus(), this.$port), (RemoteOutputStream)new RemoteOutputStreamServer(this.$compilerOut, this.$port), CompileService.OutputFormat.XML, (RemoteOutputStream)new RemoteOutputStreamServer(this.$daemonOut, this.$port), this.$operationsTracer).get()).intValue();
            }
            {
                this.$compileService = compileService;
                this.$sessionId = n;
                this.$targetPlatform = targetPlatform;
                this.$args = stringArray;
                this.$callbackServices = compilationServices;
                this.$port = n2;
                this.$compilerOut = outputStream;
                this.$daemonOut = outputStream2;
                this.$operationsTracer = remoteOperationsTracer;
                super(0);
            }
        })).intValue();
    }

    public static /* bridge */ /* synthetic */ int incrementalCompile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, CompilationServices compilationServices, OutputStream outputStream, OutputStream outputStream2, int n2, Profiler profiler, RemoteOperationsTracer remoteOperationsTracer, int n3, Object object) {
        if ((n3 & 0x80) != 0) {
            n2 = NetworkUtilsKt.getSOCKET_ANY_FREE_PORT();
        }
        if ((n3 & 0x100) != 0) {
            profiler = (Profiler)new DummyProfiler();
        }
        if ((n3 & 0x200) != 0) {
            remoteOperationsTracer = null;
        }
        return kotlinCompilerClient.incrementalCompile(compileService, n, targetPlatform, stringArray, compilationServices, outputStream, outputStream2, n2, profiler, remoteOperationsTracer);
    }

    public final int compile(@NotNull CompileService compilerService, int sessionId, @NotNull CompileService.TargetPlatform targetPlatform, @NotNull String[] args, @NotNull MessageCollector messageCollector, @Nullable Function2<? super File, ? super List<? extends File>, Unit> outputsCollector, @NotNull CompilerMode compilerMode, @NotNull ReportSeverity reportSeverity, int port, @NotNull Profiler profiler) {
        Intrinsics.checkParameterIsNotNull((Object)compilerService, (String)"compilerService");
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkParameterIsNotNull((Object)compilerMode, (String)"compilerMode");
        Intrinsics.checkParameterIsNotNull((Object)reportSeverity, (String)"reportSeverity");
        Intrinsics.checkParameterIsNotNull((Object)profiler, (String)"profiler");
        return ((Number)profiler.withMeasure((Object)this, (Function0)new Function0<Integer>(messageCollector, outputsCollector, port, compilerService, sessionId, args, compilerMode, targetPlatform, reportSeverity){
            final /* synthetic */ MessageCollector $messageCollector;
            final /* synthetic */ Function2 $outputsCollector;
            final /* synthetic */ int $port;
            final /* synthetic */ CompileService $compilerService;
            final /* synthetic */ int $sessionId;
            final /* synthetic */ String[] $args;
            final /* synthetic */ CompilerMode $compilerMode;
            final /* synthetic */ CompileService.TargetPlatform $targetPlatform;
            final /* synthetic */ ReportSeverity $reportSeverity;

            /*
             * WARNING - void declaration
             */
            public final int invoke() {
                void elements$iv;
                CompilationOptions compilationOptions;
                BasicCompilerServicesWithResultsFacadeServer services = new BasicCompilerServicesWithResultsFacadeServer(this.$messageCollector, (Function2<? super File, ? super List<? extends File>, Unit>)this.$outputsCollector, this.$port);
                Integer[] integerArray = new Integer[]{ReportCategory.COMPILER_MESSAGE.getCode(), ReportCategory.DAEMON_MESSAGE.getCode(), ReportCategory.EXCEPTION.getCode(), ReportCategory.OUTPUT_MESSAGE.getCode()};
                CompileService.TargetPlatform targetPlatform = this.$targetPlatform;
                CompilerMode compilerMode = this.$compilerMode;
                CompilationOptions compilationOptions2 = compilationOptions;
                CompilationOptions compilationOptions3 = compilationOptions;
                String[] stringArray = this.$args;
                int n = this.$sessionId;
                CompileService compileService = this.$compilerService;
                Object[] objectArray = (Object[])elements$iv;
                int n2 = this.$reportSeverity.getCode();
                objectArray = (Integer[])objectArray;
                Object[] objectArray2 = new Integer[0];
                compilationOptions2(compilerMode, targetPlatform, (Integer[])objectArray, n2, (Integer[])objectArray2);
                return ((Number)compileService.compile(n, stringArray, compilationOptions3, (CompilerServicesFacadeBase)services, null).get()).intValue();
            }
            {
                this.$messageCollector = messageCollector;
                this.$outputsCollector = function2;
                this.$port = n;
                this.$compilerService = compileService;
                this.$sessionId = n2;
                this.$args = stringArray;
                this.$compilerMode = compilerMode;
                this.$targetPlatform = targetPlatform;
                this.$reportSeverity = reportSeverity;
                super(0);
            }
        })).intValue();
    }

    public static /* bridge */ /* synthetic */ int compile$default(KotlinCompilerClient kotlinCompilerClient, CompileService compileService, int n, CompileService.TargetPlatform targetPlatform, String[] stringArray, MessageCollector messageCollector, Function2 function2, CompilerMode compilerMode, ReportSeverity reportSeverity, int n2, Profiler profiler, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            function2 = null;
        }
        if ((n3 & 0x40) != 0) {
            compilerMode = CompilerMode.NON_INCREMENTAL_COMPILER;
        }
        if ((n3 & 0x80) != 0) {
            reportSeverity = ReportSeverity.INFO;
        }
        if ((n3 & 0x100) != 0) {
            n2 = NetworkUtilsKt.getSOCKET_ANY_FREE_PORT();
        }
        if ((n3 & 0x200) != 0) {
            profiler = (Profiler)new DummyProfiler();
        }
        return kotlinCompilerClient.compile(compileService, n, targetPlatform, stringArray, messageCollector, (Function2<? super File, ? super List<? extends File>, Unit>)function2, compilerMode, reportSeverity, n2, profiler);
    }

    @NotNull
    public final String getCOMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY() {
        return COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY;
    }

    private final ClientOptions configureClientOptions(ClientOptions opts) {
        String string = System.getProperty(COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY);
        if (string != null) {
            String string2;
            String it = string2 = string;
            Iterable unrecognized = DaemonParamsKt.filterExtractProps$default((Iterable)StringsKt.split$default((CharSequence)DaemonParamsKt.trimQuotes((String)it), (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null), opts.getMappers(), (String)"", null, (int)4, null);
            if (CollectionsKt.any((Iterable)unrecognized)) {
                throw (Throwable)new IllegalArgumentException("Unrecognized client options passed via property " + DaemonParamsKt.getCOMPILE_DAEMON_OPTIONS_PROPERTY() + ": " + CollectionsKt.joinToString$default((Iterable)unrecognized, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "\nSupported options: " + CollectionsKt.joinToString$default((Iterable)opts.getMappers(), (CharSequence)", ", null, null, (int)0, null, (Function1)configureClientOptions.1.1.INSTANCE, (int)30, null));
            }
        }
        return opts;
    }

    private final ClientOptions configureClientOptions() {
        return this.configureClientOptions(new ClientOptions(false, 1, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final void main(String ... args) {
        CompileService compileService;
        Object it;
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        CompilerId compilerId = new CompilerId(null, null, 3, null);
        DaemonOptions daemonOptions = DaemonParamsKt.configureDaemonOptions();
        String[] stringArray = new String[]{};
        boolean bl = true;
        boolean bl2 = true;
        DaemonJVMOptions daemonLaunchingOptions = DaemonParamsKt.configureDaemonJVMOptions((String[])stringArray, (boolean)bl2, (boolean)bl);
        ClientOptions clientOptions = INSTANCE.configureClientOptions();
        OptionsGroup[] optionsGroupArray = new OptionsGroup[]{(OptionsGroup)compilerId, (OptionsGroup)daemonOptions, (OptionsGroup)daemonLaunchingOptions, clientOptions};
        String string = DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX();
        Iterable filteredArgs = DaemonParamsKt.filterExtractProps((Iterable)ArraysKt.asIterable((Object[])args), (OptionsGroup[])optionsGroupArray, (String)string);
        if (!clientOptions.getStop()) {
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                System.err.println("compiler wasn't explicitly specified, attempt to find appropriate jar");
                List<String> list = INSTANCE.detectCompilerClasspath();
                if (list != null) {
                    List<String> list2 = list;
                    it = list2;
                    compilerId.setCompilerClasspath(it);
                }
            }
            if (CollectionsKt.none((Iterable)compilerId.getCompilerClasspath())) {
                throw (Throwable)new IllegalArgumentException("Cannot find compiler jar");
            }
            StringBuilder stringBuilder = new StringBuilder().append("desired compiler classpath: ");
            Iterable iterable = compilerId.getCompilerClasspath();
            String string2 = File.pathSeparator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File.pathSeparator");
            String string3 = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null)).toString();
            System.out.println((Object)string3);
        }
        if ((compileService = INSTANCE.connectToCompileService(compilerId, daemonLaunchingOptions, daemonOptions, new DaemonReportingTargets(System.out, null, null, null, 14, null), !clientOptions.getStop(), !clientOptions.getStop())) == null) {
            if (!clientOptions.getStop()) throw (Throwable)new Exception("Unable to connect to daemon");
            System.err.println("No daemon found to shut down");
            return;
        }
        if (clientOptions.getStop()) {
            it = "Shutdown the daemon";
            System.out.println(it);
            compileService.shutdown();
            it = "Daemon shut down successfully";
            System.out.println(it);
            return;
        }
        if (CollectionsKt.none((Iterable)filteredArgs)) {
            it = "Warning: empty arguments list, only daemon check is performed: checkCompilerId() returns " + compileService.checkCompilerId(compilerId);
            System.out.println(it);
            return;
        }
        it = "Executing daemon compilation with args: " + CollectionsKt.joinToString$default((Iterable)filteredArgs, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        System.out.println(it);
        PrintStream printStream = System.out;
        Intrinsics.checkExpressionValueIsNotNull((Object)printStream, (String)"System.out");
        RemoteOutputStreamServer outStrm = new RemoteOutputStreamServer(printStream, 0, 2, null);
        CompilerCallbackServicesFacadeServer servicesFacade = new CompilerCallbackServicesFacadeServer(null, null, 0, 7, null);
        try {
            void $receiver$iv;
            long memBefore = ((Number)compileService.getUsedMemory().get()).longValue() / (long)1024;
            long startTime = System.nanoTime();
            Collection collection = CollectionsKt.toList((Iterable)filteredArgs);
            CompileService.TargetPlatform targetPlatform = CompileService.TargetPlatform.JVM;
            int n = CompileService.Companion.getNO_SESSION();
            Object object = compileService;
            void v5 = $receiver$iv;
            if (v5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = (Collection)v5;
            String[] stringArray2 = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
            if (stringArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray = stringArray2;
            CompileService.CallResult res = object.remoteCompile(n, targetPlatform, (String[])objectArray, (CompilerCallbackServicesFacade)servicesFacade, (RemoteOutputStream)outStrm, CompileService.OutputFormat.PLAIN, (RemoteOutputStream)outStrm, null);
            long endTime = System.nanoTime();
            String $i$f$toTypedArray = "Compilation " + (res.isGood() ? "succeeded" : "failed") + ", result code: " + ((Number)res.get()).intValue();
            System.out.println((Object)$i$f$toTypedArray);
            long memAfter = ((Number)compileService.getUsedMemory().get()).longValue() / (long)1024;
            String string4 = "Compilation time: " + TimeUnit.NANOSECONDS.toMillis(endTime - startTime) + " ms";
            System.out.println((Object)string4);
            string4 = "%+d";
            Object[] objectArray2 = new Object[]{memAfter - memBefore};
            object = new StringBuilder().append("Used memory ").append(memAfter).append(" (");
            String string5 = String.format(string4, Arrays.copyOf(objectArray2, objectArray2.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(this, *args)");
            String string6 = string5;
            string4 = ((StringBuilder)object).append(string6).append(" kb)").toString();
            System.out.println((Object)string4);
            return;
        }
        finally {
            UnicastRemoteObject.unexportObject(servicesFacade, true);
            UnicastRemoteObject.unexportObject(outStrm, true);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final List<String> detectCompilerClasspath() {
        Iterable $receiver$iv$iv;
        String string = System.getProperty("java.class.path");
        Object object = string;
        if (string == null) return null;
        CharSequence charSequence = (CharSequence)object;
        String[] stringArray = new String[1];
        String string2 = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"File.pathSeparator");
        stringArray[0] = string2;
        List list = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        object = list;
        if (list == null) return null;
        Iterable $receiver$iv = (Iterable)object;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            File file = new File((String)it).getParentFile();
            collection.add(file);
        }
        List list2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        object = list2;
        if (list2 == null) return null;
        $receiver$iv = (Iterable)object;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            File file;
            File file2;
            Object element$iv$iv = element$iv$iv$iv;
            File it = (File)element$iv$iv;
            File file3 = it;
            if (file3 != null && (file3 = FilesKt.walk$default((File)file3, null, (int)1, null)) != null) {
                Object v8;
                block5: {
                    void $receiver$iv2;
                    Sequence $i$f$map = (Sequence)file3;
                    for (Object element$iv : $receiver$iv2) {
                        File it2 = (File)element$iv;
                        if (!StringsKt.equals((String)it2.getName(), (String)DaemonParamsKt.getCOMPILER_JAR_NAME(), (boolean)true)) continue;
                        v8 = element$iv;
                        break block5;
                    }
                    v8 = null;
                }
                file2 = v8;
            } else {
                file2 = null;
            }
            if (file2 == null) continue;
            File it$iv$iv = file = file2;
            destination$iv$iv.add(it$iv$iv);
        }
        File file = (File)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        object = file;
        if (file == null) return null;
        Object object2 = object;
        File it = (File)object2;
        List list3 = CollectionsKt.listOf((Object)it.getAbsolutePath());
        return list3;
    }

    private final void report(@NotNull DaemonReportingTargets $receiver, DaemonReportCategory category, String message, String source) {
        block14: {
            MessageCollector it;
            MessageCollector messageCollector;
            if (Intrinsics.areEqual((Object)category, (Object)DaemonReportCategory.DEBUG) && !verboseReporting) {
                return;
            }
            PrintStream printStream = $receiver.getOut();
            if (printStream != null) {
                printStream.println("[" + source + "] " + category.name() + ": " + message);
            }
            Collection<DaemonReportMessage> collection = $receiver.getMessages();
            if (collection != null) {
                collection.add(new DaemonReportMessage(category, "[" + source + "] " + message));
            }
            MessageCollector messageCollector2 = $receiver.getMessageCollector();
            if (messageCollector2 != null) {
                it = messageCollector = messageCollector2;
                switch (KotlinCompilerClient$WhenMappings.$EnumSwitchMapping$0[category.ordinal()]) {
                    case 1: {
                        it.report(CompilerMessageSeverity.LOGGING, message, CompilerMessageLocation.NO_LOCATION);
                        break;
                    }
                    case 2: {
                        it.report(CompilerMessageSeverity.INFO, message, CompilerMessageLocation.NO_LOCATION);
                        break;
                    }
                    case 3: {
                        it.report(CompilerMessageSeverity.EXCEPTION, message, CompilerMessageLocation.NO_LOCATION);
                    }
                }
            }
            CompilerServicesFacadeBase compilerServicesFacadeBase = $receiver.getCompilerServices();
            if (compilerServicesFacadeBase == null) break block14;
            messageCollector = compilerServicesFacadeBase;
            it = (CompilerServicesFacadeBase)messageCollector;
            switch (KotlinCompilerClient$WhenMappings.$EnumSwitchMapping$1[category.ordinal()]) {
                case 1: {
                    CompilerServicesFacadeBaseKt.report((CompilerServicesFacadeBase)it, (ReportCategory)ReportCategory.DAEMON_MESSAGE, (ReportSeverity)ReportSeverity.DEBUG, (String)message, (Serializable)((Serializable)((Object)source)));
                    break;
                }
                case 2: {
                    CompilerServicesFacadeBaseKt.report((CompilerServicesFacadeBase)it, (ReportCategory)ReportCategory.DAEMON_MESSAGE, (ReportSeverity)ReportSeverity.INFO, (String)message, (Serializable)((Serializable)((Object)source)));
                    break;
                }
                case 3: {
                    CompilerServicesFacadeBaseKt.report((CompilerServicesFacadeBase)it, (ReportCategory)ReportCategory.EXCEPTION, (ReportSeverity)ReportSeverity.ERROR, (String)message, (Serializable)((Serializable)((Object)source)));
                }
            }
        }
    }

    static /* bridge */ /* synthetic */ void report$default(KotlinCompilerClient kotlinCompilerClient, DaemonReportingTargets daemonReportingTargets, DaemonReportCategory daemonReportCategory, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "daemon client";
        }
        kotlinCompilerClient.report(daemonReportingTargets, daemonReportCategory, string, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<CompileService, DaemonJVMOptions> tryFindSuitableDaemonOrNewOpts(File registryDir, CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, Function2<? super DaemonReportCategory, ? super String, Unit> report) {
        Sequence sequence;
        Comparator comparator = (Comparator)new DaemonJVMOptionsMemoryComparator();
        Sequence sequence2 = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)ClientUtilsKt.walkDaemons$default((File)registryDir, (CompilerId)compilerId, null, report, (int)4, null), (Function1)tryFindSuitableDaemonOrNewOpts.aliveWithOpts.1.INSTANCE), (Function1)tryFindSuitableDaemonOrNewOpts.aliveWithOpts.2.INSTANCE);
        Comparator comparator2 = new Comparator<Pair<? extends CompileService, ? extends CompileService.CallResult<? extends DaemonJVMOptions>>>(comparator){
            final /* synthetic */ Comparator $comparator;
            {
                this.$comparator = $captured_local_variable$0;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public int compare(Object a, Object b) {
                Pair it;
                Comparator comparator = this.$comparator;
                Pair pair = (Pair)b;
                Comparator comparator2 = comparator;
                DaemonJVMOptions daemonJVMOptions = (DaemonJVMOptions)((CompileService.CallResult)it.getSecond()).get();
                it = (Pair)a;
                DaemonJVMOptions daemonJVMOptions2 = (DaemonJVMOptions)((CompileService.CallResult)it.getSecond()).get();
                return comparator2.compare(daemonJVMOptions, daemonJVMOptions2);
            }
        };
        Sequence aliveWithOpts2 = SequencesKt.sortedWith((Sequence)sequence2, (Comparator)comparator2);
        DaemonJVMOptions optsCopy = DaemonJVMOptions.copy$default((DaemonJVMOptions)daemonJVMOptions, null, null, null, null, (int)15, null);
        Pair pair = (Pair)SequencesKt.firstOrNull((Sequence)aliveWithOpts2);
        if (pair != null && (pair = (Pair)AddToStdlibKt.check((Object)pair, (Function1)((Function1)new Function1<Pair<? extends CompileService, ? extends CompileService.CallResult<? extends DaemonJVMOptions>>, Boolean>(daemonJVMOptions){
            final /* synthetic */ DaemonJVMOptions $daemonJVMOptions;

            public final boolean invoke(@NotNull Pair<? extends CompileService, ? extends CompileService.CallResult<DaemonJVMOptions>> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                return DaemonParamsKt.memorywiseFitsInto((DaemonJVMOptions)this.$daemonJVMOptions, (DaemonJVMOptions)((DaemonJVMOptions)((CompileService.CallResult)it.getSecond()).get()));
            }
            {
                this.$daemonJVMOptions = daemonJVMOptions;
                super(1);
            }
        }))) != null) {
            Pair pair2;
            Pair it = pair2 = pair;
            sequence = new Pair(it.getFirst(), (Object)DaemonParamsKt.updateMemoryUpperBounds((DaemonJVMOptions)optsCopy, (DaemonJVMOptions)((DaemonJVMOptions)((CompileService.CallResult)it.getSecond()).get())));
        } else {
            void $receiver$iv;
            Pair pair3;
            Sequence sequence3 = aliveWithOpts2;
            Object var17_13 = null;
            comparator2 = pair3;
            sequence2 = pair3;
            DaemonJVMOptions accumulator$iv = optsCopy;
            for (Object element$iv : $receiver$iv) {
                void d;
                Pair pair4 = (Pair)element$iv;
                DaemonJVMOptions opts = accumulator$iv;
                accumulator$iv = DaemonParamsKt.updateMemoryUpperBounds((DaemonJVMOptions)opts, (DaemonJVMOptions)((DaemonJVMOptions)((CompileService.CallResult)d.getSecond()).get()));
            }
            DaemonJVMOptions daemonJVMOptions2 = accumulator$iv;
            sequence = sequence2;
            comparator2(var17_13, daemonJVMOptions2);
        }
        return sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void startDaemon(CompilerId compilerId, DaemonJVMOptions daemonJVMOptions, DaemonOptions daemonOptions, DaemonReportingTargets reportingTargets) {
        javaExecutable = new File(new File(System.getProperty("java.home"), "bin"), "java");
        platformSpecificOptions = CollectionsKt.listOf((Object)"-Djava.awt.headless=true");
        v0 = new String[3];
        v0[0] = javaExecutable.getAbsolutePath();
        v0[1] = "-cp";
        v1 = compilerId.getCompilerClasspath();
        v2 = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"File.pathSeparator");
        v0[2] = CollectionsKt.joinToString$default((Iterable)v1, (CharSequence)v2, null, null, (int)0, null, null, (int)62, null);
        var8_7 = daemonJVMOptions.getMappers();
        var20_8 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])v0), (Iterable)platformSpecificOptions);
        var9_9 = $receiver$iv;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            it = (PropMapper)element$iv$iv;
            list$iv$iv = it.toArgs("-");
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var21_18 = (List)destination$iv$iv;
        $receiver$iv = daemonOptions.getMappers();
        var20_8 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)var20_8, (Iterable)var21_18), (Object)DaemonParamsKt.getCOMPILER_DAEMON_CLASS_FQN());
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            it = (PropMapper)element$iv$iv;
            list$iv$iv = it.toArgs(DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var21_18 = (List)destination$iv$iv;
        $receiver$iv = compilerId.getMappers();
        var20_8 = CollectionsKt.plus((Collection)var20_8, (Iterable)var21_18);
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList<E>();
        for (T element$iv$iv : $receiver$iv$iv) {
            it = (PropMapper)element$iv$iv;
            list$iv$iv = it.toArgs(DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var21_18 = (List)destination$iv$iv;
        args = CollectionsKt.plus((Collection)var20_8, (Iterable)var21_18);
        KotlinCompilerClient.report$default(this, reportingTargets, DaemonReportCategory.DEBUG, "starting the daemon as: " + CollectionsKt.joinToString$default((Iterable)args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), null, 4, null);
        processBuilder = new ProcessBuilder(args);
        processBuilder.redirectErrorStream(true);
        daemonLauncher = (ProcessLauncher)Native.get(ProcessLauncher.class);
        daemon = daemonLauncher.start(processBuilder);
        isEchoRead = new Semaphore(1);
        isEchoRead.acquire();
        stdoutThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(daemon, daemonOptions, isEchoRead, reportingTargets){
            final /* synthetic */ Process $daemon;
            final /* synthetic */ DaemonOptions $daemonOptions;
            final /* synthetic */ Semaphore $isEchoRead;
            final /* synthetic */ DaemonReportingTargets $reportingTargets;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                try {
                    InputStream inputStream = this.$daemon.getInputStream();
                    Charset charset = null;
                    boolean bl = true;
                    Object var4_5 = null;
                    if (bl & true) {
                        charset = Charsets.UTF_8;
                    }
                    TextStreamsKt.forEachLine((Reader)new InputStreamReader(inputStream, charset), (Function1)((Function1)new Function1<String, Unit>(this){
                        final /* synthetic */ startDaemon.stdoutThread.1 this$0;

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            CharSequence charSequence = this.this$0.$daemonOptions.getRunFilesPath();
                            if (charSequence.length() > 0 && StringsKt.contains$default((CharSequence)it, (CharSequence)this.this$0.$daemonOptions.getRunFilesPath(), (boolean)false, (int)2, null)) {
                                this.this$0.$isEchoRead.release();
                                return;
                            }
                            KotlinCompilerClient.access$report(KotlinCompilerClient.INSTANCE, this.this$0.$reportingTargets, DaemonReportCategory.DEBUG, it, "daemon");
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    }));
                }
                finally {
                    this.$daemon.getInputStream().close();
                    this.$daemon.getOutputStream().close();
                    this.$daemon.getErrorStream().close();
                }
            }
            {
                this.$daemon = process;
                this.$daemonOptions = daemonOptions;
                this.$isEchoRead = semaphore;
                this.$reportingTargets = daemonReportingTargets;
                super(0);
            }
        }), (int)31, null);
        try {
            v3 = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY());
            if (v3 == null) ** GOTO lbl-1000
            list$iv$iv = v3;
            it = (String)list$iv$iv;
            try {
                var17_21 = it;
                var17_21 = Long.parseLong((String)var17_21);
            }
            catch (Exception e) {
                KotlinCompilerClient.report$default(KotlinCompilerClient.INSTANCE, reportingTargets, DaemonReportCategory.INFO, "unable to interpret " + DaemonParamsKt.getCOMPILE_DAEMON_STARTUP_TIMEOUT_PROPERTY() + " property ('" + it + "'); using default timeout " + KotlinCompilerClient.DAEMON_DEFAULT_STARTUP_TIMEOUT_MS + " ms", null, 4, null);
                var17_21 = null;
            }
            if ((v3 = (Long)var17_21) != null) {
                v4 = v3.longValue();
            } else lbl-1000:
            // 2 sources

            {
                v4 = KotlinCompilerClient.DAEMON_DEFAULT_STARTUP_TIMEOUT_MS;
            }
            daemonStartupTimeout = v4;
            list$iv$iv = daemonOptions.getRunFilesPath();
            if (list$iv$iv.length() > 0) {
                succeeded = isEchoRead.tryAcquire(daemonStartupTimeout, TimeUnit.MILLISECONDS);
                v5 = daemon;
                Intrinsics.checkExpressionValueIsNotNull((Object)v5, (String)"daemon");
                if (!KotlinCompilerClientKt.isProcessAlive(v5)) {
                    throw (Throwable)new Exception("Daemon terminated unexpectedly");
                }
                if (!succeeded) {
                    throw (Throwable)new Exception("Unable to get response from daemon in " + daemonStartupTimeout + " ms");
                }
            } else {
                Thread.sleep(daemonStartupTimeout);
            }
        }
        finally {
            if (stdoutThread.isAlive()) {
                stdoutThread.stop();
            }
        }
    }

    private KotlinCompilerClient() {
        INSTANCE = this;
        DAEMON_DEFAULT_STARTUP_TIMEOUT_MS = 10000L;
        DAEMON_CONNECT_CYCLE_ATTEMPTS = 3;
        verboseReporting = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_VERBOSE_REPORT_PROPERTY()) != null;
        COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY = COMPILE_DAEMON_CLIENT_OPTIONS_PROPERTY;
    }

    static {
        new KotlinCompilerClient();
    }

    public static final /* synthetic */ void access$report(KotlinCompilerClient $this, @NotNull DaemonReportingTargets $receiver, @NotNull DaemonReportCategory category, @NotNull String message, @NotNull String source) {
        $this.report($receiver, category, message, source);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R&\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/daemon/client/KotlinCompilerClient$ClientOptions;", "Lorg/jetbrains/kotlin/daemon/common/OptionsGroup;", "stop", "", "(Z)V", "mappers", "", "Lorg/jetbrains/kotlin/daemon/common/PropMapper;", "getMappers", "()Ljava/util/List;", "getStop", "()Z", "setStop", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "kotlin-compiler-runner"})
    public static final class ClientOptions
    implements OptionsGroup {
        private boolean stop;

        @NotNull
        public List<PropMapper<?, ?, ?>> getMappers() {
            return CollectionsKt.listOf((Object)new BoolPropMapper((Object)this, KotlinCompilerClient$ClientOptions$mappers$1.INSTANCE, null, 4, null));
        }

        public final boolean getStop() {
            return this.stop;
        }

        public final void setStop(boolean bl) {
            this.stop = bl;
        }

        public ClientOptions(boolean stop) {
            this.stop = stop;
        }

        public /* synthetic */ ClientOptions(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public ClientOptions() {
            this(false, 1, null);
        }

        public final boolean component1() {
            return this.stop;
        }

        @NotNull
        public final ClientOptions copy(boolean stop) {
            return new ClientOptions(stop);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ClientOptions copy$default(ClientOptions clientOptions, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = clientOptions.stop;
            }
            return clientOptions.copy(bl);
        }

        public String toString() {
            return "ClientOptions(stop=" + this.stop + ")";
        }

        public int hashCode() {
            int n = this.stop ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ClientOptions)) break block3;
                    ClientOptions clientOptions = (ClientOptions)object;
                    if (!(this.stop == clientOptions.stop)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

