/*
 * Copyright 2010-2024 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package org.jetbrains.kotlin.test.runners.ir;

import com.intellij.testFramework.TestDataPath;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

import java.io.File;
import java.util.regex.Pattern;

/** This class is generated by {@link org.jetbrains.kotlin.test.generators.GenerateCompilerTestsKt}. DO NOT MODIFY MANUALLY */
@SuppressWarnings("all")
@TestMetadata("compiler/testData/ir/irText")
@TestDataPath("$PROJECT_ROOT")
public class ClassicJvmIrTextTestGenerated extends AbstractClassicJvmIrTextTest {
  @Test
  public void testAllFilesPresentInIrText() {
    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, "declarations/multiplatform/k2");
  }

  @Nested
  @TestMetadata("compiler/testData/ir/irText/classes")
  @TestDataPath("$PROJECT_ROOT")
  public class Classes {
    @Test
    @TestMetadata("47424.kt")
    public void test47424() {
      runTest("compiler/testData/ir/irText/classes/47424.kt");
    }

    @Test
    @TestMetadata("abstractMembers.kt")
    public void testAbstractMembers() {
      runTest("compiler/testData/ir/irText/classes/abstractMembers.kt");
    }

    @Test
    public void testAllFilesPresentInClasses() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/classes"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("annotationClasses.kt")
    public void testAnnotationClasses() {
      runTest("compiler/testData/ir/irText/classes/annotationClasses.kt");
    }

    @Test
    @TestMetadata("annotationsOnDelegatedMembers.kt")
    public void testAnnotationsOnDelegatedMembers() {
      runTest("compiler/testData/ir/irText/classes/annotationsOnDelegatedMembers.kt");
    }

    @Test
    @TestMetadata("argumentReorderingInDelegatingConstructorCall.kt")
    public void testArgumentReorderingInDelegatingConstructorCall() {
      runTest("compiler/testData/ir/irText/classes/argumentReorderingInDelegatingConstructorCall.kt");
    }

    @Test
    @TestMetadata("clashingFakeOverrideSignatures.kt")
    public void testClashingFakeOverrideSignatures() {
      runTest("compiler/testData/ir/irText/classes/clashingFakeOverrideSignatures.kt");
    }

    @Test
    @TestMetadata("classMembers.kt")
    public void testClassMembers() {
      runTest("compiler/testData/ir/irText/classes/classMembers.kt");
    }

    @Test
    @TestMetadata("classes.kt")
    public void testClasses() {
      runTest("compiler/testData/ir/irText/classes/classes.kt");
    }

    @Test
    @TestMetadata("cloneable.kt")
    public void testCloneable() {
      runTest("compiler/testData/ir/irText/classes/cloneable.kt");
    }

    @Test
    @TestMetadata("companionObject.kt")
    public void testCompanionObject() {
      runTest("compiler/testData/ir/irText/classes/companionObject.kt");
    }

    @Test
    @TestMetadata("declarationOrder.kt")
    public void testDeclarationOrder() {
      runTest("compiler/testData/ir/irText/classes/declarationOrder.kt");
    }

    @Test
    @TestMetadata("delegatedGenericImplementation.kt")
    public void testDelegatedGenericImplementation() {
      runTest("compiler/testData/ir/irText/classes/delegatedGenericImplementation.kt");
    }

    @Test
    @TestMetadata("delegatedImplementation.kt")
    public void testDelegatedImplementation() {
      runTest("compiler/testData/ir/irText/classes/delegatedImplementation.kt");
    }

    @Test
    @TestMetadata("delegatedImplementationOfJavaInterface.kt")
    public void testDelegatedImplementationOfJavaInterface() {
      runTest("compiler/testData/ir/irText/classes/delegatedImplementationOfJavaInterface.kt");
    }

    @Test
    @TestMetadata("delegatedImplementationWithExplicitOverride.kt")
    public void testDelegatedImplementationWithExplicitOverride() {
      runTest("compiler/testData/ir/irText/classes/delegatedImplementationWithExplicitOverride.kt");
    }

    @Test
    @TestMetadata("delegatingConstructorCallToTypeAliasConstructor.kt")
    public void testDelegatingConstructorCallToTypeAliasConstructor() {
      runTest("compiler/testData/ir/irText/classes/delegatingConstructorCallToTypeAliasConstructor.kt");
    }

    @Test
    @TestMetadata("delegatingConstructorCallsInSecondaryConstructors.kt")
    public void testDelegatingConstructorCallsInSecondaryConstructors() {
      runTest("compiler/testData/ir/irText/classes/delegatingConstructorCallsInSecondaryConstructors.kt");
    }

    @Test
    @TestMetadata("enum.kt")
    public void testEnum() {
      runTest("compiler/testData/ir/irText/classes/enum.kt");
    }

    @Test
    @TestMetadata("enumClassModality.kt")
    public void testEnumClassModality() {
      runTest("compiler/testData/ir/irText/classes/enumClassModality.kt");
    }

    @Test
    @TestMetadata("enumEntries.kt")
    public void testEnumEntries() {
      runTest("compiler/testData/ir/irText/classes/enumEntries.kt");
    }

    @Test
    @TestMetadata("enumWithMultipleCtors.kt")
    public void testEnumWithMultipleCtors() {
      runTest("compiler/testData/ir/irText/classes/enumWithMultipleCtors.kt");
    }

    @Test
    @TestMetadata("enumWithSecondaryCtor.kt")
    public void testEnumWithSecondaryCtor() {
      runTest("compiler/testData/ir/irText/classes/enumWithSecondaryCtor.kt");
    }

    @Test
    @TestMetadata("fakeOverridesForAnyMembers.kt")
    public void testFakeOverridesForAnyMembers() {
      runTest("compiler/testData/ir/irText/classes/fakeOverridesForAnyMembers.kt");
    }

    @Test
    @TestMetadata("fakeOverridesForJavaNonStaticMembers.kt")
    public void testFakeOverridesForJavaNonStaticMembers() {
      runTest("compiler/testData/ir/irText/classes/fakeOverridesForJavaNonStaticMembers.kt");
    }

    @Test
    @TestMetadata("fakeOverridesForJavaStaticMembers.kt")
    public void testFakeOverridesForJavaStaticMembers() {
      runTest("compiler/testData/ir/irText/classes/fakeOverridesForJavaStaticMembers.kt");
    }

    @Test
    @TestMetadata("implicitNotNullOnDelegatedImplementation.kt")
    public void testImplicitNotNullOnDelegatedImplementation() {
      runTest("compiler/testData/ir/irText/classes/implicitNotNullOnDelegatedImplementation.kt");
    }

    @Test
    @TestMetadata("initBlock.kt")
    public void testInitBlock() {
      runTest("compiler/testData/ir/irText/classes/initBlock.kt");
    }

    @Test
    @TestMetadata("initVal.kt")
    public void testInitVal() {
      runTest("compiler/testData/ir/irText/classes/initVal.kt");
    }

    @Test
    @TestMetadata("initValInLambda.kt")
    public void testInitValInLambda() {
      runTest("compiler/testData/ir/irText/classes/initValInLambda.kt");
    }

    @Test
    @TestMetadata("initVar.kt")
    public void testInitVar() {
      runTest("compiler/testData/ir/irText/classes/initVar.kt");
    }

    @Test
    @TestMetadata("inlineClass.kt")
    public void testInlineClass() {
      runTest("compiler/testData/ir/irText/classes/inlineClass.kt");
    }

    @Test
    @TestMetadata("inlineClassSyntheticMethods.kt")
    public void testInlineClassSyntheticMethods() {
      runTest("compiler/testData/ir/irText/classes/inlineClassSyntheticMethods.kt");
    }

    @Test
    @TestMetadata("innerClass.kt")
    public void testInnerClass() {
      runTest("compiler/testData/ir/irText/classes/innerClass.kt");
    }

    @Test
    @TestMetadata("innerClassWithDelegatingConstructor.kt")
    public void testInnerClassWithDelegatingConstructor() {
      runTest("compiler/testData/ir/irText/classes/innerClassWithDelegatingConstructor.kt");
    }

    @Test
    @TestMetadata("kt19306.kt")
    public void testKt19306() {
      runTest("compiler/testData/ir/irText/classes/kt19306.kt");
    }

    @Test
    @TestMetadata("kt43217.kt")
    public void testKt43217() {
      runTest("compiler/testData/ir/irText/classes/kt43217.kt");
    }

    @Test
    @TestMetadata("kt45853.kt")
    public void testKt45853() {
      runTest("compiler/testData/ir/irText/classes/kt45853.kt");
    }

    @Test
    @TestMetadata("kt45934.kt")
    public void testKt45934() {
      runTest("compiler/testData/ir/irText/classes/kt45934.kt");
    }

    @Test
    @TestMetadata("localClasses.kt")
    public void testLocalClasses() {
      runTest("compiler/testData/ir/irText/classes/localClasses.kt");
    }

    @Test
    @TestMetadata("objectLiteralExpressions.kt")
    public void testObjectLiteralExpressions() {
      runTest("compiler/testData/ir/irText/classes/objectLiteralExpressions.kt");
    }

    @Test
    @TestMetadata("objectWithInitializers.kt")
    public void testObjectWithInitializers() {
      runTest("compiler/testData/ir/irText/classes/objectWithInitializers.kt");
    }

    @Test
    @TestMetadata("outerClassAccess.kt")
    public void testOuterClassAccess() {
      runTest("compiler/testData/ir/irText/classes/outerClassAccess.kt");
    }

    @Test
    @TestMetadata("overriddenEquals.kt")
    public void testOverriddenEquals() {
      runTest("compiler/testData/ir/irText/classes/overriddenEquals.kt");
    }

    @Test
    @TestMetadata("primaryConstructor.kt")
    public void testPrimaryConstructor() {
      runTest("compiler/testData/ir/irText/classes/primaryConstructor.kt");
    }

    @Test
    @TestMetadata("primaryConstructorWithSuperConstructorCall.kt")
    public void testPrimaryConstructorWithSuperConstructorCall() {
      runTest("compiler/testData/ir/irText/classes/primaryConstructorWithSuperConstructorCall.kt");
    }

    @Test
    @TestMetadata("privateInterface.kt")
    public void testPrivateInterface() {
      runTest("compiler/testData/ir/irText/classes/privateInterface.kt");
    }

    @Test
    @TestMetadata("qualifiedSuperCalls.kt")
    public void testQualifiedSuperCalls() {
      runTest("compiler/testData/ir/irText/classes/qualifiedSuperCalls.kt");
    }

    @Test
    @TestMetadata("sealedClassConstructorVisibility.kt")
    public void testSealedClassConstructorVisibility() {
      runTest("compiler/testData/ir/irText/classes/sealedClassConstructorVisibility.kt");
    }

    @Test
    @TestMetadata("sealedClasses.kt")
    public void testSealedClasses() {
      runTest("compiler/testData/ir/irText/classes/sealedClasses.kt");
    }

    @Test
    @TestMetadata("secondaryConstructorWithInitializersFromClassBody.kt")
    public void testSecondaryConstructorWithInitializersFromClassBody() {
      runTest("compiler/testData/ir/irText/classes/secondaryConstructorWithInitializersFromClassBody.kt");
    }

    @Test
    @TestMetadata("secondaryConstructors.kt")
    public void testSecondaryConstructors() {
      runTest("compiler/testData/ir/irText/classes/secondaryConstructors.kt");
    }

    @Test
    @TestMetadata("smartCastInValInitialization.kt")
    public void testSmartCastInValInitialization() {
      runTest("compiler/testData/ir/irText/classes/smartCastInValInitialization.kt");
    }

    @Test
    @TestMetadata("superCalls.kt")
    public void testSuperCalls() {
      runTest("compiler/testData/ir/irText/classes/superCalls.kt");
    }

    @Test
    @TestMetadata("superCallsComposed.kt")
    public void testSuperCallsComposed() {
      runTest("compiler/testData/ir/irText/classes/superCallsComposed.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/classes/dataClasses")
    @TestDataPath("$PROJECT_ROOT")
    public class DataClasses {
      @Test
      public void testAllFilesPresentInDataClasses() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/classes/dataClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("dataClassWithArrayMembers.kt")
      public void testDataClassWithArrayMembers() {
        runTest("compiler/testData/ir/irText/classes/dataClasses/dataClassWithArrayMembers.kt");
      }

      @Test
      @TestMetadata("dataClasses.kt")
      public void testDataClasses() {
        runTest("compiler/testData/ir/irText/classes/dataClasses/dataClasses.kt");
      }

      @Test
      @TestMetadata("dataClassesGeneric.kt")
      public void testDataClassesGeneric() {
        runTest("compiler/testData/ir/irText/classes/dataClasses/dataClassesGeneric.kt");
      }

      @Test
      @TestMetadata("dataObject.kt")
      public void testDataObject() {
        runTest("compiler/testData/ir/irText/classes/dataClasses/dataObject.kt");
      }

      @Test
      @TestMetadata("delegationInSealed.kt")
      public void testDelegationInSealed() {
        runTest("compiler/testData/ir/irText/classes/dataClasses/delegationInSealed.kt");
      }

      @Test
      @TestMetadata("kt31649.kt")
      public void testKt31649() {
        runTest("compiler/testData/ir/irText/classes/dataClasses/kt31649.kt");
      }

      @Test
      @TestMetadata("kt49936.kt")
      public void testKt49936() {
        runTest("compiler/testData/ir/irText/classes/dataClasses/kt49936.kt");
      }

      @Test
      @TestMetadata("lambdaInDataClassDefaultParameter.kt")
      public void testLambdaInDataClassDefaultParameter() {
        runTest("compiler/testData/ir/irText/classes/dataClasses/lambdaInDataClassDefaultParameter.kt");
      }

      @Test
      @TestMetadata("openDataClass.kt")
      public void testOpenDataClass() {
        runTest("compiler/testData/ir/irText/classes/dataClasses/openDataClass.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/irText/declarations")
  @TestDataPath("$PROJECT_ROOT")
  public class Declarations {
    @Test
    public void testAllFilesPresentInDeclarations() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, "multiplatform/k2");
    }

    @Test
    @TestMetadata("catchParameterInTopLevelProperty.kt")
    public void testCatchParameterInTopLevelProperty() {
      runTest("compiler/testData/ir/irText/declarations/catchParameterInTopLevelProperty.kt");
    }

    @Test
    @TestMetadata("classLevelProperties.kt")
    public void testClassLevelProperties() {
      runTest("compiler/testData/ir/irText/declarations/classLevelProperties.kt");
    }

    @Test
    @TestMetadata("constValInitializers.kt")
    public void testConstValInitializers() {
      runTest("compiler/testData/ir/irText/declarations/constValInitializers.kt");
    }

    @Test
    @TestMetadata("defaultArguments.kt")
    public void testDefaultArguments() {
      runTest("compiler/testData/ir/irText/declarations/defaultArguments.kt");
    }

    @Test
    @TestMetadata("delegatedProperties.kt")
    public void testDelegatedProperties() {
      runTest("compiler/testData/ir/irText/declarations/delegatedProperties.kt");
    }

    @Test
    @TestMetadata("deprecatedProperty.kt")
    public void testDeprecatedProperty() {
      runTest("compiler/testData/ir/irText/declarations/deprecatedProperty.kt");
    }

    @Test
    @TestMetadata("extensionProperties.kt")
    public void testExtensionProperties() {
      runTest("compiler/testData/ir/irText/declarations/extensionProperties.kt");
    }

    @Test
    @TestMetadata("fakeOverrideModality.kt")
    public void testFakeOverrideModality() {
      runTest("compiler/testData/ir/irText/declarations/fakeOverrideModality.kt");
    }

    @Test
    @TestMetadata("fakeOverrides.kt")
    public void testFakeOverrides() {
      runTest("compiler/testData/ir/irText/declarations/fakeOverrides.kt");
    }

    @Test
    @TestMetadata("fileWithAnnotations.kt")
    public void testFileWithAnnotations() {
      runTest("compiler/testData/ir/irText/declarations/fileWithAnnotations.kt");
    }

    @Test
    @TestMetadata("fileWithTypeAliasesOnly.kt")
    public void testFileWithTypeAliasesOnly() {
      runTest("compiler/testData/ir/irText/declarations/fileWithTypeAliasesOnly.kt");
    }

    @Test
    @TestMetadata("genericDelegatedProperty.kt")
    public void testGenericDelegatedProperty() {
      runTest("compiler/testData/ir/irText/declarations/genericDelegatedProperty.kt");
    }

    @Test
    @TestMetadata("inlineCollectionOfInlineClass.kt")
    public void testInlineCollectionOfInlineClass() {
      runTest("compiler/testData/ir/irText/declarations/inlineCollectionOfInlineClass.kt");
    }

    @Test
    @TestMetadata("interfaceProperties.kt")
    public void testInterfaceProperties() {
      runTest("compiler/testData/ir/irText/declarations/interfaceProperties.kt");
    }

    @Test
    @TestMetadata("internalStdlibOverride.kt")
    public void testInternalStdlibOverride() {
      runTest("compiler/testData/ir/irText/declarations/internalStdlibOverride.kt");
    }

    @Test
    @TestMetadata("kt27005.kt")
    public void testKt27005() {
      runTest("compiler/testData/ir/irText/declarations/kt27005.kt");
    }

    @Test
    @TestMetadata("kt29833.kt")
    public void testKt29833() {
      runTest("compiler/testData/ir/irText/declarations/kt29833.kt");
    }

    @Test
    @TestMetadata("kt35550.kt")
    public void testKt35550() {
      runTest("compiler/testData/ir/irText/declarations/kt35550.kt");
    }

    @Test
    @TestMetadata("kt47527.kt")
    public void testKt47527() {
      runTest("compiler/testData/ir/irText/declarations/kt47527.kt");
    }

    @Test
    @TestMetadata("kt52677.kt")
    public void testKt52677() {
      runTest("compiler/testData/ir/irText/declarations/kt52677.kt");
    }

    @Test
    @TestMetadata("kt65236.kt")
    public void testKt65236() {
      runTest("compiler/testData/ir/irText/declarations/kt65236.kt");
    }

    @Test
    @TestMetadata("kt65273.kt")
    public void testKt65273() {
      runTest("compiler/testData/ir/irText/declarations/kt65273.kt");
    }

    @Test
    @TestMetadata("kt65432.kt")
    public void testKt65432() {
      runTest("compiler/testData/ir/irText/declarations/kt65432.kt");
    }

    @Test
    @TestMetadata("localClassWithOverrides.kt")
    public void testLocalClassWithOverrides() {
      runTest("compiler/testData/ir/irText/declarations/localClassWithOverrides.kt");
    }

    @Test
    @TestMetadata("localDelegatedProperties.kt")
    public void testLocalDelegatedProperties() {
      runTest("compiler/testData/ir/irText/declarations/localDelegatedProperties.kt");
    }

    @Test
    @TestMetadata("localVarInDoWhile.kt")
    public void testLocalVarInDoWhile() {
      runTest("compiler/testData/ir/irText/declarations/localVarInDoWhile.kt");
    }

    @Test
    @TestMetadata("mainFunctionMangling.kt")
    public void testMainFunctionMangling() {
      runTest("compiler/testData/ir/irText/declarations/mainFunctionMangling.kt");
    }

    @Test
    @TestMetadata("mainFunctionManglingInJvm.kt")
    public void testMainFunctionManglingInJvm() {
      runTest("compiler/testData/ir/irText/declarations/mainFunctionManglingInJvm.kt");
    }

    @Test
    @TestMetadata("packageLevelProperties.kt")
    public void testPackageLevelProperties() {
      runTest("compiler/testData/ir/irText/declarations/packageLevelProperties.kt");
    }

    @Test
    @TestMetadata("primaryCtorDefaultArguments.kt")
    public void testPrimaryCtorDefaultArguments() {
      runTest("compiler/testData/ir/irText/declarations/primaryCtorDefaultArguments.kt");
    }

    @Test
    @TestMetadata("primaryCtorProperties.kt")
    public void testPrimaryCtorProperties() {
      runTest("compiler/testData/ir/irText/declarations/primaryCtorProperties.kt");
    }

    @Test
    @TestMetadata("typeAlias.kt")
    public void testTypeAlias() {
      runTest("compiler/testData/ir/irText/declarations/typeAlias.kt");
    }

    @Test
    @TestMetadata("typeAliasOfPrimitiveTypeInVarargArgument.kt")
    public void testTypeAliasOfPrimitiveTypeInVarargArgument() {
      runTest("compiler/testData/ir/irText/declarations/typeAliasOfPrimitiveTypeInVarargArgument.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/declarations/annotations")
    @TestDataPath("$PROJECT_ROOT")
    public class Annotations {
      @Test
      public void testAllFilesPresentInAnnotations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("annotationMixedTargeting.kt")
      public void testAnnotationMixedTargeting() {
        runTest("compiler/testData/ir/irText/declarations/annotations/annotationMixedTargeting.kt");
      }

      @Test
      @TestMetadata("annotationOnClassWithInitializer.kt")
      public void testAnnotationOnClassWithInitializer() {
        runTest("compiler/testData/ir/irText/declarations/annotations/annotationOnClassWithInitializer.kt");
      }

      @Test
      @TestMetadata("annotationRetentions.kt")
      public void testAnnotationRetentions() {
        runTest("compiler/testData/ir/irText/declarations/annotations/annotationRetentions.kt");
      }

      @Test
      @TestMetadata("annotationRetentionsMultiModule.kt")
      public void testAnnotationRetentionsMultiModule() {
        runTest("compiler/testData/ir/irText/declarations/annotations/annotationRetentionsMultiModule.kt");
      }

      @Test
      @TestMetadata("annotationsInAnnotationArguments.kt")
      public void testAnnotationsInAnnotationArguments() {
        runTest("compiler/testData/ir/irText/declarations/annotations/annotationsInAnnotationArguments.kt");
      }

      @Test
      @TestMetadata("annotationsOnDelegatedMembers.kt")
      public void testAnnotationsOnDelegatedMembers() {
        runTest("compiler/testData/ir/irText/declarations/annotations/annotationsOnDelegatedMembers.kt");
      }

      @Test
      @TestMetadata("annotationsWithDefaultParameterValues.kt")
      public void testAnnotationsWithDefaultParameterValues() {
        runTest("compiler/testData/ir/irText/declarations/annotations/annotationsWithDefaultParameterValues.kt");
      }

      @Test
      @TestMetadata("annotationsWithVarargParameters.kt")
      public void testAnnotationsWithVarargParameters() {
        runTest("compiler/testData/ir/irText/declarations/annotations/annotationsWithVarargParameters.kt");
      }

      @Test
      @TestMetadata("argWithDefaultValueInAnnotationClass.kt")
      public void testArgWithDefaultValueInAnnotationClass() {
        runTest("compiler/testData/ir/irText/declarations/annotations/argWithDefaultValueInAnnotationClass.kt");
      }

      @Test
      @TestMetadata("arrayInAnnotationArguments.kt")
      public void testArrayInAnnotationArguments() {
        runTest("compiler/testData/ir/irText/declarations/annotations/arrayInAnnotationArguments.kt");
      }

      @Test
      @TestMetadata("classLiteralInAnnotation.kt")
      public void testClassLiteralInAnnotation() {
        runTest("compiler/testData/ir/irText/declarations/annotations/classLiteralInAnnotation.kt");
      }

      @Test
      @TestMetadata("classesWithAnnotations.kt")
      public void testClassesWithAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/classesWithAnnotations.kt");
      }

      @Test
      @TestMetadata("constExpressionsInAnnotationArguments.kt")
      public void testConstExpressionsInAnnotationArguments() {
        runTest("compiler/testData/ir/irText/declarations/annotations/constExpressionsInAnnotationArguments.kt");
      }

      @Test
      @TestMetadata("constructorsWithAnnotations.kt")
      public void testConstructorsWithAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/constructorsWithAnnotations.kt");
      }

      @Test
      @TestMetadata("delegateFieldWithAnnotations.kt")
      public void testDelegateFieldWithAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/delegateFieldWithAnnotations.kt");
      }

      @Test
      @TestMetadata("delegatedPropertyAccessorsWithAnnotations.kt")
      public void testDelegatedPropertyAccessorsWithAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/delegatedPropertyAccessorsWithAnnotations.kt");
      }

      @Test
      @TestMetadata("enumEntriesWithAnnotations.kt")
      public void testEnumEntriesWithAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/enumEntriesWithAnnotations.kt");
      }

      @Test
      @TestMetadata("enumsInAnnotationArguments.kt")
      public void testEnumsInAnnotationArguments() {
        runTest("compiler/testData/ir/irText/declarations/annotations/enumsInAnnotationArguments.kt");
      }

      @Test
      @TestMetadata("fieldsWithAnnotations.kt")
      public void testFieldsWithAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/fieldsWithAnnotations.kt");
      }

      @Test
      @TestMetadata("fileAnnotations.kt")
      public void testFileAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/fileAnnotations.kt");
      }

      @Test
      @TestMetadata("functionsWithAnnotations.kt")
      public void testFunctionsWithAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/functionsWithAnnotations.kt");
      }

      @Test
      @TestMetadata("genericAnnotationClasses.kt")
      public void testGenericAnnotationClasses() {
        runTest("compiler/testData/ir/irText/declarations/annotations/genericAnnotationClasses.kt");
      }

      @Test
      @TestMetadata("inheritingDeprecation.kt")
      public void testInheritingDeprecation() {
        runTest("compiler/testData/ir/irText/declarations/annotations/inheritingDeprecation.kt");
      }

      @Test
      @TestMetadata("javaAnnotation.kt")
      public void testJavaAnnotation() {
        runTest("compiler/testData/ir/irText/declarations/annotations/javaAnnotation.kt");
      }

      @Test
      @TestMetadata("javaAnnotationWithSingleArrayArgument.kt")
      public void testJavaAnnotationWithSingleArrayArgument() {
        runTest("compiler/testData/ir/irText/declarations/annotations/javaAnnotationWithSingleArrayArgument.kt");
      }

      @Test
      @TestMetadata("localDelegatedPropertiesWithAnnotations.kt")
      public void testLocalDelegatedPropertiesWithAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/localDelegatedPropertiesWithAnnotations.kt");
      }

      @Test
      @TestMetadata("multipleAnnotationsInSquareBrackets.kt")
      public void testMultipleAnnotationsInSquareBrackets() {
        runTest("compiler/testData/ir/irText/declarations/annotations/multipleAnnotationsInSquareBrackets.kt");
      }

      @Test
      @TestMetadata("primaryConstructorParameterWithAnnotations.kt")
      public void testPrimaryConstructorParameterWithAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/primaryConstructorParameterWithAnnotations.kt");
      }

      @Test
      @TestMetadata("propertiesWithAnnotations.kt")
      public void testPropertiesWithAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/propertiesWithAnnotations.kt");
      }

      @Test
      @TestMetadata("propertyAccessorsFromClassHeaderWithAnnotations.kt")
      public void testPropertyAccessorsFromClassHeaderWithAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/propertyAccessorsFromClassHeaderWithAnnotations.kt");
      }

      @Test
      @TestMetadata("propertyAccessorsWithAnnotations.kt")
      public void testPropertyAccessorsWithAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/propertyAccessorsWithAnnotations.kt");
      }

      @Test
      @TestMetadata("propertySetterParameterWithAnnotations.kt")
      public void testPropertySetterParameterWithAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/propertySetterParameterWithAnnotations.kt");
      }

      @Test
      @TestMetadata("receiverParameterWithAnnotations.kt")
      public void testReceiverParameterWithAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/receiverParameterWithAnnotations.kt");
      }

      @Test
      @TestMetadata("specialAnnotationsMetadata.kt")
      public void testSpecialAnnotationsMetadata() {
        runTest("compiler/testData/ir/irText/declarations/annotations/specialAnnotationsMetadata.kt");
      }

      @Test
      @TestMetadata("spreadOperatorInAnnotationArguments.kt")
      public void testSpreadOperatorInAnnotationArguments() {
        runTest("compiler/testData/ir/irText/declarations/annotations/spreadOperatorInAnnotationArguments.kt");
      }

      @Test
      @TestMetadata("typeAliasesWithAnnotations.kt")
      public void testTypeAliasesWithAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/typeAliasesWithAnnotations.kt");
      }

      @Test
      @TestMetadata("typeParametersWithAnnotations.kt")
      public void testTypeParametersWithAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/typeParametersWithAnnotations.kt");
      }

      @Test
      @TestMetadata("valueParametersWithAnnotations.kt")
      public void testValueParametersWithAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/valueParametersWithAnnotations.kt");
      }

      @Test
      @TestMetadata("varargsInAnnotationArguments.kt")
      public void testVarargsInAnnotationArguments() {
        runTest("compiler/testData/ir/irText/declarations/annotations/varargsInAnnotationArguments.kt");
      }

      @Test
      @TestMetadata("variablesWithAnnotations.kt")
      public void testVariablesWithAnnotations() {
        runTest("compiler/testData/ir/irText/declarations/annotations/variablesWithAnnotations.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/declarations/contextParameters")
    @TestDataPath("$PROJECT_ROOT")
    public class ContextParameters {
      @Test
      public void testAllFilesPresentInContextParameters() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/contextParameters"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("contextWithAnnotation.kt")
      public void testContextWithAnnotation() {
        runTest("compiler/testData/ir/irText/declarations/contextParameters/contextWithAnnotation.kt");
      }

      @Test
      @TestMetadata("contextWithJavaAnnotation.kt")
      public void testContextWithJavaAnnotation() {
        runTest("compiler/testData/ir/irText/declarations/contextParameters/contextWithJavaAnnotation.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/declarations/contextReceivers")
    @TestDataPath("$PROJECT_ROOT")
    public class ContextReceivers {
      @Test
      public void testAllFilesPresentInContextReceivers() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/contextReceivers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("arrayAccessCompositeOperators.kt")
      public void testArrayAccessCompositeOperators() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/arrayAccessCompositeOperators.kt");
      }

      @Test
      @TestMetadata("arrayAccessOperators.kt")
      public void testArrayAccessOperators() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/arrayAccessOperators.kt");
      }

      @Test
      @TestMetadata("class.kt")
      public void testClass() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/class.kt");
      }

      @Test
      @TestMetadata("compoundAssignmentOperators.kt")
      public void testCompoundAssignmentOperators() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/compoundAssignmentOperators.kt");
      }

      @Test
      @TestMetadata("contextReceiverMethod.kt")
      public void testContextReceiverMethod() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/contextReceiverMethod.kt");
      }

      @Test
      @TestMetadata("contextualFunctionConversion.kt")
      public void testContextualFunctionConversion() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/contextualFunctionConversion.kt");
      }

      @Test
      @TestMetadata("contextualInlineCall.kt")
      public void testContextualInlineCall() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/contextualInlineCall.kt");
      }

      @Test
      @TestMetadata("contextualPrimaryConstructorWithParams.kt")
      public void testContextualPrimaryConstructorWithParams() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/contextualPrimaryConstructorWithParams.kt");
      }

      @Test
      @TestMetadata("delegatedPropertiesOperators.kt")
      public void testDelegatedPropertiesOperators() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/delegatedPropertiesOperators.kt");
      }

      @Test
      @TestMetadata("function.kt")
      public void testFunction() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/function.kt");
      }

      @Test
      @TestMetadata("functionalType.kt")
      public void testFunctionalType() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/functionalType.kt");
      }

      @Test
      @TestMetadata("genericOuterClass.kt")
      public void testGenericOuterClass() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/genericOuterClass.kt");
      }

      @Test
      @TestMetadata("iteratorOperator.kt")
      public void testIteratorOperator() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/iteratorOperator.kt");
      }

      @Test
      @TestMetadata("kt52791.kt")
      public void testKt52791() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/kt52791.kt");
      }

      @Test
      @TestMetadata("lazy.kt")
      public void testLazy() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/lazy.kt");
      }

      @Test
      @TestMetadata("overloadPriority.kt")
      public void testOverloadPriority() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/overloadPriority.kt");
      }

      @Test
      @TestMetadata("overloading.kt")
      public void testOverloading() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/overloading.kt");
      }

      @Test
      @TestMetadata("passingLambdaToContextualParam.kt")
      public void testPassingLambdaToContextualParam() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/passingLambdaToContextualParam.kt");
      }

      @Test
      @TestMetadata("plusMatrix.kt")
      public void testPlusMatrix() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/plusMatrix.kt");
      }

      @Test
      @TestMetadata("property.kt")
      public void testProperty() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/property.kt");
      }

      @Test
      @TestMetadata("thisWithCustomLabel.kt")
      public void testThisWithCustomLabel() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/thisWithCustomLabel.kt");
      }

      @Test
      @TestMetadata("typeParameterAsContextReceiver.kt")
      public void testTypeParameterAsContextReceiver() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/typeParameterAsContextReceiver.kt");
      }

      @Test
      @TestMetadata("unaryOperators.kt")
      public void testUnaryOperators() {
        runTest("compiler/testData/ir/irText/declarations/contextReceivers/unaryOperators.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP")
      @TestDataPath("$PROJECT_ROOT")
      public class FromKEEP {
        @Test
        public void testAllFilesPresentInFromKEEP() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("canvas.kt")
        public void testCanvas() {
          runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/canvas.kt");
        }

        @Test
        @TestMetadata("compareTo.kt")
        public void testCompareTo() {
          runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/compareTo.kt");
        }

        @Test
        @TestMetadata("dp.kt")
        public void testDp() {
          runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/dp.kt");
        }

        @Test
        @TestMetadata("functionalType.kt")
        public void testFunctionalType() {
          runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/functionalType.kt");
        }

        @Test
        @TestMetadata("monoidSum.kt")
        public void testMonoidSum() {
          runTest("compiler/testData/ir/irText/declarations/contextReceivers/fromKEEP/monoidSum.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/declarations/delegate")
    @TestDataPath("$PROJECT_ROOT")
    public class Delegate {
      @Test
      public void testAllFilesPresentInDelegate() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/delegate"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("delegateForExtPropertyInClass.kt")
      public void testDelegateForExtPropertyInClass() {
        runTest("compiler/testData/ir/irText/declarations/delegate/delegateForExtPropertyInClass.kt");
      }

      @Test
      @TestMetadata("delegationEvaluationOrder1.kt")
      public void testDelegationEvaluationOrder1() {
        runTest("compiler/testData/ir/irText/declarations/delegate/delegationEvaluationOrder1.kt");
      }

      @Test
      @TestMetadata("delegationEvaluationOrder2.kt")
      public void testDelegationEvaluationOrder2() {
        runTest("compiler/testData/ir/irText/declarations/delegate/delegationEvaluationOrder2.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/declarations/jvmRecord")
    @TestDataPath("$PROJECT_ROOT")
    public class JvmRecord {
      @Test
      public void testAllFilesPresentInJvmRecord() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/jvmRecord"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("dataClassWithJvmRecord.kt")
      public void testDataClassWithJvmRecord() {
        runTest("compiler/testData/ir/irText/declarations/jvmRecord/dataClassWithJvmRecord.kt");
      }

      @Test
      @TestMetadata("javaRecordComponentAccess.kt")
      public void testJavaRecordComponentAccess() {
        runTest("compiler/testData/ir/irText/declarations/jvmRecord/javaRecordComponentAccess.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/declarations/multiplatform")
    @TestDataPath("$PROJECT_ROOT")
    public class Multiplatform {
      @Test
      public void testAllFilesPresentInMultiplatform() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/multiplatform"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, "k2");
      }

      @Nested
      @TestMetadata("compiler/testData/ir/irText/declarations/multiplatform/k1")
      @TestDataPath("$PROJECT_ROOT")
      public class K1 {
        @Test
        public void testAllFilesPresentInK1() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/multiplatform/k1"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("expectClassInherited.kt")
        public void testExpectClassInherited() {
          runTest("compiler/testData/ir/irText/declarations/multiplatform/k1/expectClassInherited.kt");
        }

        @Test
        @TestMetadata("expectIntersectionOverride.kt")
        public void testExpectIntersectionOverride() {
          runTest("compiler/testData/ir/irText/declarations/multiplatform/k1/expectIntersectionOverride.kt");
        }

        @Test
        @TestMetadata("expectMemberInNotExpectClass.kt")
        public void testExpectMemberInNotExpectClass() {
          runTest("compiler/testData/ir/irText/declarations/multiplatform/k1/expectMemberInNotExpectClass.kt");
        }

        @Test
        @TestMetadata("expectedEnumClass.kt")
        public void testExpectedEnumClass() {
          runTest("compiler/testData/ir/irText/declarations/multiplatform/k1/expectedEnumClass.kt");
        }

        @Test
        @TestMetadata("expectedFun.kt")
        public void testExpectedFun() {
          runTest("compiler/testData/ir/irText/declarations/multiplatform/k1/expectedFun.kt");
        }

        @Test
        @TestMetadata("expectedSealedClass.kt")
        public void testExpectedSealedClass() {
          runTest("compiler/testData/ir/irText/declarations/multiplatform/k1/expectedSealedClass.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/declarations/parameters")
    @TestDataPath("$PROJECT_ROOT")
    public class Parameters {
      @Test
      public void testAllFilesPresentInParameters() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/parameters"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("class.kt")
      public void testClass() {
        runTest("compiler/testData/ir/irText/declarations/parameters/class.kt");
      }

      @Test
      @TestMetadata("constructor.kt")
      public void testConstructor() {
        runTest("compiler/testData/ir/irText/declarations/parameters/constructor.kt");
      }

      @Test
      @TestMetadata("dataClassMembers.kt")
      public void testDataClassMembers() {
        runTest("compiler/testData/ir/irText/declarations/parameters/dataClassMembers.kt");
      }

      @Test
      @TestMetadata("defaultPropertyAccessors.kt")
      public void testDefaultPropertyAccessors() {
        runTest("compiler/testData/ir/irText/declarations/parameters/defaultPropertyAccessors.kt");
      }

      @Test
      @TestMetadata("delegatedMembers.kt")
      public void testDelegatedMembers() {
        runTest("compiler/testData/ir/irText/declarations/parameters/delegatedMembers.kt");
      }

      @Test
      @TestMetadata("fun.kt")
      public void testFun() {
        runTest("compiler/testData/ir/irText/declarations/parameters/fun.kt");
      }

      @Test
      @TestMetadata("genericInnerClass.kt")
      public void testGenericInnerClass() {
        runTest("compiler/testData/ir/irText/declarations/parameters/genericInnerClass.kt");
      }

      @Test
      @TestMetadata("lambdas.kt")
      public void testLambdas() {
        runTest("compiler/testData/ir/irText/declarations/parameters/lambdas.kt");
      }

      @Test
      @TestMetadata("localFun.kt")
      public void testLocalFun() {
        runTest("compiler/testData/ir/irText/declarations/parameters/localFun.kt");
      }

      @Test
      @TestMetadata("propertyAccessors.kt")
      public void testPropertyAccessors() {
        runTest("compiler/testData/ir/irText/declarations/parameters/propertyAccessors.kt");
      }

      @Test
      @TestMetadata("typeParameterBeforeBound.kt")
      public void testTypeParameterBeforeBound() {
        runTest("compiler/testData/ir/irText/declarations/parameters/typeParameterBeforeBound.kt");
      }

      @Test
      @TestMetadata("typeParameterBoundedBySubclass.kt")
      public void testTypeParameterBoundedBySubclass() {
        runTest("compiler/testData/ir/irText/declarations/parameters/typeParameterBoundedBySubclass.kt");
      }

      @Test
      @TestMetadata("useNextParamInLambda.kt")
      public void testUseNextParamInLambda() {
        runTest("compiler/testData/ir/irText/declarations/parameters/useNextParamInLambda.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/declarations/provideDelegate")
    @TestDataPath("$PROJECT_ROOT")
    public class ProvideDelegate {
      @Test
      public void testAllFilesPresentInProvideDelegate() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/declarations/provideDelegate"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("differentReceivers.kt")
      public void testDifferentReceivers() {
        runTest("compiler/testData/ir/irText/declarations/provideDelegate/differentReceivers.kt");
      }

      @Test
      @TestMetadata("javaDelegate.kt")
      public void testJavaDelegate() {
        runTest("compiler/testData/ir/irText/declarations/provideDelegate/javaDelegate.kt");
      }

      @Test
      @TestMetadata("local.kt")
      public void testLocal() {
        runTest("compiler/testData/ir/irText/declarations/provideDelegate/local.kt");
      }

      @Test
      @TestMetadata("localDifferentReceivers.kt")
      public void testLocalDifferentReceivers() {
        runTest("compiler/testData/ir/irText/declarations/provideDelegate/localDifferentReceivers.kt");
      }

      @Test
      @TestMetadata("member.kt")
      public void testMember() {
        runTest("compiler/testData/ir/irText/declarations/provideDelegate/member.kt");
      }

      @Test
      @TestMetadata("memberExtension.kt")
      public void testMemberExtension() {
        runTest("compiler/testData/ir/irText/declarations/provideDelegate/memberExtension.kt");
      }

      @Test
      @TestMetadata("topLevel.kt")
      public void testTopLevel() {
        runTest("compiler/testData/ir/irText/declarations/provideDelegate/topLevel.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/irText/errors")
  @TestDataPath("$PROJECT_ROOT")
  public class Errors {
    @Test
    public void testAllFilesPresentInErrors() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/errors"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("suppressedNonPublicCall.kt")
    public void testSuppressedNonPublicCall() {
      runTest("compiler/testData/ir/irText/errors/suppressedNonPublicCall.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/irText/expressions")
  @TestDataPath("$PROJECT_ROOT")
  public class Expressions {
    @Test
    public void testAllFilesPresentInExpressions() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("ambiguousFieldAccess.kt")
    public void testAmbiguousFieldAccess() {
      runTest("compiler/testData/ir/irText/expressions/ambiguousFieldAccess.kt");
    }

    @Test
    @TestMetadata("argumentMappedWithError.kt")
    public void testArgumentMappedWithError() {
      runTest("compiler/testData/ir/irText/expressions/argumentMappedWithError.kt");
    }

    @Test
    @TestMetadata("arrayAccess.kt")
    public void testArrayAccess() {
      runTest("compiler/testData/ir/irText/expressions/arrayAccess.kt");
    }

    @Test
    @TestMetadata("arrayAssignment.kt")
    public void testArrayAssignment() {
      runTest("compiler/testData/ir/irText/expressions/arrayAssignment.kt");
    }

    @Test
    @TestMetadata("arrayAugmentedAssignment1.kt")
    public void testArrayAugmentedAssignment1() {
      runTest("compiler/testData/ir/irText/expressions/arrayAugmentedAssignment1.kt");
    }

    @Test
    @TestMetadata("arrayAugmentedAssignment2.kt")
    public void testArrayAugmentedAssignment2() {
      runTest("compiler/testData/ir/irText/expressions/arrayAugmentedAssignment2.kt");
    }

    @Test
    @TestMetadata("assignments.kt")
    public void testAssignments() {
      runTest("compiler/testData/ir/irText/expressions/assignments.kt");
    }

    @Test
    @TestMetadata("atomicFuUncheckedCast.kt")
    public void testAtomicFuUncheckedCast() {
      runTest("compiler/testData/ir/irText/expressions/atomicFuUncheckedCast.kt");
    }

    @Test
    @TestMetadata("augmentedAssignment1.kt")
    public void testAugmentedAssignment1() {
      runTest("compiler/testData/ir/irText/expressions/augmentedAssignment1.kt");
    }

    @Test
    @TestMetadata("augmentedAssignment2.kt")
    public void testAugmentedAssignment2() {
      runTest("compiler/testData/ir/irText/expressions/augmentedAssignment2.kt");
    }

    @Test
    @TestMetadata("augmentedAssignmentWithExpression.kt")
    public void testAugmentedAssignmentWithExpression() {
      runTest("compiler/testData/ir/irText/expressions/augmentedAssignmentWithExpression.kt");
    }

    @Test
    @TestMetadata("badBreakContinue.kt")
    public void testBadBreakContinue() {
      runTest("compiler/testData/ir/irText/expressions/badBreakContinue.kt");
    }

    @Test
    @TestMetadata("badInlinedBreakContinue.kt")
    public void testBadInlinedBreakContinue() {
      runTest("compiler/testData/ir/irText/expressions/badInlinedBreakContinue.kt");
    }

    @Test
    @TestMetadata("bangbang.kt")
    public void testBangbang() {
      runTest("compiler/testData/ir/irText/expressions/bangbang.kt");
    }

    @Test
    @TestMetadata("booleanConstsInAndAndOrOr.kt")
    public void testBooleanConstsInAndAndOrOr() {
      runTest("compiler/testData/ir/irText/expressions/booleanConstsInAndAndOrOr.kt");
    }

    @Test
    @TestMetadata("booleanOperators.kt")
    public void testBooleanOperators() {
      runTest("compiler/testData/ir/irText/expressions/booleanOperators.kt");
    }

    @Test
    @TestMetadata("boundCallableReferences.kt")
    public void testBoundCallableReferences() {
      runTest("compiler/testData/ir/irText/expressions/boundCallableReferences.kt");
    }

    @Test
    @TestMetadata("boxOk.kt")
    public void testBoxOk() {
      runTest("compiler/testData/ir/irText/expressions/boxOk.kt");
    }

    @Test
    @TestMetadata("breakContinue.kt")
    public void testBreakContinue() {
      runTest("compiler/testData/ir/irText/expressions/breakContinue.kt");
    }

    @Test
    @TestMetadata("breakContinueInLoopHeader.kt")
    public void testBreakContinueInLoopHeader() {
      runTest("compiler/testData/ir/irText/expressions/breakContinueInLoopHeader.kt");
    }

    @Test
    @TestMetadata("breakContinueInWhen.kt")
    public void testBreakContinueInWhen() {
      runTest("compiler/testData/ir/irText/expressions/breakContinueInWhen.kt");
    }

    @Test
    @TestMetadata("builtinOperators.kt")
    public void testBuiltinOperators() {
      runTest("compiler/testData/ir/irText/expressions/builtinOperators.kt");
    }

    @Test
    @TestMetadata("callWithReorderedArguments.kt")
    public void testCallWithReorderedArguments() {
      runTest("compiler/testData/ir/irText/expressions/callWithReorderedArguments.kt");
    }

    @Test
    @TestMetadata("calls.kt")
    public void testCalls() {
      runTest("compiler/testData/ir/irText/expressions/calls.kt");
    }

    @Test
    @TestMetadata("castToTypeParameter.kt")
    public void testCastToTypeParameter() {
      runTest("compiler/testData/ir/irText/expressions/castToTypeParameter.kt");
    }

    @Test
    @TestMetadata("catchParameterAccess.kt")
    public void testCatchParameterAccess() {
      runTest("compiler/testData/ir/irText/expressions/catchParameterAccess.kt");
    }

    @Test
    @TestMetadata("chainOfSafeCalls.kt")
    public void testChainOfSafeCalls() {
      runTest("compiler/testData/ir/irText/expressions/chainOfSafeCalls.kt");
    }

    @Test
    @TestMetadata("chainedFunSuspendConversionForSimpleExpression.kt")
    public void testChainedFunSuspendConversionForSimpleExpression() {
      runTest("compiler/testData/ir/irText/expressions/chainedFunSuspendConversionForSimpleExpression.kt");
    }

    @Test
    @TestMetadata("classReference.kt")
    public void testClassReference() {
      runTest("compiler/testData/ir/irText/expressions/classReference.kt");
    }

    @Test
    @TestMetadata("coercionToUnit.kt")
    public void testCoercionToUnit() {
      runTest("compiler/testData/ir/irText/expressions/coercionToUnit.kt");
    }

    @Test
    @TestMetadata("complexAugmentedAssignment.kt")
    public void testComplexAugmentedAssignment() {
      runTest("compiler/testData/ir/irText/expressions/complexAugmentedAssignment.kt");
    }

    @Test
    @TestMetadata("constructorWithOwnTypeParametersCall.kt")
    public void testConstructorWithOwnTypeParametersCall() {
      runTest("compiler/testData/ir/irText/expressions/constructorWithOwnTypeParametersCall.kt");
    }

    @Test
    @TestMetadata("contructorCall.kt")
    public void testContructorCall() {
      runTest("compiler/testData/ir/irText/expressions/contructorCall.kt");
    }

    @Test
    @TestMetadata("conventionComparisons.kt")
    public void testConventionComparisons() {
      runTest("compiler/testData/ir/irText/expressions/conventionComparisons.kt");
    }

    @Test
    @TestMetadata("destructuring1.kt")
    public void testDestructuring1() {
      runTest("compiler/testData/ir/irText/expressions/destructuring1.kt");
    }

    @Test
    @TestMetadata("destructuringWithUnderscore.kt")
    public void testDestructuringWithUnderscore() {
      runTest("compiler/testData/ir/irText/expressions/destructuringWithUnderscore.kt");
    }

    @Test
    @TestMetadata("dotQualified.kt")
    public void testDotQualified() {
      runTest("compiler/testData/ir/irText/expressions/dotQualified.kt");
    }

    @Test
    @TestMetadata("elvis.kt")
    public void testElvis() {
      runTest("compiler/testData/ir/irText/expressions/elvis.kt");
    }

    @Test
    @TestMetadata("enumEntryAsReceiver.kt")
    public void testEnumEntryAsReceiver() {
      runTest("compiler/testData/ir/irText/expressions/enumEntryAsReceiver.kt");
    }

    @Test
    @TestMetadata("enumEntryReferenceFromEnumEntryClass.kt")
    public void testEnumEntryReferenceFromEnumEntryClass() {
      runTest("compiler/testData/ir/irText/expressions/enumEntryReferenceFromEnumEntryClass.kt");
    }

    @Test
    @TestMetadata("equality.kt")
    public void testEquality() {
      runTest("compiler/testData/ir/irText/expressions/equality.kt");
    }

    @Test
    @TestMetadata("equals.kt")
    public void testEquals() {
      runTest("compiler/testData/ir/irText/expressions/equals.kt");
    }

    @Test
    @TestMetadata("exclExclOnPlatformType.kt")
    public void testExclExclOnPlatformType() {
      runTest("compiler/testData/ir/irText/expressions/exclExclOnPlatformType.kt");
    }

    @Test
    @TestMetadata("exhaustiveWhenElseBranch.kt")
    public void testExhaustiveWhenElseBranch() {
      runTest("compiler/testData/ir/irText/expressions/exhaustiveWhenElseBranch.kt");
    }

    @Test
    @TestMetadata("extFunInvokeAsFun.kt")
    public void testExtFunInvokeAsFun() {
      runTest("compiler/testData/ir/irText/expressions/extFunInvokeAsFun.kt");
    }

    @Test
    @TestMetadata("extFunSafeInvoke.kt")
    public void testExtFunSafeInvoke() {
      runTest("compiler/testData/ir/irText/expressions/extFunSafeInvoke.kt");
    }

    @Test
    @TestMetadata("extensionPropertyGetterCall.kt")
    public void testExtensionPropertyGetterCall() {
      runTest("compiler/testData/ir/irText/expressions/extensionPropertyGetterCall.kt");
    }

    @Test
    @TestMetadata("field.kt")
    public void testField() {
      runTest("compiler/testData/ir/irText/expressions/field.kt");
    }

    @Test
    @TestMetadata("fieldAccess_generic.kt")
    public void testFieldAccess_generic() {
      runTest("compiler/testData/ir/irText/expressions/fieldAccess_generic.kt");
    }

    @Test
    @TestMetadata("fieldAccess_invisible.kt")
    public void testFieldAccess_invisible() {
      runTest("compiler/testData/ir/irText/expressions/fieldAccess_invisible.kt");
    }

    @Test
    @TestMetadata("fieldAccess_regular.kt")
    public void testFieldAccess_regular() {
      runTest("compiler/testData/ir/irText/expressions/fieldAccess_regular.kt");
    }

    @Test
    @TestMetadata("for.kt")
    public void testFor() {
      runTest("compiler/testData/ir/irText/expressions/for.kt");
    }

    @Test
    @TestMetadata("forWithBreakContinue.kt")
    public void testForWithBreakContinue() {
      runTest("compiler/testData/ir/irText/expressions/forWithBreakContinue.kt");
    }

    @Test
    @TestMetadata("forWithImplicitReceivers.kt")
    public void testForWithImplicitReceivers() {
      runTest("compiler/testData/ir/irText/expressions/forWithImplicitReceivers.kt");
    }

    @Test
    @TestMetadata("funImportedFromObject.kt")
    public void testFunImportedFromObject() {
      runTest("compiler/testData/ir/irText/expressions/funImportedFromObject.kt");
    }

    @Test
    @TestMetadata("funInterfaceConstructorReference.kt")
    public void testFunInterfaceConstructorReference() {
      runTest("compiler/testData/ir/irText/expressions/funInterfaceConstructorReference.kt");
    }

    @Test
    @TestMetadata("genericConstructorCallWithTypeArguments.kt")
    public void testGenericConstructorCallWithTypeArguments() {
      runTest("compiler/testData/ir/irText/expressions/genericConstructorCallWithTypeArguments.kt");
    }

    @Test
    @TestMetadata("genericPropertyCall.kt")
    public void testGenericPropertyCall() {
      runTest("compiler/testData/ir/irText/expressions/genericPropertyCall.kt");
    }

    @Test
    @TestMetadata("genericPropertyRef.kt")
    public void testGenericPropertyRef() {
      runTest("compiler/testData/ir/irText/expressions/genericPropertyRef.kt");
    }

    @Test
    @TestMetadata("genericReceiverOnExtensionWithSmartcast.kt")
    public void testGenericReceiverOnExtensionWithSmartcast() {
      runTest("compiler/testData/ir/irText/expressions/genericReceiverOnExtensionWithSmartcast.kt");
    }

    @Test
    @TestMetadata("identity.kt")
    public void testIdentity() {
      runTest("compiler/testData/ir/irText/expressions/identity.kt");
    }

    @Test
    @TestMetadata("ifElseIf.kt")
    public void testIfElseIf() {
      runTest("compiler/testData/ir/irText/expressions/ifElseIf.kt");
    }

    @Test
    @TestMetadata("ifWithArrayOperation.kt")
    public void testIfWithArrayOperation() {
      runTest("compiler/testData/ir/irText/expressions/ifWithArrayOperation.kt");
    }

    @Test
    @TestMetadata("ifWithAssignment.kt")
    public void testIfWithAssignment() {
      runTest("compiler/testData/ir/irText/expressions/ifWithAssignment.kt");
    }

    @Test
    @TestMetadata("ifWithLoop.kt")
    public void testIfWithLoop() {
      runTest("compiler/testData/ir/irText/expressions/ifWithLoop.kt");
    }

    @Test
    @TestMetadata("implicitCastInReturnFromConstructor.kt")
    public void testImplicitCastInReturnFromConstructor() {
      runTest("compiler/testData/ir/irText/expressions/implicitCastInReturnFromConstructor.kt");
    }

    @Test
    @TestMetadata("implicitCastOnPlatformType.kt")
    public void testImplicitCastOnPlatformType() {
      runTest("compiler/testData/ir/irText/expressions/implicitCastOnPlatformType.kt");
    }

    @Test
    @TestMetadata("implicitCastToNonNull.kt")
    public void testImplicitCastToNonNull() {
      runTest("compiler/testData/ir/irText/expressions/implicitCastToNonNull.kt");
    }

    @Test
    @TestMetadata("implicitCastToTypeParameter.kt")
    public void testImplicitCastToTypeParameter() {
      runTest("compiler/testData/ir/irText/expressions/implicitCastToTypeParameter.kt");
    }

    @Test
    @TestMetadata("implicitNotNullInDestructuringAssignment.kt")
    public void testImplicitNotNullInDestructuringAssignment() {
      runTest("compiler/testData/ir/irText/expressions/implicitNotNullInDestructuringAssignment.kt");
    }

    @Test
    @TestMetadata("in.kt")
    public void testIn() {
      runTest("compiler/testData/ir/irText/expressions/in.kt");
    }

    @Test
    @TestMetadata("incrementDecrement.kt")
    public void testIncrementDecrement() {
      runTest("compiler/testData/ir/irText/expressions/incrementDecrement.kt");
    }

    @Test
    @TestMetadata("inlinedBreakContinue.kt")
    public void testInlinedBreakContinue() {
      runTest("compiler/testData/ir/irText/expressions/inlinedBreakContinue.kt");
    }

    @Test
    @TestMetadata("interfaceThisRef.kt")
    public void testInterfaceThisRef() {
      runTest("compiler/testData/ir/irText/expressions/interfaceThisRef.kt");
    }

    @Test
    @TestMetadata("intersectedSmartcastForExtensionReceiverWithSameConstructor.kt")
    public void testIntersectedSmartcastForExtensionReceiverWithSameConstructor() {
      runTest("compiler/testData/ir/irText/expressions/intersectedSmartcastForExtensionReceiverWithSameConstructor.kt");
    }

    @Test
    @TestMetadata("javaSyntheticGenericPropretyAccess.kt")
    public void testJavaSyntheticGenericPropretyAccess() {
      runTest("compiler/testData/ir/irText/expressions/javaSyntheticGenericPropretyAccess.kt");
    }

    @Test
    @TestMetadata("javaSyntheticPropertyAccess.kt")
    public void testJavaSyntheticPropertyAccess() {
      runTest("compiler/testData/ir/irText/expressions/javaSyntheticPropertyAccess.kt");
    }

    @Test
    @TestMetadata("jvmFieldReferenceWithIntersectionTypes.kt")
    public void testJvmFieldReferenceWithIntersectionTypes() {
      runTest("compiler/testData/ir/irText/expressions/jvmFieldReferenceWithIntersectionTypes.kt");
    }

    @Test
    @TestMetadata("jvmInstanceFieldReference.kt")
    public void testJvmInstanceFieldReference() {
      runTest("compiler/testData/ir/irText/expressions/jvmInstanceFieldReference.kt");
    }

    @Test
    @TestMetadata("jvmStaticFieldReference.kt")
    public void testJvmStaticFieldReference() {
      runTest("compiler/testData/ir/irText/expressions/jvmStaticFieldReference.kt");
    }

    @Test
    @TestMetadata("kt16904.kt")
    public void testKt16904() {
      runTest("compiler/testData/ir/irText/expressions/kt16904.kt");
    }

    @Test
    @TestMetadata("kt16905.kt")
    public void testKt16905() {
      runTest("compiler/testData/ir/irText/expressions/kt16905.kt");
    }

    @Test
    @TestMetadata("kt23030.kt")
    public void testKt23030() {
      runTest("compiler/testData/ir/irText/expressions/kt23030.kt");
    }

    @Test
    @TestMetadata("kt24804.kt")
    public void testKt24804() {
      runTest("compiler/testData/ir/irText/expressions/kt24804.kt");
    }

    @Test
    @TestMetadata("kt27933.kt")
    public void testKt27933() {
      runTest("compiler/testData/ir/irText/expressions/kt27933.kt");
    }

    @Test
    @TestMetadata("kt28006.kt")
    public void testKt28006() {
      runTest("compiler/testData/ir/irText/expressions/kt28006.kt");
    }

    @Test
    @TestMetadata("kt28456.kt")
    public void testKt28456() {
      runTest("compiler/testData/ir/irText/expressions/kt28456.kt");
    }

    @Test
    @TestMetadata("kt28456a.kt")
    public void testKt28456a() {
      runTest("compiler/testData/ir/irText/expressions/kt28456a.kt");
    }

    @Test
    @TestMetadata("kt28456b.kt")
    public void testKt28456b() {
      runTest("compiler/testData/ir/irText/expressions/kt28456b.kt");
    }

    @Test
    @TestMetadata("kt30020.kt")
    public void testKt30020() {
      runTest("compiler/testData/ir/irText/expressions/kt30020.kt");
    }

    @Test
    @TestMetadata("kt30796.kt")
    public void testKt30796() {
      runTest("compiler/testData/ir/irText/expressions/kt30796.kt");
    }

    @Test
    @TestMetadata("kt35730.kt")
    public void testKt35730() {
      runTest("compiler/testData/ir/irText/expressions/kt35730.kt");
    }

    @Test
    @TestMetadata("kt36956.kt")
    public void testKt36956() {
      runTest("compiler/testData/ir/irText/expressions/kt36956.kt");
    }

    @Test
    @TestMetadata("kt36963.kt")
    public void testKt36963() {
      runTest("compiler/testData/ir/irText/expressions/kt36963.kt");
    }

    @Test
    @TestMetadata("kt37570.kt")
    public void testKt37570() {
      runTest("compiler/testData/ir/irText/expressions/kt37570.kt");
    }

    @Test
    @TestMetadata("kt37779.kt")
    public void testKt37779() {
      runTest("compiler/testData/ir/irText/expressions/kt37779.kt");
    }

    @Test
    @TestMetadata("kt42321.kt")
    public void testKt42321() {
      runTest("compiler/testData/ir/irText/expressions/kt42321.kt");
    }

    @Test
    @TestMetadata("kt44993.kt")
    public void testKt44993() {
      runTest("compiler/testData/ir/irText/expressions/kt44993.kt");
    }

    @Test
    @TestMetadata("kt45022.kt")
    public void testKt45022() {
      runTest("compiler/testData/ir/irText/expressions/kt45022.kt");
    }

    @Test
    @TestMetadata("kt47082.kt")
    public void testKt47082() {
      runTest("compiler/testData/ir/irText/expressions/kt47082.kt");
    }

    @Test
    @TestMetadata("kt47245.kt")
    public void testKt47245() {
      runTest("compiler/testData/ir/irText/expressions/kt47245.kt");
    }

    @Test
    @TestMetadata("kt47450.kt")
    public void testKt47450() {
      runTest("compiler/testData/ir/irText/expressions/kt47450.kt");
    }

    @Test
    @TestMetadata("kt48708.kt")
    public void testKt48708() {
      runTest("compiler/testData/ir/irText/expressions/kt48708.kt");
    }

    @Test
    @TestMetadata("kt48806.kt")
    public void testKt48806() {
      runTest("compiler/testData/ir/irText/expressions/kt48806.kt");
    }

    @Test
    @TestMetadata("kt49203.kt")
    public void testKt49203() {
      runTest("compiler/testData/ir/irText/expressions/kt49203.kt");
    }

    @Test
    @TestMetadata("kt50028.kt")
    public void testKt50028() {
      runTest("compiler/testData/ir/irText/expressions/kt50028.kt");
    }

    @Test
    @TestMetadata("kt51036.kt")
    public void testKt51036() {
      runTest("compiler/testData/ir/irText/expressions/kt51036.kt");
    }

    @Test
    @TestMetadata("kt70753.kt")
    public void testKt70753() {
      runTest("compiler/testData/ir/irText/expressions/kt70753.kt");
    }

    @Test
    @TestMetadata("lambdaInCAO.kt")
    public void testLambdaInCAO() {
      runTest("compiler/testData/ir/irText/expressions/lambdaInCAO.kt");
    }

    @Test
    @TestMetadata("lambdaWithParameterName.kt")
    public void testLambdaWithParameterName() {
      runTest("compiler/testData/ir/irText/expressions/lambdaWithParameterName.kt");
    }

    @Test
    @TestMetadata("literals.kt")
    public void testLiterals() {
      runTest("compiler/testData/ir/irText/expressions/literals.kt");
    }

    @Test
    @TestMetadata("memberTypeArguments.kt")
    public void testMemberTypeArguments() {
      runTest("compiler/testData/ir/irText/expressions/memberTypeArguments.kt");
    }

    @Test
    @TestMetadata("membersImportedFromObject.kt")
    public void testMembersImportedFromObject() {
      runTest("compiler/testData/ir/irText/expressions/membersImportedFromObject.kt");
    }

    @Test
    @TestMetadata("multipleSmartCasts.kt")
    public void testMultipleSmartCasts() {
      runTest("compiler/testData/ir/irText/expressions/multipleSmartCasts.kt");
    }

    @Test
    @TestMetadata("multipleThisReferences.kt")
    public void testMultipleThisReferences() {
      runTest("compiler/testData/ir/irText/expressions/multipleThisReferences.kt");
    }

    @Test
    @TestMetadata("nullCheckOnGenericLambdaReturn.kt")
    public void testNullCheckOnGenericLambdaReturn() {
      runTest("compiler/testData/ir/irText/expressions/nullCheckOnGenericLambdaReturn.kt");
    }

    @Test
    @TestMetadata("nullCheckOnLambdaReturn.kt")
    public void testNullCheckOnLambdaReturn() {
      runTest("compiler/testData/ir/irText/expressions/nullCheckOnLambdaReturn.kt");
    }

    @Test
    @TestMetadata("objectAsCallable.kt")
    public void testObjectAsCallable() {
      runTest("compiler/testData/ir/irText/expressions/objectAsCallable.kt");
    }

    @Test
    @TestMetadata("objectByNameInsideObject.kt")
    public void testObjectByNameInsideObject() {
      runTest("compiler/testData/ir/irText/expressions/objectByNameInsideObject.kt");
    }

    @Test
    @TestMetadata("objectClassReference.kt")
    public void testObjectClassReference() {
      runTest("compiler/testData/ir/irText/expressions/objectClassReference.kt");
    }

    @Test
    @TestMetadata("objectReference.kt")
    public void testObjectReference() {
      runTest("compiler/testData/ir/irText/expressions/objectReference.kt");
    }

    @Test
    @TestMetadata("objectReferenceInClosureInSuperConstructorCall.kt")
    public void testObjectReferenceInClosureInSuperConstructorCall() {
      runTest("compiler/testData/ir/irText/expressions/objectReferenceInClosureInSuperConstructorCall.kt");
    }

    @Test
    @TestMetadata("objectReferenceInFieldInitializer.kt")
    public void testObjectReferenceInFieldInitializer() {
      runTest("compiler/testData/ir/irText/expressions/objectReferenceInFieldInitializer.kt");
    }

    @Test
    @TestMetadata("outerClassInstanceReference.kt")
    public void testOuterClassInstanceReference() {
      runTest("compiler/testData/ir/irText/expressions/outerClassInstanceReference.kt");
    }

    @Test
    @TestMetadata("posptonedPCLACallInsideStringInterpolation.kt")
    public void testPosptonedPCLACallInsideStringInterpolation() {
      runTest("compiler/testData/ir/irText/expressions/posptonedPCLACallInsideStringInterpolation.kt");
    }

    @Test
    @TestMetadata("primitiveComparisons.kt")
    public void testPrimitiveComparisons() {
      runTest("compiler/testData/ir/irText/expressions/primitiveComparisons.kt");
    }

    @Test
    @TestMetadata("primitivesImplicitConversions.kt")
    public void testPrimitivesImplicitConversions() {
      runTest("compiler/testData/ir/irText/expressions/primitivesImplicitConversions.kt");
    }

    @Test
    @TestMetadata("propertyReferences.kt")
    public void testPropertyReferences() {
      runTest("compiler/testData/ir/irText/expressions/propertyReferences.kt");
    }

    @Test
    @TestMetadata("protectedJavaFieldRef.kt")
    public void testProtectedJavaFieldRef() {
      runTest("compiler/testData/ir/irText/expressions/protectedJavaFieldRef.kt");
    }

    @Test
    @TestMetadata("references.kt")
    public void testReferences() {
      runTest("compiler/testData/ir/irText/expressions/references.kt");
    }

    @Test
    @TestMetadata("reflectionLiterals.kt")
    public void testReflectionLiterals() {
      runTest("compiler/testData/ir/irText/expressions/reflectionLiterals.kt");
    }

    @Test
    @TestMetadata("safeAssignment.kt")
    public void testSafeAssignment() {
      runTest("compiler/testData/ir/irText/expressions/safeAssignment.kt");
    }

    @Test
    @TestMetadata("safeCallWithIncrementDecrement.kt")
    public void testSafeCallWithIncrementDecrement() {
      runTest("compiler/testData/ir/irText/expressions/safeCallWithIncrementDecrement.kt");
    }

    @Test
    @TestMetadata("safeCalls.kt")
    public void testSafeCalls() {
      runTest("compiler/testData/ir/irText/expressions/safeCalls.kt");
    }

    @Test
    @TestMetadata("setFieldWithImplicitCast.kt")
    public void testSetFieldWithImplicitCast() {
      runTest("compiler/testData/ir/irText/expressions/setFieldWithImplicitCast.kt");
    }

    @Test
    @TestMetadata("signedToUnsignedConversions.kt")
    public void testSignedToUnsignedConversions() {
      runTest("compiler/testData/ir/irText/expressions/signedToUnsignedConversions.kt");
    }

    @Test
    @TestMetadata("simpleOperators.kt")
    public void testSimpleOperators() {
      runTest("compiler/testData/ir/irText/expressions/simpleOperators.kt");
    }

    @Test
    @TestMetadata("simpleUnaryOperators.kt")
    public void testSimpleUnaryOperators() {
      runTest("compiler/testData/ir/irText/expressions/simpleUnaryOperators.kt");
    }

    @Test
    @TestMetadata("smartCastAside.kt")
    public void testSmartCastAside() {
      runTest("compiler/testData/ir/irText/expressions/smartCastAside.kt");
    }

    @Test
    @TestMetadata("smartCastAside2.kt")
    public void testSmartCastAside2() {
      runTest("compiler/testData/ir/irText/expressions/smartCastAside2.kt");
    }

    @Test
    @TestMetadata("smartCasts.kt")
    public void testSmartCasts() {
      runTest("compiler/testData/ir/irText/expressions/smartCasts.kt");
    }

    @Test
    @TestMetadata("smartCastsWithDestructuring.kt")
    public void testSmartCastsWithDestructuring() {
      runTest("compiler/testData/ir/irText/expressions/smartCastsWithDestructuring.kt");
    }

    @Test
    @TestMetadata("smartcastToIntersection.kt")
    public void testSmartcastToIntersection() {
      runTest("compiler/testData/ir/irText/expressions/smartcastToIntersection.kt");
    }

    @Test
    @TestMetadata("specializedTypeAliasConstructorCall.kt")
    public void testSpecializedTypeAliasConstructorCall() {
      runTest("compiler/testData/ir/irText/expressions/specializedTypeAliasConstructorCall.kt");
    }

    @Test
    @TestMetadata("stringComparisons.kt")
    public void testStringComparisons() {
      runTest("compiler/testData/ir/irText/expressions/stringComparisons.kt");
    }

    @Test
    @TestMetadata("stringPlus.kt")
    public void testStringPlus() {
      runTest("compiler/testData/ir/irText/expressions/stringPlus.kt");
    }

    @Test
    @TestMetadata("stringTemplates.kt")
    public void testStringTemplates() {
      runTest("compiler/testData/ir/irText/expressions/stringTemplates.kt");
    }

    @Test
    @TestMetadata("suspendConversionForExtensionFunction.kt")
    public void testSuspendConversionForExtensionFunction() {
      runTest("compiler/testData/ir/irText/expressions/suspendConversionForExtensionFunction.kt");
    }

    @Test
    @TestMetadata("suspendConversionInVararg.kt")
    public void testSuspendConversionInVararg() {
      runTest("compiler/testData/ir/irText/expressions/suspendConversionInVararg.kt");
    }

    @Test
    @TestMetadata("suspendConversionOnArbitraryExpression.kt")
    public void testSuspendConversionOnArbitraryExpression() {
      runTest("compiler/testData/ir/irText/expressions/suspendConversionOnArbitraryExpression.kt");
    }

    @Test
    @TestMetadata("suspendConversionWithFunInterfaces.kt")
    public void testSuspendConversionWithFunInterfaces() {
      runTest("compiler/testData/ir/irText/expressions/suspendConversionWithFunInterfaces.kt");
    }

    @Test
    @TestMetadata("temporaryInEnumEntryInitializer.kt")
    public void testTemporaryInEnumEntryInitializer() {
      runTest("compiler/testData/ir/irText/expressions/temporaryInEnumEntryInitializer.kt");
    }

    @Test
    @TestMetadata("temporaryInInitBlock.kt")
    public void testTemporaryInInitBlock() {
      runTest("compiler/testData/ir/irText/expressions/temporaryInInitBlock.kt");
    }

    @Test
    @TestMetadata("thisOfGenericOuterClass.kt")
    public void testThisOfGenericOuterClass() {
      runTest("compiler/testData/ir/irText/expressions/thisOfGenericOuterClass.kt");
    }

    @Test
    @TestMetadata("thisRefToObjectInNestedClassConstructorCall.kt")
    public void testThisRefToObjectInNestedClassConstructorCall() {
      runTest("compiler/testData/ir/irText/expressions/thisRefToObjectInNestedClassConstructorCall.kt");
    }

    @Test
    @TestMetadata("thisReferenceBeforeClassDeclared.kt")
    public void testThisReferenceBeforeClassDeclared() {
      runTest("compiler/testData/ir/irText/expressions/thisReferenceBeforeClassDeclared.kt");
    }

    @Test
    @TestMetadata("throw.kt")
    public void testThrow() {
      runTest("compiler/testData/ir/irText/expressions/throw.kt");
    }

    @Test
    @TestMetadata("tryCatch.kt")
    public void testTryCatch() {
      runTest("compiler/testData/ir/irText/expressions/tryCatch.kt");
    }

    @Test
    @TestMetadata("tryCatchIlt.kt")
    public void testTryCatchIlt() {
      runTest("compiler/testData/ir/irText/expressions/tryCatchIlt.kt");
    }

    @Test
    @TestMetadata("tryCatchWithImplicitCast.kt")
    public void testTryCatchWithImplicitCast() {
      runTest("compiler/testData/ir/irText/expressions/tryCatchWithImplicitCast.kt");
    }

    @Test
    @TestMetadata("typeAliasConstructorReference.kt")
    public void testTypeAliasConstructorReference() {
      runTest("compiler/testData/ir/irText/expressions/typeAliasConstructorReference.kt");
    }

    @Test
    @TestMetadata("typeArguments.kt")
    public void testTypeArguments() {
      runTest("compiler/testData/ir/irText/expressions/typeArguments.kt");
    }

    @Test
    @TestMetadata("typeOperators.kt")
    public void testTypeOperators() {
      runTest("compiler/testData/ir/irText/expressions/typeOperators.kt");
    }

    @Test
    @TestMetadata("typeParameterClassLiteral.kt")
    public void testTypeParameterClassLiteral() {
      runTest("compiler/testData/ir/irText/expressions/typeParameterClassLiteral.kt");
    }

    @Test
    @TestMetadata("unsignedIntegerLiterals.kt")
    public void testUnsignedIntegerLiterals() {
      runTest("compiler/testData/ir/irText/expressions/unsignedIntegerLiterals.kt");
    }

    @Test
    @TestMetadata("useImportedMember.kt")
    public void testUseImportedMember() {
      runTest("compiler/testData/ir/irText/expressions/useImportedMember.kt");
    }

    @Test
    @TestMetadata("values.kt")
    public void testValues() {
      runTest("compiler/testData/ir/irText/expressions/values.kt");
    }

    @Test
    @TestMetadata("vararg.kt")
    public void testVararg() {
      runTest("compiler/testData/ir/irText/expressions/vararg.kt");
    }

    @Test
    @TestMetadata("varargListOfJsStatement.kt")
    public void testVarargListOfJsStatement() {
      runTest("compiler/testData/ir/irText/expressions/varargListOfJsStatement.kt");
    }

    @Test
    @TestMetadata("varargWithImplicitCast.kt")
    public void testVarargWithImplicitCast() {
      runTest("compiler/testData/ir/irText/expressions/varargWithImplicitCast.kt");
    }

    @Test
    @TestMetadata("variableAsFunctionCall.kt")
    public void testVariableAsFunctionCall() {
      runTest("compiler/testData/ir/irText/expressions/variableAsFunctionCall.kt");
    }

    @Test
    @TestMetadata("variableAsFunctionCallWithGenerics.kt")
    public void testVariableAsFunctionCallWithGenerics() {
      runTest("compiler/testData/ir/irText/expressions/variableAsFunctionCallWithGenerics.kt");
    }

    @Test
    @TestMetadata("when.kt")
    public void testWhen() {
      runTest("compiler/testData/ir/irText/expressions/when.kt");
    }

    @Test
    @TestMetadata("whenCoercedToUnit.kt")
    public void testWhenCoercedToUnit() {
      runTest("compiler/testData/ir/irText/expressions/whenCoercedToUnit.kt");
    }

    @Test
    @TestMetadata("whenElse.kt")
    public void testWhenElse() {
      runTest("compiler/testData/ir/irText/expressions/whenElse.kt");
    }

    @Test
    @TestMetadata("whenReturn.kt")
    public void testWhenReturn() {
      runTest("compiler/testData/ir/irText/expressions/whenReturn.kt");
    }

    @Test
    @TestMetadata("whenReturnUnit.kt")
    public void testWhenReturnUnit() {
      runTest("compiler/testData/ir/irText/expressions/whenReturnUnit.kt");
    }

    @Test
    @TestMetadata("whenSmartCastToEnum.kt")
    public void testWhenSmartCastToEnum() {
      runTest("compiler/testData/ir/irText/expressions/whenSmartCastToEnum.kt");
    }

    @Test
    @TestMetadata("whenUnusedExpression.kt")
    public void testWhenUnusedExpression() {
      runTest("compiler/testData/ir/irText/expressions/whenUnusedExpression.kt");
    }

    @Test
    @TestMetadata("whenWithSubjectVariable.kt")
    public void testWhenWithSubjectVariable() {
      runTest("compiler/testData/ir/irText/expressions/whenWithSubjectVariable.kt");
    }

    @Test
    @TestMetadata("whileDoWhile.kt")
    public void testWhileDoWhile() {
      runTest("compiler/testData/ir/irText/expressions/whileDoWhile.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/expressions/callableReferences")
    @TestDataPath("$PROJECT_ROOT")
    public class CallableReferences {
      @Test
      @TestMetadata("adaptedExtensionFunctions.kt")
      public void testAdaptedExtensionFunctions() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/adaptedExtensionFunctions.kt");
      }

      @Test
      @TestMetadata("adaptedWithCoercionToUnit.kt")
      public void testAdaptedWithCoercionToUnit() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/adaptedWithCoercionToUnit.kt");
      }

      @Test
      public void testAllFilesPresentInCallableReferences() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions/callableReferences"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("boundInlineAdaptedReference.kt")
      public void testBoundInlineAdaptedReference() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/boundInlineAdaptedReference.kt");
      }

      @Test
      @TestMetadata("boundInnerGenericConstructor.kt")
      public void testBoundInnerGenericConstructor() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/boundInnerGenericConstructor.kt");
      }

      @Test
      @TestMetadata("caoWithAdaptationForSam.kt")
      public void testCaoWithAdaptationForSam() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/caoWithAdaptationForSam.kt");
      }

      @Test
      @TestMetadata("constructorWithAdaptedArguments.kt")
      public void testConstructorWithAdaptedArguments() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/constructorWithAdaptedArguments.kt");
      }

      @Test
      @TestMetadata("funWithDefaultParametersAsKCallableStar.kt")
      public void testFunWithDefaultParametersAsKCallableStar() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/funWithDefaultParametersAsKCallableStar.kt");
      }

      @Test
      @TestMetadata("genericLocalClassConstructorReference.kt")
      public void testGenericLocalClassConstructorReference() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/genericLocalClassConstructorReference.kt");
      }

      @Test
      @TestMetadata("genericMember.kt")
      public void testGenericMember() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/genericMember.kt");
      }

      @Test
      @TestMetadata("importedFromObject.kt")
      public void testImportedFromObject() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/importedFromObject.kt");
      }

      @Test
      @TestMetadata("kt37131.kt")
      public void testKt37131() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/kt37131.kt");
      }

      @Test
      @TestMetadata("kt46069.kt")
      public void testKt46069() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/kt46069.kt");
      }

      @Test
      @TestMetadata("suspendConversion.kt")
      public void testSuspendConversion() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/suspendConversion.kt");
      }

      @Test
      @TestMetadata("typeArguments.kt")
      public void testTypeArguments() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/typeArguments.kt");
      }

      @Test
      @TestMetadata("unboundMemberReferenceWithAdaptedArguments.kt")
      public void testUnboundMemberReferenceWithAdaptedArguments() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/unboundMemberReferenceWithAdaptedArguments.kt");
      }

      @Test
      @TestMetadata("varargFunImportedFromObject.kt")
      public void testVarargFunImportedFromObject() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/varargFunImportedFromObject.kt");
      }

      @Test
      @TestMetadata("withAdaptationForSam.kt")
      public void testWithAdaptationForSam() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/withAdaptationForSam.kt");
      }

      @Test
      @TestMetadata("withAdaptedArguments.kt")
      public void testWithAdaptedArguments() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/withAdaptedArguments.kt");
      }

      @Test
      @TestMetadata("withArgumentAdaptationAndReceiver.kt")
      public void testWithArgumentAdaptationAndReceiver() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/withArgumentAdaptationAndReceiver.kt");
      }

      @Test
      @TestMetadata("withVarargViewedAsArray.kt")
      public void testWithVarargViewedAsArray() {
        runTest("compiler/testData/ir/irText/expressions/callableReferences/withVarargViewedAsArray.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/expressions/floatingPointComparisons")
    @TestDataPath("$PROJECT_ROOT")
    public class FloatingPointComparisons {
      @Test
      public void testAllFilesPresentInFloatingPointComparisons() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions/floatingPointComparisons"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("comparableWithDoubleOrFloat.kt")
      public void testComparableWithDoubleOrFloat() {
        runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/comparableWithDoubleOrFloat.kt");
      }

      @Test
      @TestMetadata("eqeqRhsConditionPossiblyAffectingLhs.kt")
      public void testEqeqRhsConditionPossiblyAffectingLhs() {
        runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/eqeqRhsConditionPossiblyAffectingLhs.kt");
      }

      @Test
      @TestMetadata("floatingPointCompareTo.kt")
      public void testFloatingPointCompareTo() {
        runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointCompareTo.kt");
      }

      @Test
      @TestMetadata("floatingPointEqeq.kt")
      public void testFloatingPointEqeq() {
        runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointEqeq.kt");
      }

      @Test
      @TestMetadata("floatingPointEquals.kt")
      public void testFloatingPointEquals() {
        runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointEquals.kt");
      }

      @Test
      @TestMetadata("floatingPointExcleq.kt")
      public void testFloatingPointExcleq() {
        runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointExcleq.kt");
      }

      @Test
      @TestMetadata("floatingPointLess.kt")
      public void testFloatingPointLess() {
        runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/floatingPointLess.kt");
      }

      @Test
      @TestMetadata("nullableAnyAsIntToDouble.kt")
      public void testNullableAnyAsIntToDouble() {
        runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/nullableAnyAsIntToDouble.kt");
      }

      @Test
      @TestMetadata("nullableFloatingPointEqeq.kt")
      public void testNullableFloatingPointEqeq() {
        runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/nullableFloatingPointEqeq.kt");
      }

      @Test
      @TestMetadata("typeParameterWithPrimitiveNumericSupertype.kt")
      public void testTypeParameterWithPrimitiveNumericSupertype() {
        runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/typeParameterWithPrimitiveNumericSupertype.kt");
      }

      @Test
      @TestMetadata("whenByFloatingPoint.kt")
      public void testWhenByFloatingPoint() {
        runTest("compiler/testData/ir/irText/expressions/floatingPointComparisons/whenByFloatingPoint.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/expressions/funInterface")
    @TestDataPath("$PROJECT_ROOT")
    public class FunInterface {
      @Test
      public void testAllFilesPresentInFunInterface() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions/funInterface"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("arrayAsVarargAfterSamArgument_fi.kt")
      public void testArrayAsVarargAfterSamArgument_fi() {
        runTest("compiler/testData/ir/irText/expressions/funInterface/arrayAsVarargAfterSamArgument_fi.kt");
      }

      @Test
      @TestMetadata("basicFunInterfaceConversion.kt")
      public void testBasicFunInterfaceConversion() {
        runTest("compiler/testData/ir/irText/expressions/funInterface/basicFunInterfaceConversion.kt");
      }

      @Test
      @TestMetadata("castFromAny.kt")
      public void testCastFromAny() {
        runTest("compiler/testData/ir/irText/expressions/funInterface/castFromAny.kt");
      }

      @Test
      @TestMetadata("functionSupertype.kt")
      public void testFunctionSupertype() {
        runTest("compiler/testData/ir/irText/expressions/funInterface/functionSupertype.kt");
      }

      @Test
      @TestMetadata("partialSam.kt")
      public void testPartialSam() {
        runTest("compiler/testData/ir/irText/expressions/funInterface/partialSam.kt");
      }

      @Test
      @TestMetadata("samConversionInVarargs.kt")
      public void testSamConversionInVarargs() {
        runTest("compiler/testData/ir/irText/expressions/funInterface/samConversionInVarargs.kt");
      }

      @Test
      @TestMetadata("samConversionInVarargsMixed.kt")
      public void testSamConversionInVarargsMixed() {
        runTest("compiler/testData/ir/irText/expressions/funInterface/samConversionInVarargsMixed.kt");
      }

      @Test
      @TestMetadata("samConversionOnCallableReference.kt")
      public void testSamConversionOnCallableReference() {
        runTest("compiler/testData/ir/irText/expressions/funInterface/samConversionOnCallableReference.kt");
      }

      @Test
      @TestMetadata("samConversionsWithSmartCasts.kt")
      public void testSamConversionsWithSmartCasts() {
        runTest("compiler/testData/ir/irText/expressions/funInterface/samConversionsWithSmartCasts.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/expressions/sam")
    @TestDataPath("$PROJECT_ROOT")
    public class Sam {
      @Test
      public void testAllFilesPresentInSam() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/expressions/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("genericSamProjectedOut.kt")
      public void testGenericSamProjectedOut() {
        runTest("compiler/testData/ir/irText/expressions/sam/genericSamProjectedOut.kt");
      }

      @Test
      @TestMetadata("genericSamSmartcast.kt")
      public void testGenericSamSmartcast() {
        runTest("compiler/testData/ir/irText/expressions/sam/genericSamSmartcast.kt");
      }

      @Test
      @TestMetadata("samByProjectedType.kt")
      public void testSamByProjectedType() {
        runTest("compiler/testData/ir/irText/expressions/sam/samByProjectedType.kt");
      }

      @Test
      @TestMetadata("samConstructors.kt")
      public void testSamConstructors() {
        runTest("compiler/testData/ir/irText/expressions/sam/samConstructors.kt");
      }

      @Test
      @TestMetadata("samConversionInGenericConstructorCall.kt")
      public void testSamConversionInGenericConstructorCall() {
        runTest("compiler/testData/ir/irText/expressions/sam/samConversionInGenericConstructorCall.kt");
      }

      @Test
      @TestMetadata("samConversionToGeneric.kt")
      public void testSamConversionToGeneric() {
        runTest("compiler/testData/ir/irText/expressions/sam/samConversionToGeneric.kt");
      }

      @Test
      @TestMetadata("samConversions.kt")
      public void testSamConversions() {
        runTest("compiler/testData/ir/irText/expressions/sam/samConversions.kt");
      }

      @Test
      @TestMetadata("samConversionsWithSmartCasts.kt")
      public void testSamConversionsWithSmartCasts() {
        runTest("compiler/testData/ir/irText/expressions/sam/samConversionsWithSmartCasts.kt");
      }

      @Test
      @TestMetadata("samOperators.kt")
      public void testSamOperators() {
        runTest("compiler/testData/ir/irText/expressions/sam/samOperators.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/irText/fakeOverrides")
  @TestDataPath("$PROJECT_ROOT")
  public class FakeOverrides {
    @Test
    public void testAllFilesPresentInFakeOverrides() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("annotatedTypeParameter.kt")
    public void testAnnotatedTypeParameter() {
      runTest("compiler/testData/ir/irText/fakeOverrides/annotatedTypeParameter.kt");
    }

    @Test
    @TestMetadata("capturedTypeInFakeOverride.kt")
    public void testCapturedTypeInFakeOverride() {
      runTest("compiler/testData/ir/irText/fakeOverrides/capturedTypeInFakeOverride.kt");
    }

    @Test
    @TestMetadata("fakeOverrideOfRaw.kt")
    public void testFakeOverrideOfRaw() {
      runTest("compiler/testData/ir/irText/fakeOverrides/fakeOverrideOfRaw.kt");
    }

    @Test
    @TestMetadata("fakeOverrideOfRawJavaCollection.kt")
    public void testFakeOverrideOfRawJavaCollection() {
      runTest("compiler/testData/ir/irText/fakeOverrides/fakeOverrideOfRawJavaCollection.kt");
    }

    @Test
    @TestMetadata("intersectionWithJava.kt")
    public void testIntersectionWithJava() {
      runTest("compiler/testData/ir/irText/fakeOverrides/intersectionWithJava.kt");
    }

    @Test
    @TestMetadata("intersectionWithMappedSignature.kt")
    public void testIntersectionWithMappedSignature() {
      runTest("compiler/testData/ir/irText/fakeOverrides/intersectionWithMappedSignature.kt");
    }

    @Test
    @TestMetadata("intersectionWithRawType.kt")
    public void testIntersectionWithRawType() {
      runTest("compiler/testData/ir/irText/fakeOverrides/intersectionWithRawType.kt");
    }

    @Test
    @TestMetadata("kjkWithRawTypes.kt")
    public void testKjkWithRawTypes() {
      runTest("compiler/testData/ir/irText/fakeOverrides/kjkWithRawTypes.kt");
    }

    @Test
    @TestMetadata("setterVisibliity.kt")
    public void testSetterVisibliity() {
      runTest("compiler/testData/ir/irText/fakeOverrides/setterVisibliity.kt");
    }

    @Test
    @TestMetadata("setterVisibliityWithJava.kt")
    public void testSetterVisibliityWithJava() {
      runTest("compiler/testData/ir/irText/fakeOverrides/setterVisibliityWithJava.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/annotations")
    @TestDataPath("$PROJECT_ROOT")
    public class Annotations {
      @Test
      public void testAllFilesPresentInAnnotations() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/annotations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("basicNullabilityAnnotationOverride.kt")
      public void testBasicNullabilityAnnotationOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/annotations/basicNullabilityAnnotationOverride.kt");
      }

      @Test
      @TestMetadata("intersectionNullabilityAnnotation.kt")
      public void testIntersectionNullabilityAnnotation() {
        runTest("compiler/testData/ir/irText/fakeOverrides/annotations/intersectionNullabilityAnnotation.kt");
      }

      @Test
      @TestMetadata("kotlinCustomAnnotationOverride.kt")
      public void testKotlinCustomAnnotationOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/annotations/kotlinCustomAnnotationOverride.kt");
      }

      @Test
      @TestMetadata("nullabilityAnnotationOverrideOnComplexHierarchy.kt")
      public void testNullabilityAnnotationOverrideOnComplexHierarchy() {
        runTest("compiler/testData/ir/irText/fakeOverrides/annotations/nullabilityAnnotationOverrideOnComplexHierarchy.kt");
      }

      @Test
      @TestMetadata("platformAnnotationOverride.kt")
      public void testPlatformAnnotationOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/annotations/platformAnnotationOverride.kt");
      }

      @Test
      @TestMetadata("typeArgumentAnnotationOverride.kt")
      public void testTypeArgumentAnnotationOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/annotations/typeArgumentAnnotationOverride.kt");
      }

      @Test
      @TestMetadata("typeParameterAnnotationOverride.kt")
      public void testTypeParameterAnnotationOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/annotations/typeParameterAnnotationOverride.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/charsequence")
    @TestDataPath("$PROJECT_ROOT")
    public class Charsequence {
      @Test
      public void testAllFilesPresentInCharsequence() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/charsequence"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("javaCharSequenceOverride.kt")
      public void testJavaCharSequenceOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/charsequence/javaCharSequenceOverride.kt");
      }

      @Test
      @TestMetadata("kotlinCharSequenceOverride.kt")
      public void testKotlinCharSequenceOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/charsequence/kotlinCharSequenceOverride.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/collections")
    @TestDataPath("$PROJECT_ROOT")
    public class Collections {
      @Test
      public void testAllFilesPresentInCollections() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/collections"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Nested
      @TestMetadata("compiler/testData/ir/irText/fakeOverrides/collections/list")
      @TestDataPath("$PROJECT_ROOT")
      public class List {
        @Test
        public void testAllFilesPresentInList() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/collections/list"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("inheritJavaListSubclass.kt")
        public void testInheritJavaListSubclass() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/inheritJavaListSubclass.kt");
        }

        @Test
        @TestMetadata("inheritJavaUtilList.kt")
        public void testInheritJavaUtilList() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/inheritJavaUtilList.kt");
        }

        @Test
        @TestMetadata("intersectionListOverrideKJJ.kt")
        public void testIntersectionListOverrideKJJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/intersectionListOverrideKJJ.kt");
        }

        @Test
        @TestMetadata("intersectionListOverrideKJK.kt")
        public void testIntersectionListOverrideKJK() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/intersectionListOverrideKJK.kt");
        }

        @Test
        @TestMetadata("listOverrideKJ.kt")
        public void testListOverrideKJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/listOverrideKJ.kt");
        }

        @Test
        @TestMetadata("listOverrideKJJ.kt")
        public void testListOverrideKJJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/listOverrideKJJ.kt");
        }

        @Test
        @TestMetadata("listOverrideKJK.kt")
        public void testListOverrideKJK() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/listOverrideKJK.kt");
        }

        @Test
        @TestMetadata("listOverrideOnComplexHierarchy.kt")
        public void testListOverrideOnComplexHierarchy() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/listOverrideOnComplexHierarchy.kt");
        }

        @Test
        @TestMetadata("listOverrideOnKJKJ.kt")
        public void testListOverrideOnKJKJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/listOverrideOnKJKJ.kt");
        }

        @Test
        @TestMetadata("substitutionListOverrideKJ.kt")
        public void testSubstitutionListOverrideKJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/substitutionListOverrideKJ.kt");
        }

        @Test
        @TestMetadata("substitutionListOverrideKJJ.kt")
        public void testSubstitutionListOverrideKJJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/substitutionListOverrideKJJ.kt");
        }

        @Test
        @TestMetadata("substitutionListOverrideKJK.kt")
        public void testSubstitutionListOverrideKJK() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/substitutionListOverrideKJK.kt");
        }

        @Test
        @TestMetadata("substitutionListOverrideKJKJ.kt")
        public void testSubstitutionListOverrideKJKJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/list/substitutionListOverrideKJKJ.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/ir/irText/fakeOverrides/collections/map")
      @TestDataPath("$PROJECT_ROOT")
      public class Map {
        @Test
        public void testAllFilesPresentInMap() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/collections/map"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("intersectionMapOverrideKJJ.kt")
        public void testIntersectionMapOverrideKJJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/intersectionMapOverrideKJJ.kt");
        }

        @Test
        @TestMetadata("intersectionMapOverrideKJK.kt")
        public void testIntersectionMapOverrideKJK() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/intersectionMapOverrideKJK.kt");
        }

        @Test
        @TestMetadata("intersectionWithGenericMapOverrideKJJ.kt")
        public void testIntersectionWithGenericMapOverrideKJJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/intersectionWithGenericMapOverrideKJJ.kt");
        }

        @Test
        @TestMetadata("intersectionWithGenericMapOverrideKJK.kt")
        public void testIntersectionWithGenericMapOverrideKJK() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/intersectionWithGenericMapOverrideKJK.kt");
        }

        @Test
        @TestMetadata("mapOverrideKJKJ.kt")
        public void testMapOverrideKJKJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/mapOverrideKJKJ.kt");
        }

        @Test
        @TestMetadata("mapOverrideOnComplexHierarchy.kt")
        public void testMapOverrideOnComplexHierarchy() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/mapOverrideOnComplexHierarchy.kt");
        }

        @Test
        @TestMetadata("mapOverrideOnKJ.kt")
        public void testMapOverrideOnKJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/mapOverrideOnKJ.kt");
        }

        @Test
        @TestMetadata("mapOverrideOnKJJ.kt")
        public void testMapOverrideOnKJJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/mapOverrideOnKJJ.kt");
        }

        @Test
        @TestMetadata("mapOverrrideOnKJK.kt")
        public void testMapOverrrideOnKJK() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/mapOverrrideOnKJK.kt");
        }

        @Test
        @TestMetadata("substitutionMapOverrideKJJ.kt")
        public void testSubstitutionMapOverrideKJJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/substitutionMapOverrideKJJ.kt");
        }

        @Test
        @TestMetadata("substitutionMapOverrideKJK.kt")
        public void testSubstitutionMapOverrideKJK() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/substitutionMapOverrideKJK.kt");
        }

        @Test
        @TestMetadata("substitutionMapOverrideOnKJKJ.kt")
        public void testSubstitutionMapOverrideOnKJKJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/substitutionMapOverrideOnKJKJ.kt");
        }

        @Test
        @TestMetadata("sunstitutionMapOverrideKJ.kt")
        public void testSunstitutionMapOverrideKJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/map/sunstitutionMapOverrideKJ.kt");
        }
      }

      @Nested
      @TestMetadata("compiler/testData/ir/irText/fakeOverrides/collections/set")
      @TestDataPath("$PROJECT_ROOT")
      public class Set {
        @Test
        public void testAllFilesPresentInSet() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/collections/set"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("intersectionSetOverrideKJJ.kt")
        public void testIntersectionSetOverrideKJJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/set/intersectionSetOverrideKJJ.kt");
        }

        @Test
        @TestMetadata("intersectionSetOverrideKJK.kt")
        public void testIntersectionSetOverrideKJK() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/set/intersectionSetOverrideKJK.kt");
        }

        @Test
        @TestMetadata("setOverrideKJ.kt")
        public void testSetOverrideKJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/set/setOverrideKJ.kt");
        }

        @Test
        @TestMetadata("setOverrideKJJ.kt")
        public void testSetOverrideKJJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/set/setOverrideKJJ.kt");
        }

        @Test
        @TestMetadata("setOverrideKJK.kt")
        public void testSetOverrideKJK() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/set/setOverrideKJK.kt");
        }

        @Test
        @TestMetadata("setOverrideKJKJ.kt")
        public void testSetOverrideKJKJ() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/set/setOverrideKJKJ.kt");
        }

        @Test
        @TestMetadata("setOverrideOnComplexHierarchy.kt")
        public void testSetOverrideOnComplexHierarchy() {
          runTest("compiler/testData/ir/irText/fakeOverrides/collections/set/setOverrideOnComplexHierarchy.kt");
        }
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/dataclass")
    @TestDataPath("$PROJECT_ROOT")
    public class Dataclass {
      @Test
      public void testAllFilesPresentInDataclass() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/dataclass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("dataClassMethodOverride.kt")
      public void testDataClassMethodOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/dataclass/dataClassMethodOverride.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/enum")
    @TestDataPath("$PROJECT_ROOT")
    public class Enum {
      @Test
      public void testAllFilesPresentInEnum() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/enum"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("enumMethodOverride.kt")
      public void testEnumMethodOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/enum/enumMethodOverride.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/fieldmodifiers")
    @TestDataPath("$PROJECT_ROOT")
    public class Fieldmodifiers {
      @Test
      public void testAllFilesPresentInFieldmodifiers() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/fieldmodifiers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("javaModifiersOverride.kt")
      public void testJavaModifiersOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/fieldmodifiers/javaModifiersOverride.kt");
      }

      @Test
      @TestMetadata("kotlinModifiersOverride.kt")
      public void testKotlinModifiersOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/fieldmodifiers/kotlinModifiersOverride.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/generics")
    @TestDataPath("$PROJECT_ROOT")
    public class Generics {
      @Test
      public void testAllFilesPresentInGenerics() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/generics"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("basicGenericMethodsOverride.kt")
      public void testBasicGenericMethodsOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/basicGenericMethodsOverride.kt");
      }

      @Test
      @TestMetadata("basicGenericWithBoundsOverride.kt")
      public void testBasicGenericWithBoundsOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/basicGenericWithBoundsOverride.kt");
      }

      @Test
      @TestMetadata("basicRawTypeOverride.kt")
      public void testBasicRawTypeOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/basicRawTypeOverride.kt");
      }

      @Test
      @TestMetadata("basicWilcardsOverride.kt")
      public void testBasicWilcardsOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/basicWilcardsOverride.kt");
      }

      @Test
      @TestMetadata("genericMethodOverrideOnComplexHierarchy.kt")
      public void testGenericMethodOverrideOnComplexHierarchy() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/genericMethodOverrideOnComplexHierarchy.kt");
      }

      @Test
      @TestMetadata("genericMethodOverrideOnKJJ.kt")
      public void testGenericMethodOverrideOnKJJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/genericMethodOverrideOnKJJ.kt");
      }

      @Test
      @TestMetadata("genericMethodOverrideOnKJK.kt")
      public void testGenericMethodOverrideOnKJK() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/genericMethodOverrideOnKJK.kt");
      }

      @Test
      @TestMetadata("genericWithBoundsOnComplexHierarchy.kt")
      public void testGenericWithBoundsOnComplexHierarchy() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/genericWithBoundsOnComplexHierarchy.kt");
      }

      @Test
      @TestMetadata("genericWithBoundsOnKJJ.kt")
      public void testGenericWithBoundsOnKJJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/genericWithBoundsOnKJJ.kt");
      }

      @Test
      @TestMetadata("genericWithBoundsOnKJK.kt")
      public void testGenericWithBoundsOnKJK() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/genericWithBoundsOnKJK.kt");
      }

      @Test
      @TestMetadata("intersectionGenericMethodOverride.kt")
      public void testIntersectionGenericMethodOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/intersectionGenericMethodOverride.kt");
      }

      @Test
      @TestMetadata("intersectionGenericWithBoundsOverride.kt")
      public void testIntersectionGenericWithBoundsOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/intersectionGenericWithBoundsOverride.kt");
      }

      @Test
      @TestMetadata("intersectionRawTypeOverride.kt")
      public void testIntersectionRawTypeOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/intersectionRawTypeOverride.kt");
      }

      @Test
      @TestMetadata("intersectionWildcardsOverride.kt")
      public void testIntersectionWildcardsOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/intersectionWildcardsOverride.kt");
      }

      @Test
      @TestMetadata("rawTypeOverrideOnComplexHierarchy.kt")
      public void testRawTypeOverrideOnComplexHierarchy() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/rawTypeOverrideOnComplexHierarchy.kt");
      }

      @Test
      @TestMetadata("rawTypeOverrideOnKJJ.kt")
      public void testRawTypeOverrideOnKJJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/rawTypeOverrideOnKJJ.kt");
      }

      @Test
      @TestMetadata("wildcardsOverrideOnComplexHierarchy.kt")
      public void testWildcardsOverrideOnComplexHierarchy() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/wildcardsOverrideOnComplexHierarchy.kt");
      }

      @Test
      @TestMetadata("wildcardsOverrideOnKJJ.kt")
      public void testWildcardsOverrideOnKJJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/wildcardsOverrideOnKJJ.kt");
      }

      @Test
      @TestMetadata("wildcardsOverrideOnKJK.kt")
      public void testWildcardsOverrideOnKJK() {
        runTest("compiler/testData/ir/irText/fakeOverrides/generics/wildcardsOverrideOnKJK.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/gettersetter")
    @TestDataPath("$PROJECT_ROOT")
    public class Gettersetter {
      @Test
      public void testAllFilesPresentInGettersetter() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/gettersetter"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("getterSetterOverrideOnKJ.kt")
      public void testGetterSetterOverrideOnKJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/gettersetter/getterSetterOverrideOnKJ.kt");
      }

      @Test
      @TestMetadata("getterSetterOverrideOnKJK.kt")
      public void testGetterSetterOverrideOnKJK() {
        runTest("compiler/testData/ir/irText/fakeOverrides/gettersetter/getterSetterOverrideOnKJK.kt");
      }

      @Test
      @TestMetadata("getterSetterOverrideonComplexHierarchy.kt")
      public void testGetterSetterOverrideonComplexHierarchy() {
        runTest("compiler/testData/ir/irText/fakeOverrides/gettersetter/getterSetterOverrideonComplexHierarchy.kt");
      }

      @Test
      @TestMetadata("getterSetterOvverideOnKJJ.kt")
      public void testGetterSetterOvverideOnKJJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/gettersetter/getterSetterOvverideOnKJJ.kt");
      }

      @Test
      @TestMetadata("getterSetterOvverrideOnKJKJ.kt")
      public void testGetterSetterOvverrideOnKJKJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/gettersetter/getterSetterOvverrideOnKJKJ.kt");
      }

      @Test
      @TestMetadata("intersectionOverrideForGetterSetter.kt")
      public void testIntersectionOverrideForGetterSetter() {
        runTest("compiler/testData/ir/irText/fakeOverrides/gettersetter/intersectionOverrideForGetterSetter.kt");
      }

      @Test
      @TestMetadata("substitutionOverrideForGetterSetter.kt")
      public void testSubstitutionOverrideForGetterSetter() {
        runTest("compiler/testData/ir/irText/fakeOverrides/gettersetter/substitutionOverrideForGetterSetter.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/java21")
    @TestDataPath("$PROJECT_ROOT")
    public class Java21 {
      @Test
      public void testAllFilesPresentInJava21() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/java21"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("sequenceCollectionIntersectionOverrideKJJ.kt")
      public void testSequenceCollectionIntersectionOverrideKJJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/java21/sequenceCollectionIntersectionOverrideKJJ.kt");
      }

      @Test
      @TestMetadata("sequenceCollectionIntersectionOverrideKJK.kt")
      public void testSequenceCollectionIntersectionOverrideKJK() {
        runTest("compiler/testData/ir/irText/fakeOverrides/java21/sequenceCollectionIntersectionOverrideKJK.kt");
      }

      @Test
      @TestMetadata("sequenceCollectionOverride.kt")
      public void testSequenceCollectionOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/java21/sequenceCollectionOverride.kt");
      }

      @Test
      @TestMetadata("sequenceMapIntersectionOverrideKJJ.kt")
      public void testSequenceMapIntersectionOverrideKJJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/java21/sequenceMapIntersectionOverrideKJJ.kt");
      }

      @Test
      @TestMetadata("sequenceMapOverride.kt")
      public void testSequenceMapOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/java21/sequenceMapOverride.kt");
      }

      @Test
      @TestMetadata("sequenceMapOverrideKJ.kt")
      public void testSequenceMapOverrideKJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/java21/sequenceMapOverrideKJ.kt");
      }

      @Test
      @TestMetadata("sequenceSetIntersectionOverrideKJJ.kt")
      public void testSequenceSetIntersectionOverrideKJJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/java21/sequenceSetIntersectionOverrideKJJ.kt");
      }

      @Test
      @TestMetadata("sequenceSetIntersectionOverrideKJK.kt")
      public void testSequenceSetIntersectionOverrideKJK() {
        runTest("compiler/testData/ir/irText/fakeOverrides/java21/sequenceSetIntersectionOverrideKJK.kt");
      }

      @Test
      @TestMetadata("sequenceSetOverride.kt")
      public void testSequenceSetOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/java21/sequenceSetOverride.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/javastatic")
    @TestDataPath("$PROJECT_ROOT")
    public class Javastatic {
      @Test
      public void testAllFilesPresentInJavastatic() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/javastatic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("intersectionOverrideOnStaticKJJ.kt")
      public void testIntersectionOverrideOnStaticKJJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/javastatic/intersectionOverrideOnStaticKJJ.kt");
      }

      @Test
      @TestMetadata("intersectionOverrideOnStaticKJK.kt")
      public void testIntersectionOverrideOnStaticKJK() {
        runTest("compiler/testData/ir/irText/fakeOverrides/javastatic/intersectionOverrideOnStaticKJK.kt");
      }

      @Test
      @TestMetadata("intersectionWithGenericOnComplexHierarchy.kt")
      public void testIntersectionWithGenericOnComplexHierarchy() {
        runTest("compiler/testData/ir/irText/fakeOverrides/javastatic/intersectionWithGenericOnComplexHierarchy.kt");
      }

      @Test
      @TestMetadata("intersectionWithGenericOverride.kt")
      public void testIntersectionWithGenericOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/javastatic/intersectionWithGenericOverride.kt");
      }

      @Test
      @TestMetadata("staticOverrideOnComplexHierarchy.kt")
      public void testStaticOverrideOnComplexHierarchy() {
        runTest("compiler/testData/ir/irText/fakeOverrides/javastatic/staticOverrideOnComplexHierarchy.kt");
      }

      @Test
      @TestMetadata("staticOverrideOnKJ.kt")
      public void testStaticOverrideOnKJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/javastatic/staticOverrideOnKJ.kt");
      }

      @Test
      @TestMetadata("staticOverrideOnKJJ.kt")
      public void testStaticOverrideOnKJJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/javastatic/staticOverrideOnKJJ.kt");
      }

      @Test
      @TestMetadata("staticOverrideOnKJK.kt")
      public void testStaticOverrideOnKJK() {
        runTest("compiler/testData/ir/irText/fakeOverrides/javastatic/staticOverrideOnKJK.kt");
      }

      @Test
      @TestMetadata("staticOverrideOnKJKJ.kt")
      public void testStaticOverrideOnKJKJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/javastatic/staticOverrideOnKJKJ.kt");
      }

      @Test
      @TestMetadata("substitutionStaticOverride.kt")
      public void testSubstitutionStaticOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/javastatic/substitutionStaticOverride.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/kotlinextensions")
    @TestDataPath("$PROJECT_ROOT")
    public class Kotlinextensions {
      @Test
      public void testAllFilesPresentInKotlinextensions() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/kotlinextensions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("kotlinExtensionsOverride.kt")
      public void testKotlinExtensionsOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/kotlinextensions/kotlinExtensionsOverride.kt");
      }

      @Test
      @TestMetadata("memberExtensionOverride.kt")
      public void testMemberExtensionOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/kotlinextensions/memberExtensionOverride.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/methodmodifiers")
    @TestDataPath("$PROJECT_ROOT")
    public class Methodmodifiers {
      @Test
      public void testAllFilesPresentInMethodmodifiers() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/methodmodifiers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("basicJavaModifiersOverride.kt")
      public void testBasicJavaModifiersOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/methodmodifiers/basicJavaModifiersOverride.kt");
      }

      @Test
      @TestMetadata("basicKotlinModifiersOverride.kt")
      public void testBasicKotlinModifiersOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/methodmodifiers/basicKotlinModifiersOverride.kt");
      }

      @Test
      @TestMetadata("intersectionJavaModifiersOverride.kt")
      public void testIntersectionJavaModifiersOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/methodmodifiers/intersectionJavaModifiersOverride.kt");
      }

      @Test
      @TestMetadata("intersectionKotlinModifiersOverride.kt")
      public void testIntersectionKotlinModifiersOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/methodmodifiers/intersectionKotlinModifiersOverride.kt");
      }

      @Test
      @TestMetadata("kotlinFunParamModifiersOverride.kt")
      public void testKotlinFunParamModifiersOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/methodmodifiers/kotlinFunParamModifiersOverride.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/methodparameters")
    @TestDataPath("$PROJECT_ROOT")
    public class Methodparameters {
      @Test
      public void testAllFilesPresentInMethodparameters() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/methodparameters"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("basicJavaThisOverride.kt")
      public void testBasicJavaThisOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/methodparameters/basicJavaThisOverride.kt");
      }

      @Test
      @TestMetadata("basicKotlinDefaultParametersOverride.kt")
      public void testBasicKotlinDefaultParametersOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/methodparameters/basicKotlinDefaultParametersOverride.kt");
      }

      @Test
      @TestMetadata("intersectionJavaThisOverride.kt")
      public void testIntersectionJavaThisOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/methodparameters/intersectionJavaThisOverride.kt");
      }

      @Test
      @TestMetadata("intersectionKotlinDefaultParametersOverride.kt")
      public void testIntersectionKotlinDefaultParametersOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/methodparameters/intersectionKotlinDefaultParametersOverride.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/number")
    @TestDataPath("$PROJECT_ROOT")
    public class Number {
      @Test
      public void testAllFilesPresentInNumber() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/number"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("javaNumberOverride.kt")
      public void testJavaNumberOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/number/javaNumberOverride.kt");
      }

      @Test
      @TestMetadata("kotlinNumberOverride.kt")
      public void testKotlinNumberOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/number/kotlinNumberOverride.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/operators")
    @TestDataPath("$PROJECT_ROOT")
    public class Operators {
      @Test
      public void testAllFilesPresentInOperators() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/operators"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("basicOperatorsOverride.kt")
      public void testBasicOperatorsOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/operators/basicOperatorsOverride.kt");
      }

      @Test
      @TestMetadata("basicOverrideOnComplexHierarchy.kt")
      public void testBasicOverrideOnComplexHierarchy() {
        runTest("compiler/testData/ir/irText/fakeOverrides/operators/basicOverrideOnComplexHierarchy.kt");
      }

      @Test
      @TestMetadata("intersectionOperatorsOverride.kt")
      public void testIntersectionOperatorsOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/operators/intersectionOperatorsOverride.kt");
      }

      @Test
      @TestMetadata("substitutionOperatorsOverride.kt")
      public void testSubstitutionOperatorsOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/operators/substitutionOperatorsOverride.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/platformtypes")
    @TestDataPath("$PROJECT_ROOT")
    public class Platformtypes {
      @Test
      public void testAllFilesPresentInPlatformtypes() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/platformtypes"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("basicCollectionOverrideOnComplexHierarchy.kt")
      public void testBasicCollectionOverrideOnComplexHierarchy() {
        runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/basicCollectionOverrideOnComplexHierarchy.kt");
      }

      @Test
      @TestMetadata("basicCollectionsOverride.kt")
      public void testBasicCollectionsOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/basicCollectionsOverride.kt");
      }

      @Test
      @TestMetadata("basicOverride.kt")
      public void testBasicOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/basicOverride.kt");
      }

      @Test
      @TestMetadata("basicOverrideOnComplexHierarchy.kt")
      public void testBasicOverrideOnComplexHierarchy() {
        runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/basicOverrideOnComplexHierarchy.kt");
      }

      @Test
      @TestMetadata("combinationExplicitImlicitOverride.kt")
      public void testCombinationExplicitImlicitOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/combinationExplicitImlicitOverride.kt");
      }

      @Test
      @TestMetadata("intersectionOnComplexHierarchy.kt")
      public void testIntersectionOnComplexHierarchy() {
        runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/intersectionOnComplexHierarchy.kt");
      }

      @Test
      @TestMetadata("intersectionOverride.kt")
      public void testIntersectionOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/intersectionOverride.kt");
      }

      @Test
      @TestMetadata("intersectionOverrideOnCollections.kt")
      public void testIntersectionOverrideOnCollections() {
        runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/intersectionOverrideOnCollections.kt");
      }

      @Test
      @TestMetadata("intersectionWithExplicitOverride.kt")
      public void testIntersectionWithExplicitOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/intersectionWithExplicitOverride.kt");
      }

      @Test
      @TestMetadata("intersectionWithGenericExplicitOverride.kt")
      public void testIntersectionWithGenericExplicitOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/intersectionWithGenericExplicitOverride.kt");
      }

      @Test
      @TestMetadata("intersectionWithGenericOnComplexHierarchy.kt")
      public void testIntersectionWithGenericOnComplexHierarchy() {
        runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/intersectionWithGenericOnComplexHierarchy.kt");
      }

      @Test
      @TestMetadata("intersectionWithGenericOverride.kt")
      public void testIntersectionWithGenericOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/intersectionWithGenericOverride.kt");
      }

      @Test
      @TestMetadata("substitutionOverride.kt")
      public void testSubstitutionOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/substitutionOverride.kt");
      }

      @Test
      @TestMetadata("substitutionOverrideOnCollections.kt")
      public void testSubstitutionOverrideOnCollections() {
        runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/substitutionOverrideOnCollections.kt");
      }

      @Test
      @TestMetadata("substitutionOverrideOnComplexHierarchy.kt")
      public void testSubstitutionOverrideOnComplexHierarchy() {
        runTest("compiler/testData/ir/irText/fakeOverrides/platformtypes/substitutionOverrideOnComplexHierarchy.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/typenothing")
    @TestDataPath("$PROJECT_ROOT")
    public class Typenothing {
      @Test
      public void testAllFilesPresentInTypenothing() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/typenothing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("baseOverrideOnNothing.kt")
      public void testBaseOverrideOnNothing() {
        runTest("compiler/testData/ir/irText/fakeOverrides/typenothing/baseOverrideOnNothing.kt");
      }

      @Test
      @TestMetadata("intersectionOverrrideOnNothing.kt")
      public void testIntersectionOverrrideOnNothing() {
        runTest("compiler/testData/ir/irText/fakeOverrides/typenothing/intersectionOverrrideOnNothing.kt");
      }

      @Test
      @TestMetadata("substitutionOverrideOnNothing.kt")
      public void testSubstitutionOverrideOnNothing() {
        runTest("compiler/testData/ir/irText/fakeOverrides/typenothing/substitutionOverrideOnNothing.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/vararg")
    @TestDataPath("$PROJECT_ROOT")
    public class Vararg {
      @Test
      public void testAllFilesPresentInVararg() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/vararg"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("basicVarargOverride.kt")
      public void testBasicVarargOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/vararg/basicVarargOverride.kt");
      }

      @Test
      @TestMetadata("intersectionOnVarargOverride.kt")
      public void testIntersectionOnVarargOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/vararg/intersectionOnVarargOverride.kt");
      }

      @Test
      @TestMetadata("intersectionWithGenericOnVarargOverride.kt")
      public void testIntersectionWithGenericOnVarargOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/vararg/intersectionWithGenericOnVarargOverride.kt");
      }

      @Test
      @TestMetadata("substitutionOnVarargOverride.kt")
      public void testSubstitutionOnVarargOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/vararg/substitutionOnVarargOverride.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/visibility")
    @TestDataPath("$PROJECT_ROOT")
    public class Visibility {
      @Test
      public void testAllFilesPresentInVisibility() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/visibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("allPropertiesAndMethodsKJ.kt")
      public void testAllPropertiesAndMethodsKJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/allPropertiesAndMethodsKJ.kt");
      }

      @Test
      @TestMetadata("allPropertiesAndMethodsKJJ.kt")
      public void testAllPropertiesAndMethodsKJJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/allPropertiesAndMethodsKJJ.kt");
      }

      @Test
      @TestMetadata("allPropertiesAndMethodsKJK.kt")
      public void testAllPropertiesAndMethodsKJK() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/allPropertiesAndMethodsKJK.kt");
      }

      @Test
      @TestMetadata("allPropertiesAndMethodsKJKJ.kt")
      public void testAllPropertiesAndMethodsKJKJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/allPropertiesAndMethodsKJKJ.kt");
      }

      @Test
      @TestMetadata("allPropertiesAndMethodsWithSeparateModuleKJJ.kt")
      public void testAllPropertiesAndMethodsWithSeparateModuleKJJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/allPropertiesAndMethodsWithSeparateModuleKJJ.kt");
      }

      @Test
      @TestMetadata("internalOverrideCrossModule.kt")
      public void testInternalOverrideCrossModule() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/internalOverrideCrossModule.kt");
      }

      @Test
      @TestMetadata("internalOverrideWithFriendModule.kt")
      public void testInternalOverrideWithFriendModule() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/internalOverrideWithFriendModule.kt");
      }

      @Test
      @TestMetadata("internalWithPublishedApiOverride.kt")
      public void testInternalWithPublishedApiOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/internalWithPublishedApiOverride.kt");
      }

      @Test
      @TestMetadata("intersectionVisibilityOverrideKJJ.kt")
      public void testIntersectionVisibilityOverrideKJJ() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/intersectionVisibilityOverrideKJJ.kt");
      }

      @Test
      @TestMetadata("intersectionVisibilityOverrideKJK.kt")
      public void testIntersectionVisibilityOverrideKJK() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/intersectionVisibilityOverrideKJK.kt");
      }

      @Test
      @TestMetadata("intersectionWithPublishedApiOverride.kt")
      public void testIntersectionWithPublishedApiOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/intersectionWithPublishedApiOverride.kt");
      }

      @Test
      @TestMetadata("intersectionWithSeparateModule.kt")
      public void testIntersectionWithSeparateModule() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/intersectionWithSeparateModule.kt");
      }

      @Test
      @TestMetadata("lateinitPropertiesFakeOverrideJKK.kt")
      public void testLateinitPropertiesFakeOverrideJKK() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/lateinitPropertiesFakeOverrideJKK.kt");
      }

      @Test
      @TestMetadata("lateinitPropertiesJJK.kt")
      public void testLateinitPropertiesJJK() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/lateinitPropertiesJJK.kt");
      }

      @Test
      @TestMetadata("lateinitPropertiesJK.kt")
      public void testLateinitPropertiesJK() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/lateinitPropertiesJK.kt");
      }

      @Test
      @TestMetadata("lateinitPropertiesJKK.kt")
      public void testLateinitPropertiesJKK() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/lateinitPropertiesJKK.kt");
      }

      @Test
      @TestMetadata("lateinitPropertiesSeparateModule.kt")
      public void testLateinitPropertiesSeparateModule() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/lateinitPropertiesSeparateModule.kt");
      }

      @Test
      @TestMetadata("overrideKotlinMethodsKJKK.kt")
      public void testOverrideKotlinMethodsKJKK() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/overrideKotlinMethodsKJKK.kt");
      }

      @Test
      @TestMetadata("overridePropertiesKJKK.kt")
      public void testOverridePropertiesKJKK() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/overridePropertiesKJKK.kt");
      }

      @Test
      @TestMetadata("overrideSetAndGetKJK.kt")
      public void testOverrideSetAndGetKJK() {
        runTest("compiler/testData/ir/irText/fakeOverrides/visibility/overrideSetAndGetKJK.kt");
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/fakeOverrides/void")
    @TestDataPath("$PROJECT_ROOT")
    public class Void {
      @Test
      public void testAllFilesPresentInVoid() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/fakeOverrides/void"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("basicVoidOverride.kt")
      public void testBasicVoidOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/void/basicVoidOverride.kt");
      }

      @Test
      @TestMetadata("intersectionVoidOverride.kt")
      public void testIntersectionVoidOverride() {
        runTest("compiler/testData/ir/irText/fakeOverrides/void/intersectionVoidOverride.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/irText/firProblems")
  @TestDataPath("$PROJECT_ROOT")
  public class FirProblems {
    @Test
    @TestMetadata("AbstractMutableMap.kt")
    public void testAbstractMutableMap() {
      runTest("compiler/testData/ir/irText/firProblems/AbstractMutableMap.kt");
    }

    @Test
    @TestMetadata("AllCandidates.kt")
    public void testAllCandidates() {
      runTest("compiler/testData/ir/irText/firProblems/AllCandidates.kt");
    }

    @Test
    public void testAllFilesPresentInFirProblems() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/firProblems"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("AnnotationInAnnotation.kt")
    public void testAnnotationInAnnotation() {
      runTest("compiler/testData/ir/irText/firProblems/AnnotationInAnnotation.kt");
    }

    @Test
    @TestMetadata("AnnotationLoader.kt")
    public void testAnnotationLoader() {
      runTest("compiler/testData/ir/irText/firProblems/AnnotationLoader.kt");
    }

    @Test
    @TestMetadata("AnonymousAsReturnOfGenericFunction.kt")
    public void testAnonymousAsReturnOfGenericFunction() {
      runTest("compiler/testData/ir/irText/firProblems/AnonymousAsReturnOfGenericFunction.kt");
    }

    @Test
    @TestMetadata("ArrayListOverrides.kt")
    public void testArrayListOverrides() {
      runTest("compiler/testData/ir/irText/firProblems/ArrayListOverrides.kt");
    }

    @Test
    @TestMetadata("ArrayMap.kt")
    public void testArrayMap() {
      runTest("compiler/testData/ir/irText/firProblems/ArrayMap.kt");
    }

    @Test
    @TestMetadata("AssignmentOperator.kt")
    public void testAssignmentOperator() {
      runTest("compiler/testData/ir/irText/firProblems/AssignmentOperator.kt");
    }

    @Test
    @TestMetadata("candidateSymbol.kt")
    public void testCandidateSymbol() {
      runTest("compiler/testData/ir/irText/firProblems/candidateSymbol.kt");
    }

    @Test
    @TestMetadata("cannotCastToFunction.kt")
    public void testCannotCastToFunction() {
      runTest("compiler/testData/ir/irText/firProblems/cannotCastToFunction.kt");
    }

    @Test
    @TestMetadata("ClashResolutionDescriptor.kt")
    public void testClashResolutionDescriptor() {
      runTest("compiler/testData/ir/irText/firProblems/ClashResolutionDescriptor.kt");
    }

    @Test
    @TestMetadata("coercionToUnitForNestedWhen.kt")
    public void testCoercionToUnitForNestedWhen() {
      runTest("compiler/testData/ir/irText/firProblems/coercionToUnitForNestedWhen.kt");
    }

    @Test
    @TestMetadata("DeepCopyIrTree.kt")
    public void testDeepCopyIrTree() {
      runTest("compiler/testData/ir/irText/firProblems/DeepCopyIrTree.kt");
    }

    @Test
    @TestMetadata("delegatedSetterShouldBeSpecialized.kt")
    public void testDelegatedSetterShouldBeSpecialized() {
      runTest("compiler/testData/ir/irText/firProblems/delegatedSetterShouldBeSpecialized.kt");
    }

    @Test
    @TestMetadata("DelegationAndInheritanceFromJava.kt")
    public void testDelegationAndInheritanceFromJava() {
      runTest("compiler/testData/ir/irText/firProblems/DelegationAndInheritanceFromJava.kt");
    }

    @Test
    @TestMetadata("deprecated.kt")
    public void testDeprecated() {
      runTest("compiler/testData/ir/irText/firProblems/deprecated.kt");
    }

    @Test
    @TestMetadata("elvisOnBackingFieldInGetter.kt")
    public void testElvisOnBackingFieldInGetter() {
      runTest("compiler/testData/ir/irText/firProblems/elvisOnBackingFieldInGetter.kt");
    }

    @Test
    @TestMetadata("emptyWhen.kt")
    public void testEmptyWhen() {
      runTest("compiler/testData/ir/irText/firProblems/emptyWhen.kt");
    }

    @Test
    @TestMetadata("ErrorInDefaultValue.kt")
    public void testErrorInDefaultValue() {
      runTest("compiler/testData/ir/irText/firProblems/ErrorInDefaultValue.kt");
    }

    @Test
    @TestMetadata("explicitIncrement.kt")
    public void testExplicitIncrement() {
      runTest("compiler/testData/ir/irText/firProblems/explicitIncrement.kt");
    }

    @Test
    @TestMetadata("FakeOverrideInAnonymousWithDelegation.kt")
    public void testFakeOverrideInAnonymousWithDelegation() {
      runTest("compiler/testData/ir/irText/firProblems/FakeOverrideInAnonymousWithDelegation.kt");
    }

    @Test
    @TestMetadata("FieldsFromJavaClass.kt")
    public void testFieldsFromJavaClass() {
      runTest("compiler/testData/ir/irText/firProblems/FieldsFromJavaClass.kt");
    }

    @Test
    @TestMetadata("Fir2IrClassifierStorage.kt")
    public void testFir2IrClassifierStorage() {
      runTest("compiler/testData/ir/irText/firProblems/Fir2IrClassifierStorage.kt");
    }

    @Test
    @TestMetadata("FirBuilder.kt")
    public void testFirBuilder() {
      runTest("compiler/testData/ir/irText/firProblems/FirBuilder.kt");
    }

    @Test
    @TestMetadata("FlushFromAnonymous.kt")
    public void testFlushFromAnonymous() {
      runTest("compiler/testData/ir/irText/firProblems/FlushFromAnonymous.kt");
    }

    @Test
    @TestMetadata("functionLiteralGenericSignature.kt")
    public void testFunctionLiteralGenericSignature() {
      runTest("compiler/testData/ir/irText/firProblems/functionLiteralGenericSignature.kt");
    }

    @Test
    @TestMetadata("ImplicitReceiverStack.kt")
    public void testImplicitReceiverStack() {
      runTest("compiler/testData/ir/irText/firProblems/ImplicitReceiverStack.kt");
    }

    @Test
    @TestMetadata("inapplicableCollectionSet.kt")
    public void testInapplicableCollectionSet() {
      runTest("compiler/testData/ir/irText/firProblems/inapplicableCollectionSet.kt");
    }

    @Test
    @TestMetadata("InnerClassInAnonymous.kt")
    public void testInnerClassInAnonymous() {
      runTest("compiler/testData/ir/irText/firProblems/InnerClassInAnonymous.kt");
    }

    @Test
    @TestMetadata("IntArrayAsVararg.kt")
    public void testIntArrayAsVararg() {
      runTest("compiler/testData/ir/irText/firProblems/IntArrayAsVararg.kt");
    }

    @Test
    @TestMetadata("integerLiteralWithExpectedTypealiasType.kt")
    public void testIntegerLiteralWithExpectedTypealiasType() {
      runTest("compiler/testData/ir/irText/firProblems/integerLiteralWithExpectedTypealiasType.kt");
    }

    @Test
    @TestMetadata("internalPotentialFakeOverride.kt")
    public void testInternalPotentialFakeOverride() {
      runTest("compiler/testData/ir/irText/firProblems/internalPotentialFakeOverride.kt");
    }

    @Test
    @TestMetadata("internalPotentialOverride.kt")
    public void testInternalPotentialOverride() {
      runTest("compiler/testData/ir/irText/firProblems/internalPotentialOverride.kt");
    }

    @Test
    @TestMetadata("kt19251.kt")
    public void testKt19251() {
      runTest("compiler/testData/ir/irText/firProblems/kt19251.kt");
    }

    @Test
    @TestMetadata("kt43342.kt")
    public void testKt43342() {
      runTest("compiler/testData/ir/irText/firProblems/kt43342.kt");
    }

    @Test
    @TestMetadata("kt55458.kt")
    public void testKt55458() {
      runTest("compiler/testData/ir/irText/firProblems/kt55458.kt");
    }

    @Test
    @TestMetadata("kt59102.kt")
    public void testKt59102() {
      runTest("compiler/testData/ir/irText/firProblems/kt59102.kt");
    }

    @Test
    @TestMetadata("kt65642.kt")
    public void testKt65642() {
      runTest("compiler/testData/ir/irText/firProblems/kt65642.kt");
    }

    @Test
    @TestMetadata("lambdaInEnumEntryConstructorCall.kt")
    public void testLambdaInEnumEntryConstructorCall() {
      runTest("compiler/testData/ir/irText/firProblems/lambdaInEnumEntryConstructorCall.kt");
    }

    @Test
    @TestMetadata("localClassUsedBeforeDeclaration.kt")
    public void testLocalClassUsedBeforeDeclaration() {
      runTest("compiler/testData/ir/irText/firProblems/localClassUsedBeforeDeclaration.kt");
    }

    @Test
    @TestMetadata("localCompanion.kt")
    public void testLocalCompanion() {
      runTest("compiler/testData/ir/irText/firProblems/localCompanion.kt");
    }

    @Test
    @TestMetadata("LocalSuspendFun.kt")
    public void testLocalSuspendFun() {
      runTest("compiler/testData/ir/irText/firProblems/LocalSuspendFun.kt");
    }

    @Test
    @TestMetadata("Modality.kt")
    public void testModality() {
      runTest("compiler/testData/ir/irText/firProblems/Modality.kt");
    }

    @Test
    @TestMetadata("MultiList.kt")
    public void testMultiList() {
      runTest("compiler/testData/ir/irText/firProblems/MultiList.kt");
    }

    @Test
    @TestMetadata("noErrorTypeAfterCaptureApproximation.kt")
    public void testNoErrorTypeAfterCaptureApproximation() {
      runTest("compiler/testData/ir/irText/firProblems/noErrorTypeAfterCaptureApproximation.kt");
    }

    @Test
    @TestMetadata("OutBox.kt")
    public void testOutBox() {
      runTest("compiler/testData/ir/irText/firProblems/OutBox.kt");
    }

    @Test
    @TestMetadata("putIfAbsent.kt")
    public void testPutIfAbsent() {
      runTest("compiler/testData/ir/irText/firProblems/putIfAbsent.kt");
    }

    @Test
    @TestMetadata("readWriteProperty.kt")
    public void testReadWriteProperty() {
      runTest("compiler/testData/ir/irText/firProblems/readWriteProperty.kt");
    }

    @Test
    @TestMetadata("recursiveCapturedTypeInPropertyReference.kt")
    public void testRecursiveCapturedTypeInPropertyReference() {
      runTest("compiler/testData/ir/irText/firProblems/recursiveCapturedTypeInPropertyReference.kt");
    }

    @Test
    @TestMetadata("reflectFindAnnotationOnDefaultMethodParameter.kt")
    public void testReflectFindAnnotationOnDefaultMethodParameter() {
      runTest("compiler/testData/ir/irText/firProblems/reflectFindAnnotationOnDefaultMethodParameter.kt");
    }

    @Test
    @TestMetadata("reflectGetOnNullableTypeAlias.kt")
    public void testReflectGetOnNullableTypeAlias() {
      runTest("compiler/testData/ir/irText/firProblems/reflectGetOnNullableTypeAlias.kt");
    }

    @Test
    @TestMetadata("SafeLetWithReturn.kt")
    public void testSafeLetWithReturn() {
      runTest("compiler/testData/ir/irText/firProblems/SafeLetWithReturn.kt");
    }

    @Test
    @TestMetadata("SameJavaFieldReferences.kt")
    public void testSameJavaFieldReferences() {
      runTest("compiler/testData/ir/irText/firProblems/SameJavaFieldReferences.kt");
    }

    @Test
    @TestMetadata("SignatureClash.kt")
    public void testSignatureClash() {
      runTest("compiler/testData/ir/irText/firProblems/SignatureClash.kt");
    }

    @Test
    @TestMetadata("SignatureComputationComplexJavaGeneric.kt")
    public void testSignatureComputationComplexJavaGeneric() {
      runTest("compiler/testData/ir/irText/firProblems/SignatureComputationComplexJavaGeneric.kt");
    }

    @Test
    @TestMetadata("SimpleTypeMarker.kt")
    public void testSimpleTypeMarker() {
      runTest("compiler/testData/ir/irText/firProblems/SimpleTypeMarker.kt");
    }

    @Test
    @TestMetadata("substitutionOverrideWithDelegate.kt")
    public void testSubstitutionOverrideWithDelegate() {
      runTest("compiler/testData/ir/irText/firProblems/substitutionOverrideWithDelegate.kt");
    }

    @Test
    @TestMetadata("SyntheticSetterType.kt")
    public void testSyntheticSetterType() {
      runTest("compiler/testData/ir/irText/firProblems/SyntheticSetterType.kt");
    }

    @Test
    @TestMetadata("thisInEnumConstructor.kt")
    public void testThisInEnumConstructor() {
      runTest("compiler/testData/ir/irText/firProblems/thisInEnumConstructor.kt");
    }

    @Test
    @TestMetadata("throwableStackTrace.kt")
    public void testThrowableStackTrace() {
      runTest("compiler/testData/ir/irText/firProblems/throwableStackTrace.kt");
    }

    @Test
    @TestMetadata("timesInBuilder.kt")
    public void testTimesInBuilder() {
      runTest("compiler/testData/ir/irText/firProblems/timesInBuilder.kt");
    }

    @Test
    @TestMetadata("TypeAliasConstructorParameterMapping.kt")
    public void testTypeAliasConstructorParameterMapping() {
      runTest("compiler/testData/ir/irText/firProblems/TypeAliasConstructorParameterMapping.kt");
    }

    @Test
    @TestMetadata("TypeAliasInImport.kt")
    public void testTypeAliasInImport() {
      runTest("compiler/testData/ir/irText/firProblems/TypeAliasInImport.kt");
    }

    @Test
    @TestMetadata("typeOfNonExhaustiveWhen.kt")
    public void testTypeOfNonExhaustiveWhen() {
      runTest("compiler/testData/ir/irText/firProblems/typeOfNonExhaustiveWhen.kt");
    }

    @Test
    @TestMetadata("TypeParameterBounds.kt")
    public void testTypeParameterBounds() {
      runTest("compiler/testData/ir/irText/firProblems/TypeParameterBounds.kt");
    }

    @Test
    @TestMetadata("typeParameterFromJavaClass.kt")
    public void testTypeParameterFromJavaClass() {
      runTest("compiler/testData/ir/irText/firProblems/typeParameterFromJavaClass.kt");
    }

    @Test
    @TestMetadata("TypeParameterInClashingAccessor.kt")
    public void testTypeParameterInClashingAccessor() {
      runTest("compiler/testData/ir/irText/firProblems/TypeParameterInClashingAccessor.kt");
    }

    @Test
    @TestMetadata("TypeParameterInNestedClass.kt")
    public void testTypeParameterInNestedClass() {
      runTest("compiler/testData/ir/irText/firProblems/TypeParameterInNestedClass.kt");
    }

    @Test
    @TestMetadata("typeVariableAfterBuildMap.kt")
    public void testTypeVariableAfterBuildMap() {
      runTest("compiler/testData/ir/irText/firProblems/typeVariableAfterBuildMap.kt");
    }

    @Test
    @TestMetadata("V8ArrayToList.kt")
    public void testV8ArrayToList() {
      runTest("compiler/testData/ir/irText/firProblems/V8ArrayToList.kt");
    }

    @Test
    @TestMetadata("valueClassEquals.kt")
    public void testValueClassEquals() {
      runTest("compiler/testData/ir/irText/firProblems/valueClassEquals.kt");
    }

    @Test
    @TestMetadata("VarInInit.kt")
    public void testVarInInit() {
      runTest("compiler/testData/ir/irText/firProblems/VarInInit.kt");
    }

    @Test
    @TestMetadata("VarargIntegerLiteral.kt")
    public void testVarargIntegerLiteral() {
      runTest("compiler/testData/ir/irText/firProblems/VarargIntegerLiteral.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/irText/js")
  @TestDataPath("$PROJECT_ROOT")
  public class Js {
    @Test
    public void testAllFilesPresentInJs() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/js"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/js/dynamic")
    @TestDataPath("$PROJECT_ROOT")
    public class Dynamic {
      @Test
      public void testAllFilesPresentInDynamic() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/js/dynamic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/js/external")
    @TestDataPath("$PROJECT_ROOT")
    public class External {
      @Test
      public void testAllFilesPresentInExternal() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/js/external"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/js/native")
    @TestDataPath("$PROJECT_ROOT")
    public class Native {
      @Test
      public void testAllFilesPresentInNative() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/js/native"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/irText/lambdas")
  @TestDataPath("$PROJECT_ROOT")
  public class Lambdas {
    @Test
    public void testAllFilesPresentInLambdas() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/lambdas"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("anonymousFunction.kt")
    public void testAnonymousFunction() {
      runTest("compiler/testData/ir/irText/lambdas/anonymousFunction.kt");
    }

    @Test
    @TestMetadata("destructuringInLambda.kt")
    public void testDestructuringInLambda() {
      runTest("compiler/testData/ir/irText/lambdas/destructuringInLambda.kt");
    }

    @Test
    @TestMetadata("extensionLambda.kt")
    public void testExtensionLambda() {
      runTest("compiler/testData/ir/irText/lambdas/extensionLambda.kt");
    }

    @Test
    @TestMetadata("justLambda.kt")
    public void testJustLambda() {
      runTest("compiler/testData/ir/irText/lambdas/justLambda.kt");
    }

    @Test
    @TestMetadata("localFunction.kt")
    public void testLocalFunction() {
      runTest("compiler/testData/ir/irText/lambdas/localFunction.kt");
    }

    @Test
    @TestMetadata("multipleImplicitReceivers.kt")
    public void testMultipleImplicitReceivers() {
      runTest("compiler/testData/ir/irText/lambdas/multipleImplicitReceivers.kt");
    }

    @Test
    @TestMetadata("nonLocalReturn.kt")
    public void testNonLocalReturn() {
      runTest("compiler/testData/ir/irText/lambdas/nonLocalReturn.kt");
    }

    @Test
    @TestMetadata("samAdapter.kt")
    public void testSamAdapter() {
      runTest("compiler/testData/ir/irText/lambdas/samAdapter.kt");
    }

    @Test
    @TestMetadata("samConversionClassInProjection.kt")
    public void testSamConversionClassInProjection() {
      runTest("compiler/testData/ir/irText/lambdas/samConversionClassInProjection.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/irText/lenientMode")
  @TestDataPath("$PROJECT_ROOT")
  public class LenientMode {
    @Test
    public void testAllFilesPresentInLenientMode() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/lenientMode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("annotations.kt")
    public void testAnnotations() {
      runTest("compiler/testData/ir/irText/lenientMode/annotations.kt");
    }

    @Test
    @TestMetadata("lenientModeStubs.kt")
    public void testLenientModeStubs() {
      runTest("compiler/testData/ir/irText/lenientMode/lenientModeStubs.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/irText/properties")
  @TestDataPath("$PROJECT_ROOT")
  public class Properties {
    @Test
    public void testAllFilesPresentInProperties() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/properties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("setters.kt")
    public void testSetters() {
      runTest("compiler/testData/ir/irText/properties/setters.kt");
    }

    @Test
    @TestMetadata("targetOnPrimaryCtorParameter.kt")
    public void testTargetOnPrimaryCtorParameter() {
      runTest("compiler/testData/ir/irText/properties/targetOnPrimaryCtorParameter.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/properties/backingField")
    @TestDataPath("$PROJECT_ROOT")
    public class BackingField {
      @Test
      public void testAllFilesPresentInBackingField() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/properties/backingField"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("backingFieldVisibility.kt")
      public void testBackingFieldVisibility() {
        runTest("compiler/testData/ir/irText/properties/backingField/backingFieldVisibility.kt");
      }

      @Test
      @TestMetadata("explicitBackingFieldType.kt")
      public void testExplicitBackingFieldType() {
        runTest("compiler/testData/ir/irText/properties/backingField/explicitBackingFieldType.kt");
      }

      @Test
      @TestMetadata("independentBackingFieldType.kt")
      public void testIndependentBackingFieldType() {
        runTest("compiler/testData/ir/irText/properties/backingField/independentBackingFieldType.kt");
      }

      @Test
      @TestMetadata("propertyTypeNarrowing.kt")
      public void testPropertyTypeNarrowing() {
        runTest("compiler/testData/ir/irText/properties/backingField/propertyTypeNarrowing.kt");
      }
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/irText/regressions")
  @TestDataPath("$PROJECT_ROOT")
  public class Regressions {
    @Test
    public void testAllFilesPresentInRegressions() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/regressions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("coercionInLoop.kt")
    public void testCoercionInLoop() {
      runTest("compiler/testData/ir/irText/regressions/coercionInLoop.kt");
    }

    @Test
    @TestMetadata("integerCoercionToT.kt")
    public void testIntegerCoercionToT() {
      runTest("compiler/testData/ir/irText/regressions/integerCoercionToT.kt");
    }

    @Test
    @TestMetadata("kt24114.kt")
    public void testKt24114() {
      runTest("compiler/testData/ir/irText/regressions/kt24114.kt");
    }

    @Test
    @TestMetadata("kt44855.kt")
    public void testKt44855() {
      runTest("compiler/testData/ir/irText/regressions/kt44855.kt");
    }

    @Test
    @TestMetadata("kt45236.kt")
    public void testKt45236() {
      runTest("compiler/testData/ir/irText/regressions/kt45236.kt");
    }

    @Test
    @TestMetadata("newInferenceFixationOrder1.kt")
    public void testNewInferenceFixationOrder1() {
      runTest("compiler/testData/ir/irText/regressions/newInferenceFixationOrder1.kt");
    }

    @Test
    @TestMetadata("noSyntheticTypeParameterLeftAfterPCLA.kt")
    public void testNoSyntheticTypeParameterLeftAfterPCLA() {
      runTest("compiler/testData/ir/irText/regressions/noSyntheticTypeParameterLeftAfterPCLA.kt");
    }

    @Test
    @TestMetadata("typeAliasCtorForGenericClass.kt")
    public void testTypeAliasCtorForGenericClass() {
      runTest("compiler/testData/ir/irText/regressions/typeAliasCtorForGenericClass.kt");
    }

    @Test
    @TestMetadata("typeParametersInImplicitCast.kt")
    public void testTypeParametersInImplicitCast() {
      runTest("compiler/testData/ir/irText/regressions/typeParametersInImplicitCast.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/irText/singletons")
  @TestDataPath("$PROJECT_ROOT")
  public class Singletons {
    @Test
    public void testAllFilesPresentInSingletons() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/singletons"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("companion.kt")
    public void testCompanion() {
      runTest("compiler/testData/ir/irText/singletons/companion.kt");
    }

    @Test
    @TestMetadata("enumEntry.kt")
    public void testEnumEntry() {
      runTest("compiler/testData/ir/irText/singletons/enumEntry.kt");
    }

    @Test
    @TestMetadata("object.kt")
    public void testObject() {
      runTest("compiler/testData/ir/irText/singletons/object.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/irText/stubs")
  @TestDataPath("$PROJECT_ROOT")
  public class Stubs {
    @Test
    public void testAllFilesPresentInStubs() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/stubs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("arraysFromBuiltins.kt")
    public void testArraysFromBuiltins() {
      runTest("compiler/testData/ir/irText/stubs/arraysFromBuiltins.kt");
    }

    @Test
    @TestMetadata("builtinMap.kt")
    public void testBuiltinMap() {
      runTest("compiler/testData/ir/irText/stubs/builtinMap.kt");
    }

    @Test
    @TestMetadata("constFromBuiltins.kt")
    public void testConstFromBuiltins() {
      runTest("compiler/testData/ir/irText/stubs/constFromBuiltins.kt");
    }

    @Test
    @TestMetadata("genericClassInDifferentModule.kt")
    public void testGenericClassInDifferentModule() {
      runTest("compiler/testData/ir/irText/stubs/genericClassInDifferentModule.kt");
    }

    @Test
    @TestMetadata("javaAnnotationOnJavaEnum.kt")
    public void testJavaAnnotationOnJavaEnum() {
      runTest("compiler/testData/ir/irText/stubs/javaAnnotationOnJavaEnum.kt");
    }

    @Test
    @TestMetadata("javaConstructorWithTypeParameters.kt")
    public void testJavaConstructorWithTypeParameters() {
      runTest("compiler/testData/ir/irText/stubs/javaConstructorWithTypeParameters.kt");
    }

    @Test
    @TestMetadata("javaEnum.kt")
    public void testJavaEnum() {
      runTest("compiler/testData/ir/irText/stubs/javaEnum.kt");
    }

    @Test
    @TestMetadata("javaInnerClass.kt")
    public void testJavaInnerClass() {
      runTest("compiler/testData/ir/irText/stubs/javaInnerClass.kt");
    }

    @Test
    @TestMetadata("javaMethod.kt")
    public void testJavaMethod() {
      runTest("compiler/testData/ir/irText/stubs/javaMethod.kt");
    }

    @Test
    @TestMetadata("javaNestedClass.kt")
    public void testJavaNestedClass() {
      runTest("compiler/testData/ir/irText/stubs/javaNestedClass.kt");
    }

    @Test
    @TestMetadata("javaNestedClassesInHierarchy.kt")
    public void testJavaNestedClassesInHierarchy() {
      runTest("compiler/testData/ir/irText/stubs/javaNestedClassesInHierarchy.kt");
    }

    @Test
    @TestMetadata("javaStaticMethod.kt")
    public void testJavaStaticMethod() {
      runTest("compiler/testData/ir/irText/stubs/javaStaticMethod.kt");
    }

    @Test
    @TestMetadata("javaSyntheticProperty.kt")
    public void testJavaSyntheticProperty() {
      runTest("compiler/testData/ir/irText/stubs/javaSyntheticProperty.kt");
    }

    @Test
    @TestMetadata("jdkClassSyntheticProperty.kt")
    public void testJdkClassSyntheticProperty() {
      runTest("compiler/testData/ir/irText/stubs/jdkClassSyntheticProperty.kt");
    }

    @Test
    @TestMetadata("kotlinInnerClass.kt")
    public void testKotlinInnerClass() {
      runTest("compiler/testData/ir/irText/stubs/kotlinInnerClass.kt");
    }

    @Test
    @TestMetadata("simple.kt")
    public void testSimple() {
      runTest("compiler/testData/ir/irText/stubs/simple.kt");
    }
  }

  @Nested
  @TestMetadata("compiler/testData/ir/irText/types")
  @TestDataPath("$PROJECT_ROOT")
  public class Types {
    @Test
    @TestMetadata("abbreviatedTypes.kt")
    public void testAbbreviatedTypes() {
      runTest("compiler/testData/ir/irText/types/abbreviatedTypes.kt");
    }

    @Test
    public void testAllFilesPresentInTypes() {
      KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/types"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
    }

    @Test
    @TestMetadata("asOnPlatformType.kt")
    public void testAsOnPlatformType() {
      runTest("compiler/testData/ir/irText/types/asOnPlatformType.kt");
    }

    @Test
    @TestMetadata("castsInsideCoroutineInference.kt")
    public void testCastsInsideCoroutineInference() {
      runTest("compiler/testData/ir/irText/types/castsInsideCoroutineInference.kt");
    }

    @Test
    @TestMetadata("coercionToUnitInLambdaReturnValue.kt")
    public void testCoercionToUnitInLambdaReturnValue() {
      runTest("compiler/testData/ir/irText/types/coercionToUnitInLambdaReturnValue.kt");
    }

    @Test
    @TestMetadata("definitelyNonNull.kt")
    public void testDefinitelyNonNull() {
      runTest("compiler/testData/ir/irText/types/definitelyNonNull.kt");
    }

    @Test
    @TestMetadata("definitelyNonNullOverride.kt")
    public void testDefinitelyNonNullOverride() {
      runTest("compiler/testData/ir/irText/types/definitelyNonNullOverride.kt");
    }

    @Test
    @TestMetadata("definitelyNonNullSAM.kt")
    public void testDefinitelyNonNullSAM() {
      runTest("compiler/testData/ir/irText/types/definitelyNonNullSAM.kt");
    }

    @Test
    @TestMetadata("definitelyNonNullWithJava.kt")
    public void testDefinitelyNonNullWithJava() {
      runTest("compiler/testData/ir/irText/types/definitelyNonNullWithJava.kt");
    }

    @Test
    @TestMetadata("definitelyNotNullAsArgument.kt")
    public void testDefinitelyNotNullAsArgument() {
      runTest("compiler/testData/ir/irText/types/definitelyNotNullAsArgument.kt");
    }

    @Test
    @TestMetadata("definitelyNotNullAsReceiver.kt")
    public void testDefinitelyNotNullAsReceiver() {
      runTest("compiler/testData/ir/irText/types/definitelyNotNullAsReceiver.kt");
    }

    @Test
    @TestMetadata("definitelyNotNullWithIntersection1.kt")
    public void testDefinitelyNotNullWithIntersection1() {
      runTest("compiler/testData/ir/irText/types/definitelyNotNullWithIntersection1.kt");
    }

    @Test
    @TestMetadata("dontLeaveStubTypesInSetter.kt")
    public void testDontLeaveStubTypesInSetter() {
      runTest("compiler/testData/ir/irText/types/dontLeaveStubTypesInSetter.kt");
    }

    @Test
    @TestMetadata("genericDelegatedDeepProperty.kt")
    public void testGenericDelegatedDeepProperty() {
      runTest("compiler/testData/ir/irText/types/genericDelegatedDeepProperty.kt");
    }

    @Test
    @TestMetadata("genericFunWithStar.kt")
    public void testGenericFunWithStar() {
      runTest("compiler/testData/ir/irText/types/genericFunWithStar.kt");
    }

    @Test
    @TestMetadata("genericPropertyReferenceType.kt")
    public void testGenericPropertyReferenceType() {
      runTest("compiler/testData/ir/irText/types/genericPropertyReferenceType.kt");
    }

    @Test
    @TestMetadata("inStarProjectionInReceiverType.kt")
    public void testInStarProjectionInReceiverType() {
      runTest("compiler/testData/ir/irText/types/inStarProjectionInReceiverType.kt");
    }

    @Test
    @TestMetadata("inferenceOfDefinitelyNotNullableBoolean.kt")
    public void testInferenceOfDefinitelyNotNullableBoolean() {
      runTest("compiler/testData/ir/irText/types/inferenceOfDefinitelyNotNullableBoolean.kt");
    }

    @Test
    @TestMetadata("intersectionType1.kt")
    public void testIntersectionType1() {
      runTest("compiler/testData/ir/irText/types/intersectionType1.kt");
    }

    @Test
    @TestMetadata("intersectionType2.kt")
    public void testIntersectionType2() {
      runTest("compiler/testData/ir/irText/types/intersectionType2.kt");
    }

    @Test
    @TestMetadata("intersectionType3.kt")
    public void testIntersectionType3() {
      runTest("compiler/testData/ir/irText/types/intersectionType3.kt");
    }

    @Test
    @TestMetadata("intersectionTypeInSamType.kt")
    public void testIntersectionTypeInSamType() {
      runTest("compiler/testData/ir/irText/types/intersectionTypeInSamType.kt");
    }

    @Test
    @TestMetadata("javaWildcardType.kt")
    public void testJavaWildcardType() {
      runTest("compiler/testData/ir/irText/types/javaWildcardType.kt");
    }

    @Test
    @TestMetadata("kt36143.kt")
    public void testKt36143() {
      runTest("compiler/testData/ir/irText/types/kt36143.kt");
    }

    @Test
    @TestMetadata("kt49526.kt")
    public void testKt49526() {
      runTest("compiler/testData/ir/irText/types/kt49526.kt");
    }

    @Test
    @TestMetadata("localVariableOfIntersectionType.kt")
    public void testLocalVariableOfIntersectionType() {
      runTest("compiler/testData/ir/irText/types/localVariableOfIntersectionType.kt");
    }

    @Test
    @TestMetadata("rawTypeInSignature.kt")
    public void testRawTypeInSignature() {
      runTest("compiler/testData/ir/irText/types/rawTypeInSignature.kt");
    }

    @Test
    @TestMetadata("receiverOfIntersectionType.kt")
    public void testReceiverOfIntersectionType() {
      runTest("compiler/testData/ir/irText/types/receiverOfIntersectionType.kt");
    }

    @Test
    @TestMetadata("smartCastOnFakeOverrideReceiver.kt")
    public void testSmartCastOnFakeOverrideReceiver() {
      runTest("compiler/testData/ir/irText/types/smartCastOnFakeOverrideReceiver.kt");
    }

    @Test
    @TestMetadata("smartCastOnFieldReceiverOfGenericType.kt")
    public void testSmartCastOnFieldReceiverOfGenericType() {
      runTest("compiler/testData/ir/irText/types/smartCastOnFieldReceiverOfGenericType.kt");
    }

    @Test
    @TestMetadata("smartCastOnReceiverOfGenericType.kt")
    public void testSmartCastOnReceiverOfGenericType() {
      runTest("compiler/testData/ir/irText/types/smartCastOnReceiverOfGenericType.kt");
    }

    @Test
    @TestMetadata("starProjection.kt")
    public void testStarProjection() {
      runTest("compiler/testData/ir/irText/types/starProjection.kt");
    }

    @Test
    @TestMetadata("typeAliasWithUnsafeVariance.kt")
    public void testTypeAliasWithUnsafeVariance() {
      runTest("compiler/testData/ir/irText/types/typeAliasWithUnsafeVariance.kt");
    }

    @Test
    @TestMetadata("typeCheckOnDefinitelyNotNull.kt")
    public void testTypeCheckOnDefinitelyNotNull() {
      runTest("compiler/testData/ir/irText/types/typeCheckOnDefinitelyNotNull.kt");
    }

    @Nested
    @TestMetadata("compiler/testData/ir/irText/types/nullChecks")
    @TestDataPath("$PROJECT_ROOT")
    public class NullChecks {
      @Test
      public void testAllFilesPresentInNullChecks() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/types/nullChecks"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
      }

      @Test
      @TestMetadata("enhancedNullability.kt")
      public void testEnhancedNullability() {
        runTest("compiler/testData/ir/irText/types/nullChecks/enhancedNullability.kt");
      }

      @Test
      @TestMetadata("enhancedNullabilityInCatch.kt")
      public void testEnhancedNullabilityInCatch() {
        runTest("compiler/testData/ir/irText/types/nullChecks/enhancedNullabilityInCatch.kt");
      }

      @Test
      @TestMetadata("enhancedNullabilityInDestructuringAssignment.kt")
      public void testEnhancedNullabilityInDestructuringAssignment() {
        runTest("compiler/testData/ir/irText/types/nullChecks/enhancedNullabilityInDestructuringAssignment.kt");
      }

      @Test
      @TestMetadata("enhancedNullabilityInForLoop.kt")
      public void testEnhancedNullabilityInForLoop() {
        runTest("compiler/testData/ir/irText/types/nullChecks/enhancedNullabilityInForLoop.kt");
      }

      @Test
      @TestMetadata("explicitEqualsAndCompareToCallsOnPlatformTypeReceiver.kt")
      public void testExplicitEqualsAndCompareToCallsOnPlatformTypeReceiver() {
        runTest("compiler/testData/ir/irText/types/nullChecks/explicitEqualsAndCompareToCallsOnPlatformTypeReceiver.kt");
      }

      @Test
      @TestMetadata("implicitNotNullOnPlatformType.kt")
      public void testImplicitNotNullOnPlatformType() {
        runTest("compiler/testData/ir/irText/types/nullChecks/implicitNotNullOnPlatformType.kt");
      }

      @Test
      @TestMetadata("nullCheckInElvisRhs.kt")
      public void testNullCheckInElvisRhs() {
        runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckInElvisRhs.kt");
      }

      @Test
      @TestMetadata("nullCheckOnInterfaceDelegation.kt")
      public void testNullCheckOnInterfaceDelegation() {
        runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnInterfaceDelegation.kt");
      }

      @Test
      @TestMetadata("nullabilityAssertionOnExtensionReceiver.kt")
      public void testNullabilityAssertionOnExtensionReceiver() {
        runTest("compiler/testData/ir/irText/types/nullChecks/nullabilityAssertionOnExtensionReceiver.kt");
      }

      @Test
      @TestMetadata("platformTypeReceiver.kt")
      public void testPlatformTypeReceiver() {
        runTest("compiler/testData/ir/irText/types/nullChecks/platformTypeReceiver.kt");
      }

      @Test
      @TestMetadata("typeParameterWithMixedNullableAndNotNullableBounds.kt")
      public void testTypeParameterWithMixedNullableAndNotNullableBounds() {
        runTest("compiler/testData/ir/irText/types/nullChecks/typeParameterWithMixedNullableAndNotNullableBounds.kt");
      }

      @Test
      @TestMetadata("typeParameterWithMultipleNotNullableBounds.kt")
      public void testTypeParameterWithMultipleNotNullableBounds() {
        runTest("compiler/testData/ir/irText/types/nullChecks/typeParameterWithMultipleNotNullableBounds.kt");
      }

      @Test
      @TestMetadata("typeParameterWithMultipleNullableBounds.kt")
      public void testTypeParameterWithMultipleNullableBounds() {
        runTest("compiler/testData/ir/irText/types/nullChecks/typeParameterWithMultipleNullableBounds.kt");
      }

      @Nested
      @TestMetadata("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult")
      @TestDataPath("$PROJECT_ROOT")
      public class NullCheckOnLambdaResult {
        @Test
        public void testAllFilesPresentInNullCheckOnLambdaResult() {
          KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true);
        }

        @Test
        @TestMetadata("nnStringVsT.kt")
        public void testNnStringVsT() {
          runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsT.kt");
        }

        @Test
        @TestMetadata("nnStringVsTAny.kt")
        public void testNnStringVsTAny() {
          runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsTAny.kt");
        }

        @Test
        @TestMetadata("nnStringVsTConstrained.kt")
        public void testNnStringVsTConstrained() {
          runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsTConstrained.kt");
        }

        @Test
        @TestMetadata("nnStringVsTXArray.kt")
        public void testNnStringVsTXArray() {
          runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsTXArray.kt");
        }

        @Test
        @TestMetadata("nnStringVsTXString.kt")
        public void testNnStringVsTXString() {
          runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/nnStringVsTXString.kt");
        }

        @Test
        @TestMetadata("stringVsAny.kt")
        public void testStringVsAny() {
          runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsAny.kt");
        }

        @Test
        @TestMetadata("stringVsT.kt")
        public void testStringVsT() {
          runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsT.kt");
        }

        @Test
        @TestMetadata("stringVsTAny.kt")
        public void testStringVsTAny() {
          runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsTAny.kt");
        }

        @Test
        @TestMetadata("stringVsTConstrained.kt")
        public void testStringVsTConstrained() {
          runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsTConstrained.kt");
        }

        @Test
        @TestMetadata("stringVsTXArray.kt")
        public void testStringVsTXArray() {
          runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsTXArray.kt");
        }

        @Test
        @TestMetadata("stringVsTXString.kt")
        public void testStringVsTXString() {
          runTest("compiler/testData/ir/irText/types/nullChecks/nullCheckOnLambdaResult/stringVsTXString.kt");
        }
      }
    }
  }
}
