/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.sourceProviders;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.directives.AdditionalFilesDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AdditionalSourceProvider;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/test/services/sourceProviders/SpecHelpersSourceFilesProvider;", "Lorg/jetbrains/kotlin/test/services/AdditionalSourceProvider;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "testType", "", "baseDir", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Ljava/lang/String;Ljava/lang/String;)V", "helpersDirPath", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "produceAdditionalFiles", "Lorg/jetbrains/kotlin/test/model/TestFile;", "globalDirectives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testModuleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "tests-common-new_test"})
public final class SpecHelpersSourceFilesProvider
extends AdditionalSourceProvider {
    @NotNull
    private final String helpersDirPath;
    @NotNull
    private final List<DirectivesContainer> directiveContainers;

    public SpecHelpersSourceFilesProvider(@NotNull TestServices testServices, @NotNull String testType, @NotNull String baseDir) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)testType, (String)"testType");
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        super(testServices);
        this.helpersDirPath = baseDir + "/compiler/tests-spec/testData/" + testType + "/helpers";
        this.directiveContainers = CollectionsKt.listOf((Object)AdditionalFilesDirectives.INSTANCE);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return this.directiveContainers;
    }

    @Override
    @NotNull
    public List<TestFile> produceAdditionalFiles(@NotNull RegisteredDirectives globalDirectives, @NotNull TestModule module, @NotNull TestModuleStructure testModuleStructure) {
        Intrinsics.checkNotNullParameter((Object)globalDirectives, (String)"globalDirectives");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)testModuleStructure, (String)"testModuleStructure");
        if (!module.getDirectives().contains(AdditionalFilesDirectives.INSTANCE.getSPEC_HELPERS())) {
            return CollectionsKt.emptyList();
        }
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)((Sequence)FilesKt.walkTopDown((File)new File(this.helpersDirPath))), arg_0 -> SpecHelpersSourceFilesProvider.produceAdditionalFiles$lambda$0(this, arg_0)));
    }

    private static final TestFile produceAdditionalFiles$lambda$0(SpecHelpersSourceFilesProvider this$0, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.isDirectory()) {
            return null;
        }
        return AdditionalSourceProvider.toTestFile$default(this$0, it, null, 1, null);
    }
}

