/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.test.directives.ConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.KlibBasedCompilerTestDirectives;
import org.jetbrains.kotlin.test.directives.NativeEnvironmentConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.SimpleDirectivesContainer;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.EnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.RuntimeClasspathProvider;
import org.jetbrains.kotlin.test.services.RuntimeClasspathProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.KlibBasedEnvironmentConfiguratorUtils;
import org.jetbrains.kotlin.test.services.configuration.NativeEnvironmentConfiguratorKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\u0006\u0010\u0012\u001a\u00020\u0013R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/NativeEnvironmentConfigurator;", "Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "nativeHome", "", "getNativeHome", "()Ljava/lang/String;", "nativeHome$delegate", "Lkotlin/Lazy;", "defaultNativeTarget", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "getDefaultNativeTarget", "()Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "defaultNativeTarget$delegate", "getNativeTarget", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "distributionKlibPath", "Ljava/io/File;", "getRuntimePathsForModule", "", "directiveContainers", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nNativeEnvironmentConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/NativeEnvironmentConfigurator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n13472#2,2:89\n1374#3:91\n1460#3,5:92\n1634#3,3:97\n*S KotlinDebug\n*F\n+ 1 NativeEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/NativeEnvironmentConfigurator\n*L\n69#1:89,2\n75#1:91\n75#1:92,5\n76#1:97,3\n*E\n"})
public final class NativeEnvironmentConfigurator
extends EnvironmentConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy nativeHome$delegate;
    @NotNull
    private final Lazy defaultNativeTarget$delegate;
    @NotNull
    private static final String TEST_PROPERTY_NATIVE_HOME = "kotlin.internal.native.test.nativeHome";
    @NotNull
    private static final String TEST_PROPERTY_TEST_TARGET = "kotlin.internal.native.test.target";

    public NativeEnvironmentConfigurator(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
        this.nativeHome$delegate = LazyKt.lazy(() -> NativeEnvironmentConfigurator.nativeHome_delegate$lambda$1(testServices));
        this.defaultNativeTarget$delegate = LazyKt.lazy(() -> NativeEnvironmentConfigurator.defaultNativeTarget_delegate$lambda$3(testServices));
    }

    private final String getNativeHome() {
        Lazy lazy = this.nativeHome$delegate;
        return (String)lazy.getValue();
    }

    private final KonanTarget getDefaultNativeTarget() {
        Lazy lazy = this.defaultNativeTarget$delegate;
        return (KonanTarget)lazy.getValue();
    }

    @NotNull
    public final KonanTarget getNativeTarget(@NotNull TestModule module) {
        KonanTarget konanTarget;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        String testDefinedTarget = (String)CollectionsKt.firstOrNull(module.getDirectives().get(NativeEnvironmentConfigurationDirectives.INSTANCE.getWITH_FIXED_TARGET()));
        if (testDefinedTarget != null) {
            konanTarget = (KonanTarget)new HostManager().getTargets().get(testDefinedTarget);
            if (konanTarget == null) {
                AssertionsKt.getAssertions(this.getTestServices()).fail((Function0<String>)((Function0)() -> NativeEnvironmentConfigurator.getNativeTarget$lambda$4(testDefinedTarget)));
                throw new KotlinNothingValueException();
            }
        } else {
            konanTarget = this.getDefaultNativeTarget();
        }
        return konanTarget;
    }

    @NotNull
    public final File distributionKlibPath() {
        return new File(this.getNativeHome(), "klib");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getRuntimePathsForModule(@NotNull TestModule module) {
        void $this$flatMapTo$iv$iv;
        Object it;
        File[] $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        List result = new ArrayList();
        if (module.getDirectives().contains(ConfigurationDirectives.INSTANCE.getWITH_STDLIB())) {
            ((Collection)result).add(FilesKt.resolve((File)FilesKt.resolve((File)this.distributionKlibPath(), (String)"common"), (String)"stdlib").getAbsolutePath());
        }
        if (module.getDirectives().contains(NativeEnvironmentConfigurationDirectives.INSTANCE.getWITH_PLATFORM_LIBS())) {
            KonanTarget nativeTarget = this.getNativeTarget(module);
            File[] fileArray = FilesKt.resolve((File)FilesKt.resolve((File)this.distributionKlibPath(), (String)"platform"), (String)nativeTarget.getName()).listFiles();
            if (fileArray != null) {
                $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                for (File element$iv : $this$forEach$iv) {
                    it = element$iv;
                    boolean bl = false;
                    ((Collection)result).add(((File)it).getAbsolutePath());
                }
            }
        }
        File[] $this$flatMap$iv = (File[])RuntimeClasspathProviderKt.getRuntimeClasspathProviders(this.getTestServices());
        boolean $i$f$flatMap = false;
        $this$forEach$iv = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (RuntimeClasspathProvider)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ((RuntimeClasspathProvider)it).runtimeClassPaths(module);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$mapTo$iv = (List)destination$iv$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it2;
            File $i$f$flatMapTo2 = (File)item$iv;
            Collection collection = result;
            boolean bl = false;
            collection.add(it2.getAbsolutePath());
        }
        return result;
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        Object[] objectArray = new SimpleDirectivesContainer[]{NativeEnvironmentConfigurationDirectives.INSTANCE, KlibBasedCompilerTestDirectives.INSTANCE};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private static final String nativeHome_delegate$lambda$1$lambda$0() {
        return "No 'kotlin.internal.native.test.nativeHome' provided. Are you sure the test are executed within :native:native.tests?";
    }

    private static final String nativeHome_delegate$lambda$1(TestServices $testServices) {
        String string = System.getProperty(TEST_PROPERTY_NATIVE_HOME);
        if (string == null) {
            AssertionsKt.getAssertions($testServices).fail((Function0<String>)((Function0)NativeEnvironmentConfigurator::nativeHome_delegate$lambda$1$lambda$0));
            throw new KotlinNothingValueException();
        }
        return string;
    }

    private static final String defaultNativeTarget_delegate$lambda$3$lambda$2(String $userDefinedTarget) {
        return "Unsupported target name specified in 'kotlin.internal.native.test.target': " + $userDefinedTarget;
    }

    private static final KonanTarget defaultNativeTarget_delegate$lambda$3(TestServices $testServices) {
        KonanTarget konanTarget;
        String userDefinedTarget = System.getProperty(TEST_PROPERTY_TEST_TARGET);
        if (userDefinedTarget != null) {
            konanTarget = (KonanTarget)new HostManager().getTargets().get(userDefinedTarget);
            if (konanTarget == null) {
                AssertionsKt.getAssertions($testServices).fail((Function0<String>)((Function0)() -> NativeEnvironmentConfigurator.defaultNativeTarget_delegate$lambda$3$lambda$2(userDefinedTarget)));
                throw new KotlinNothingValueException();
            }
        } else {
            konanTarget = HostManager.Companion.getHost();
        }
        return konanTarget;
    }

    private static final String getNativeTarget$lambda$4(String $testDefinedTarget) {
        return "Unsupported target name specified in '" + NativeEnvironmentConfigurationDirectives.INSTANCE.getWITH_FIXED_TARGET() + "': " + $testDefinedTarget;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/NativeEnvironmentConfigurator$Companion;", "Lorg/jetbrains/kotlin/test/services/configuration/KlibBasedEnvironmentConfiguratorUtils;", "<init>", "()V", "TEST_PROPERTY_NATIVE_HOME", "", "TEST_PROPERTY_TEST_TARGET", "getRuntimePathsForModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "tests-common-new_test"})
    public static final class Companion
    implements KlibBasedEnvironmentConfiguratorUtils {
        private Companion() {
        }

        @NotNull
        public final List<String> getRuntimePathsForModule(@NotNull TestModule module, @NotNull TestServices testServices) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            return NativeEnvironmentConfiguratorKt.getNativeEnvironmentConfigurator(testServices).getRuntimePathsForModule(module);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

