/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.runners.codegen;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.runners.codegen.AbstractIrBytecodeTextTest;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="compiler/testData/codegen/bytecodeText")
@TestDataPath(value="$PROJECT_ROOT")
public class IrBytecodeTextTestGenerated
extends AbstractIrBytecodeTextTest {
    @Test
    @TestMetadata(value="accessorForOverridenVal.kt")
    public void testAccessorForOverridenVal() {
        this.runTest("compiler/testData/codegen/bytecodeText/accessorForOverridenVal.kt");
    }

    @Test
    @TestMetadata(value="accessorForProtected.kt")
    public void testAccessorForProtected() {
        this.runTest("compiler/testData/codegen/bytecodeText/accessorForProtected.kt");
    }

    @Test
    @TestMetadata(value="accessorNaming.kt")
    public void testAccessorNaming() {
        this.runTest("compiler/testData/codegen/bytecodeText/accessorNaming.kt");
    }

    @Test
    public void testAllFilesPresentInBytecodeText() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
    }

    @Test
    @TestMetadata(value="annotationDefaultValue.kt")
    public void testAnnotationDefaultValue() {
        this.runTest("compiler/testData/codegen/bytecodeText/annotationDefaultValue.kt");
    }

    @Test
    @TestMetadata(value="annotationDefaultValueOfUnsigned.kt")
    public void testAnnotationDefaultValueOfUnsigned() {
        this.runTest("compiler/testData/codegen/bytecodeText/annotationDefaultValueOfUnsigned.kt");
    }

    @Test
    @TestMetadata(value="annotationJavaRetentionPolicyRuntime.kt")
    public void testAnnotationJavaRetentionPolicyRuntime() {
        this.runTest("compiler/testData/codegen/bytecodeText/annotationJavaRetentionPolicyRuntime.kt");
    }

    @Test
    @TestMetadata(value="annotationRetentionPolicyClass.kt")
    public void testAnnotationRetentionPolicyClass() {
        this.runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicyClass.kt");
    }

    @Test
    @TestMetadata(value="annotationRetentionPolicyRuntime.kt")
    public void testAnnotationRetentionPolicyRuntime() {
        this.runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicyRuntime.kt");
    }

    @Test
    @TestMetadata(value="annotationRetentionPolicySource.kt")
    public void testAnnotationRetentionPolicySource() {
        this.runTest("compiler/testData/codegen/bytecodeText/annotationRetentionPolicySource.kt");
    }

    @Test
    @TestMetadata(value="boxedNotNumberTypeOnUnboxing.kt")
    public void testBoxedNotNumberTypeOnUnboxing() {
        this.runTest("compiler/testData/codegen/bytecodeText/boxedNotNumberTypeOnUnboxing.kt");
    }

    @Test
    @TestMetadata(value="bridgeForFakeOverride.kt")
    public void testBridgeForFakeOverride() {
        this.runTest("compiler/testData/codegen/bytecodeText/bridgeForFakeOverride.kt");
    }

    @Test
    @TestMetadata(value="charConstant.kt")
    public void testCharConstant() {
        this.runTest("compiler/testData/codegen/bytecodeText/charConstant.kt");
    }

    @Test
    @TestMetadata(value="checkcastOnThrow.kt")
    public void testCheckcastOnThrow() {
        this.runTest("compiler/testData/codegen/bytecodeText/checkcastOnThrow.kt");
    }

    @Test
    @TestMetadata(value="collectionStubs.kt")
    public void testCollectionStubs() {
        this.runTest("compiler/testData/codegen/bytecodeText/collectionStubs.kt");
    }

    @Test
    @TestMetadata(value="componentEvaluatesOnlyOnce.kt")
    public void testComponentEvaluatesOnlyOnce() {
        this.runTest("compiler/testData/codegen/bytecodeText/componentEvaluatesOnlyOnce.kt");
    }

    @Test
    @TestMetadata(value="constClosureOptimization.kt")
    public void testConstClosureOptimization() {
        this.runTest("compiler/testData/codegen/bytecodeText/constClosureOptimization.kt");
    }

    @Test
    @TestMetadata(value="defaultMethodBody.kt")
    public void testDefaultMethodBody() {
        this.runTest("compiler/testData/codegen/bytecodeText/defaultMethodBody.kt");
    }

    @Test
    @TestMetadata(value="doNotStoreNullForTmpInDestructuring.kt")
    public void testDoNotStoreNullForTmpInDestructuring() {
        this.runTest("compiler/testData/codegen/bytecodeText/doNotStoreNullForTmpInDestructuring.kt");
    }

    @Test
    @TestMetadata(value="doNotStoreNullsForCapturedVars.kt")
    public void testDoNotStoreNullsForCapturedVars() {
        this.runTest("compiler/testData/codegen/bytecodeText/doNotStoreNullsForCapturedVars.kt");
    }

    @Test
    @TestMetadata(value="falseSmartCast.kt")
    public void testFalseSmartCast() {
        this.runTest("compiler/testData/codegen/bytecodeText/falseSmartCast.kt");
    }

    @Test
    @TestMetadata(value="flagsInMultiFileInherit.kt")
    public void testFlagsInMultiFileInherit() {
        this.runTest("compiler/testData/codegen/bytecodeText/flagsInMultiFileInherit.kt");
    }

    @Test
    @TestMetadata(value="iincGeneration.kt")
    public void testIincGeneration() {
        this.runTest("compiler/testData/codegen/bytecodeText/iincGeneration.kt");
    }

    @Test
    @TestMetadata(value="inheritedPropertyAnnotations.kt")
    public void testInheritedPropertyAnnotations() {
        this.runTest("compiler/testData/codegen/bytecodeText/inheritedPropertyAnnotations.kt");
    }

    @Test
    @TestMetadata(value="inlineFromOtherModule.kt")
    public void testInlineFromOtherModule() {
        this.runTest("compiler/testData/codegen/bytecodeText/inlineFromOtherModule.kt");
    }

    @Test
    @TestMetadata(value="inlineJavaConstantFromSubclass.kt")
    public void testInlineJavaConstantFromSubclass() {
        this.runTest("compiler/testData/codegen/bytecodeText/inlineJavaConstantFromSubclass.kt");
    }

    @Test
    @TestMetadata(value="inlineJavaStaticFields.kt")
    public void testInlineJavaStaticFields() {
        this.runTest("compiler/testData/codegen/bytecodeText/inlineJavaStaticFields.kt");
    }

    @Test
    @TestMetadata(value="inlineProtectedJavaConstantFromOtherPackage.kt")
    public void testInlineProtectedJavaConstantFromOtherPackage() {
        this.runTest("compiler/testData/codegen/bytecodeText/inlineProtectedJavaConstantFromOtherPackage.kt");
    }

    @Test
    @TestMetadata(value="intConstantNotNull.kt")
    public void testIntConstantNotNull() {
        this.runTest("compiler/testData/codegen/bytecodeText/intConstantNotNull.kt");
    }

    @Test
    @TestMetadata(value="intConstantNullable.kt")
    public void testIntConstantNullable() {
        this.runTest("compiler/testData/codegen/bytecodeText/intConstantNullable.kt");
    }

    @Test
    @TestMetadata(value="intConstantNullableSafeCall.kt")
    public void testIntConstantNullableSafeCall() {
        this.runTest("compiler/testData/codegen/bytecodeText/intConstantNullableSafeCall.kt");
    }

    @Test
    @TestMetadata(value="intConstantSafeCall.kt")
    public void testIntConstantSafeCall() {
        this.runTest("compiler/testData/codegen/bytecodeText/intConstantSafeCall.kt");
    }

    @Test
    @TestMetadata(value="intProgressionNoBoxing.kt")
    public void testIntProgressionNoBoxing() {
        this.runTest("compiler/testData/codegen/bytecodeText/intProgressionNoBoxing.kt");
    }

    @Test
    @TestMetadata(value="intRangeNoBoxing.kt")
    public void testIntRangeNoBoxing() {
        this.runTest("compiler/testData/codegen/bytecodeText/intRangeNoBoxing.kt");
    }

    @Test
    @TestMetadata(value="interfaceDefaultImpl.kt")
    public void testInterfaceDefaultImpl() {
        this.runTest("compiler/testData/codegen/bytecodeText/interfaceDefaultImpl.kt");
    }

    @Test
    @TestMetadata(value="isArrayOf.kt")
    public void testIsArrayOf() {
        this.runTest("compiler/testData/codegen/bytecodeText/isArrayOf.kt");
    }

    @Test
    @TestMetadata(value="javaExtensionPropertyIntrinsic.kt")
    public void testJavaExtensionPropertyIntrinsic() {
        this.runTest("compiler/testData/codegen/bytecodeText/javaExtensionPropertyIntrinsic.kt");
    }

    @Test
    @TestMetadata(value="javaFields.kt")
    public void testJavaFields() {
        this.runTest("compiler/testData/codegen/bytecodeText/javaFields.kt");
    }

    @Test
    @TestMetadata(value="javaFieldsWithIntersectionTypes.kt")
    public void testJavaFieldsWithIntersectionTypes() {
        this.runTest("compiler/testData/codegen/bytecodeText/javaFieldsWithIntersectionTypes.kt");
    }

    @Test
    @TestMetadata(value="javaStatics.kt")
    public void testJavaStatics() {
        this.runTest("compiler/testData/codegen/bytecodeText/javaStatics.kt");
    }

    @Test
    @TestMetadata(value="jvmField.kt")
    public void testJvmField() {
        this.runTest("compiler/testData/codegen/bytecodeText/jvmField.kt");
    }

    @Test
    @TestMetadata(value="jvmStaticInternalMangling.kt")
    public void testJvmStaticInternalMangling() {
        this.runTest("compiler/testData/codegen/bytecodeText/jvmStaticInternalMangling.kt");
    }

    @Test
    @TestMetadata(value="kt10259.kt")
    public void testKt10259() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt10259.kt");
    }

    @Test
    @TestMetadata(value="kt10259_2.kt")
    public void testKt10259_2() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt10259_2.kt");
    }

    @Test
    @TestMetadata(value="kt10259_3.kt")
    public void testKt10259_3() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt10259_3.kt");
    }

    @Test
    @TestMetadata(value="kt2202.kt")
    public void testKt2202() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt2202.kt");
    }

    @Test
    @TestMetadata(value="kt2887.kt")
    public void testKt2887() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt2887.kt");
    }

    @Test
    @TestMetadata(value="kt3845.kt")
    public void testKt3845() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt3845.kt");
    }

    @Test
    @TestMetadata(value="kt46615.kt")
    public void testKt46615() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt46615.kt");
    }

    @Test
    @TestMetadata(value="kt48367.kt")
    public void testKt48367() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt48367.kt");
    }

    @Test
    @TestMetadata(value="kt5016.kt")
    public void testKt5016() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt5016.kt");
    }

    @Test
    @TestMetadata(value="kt5016int.kt")
    public void testKt5016int() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt5016int.kt");
    }

    @Test
    @TestMetadata(value="kt5016intOrNull.kt")
    public void testKt5016intOrNull() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt5016intOrNull.kt");
    }

    @Test
    @TestMetadata(value="kt56923.kt")
    public void testKt56923() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt56923.kt");
    }

    @Test
    @TestMetadata(value="kt7188.kt")
    public void testKt7188() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt7188.kt");
    }

    @Test
    @TestMetadata(value="kt7769.kt")
    public void testKt7769() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt7769.kt");
    }

    @Test
    @TestMetadata(value="kt9603.kt")
    public void testKt9603() {
        this.runTest("compiler/testData/codegen/bytecodeText/kt9603.kt");
    }

    @Test
    @TestMetadata(value="mapGetOrDefault.kt")
    public void testMapGetOrDefault() {
        this.runTest("compiler/testData/codegen/bytecodeText/mapGetOrDefault.kt");
    }

    @Test
    @TestMetadata(value="maxStackAfterOptimizations.kt")
    public void testMaxStackAfterOptimizations() {
        this.runTest("compiler/testData/codegen/bytecodeText/maxStackAfterOptimizations.kt");
    }

    @Test
    @TestMetadata(value="mergedProgression.kt")
    public void testMergedProgression() {
        this.runTest("compiler/testData/codegen/bytecodeText/mergedProgression.kt");
    }

    @Test
    @TestMetadata(value="noAccessorForProtectedInSamePackageCrossinline.kt")
    public void testNoAccessorForProtectedInSamePackageCrossinline() {
        this.runTest("compiler/testData/codegen/bytecodeText/noAccessorForProtectedInSamePackageCrossinline.kt");
    }

    @Test
    @TestMetadata(value="noAccessorForProtectedInSamePackagePrivateInline.kt")
    public void testNoAccessorForProtectedInSamePackagePrivateInline() {
        this.runTest("compiler/testData/codegen/bytecodeText/noAccessorForProtectedInSamePackagePrivateInline.kt");
    }

    @Test
    @TestMetadata(value="noFlagAnnotations.kt")
    public void testNoFlagAnnotations() {
        this.runTest("compiler/testData/codegen/bytecodeText/noFlagAnnotations.kt");
    }

    @Test
    @TestMetadata(value="noLineNumberInEnumEntries.kt")
    public void testNoLineNumberInEnumEntries() {
        this.runTest("compiler/testData/codegen/bytecodeText/noLineNumberInEnumEntries.kt");
    }

    @Test
    @TestMetadata(value="noLinenumberInJvmOverloads.kt")
    public void testNoLinenumberInJvmOverloads() {
        this.runTest("compiler/testData/codegen/bytecodeText/noLinenumberInJvmOverloads.kt");
    }

    @Test
    @TestMetadata(value="noNumberCheckCast.kt")
    public void testNoNumberCheckCast() {
        this.runTest("compiler/testData/codegen/bytecodeText/noNumberCheckCast.kt");
    }

    @Test
    @TestMetadata(value="noSuperCheckInDefaultConstuctor.kt")
    public void testNoSuperCheckInDefaultConstuctor() {
        this.runTest("compiler/testData/codegen/bytecodeText/noSuperCheckInDefaultConstuctor.kt");
    }

    @Test
    @TestMetadata(value="noSyntheticAccessorForPrivateCompanionObjectWhenNotRequired.kt")
    public void testNoSyntheticAccessorForPrivateCompanionObjectWhenNotRequired() {
        this.runTest("compiler/testData/codegen/bytecodeText/noSyntheticAccessorForPrivateCompanionObjectWhenNotRequired.kt");
    }

    @Test
    @TestMetadata(value="noWrapperForMethodReturningPrimitive.kt")
    public void testNoWrapperForMethodReturningPrimitive() {
        this.runTest("compiler/testData/codegen/bytecodeText/noWrapperForMethodReturningPrimitive.kt");
    }

    @Test
    @TestMetadata(value="nopsInDoWhile.kt")
    public void testNopsInDoWhile() {
        this.runTest("compiler/testData/codegen/bytecodeText/nopsInDoWhile.kt");
    }

    @Test
    @TestMetadata(value="partMembersCall.kt")
    public void testPartMembersCall() {
        this.runTest("compiler/testData/codegen/bytecodeText/partMembersCall.kt");
    }

    @Test
    @TestMetadata(value="partMembersInline.kt")
    public void testPartMembersInline() {
        this.runTest("compiler/testData/codegen/bytecodeText/partMembersInline.kt");
    }

    @Test
    @TestMetadata(value="preEvaluateInlineJavaStaticFields.kt")
    public void testPreEvaluateInlineJavaStaticFields() {
        this.runTest("compiler/testData/codegen/bytecodeText/preEvaluateInlineJavaStaticFields.kt");
    }

    @Test
    @TestMetadata(value="prefixIntVarIncrement.kt")
    public void testPrefixIntVarIncrement() {
        this.runTest("compiler/testData/codegen/bytecodeText/prefixIntVarIncrement.kt");
    }

    @Test
    @TestMetadata(value="privateDefaultArgs.kt")
    public void testPrivateDefaultArgs() {
        this.runTest("compiler/testData/codegen/bytecodeText/privateDefaultArgs.kt");
    }

    @Test
    @TestMetadata(value="redundantGotoRemoving.kt")
    public void testRedundantGotoRemoving() {
        this.runTest("compiler/testData/codegen/bytecodeText/redundantGotoRemoving.kt");
    }

    @Test
    @TestMetadata(value="redundantInitializer.kt")
    public void testRedundantInitializer() {
        this.runTest("compiler/testData/codegen/bytecodeText/redundantInitializer.kt");
    }

    @Test
    @TestMetadata(value="redundantInitializerNumber.kt")
    public void testRedundantInitializerNumber() {
        this.runTest("compiler/testData/codegen/bytecodeText/redundantInitializerNumber.kt");
    }

    @Test
    @TestMetadata(value="redundantValInitializer.kt")
    public void testRedundantValInitializer() {
        this.runTest("compiler/testData/codegen/bytecodeText/redundantValInitializer.kt");
    }

    @Test
    @TestMetadata(value="redundantValInitializerInObject.kt")
    public void testRedundantValInitializerInObject() {
        this.runTest("compiler/testData/codegen/bytecodeText/redundantValInitializerInObject.kt");
    }

    @Test
    @TestMetadata(value="redundantVarInitializer.kt")
    public void testRedundantVarInitializer() {
        this.runTest("compiler/testData/codegen/bytecodeText/redundantVarInitializer.kt");
    }

    @Test
    @TestMetadata(value="redundantVarInitializerInObject.kt")
    public void testRedundantVarInitializerInObject() {
        this.runTest("compiler/testData/codegen/bytecodeText/redundantVarInitializerInObject.kt");
    }

    @Test
    @TestMetadata(value="reifiedAsCheck.kt")
    public void testReifiedAsCheck() {
        this.runTest("compiler/testData/codegen/bytecodeText/reifiedAsCheck.kt");
    }

    @Test
    @TestMetadata(value="reifiedAsCheckWithNullable.kt")
    public void testReifiedAsCheckWithNullable() {
        this.runTest("compiler/testData/codegen/bytecodeText/reifiedAsCheckWithNullable.kt");
    }

    @Test
    @TestMetadata(value="reifiedIsCheck.kt")
    public void testReifiedIsCheck() {
        this.runTest("compiler/testData/codegen/bytecodeText/reifiedIsCheck.kt");
    }

    @Test
    @TestMetadata(value="reifiedIsCheckWithNullable.kt")
    public void testReifiedIsCheckWithNullable() {
        this.runTest("compiler/testData/codegen/bytecodeText/reifiedIsCheckWithNullable.kt");
    }

    @Test
    @TestMetadata(value="reifiedSafeAsCheck.kt")
    public void testReifiedSafeAsCheck() {
        this.runTest("compiler/testData/codegen/bytecodeText/reifiedSafeAsCheck.kt");
    }

    @Test
    @TestMetadata(value="safeAsWithMutable.kt")
    public void testSafeAsWithMutable() {
        this.runTest("compiler/testData/codegen/bytecodeText/safeAsWithMutable.kt");
    }

    @Test
    @TestMetadata(value="superFlagInMultiFileFacade.kt")
    public void testSuperFlagInMultiFileFacade() {
        this.runTest("compiler/testData/codegen/bytecodeText/superFlagInMultiFileFacade.kt");
    }

    @Test
    @TestMetadata(value="superToString.kt")
    public void testSuperToString() {
        this.runTest("compiler/testData/codegen/bytecodeText/superToString.kt");
    }

    @Test
    @TestMetadata(value="suspendCoroutineUninterceptedOrReturn.kt")
    public void testSuspendCoroutineUninterceptedOrReturn() {
        this.runTest("compiler/testData/codegen/bytecodeText/suspendCoroutineUninterceptedOrReturn.kt");
    }

    @Test
    @TestMetadata(value="topLevelFunWithDefaultArgs.kt")
    public void testTopLevelFunWithDefaultArgs() {
        this.runTest("compiler/testData/codegen/bytecodeText/topLevelFunWithDefaultArgs.kt");
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/whenStringOptimization")
    @TestDataPath(value="$PROJECT_ROOT")
    public class WhenStringOptimization {
        @Test
        public void testAllFilesPresentInWhenStringOptimization() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/whenStringOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="denseHashCode.kt")
        public void testDenseHashCode() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/denseHashCode.kt");
        }

        @Test
        @TestMetadata(value="duplicatingItems.kt")
        public void testDuplicatingItems() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItems.kt");
        }

        @Test
        @TestMetadata(value="duplicatingItemsSameHashCodeFewBranches.kt")
        public void testDuplicatingItemsSameHashCodeFewBranches() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItemsSameHashCodeFewBranches.kt");
        }

        @Test
        @TestMetadata(value="duplicatingItemsSameHashCodeMoreBranches.kt")
        public void testDuplicatingItemsSameHashCodeMoreBranches() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/duplicatingItemsSameHashCodeMoreBranches.kt");
        }

        @Test
        @TestMetadata(value="expression.kt")
        public void testExpression() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/expression.kt");
        }

        @Test
        @TestMetadata(value="inlineStringConstInsideWhen.kt")
        public void testInlineStringConstInsideWhen() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/inlineStringConstInsideWhen.kt");
        }

        @Test
        @TestMetadata(value="nullability.kt")
        public void testNullability() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/nullability.kt");
        }

        @Test
        @TestMetadata(value="sameHashCode.kt")
        public void testSameHashCode() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/sameHashCode.kt");
        }

        @Test
        @TestMetadata(value="statement.kt")
        public void testStatement() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenStringOptimization/statement.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/whenEnumOptimization")
    @TestDataPath(value="$PROJECT_ROOT")
    public class WhenEnumOptimization {
        @Test
        public void testAllFilesPresentInWhenEnumOptimization() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/whenEnumOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="bigEnum.kt")
        public void testBigEnum() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/bigEnum.kt");
        }

        @Test
        @TestMetadata(value="duplicatingItems.kt")
        public void testDuplicatingItems() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/duplicatingItems.kt");
        }

        @Test
        @TestMetadata(value="expression.kt")
        public void testExpression() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/expression.kt");
        }

        @Test
        @TestMetadata(value="functionLiteralInTopLevel.kt")
        public void testFunctionLiteralInTopLevel() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/functionLiteralInTopLevel.kt");
        }

        @Test
        @TestMetadata(value="importedEnumEntry.kt")
        public void testImportedEnumEntry() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/importedEnumEntry.kt");
        }

        @Test
        @TestMetadata(value="kt14597_full.kt")
        public void testKt14597_full() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/kt14597_full.kt");
        }

        @Test
        @TestMetadata(value="kt14802.kt")
        public void testKt14802() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/kt14802.kt");
        }

        @Test
        @TestMetadata(value="manyWhensWithinClass.kt")
        public void testManyWhensWithinClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/manyWhensWithinClass.kt");
        }

        @Test
        @TestMetadata(value="nestedWhenInCondition.kt")
        public void testNestedWhenInCondition() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nestedWhenInCondition.kt");
        }

        @Test
        @TestMetadata(value="nonConstantEnum.kt")
        public void testNonConstantEnum() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nonConstantEnum.kt");
        }

        @Test
        @TestMetadata(value="nullability.kt")
        public void testNullability() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/nullability.kt");
        }

        @Test
        @TestMetadata(value="subjectAny.kt")
        public void testSubjectAny() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/subjectAny.kt");
        }

        @Test
        @TestMetadata(value="whenOr.kt")
        public void testWhenOr() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/whenOr.kt");
        }

        @Test
        @TestMetadata(value="withoutElse.kt")
        public void testWithoutElse() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/whenEnumOptimization/withoutElse.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/when")
    @TestDataPath(value="$PROJECT_ROOT")
    public class When {
        @Test
        public void testAllFilesPresentInWhen() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/when"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="edgeCases.kt")
        public void testEdgeCases() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/edgeCases.kt");
        }

        @Test
        @TestMetadata(value="exhaustiveWhenInitialization.kt")
        public void testExhaustiveWhenInitialization() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenInitialization.kt");
        }

        @Test
        @TestMetadata(value="exhaustiveWhenReturn.kt")
        public void testExhaustiveWhenReturn() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenReturn.kt");
        }

        @Test
        @TestMetadata(value="exhaustiveWhenSpecialCases.kt")
        public void testExhaustiveWhenSpecialCases() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenSpecialCases.kt");
        }

        @Test
        @TestMetadata(value="exhaustiveWhenUnit.kt")
        public void testExhaustiveWhenUnit() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenUnit.kt");
        }

        @Test
        @TestMetadata(value="exhaustiveWhenUnitStatement.kt")
        public void testExhaustiveWhenUnitStatement() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/exhaustiveWhenUnitStatement.kt");
        }

        @Test
        @TestMetadata(value="inlineConstValsInsideWhen.kt")
        public void testInlineConstValsInsideWhen() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/inlineConstValsInsideWhen.kt");
        }

        @Test
        @TestMetadata(value="innerWhenEnumTableSwitch.kt")
        public void testInnerWhenEnumTableSwitch() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/innerWhenEnumTableSwitch.kt");
        }

        @Test
        @TestMetadata(value="integralWhenWithNoInlinedConstants.kt")
        public void testIntegralWhenWithNoInlinedConstants() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/integralWhenWithNoInlinedConstants.kt");
        }

        @Test
        @TestMetadata(value="kt18818.kt")
        public void testKt18818() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/kt18818.kt");
        }

        @Test
        @TestMetadata(value="lookupSwitch.kt")
        public void testLookupSwitch() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/lookupSwitch.kt");
        }

        @Test
        @TestMetadata(value="lookupSwitchWithSubjectVal.kt")
        public void testLookupSwitchWithSubjectVal() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/lookupSwitchWithSubjectVal.kt");
        }

        @Test
        @TestMetadata(value="noBoxingInDefaultWhenWithSpecialCases.kt")
        public void testNoBoxingInDefaultWhenWithSpecialCases() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/noBoxingInDefaultWhenWithSpecialCases.kt");
        }

        @Test
        @TestMetadata(value="qualifiedConstValsInsideWhen.kt")
        public void testQualifiedConstValsInsideWhen() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/qualifiedConstValsInsideWhen.kt");
        }

        @Test
        @TestMetadata(value="sealedWhenInitialization.kt")
        public void testSealedWhenInitialization() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/sealedWhenInitialization.kt");
        }

        @Test
        @TestMetadata(value="simpleConstValsInsideWhen.kt")
        public void testSimpleConstValsInsideWhen() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/simpleConstValsInsideWhen.kt");
        }

        @Test
        @TestMetadata(value="stringSwitchWithSubjectVal.kt")
        public void testStringSwitchWithSubjectVal() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/stringSwitchWithSubjectVal.kt");
        }

        @Test
        @TestMetadata(value="subjectValHasLocalVariableSlot.kt")
        public void testSubjectValHasLocalVariableSlot() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/subjectValHasLocalVariableSlot.kt");
        }

        @Test
        @TestMetadata(value="subjectValInEnumWhenHasLocalVariableSlot.kt")
        public void testSubjectValInEnumWhenHasLocalVariableSlot() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/subjectValInEnumWhenHasLocalVariableSlot.kt");
        }

        @Test
        @TestMetadata(value="subjectValInIntWhenHasLocalVariableSlot.kt")
        public void testSubjectValInIntWhenHasLocalVariableSlot() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/subjectValInIntWhenHasLocalVariableSlot.kt");
        }

        @Test
        @TestMetadata(value="subjectValInStringWhenHasLocalVariableSlot.kt")
        public void testSubjectValInStringWhenHasLocalVariableSlot() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/subjectValInStringWhenHasLocalVariableSlot.kt");
        }

        @Test
        @TestMetadata(value="switchOptimizationDuplicates.kt")
        public void testSwitchOptimizationDuplicates() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/switchOptimizationDuplicates.kt");
        }

        @Test
        @TestMetadata(value="tableSwitch.kt")
        public void testTableSwitch() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/tableSwitch.kt");
        }

        @Test
        @TestMetadata(value="tableSwitchWithSubjectVal.kt")
        public void testTableSwitchWithSubjectVal() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/tableSwitchWithSubjectVal.kt");
        }

        @Test
        @TestMetadata(value="whenNull.kt")
        public void testWhenNull() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/whenNull.kt");
        }

        @Test
        @TestMetadata(value="whenZero.kt")
        public void testWhenZero() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/when/whenZero.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/varargs")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Varargs {
        @Test
        public void testAllFilesPresentInVarargs() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/varargs"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="doNotCopyImmediatelyCreatedArrays.kt")
        public void testDoNotCopyImmediatelyCreatedArrays() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/varargs/doNotCopyImmediatelyCreatedArrays.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/valueClasses")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ValueClasses {
        @Test
        public void testAllFilesPresentInValueClasses() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/valueClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="conditionalExpressions.kt")
        public void testConditionalExpressions() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/conditionalExpressions.kt");
        }

        @Test
        @TestMetadata(value="equalsBoxTest.kt")
        public void testEqualsBoxTest() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/equalsBoxTest.kt");
        }

        @Test
        @TestMetadata(value="mfvcDeclaration.kt")
        public void testMfvcDeclaration() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/mfvcDeclaration.kt");
        }

        @Test
        @TestMetadata(value="mfvcReassignments.kt")
        public void testMfvcReassignments() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/mfvcReassignments.kt");
        }

        @Test
        @TestMetadata(value="passingMFVC2Functions.kt")
        public void testPassingMFVC2Functions() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/passingMFVC2Functions.kt");
        }

        @Test
        @TestMetadata(value="regularClassWithMFVC.kt")
        public void testRegularClassWithMFVC() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/regularClassWithMFVC.kt");
        }

        @Test
        @TestMetadata(value="tryExpressions.kt")
        public void testTryExpressions() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/valueClasses/tryExpressions.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/unsignedTypes")
    @TestDataPath(value="$PROJECT_ROOT")
    public class UnsignedTypes {
        @Test
        public void testAllFilesPresentInUnsignedTypes() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/unsignedTypes"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="unsignedIntCompare_jvm18.kt")
        public void testUnsignedIntCompare_jvm18() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntCompare_jvm18.kt");
        }

        @Test
        @TestMetadata(value="unsignedIntDivide_jvm18.kt")
        public void testUnsignedIntDivide_jvm18() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntDivide_jvm18.kt");
        }

        @Test
        @TestMetadata(value="unsignedIntRemainder_jvm18.kt")
        public void testUnsignedIntRemainder_jvm18() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntRemainder_jvm18.kt");
        }

        @Test
        @TestMetadata(value="unsignedIntSmartCasts_jvm18.kt")
        public void testUnsignedIntSmartCasts_jvm18() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntSmartCasts_jvm18.kt");
        }

        @Test
        @TestMetadata(value="unsignedIntToString_jvm18.kt")
        public void testUnsignedIntToString_jvm18() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedIntToString_jvm18.kt");
        }

        @Test
        @TestMetadata(value="unsignedLongCompare_jvm18.kt")
        public void testUnsignedLongCompare_jvm18() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongCompare_jvm18.kt");
        }

        @Test
        @TestMetadata(value="unsignedLongDivide_jvm18.kt")
        public void testUnsignedLongDivide_jvm18() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongDivide_jvm18.kt");
        }

        @Test
        @TestMetadata(value="unsignedLongRemainder_jvm18.kt")
        public void testUnsignedLongRemainder_jvm18() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongRemainder_jvm18.kt");
        }

        @Test
        @TestMetadata(value="unsignedLongToString_jvm18.kt")
        public void testUnsignedLongToString_jvm18() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/unsignedLongToString_jvm18.kt");
        }

        @Test
        @TestMetadata(value="whenByUnsigned.kt")
        public void testWhenByUnsigned() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/unsignedTypes/whenByUnsigned.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/toArray")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ToArray {
        @Test
        public void testAllFilesPresentInToArray() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/toArray"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="noAccessorForToArray.kt")
        public void testNoAccessorForToArray() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/toArray/noAccessorForToArray.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/temporaryVals")
    @TestDataPath(value="$PROJECT_ROOT")
    public class TemporaryVals {
        @Test
        public void testAllFilesPresentInTemporaryVals() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/temporaryVals"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="arrayCompoundAssignment.kt")
        public void testArrayCompoundAssignment() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/arrayCompoundAssignment.kt");
        }

        @Test
        @TestMetadata(value="elvisChain.kt")
        public void testElvisChain() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/elvisChain.kt");
        }

        @Test
        @TestMetadata(value="noTemporaryInCheckedCast.kt")
        public void testNoTemporaryInCheckedCast() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/noTemporaryInCheckedCast.kt");
        }

        @Test
        @TestMetadata(value="notNullReceiversInChain.kt")
        public void testNotNullReceiversInChain() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/notNullReceiversInChain.kt");
        }

        @Test
        @TestMetadata(value="safeCallChain1.kt")
        public void testSafeCallChain1() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChain1.kt");
        }

        @Test
        @TestMetadata(value="safeCallChain2.kt")
        public void testSafeCallChain2() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChain2.kt");
        }

        @Test
        @TestMetadata(value="safeCallChainMemberExt1.kt")
        public void testSafeCallChainMemberExt1() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChainMemberExt1.kt");
        }

        @Test
        @TestMetadata(value="safeCallChainMemberExt2.kt")
        public void testSafeCallChainMemberExt2() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallChainMemberExt2.kt");
        }

        @Test
        @TestMetadata(value="safeCallElvisSafeCallElvisSomething.kt")
        public void testSafeCallElvisSafeCallElvisSomething() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallElvisSafeCallElvisSomething.kt");
        }

        @Test
        @TestMetadata(value="safeCallWithElvis.kt")
        public void testSafeCallWithElvis() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/temporaryVals/safeCallWithElvis.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/stringOperations")
    @TestDataPath(value="$PROJECT_ROOT")
    public class StringOperations {
        @Test
        public void testAllFilesPresentInStringOperations() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/stringOperations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="concat.kt")
        public void testConcat() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concat.kt");
        }

        @Test
        @TestMetadata(value="concatDynamic.kt")
        public void testConcatDynamic() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic.kt");
        }

        @Test
        @TestMetadata(value="concatDynamic199.kt")
        public void testConcatDynamic199() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic199.kt");
        }

        @Test
        @TestMetadata(value="concatDynamic200.kt")
        public void testConcatDynamic200() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic200.kt");
        }

        @Test
        @TestMetadata(value="concatDynamic201.kt")
        public void testConcatDynamic201() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamic201.kt");
        }

        @Test
        @TestMetadata(value="concatDynamicConstants.kt")
        public void testConcatDynamicConstants() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicConstants.kt");
        }

        @Test
        @TestMetadata(value="concatDynamicDataClass.kt")
        public void testConcatDynamicDataClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicDataClass.kt");
        }

        @Test
        @TestMetadata(value="concatDynamicIndy.kt")
        public void testConcatDynamicIndy() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicIndy.kt");
        }

        @Test
        @TestMetadata(value="concatDynamicIndy201.kt")
        public void testConcatDynamicIndy201() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicIndy201.kt");
        }

        @Test
        @TestMetadata(value="concatDynamicIndyDataClass.kt")
        public void testConcatDynamicIndyDataClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicIndyDataClass.kt");
        }

        @Test
        @TestMetadata(value="concatDynamicSpecialSymbols.kt")
        public void testConcatDynamicSpecialSymbols() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicSpecialSymbols.kt");
        }

        @Test
        @TestMetadata(value="concatDynamicUnit.kt")
        public void testConcatDynamicUnit() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatDynamicUnit.kt");
        }

        @Test
        @TestMetadata(value="concatNotDynamic.kt")
        public void testConcatNotDynamic() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/concatNotDynamic.kt");
        }

        @Test
        @TestMetadata(value="constConcat.kt")
        public void testConstConcat() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/constConcat.kt");
        }

        @Test
        @TestMetadata(value="constValConcat.kt")
        public void testConstValConcat() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/constValConcat.kt");
        }

        @Test
        @TestMetadata(value="doNotAppendEmptyString.kt")
        public void testDoNotAppendEmptyString() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/doNotAppendEmptyString.kt");
        }

        @Test
        @TestMetadata(value="interpolation.kt")
        public void testInterpolation() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/interpolation.kt");
        }

        @Test
        @TestMetadata(value="kt15235.kt")
        public void testKt15235() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt15235.kt");
        }

        @Test
        @TestMetadata(value="kt19037.kt")
        public void testKt19037() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt19037.kt");
        }

        @Test
        @TestMetadata(value="kt42457_old.kt")
        public void testKt42457_old() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/kt42457_old.kt");
        }

        @Test
        @TestMetadata(value="multipleNestedConcat.kt")
        public void testMultipleNestedConcat() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/multipleNestedConcat.kt");
        }

        @Test
        @TestMetadata(value="nestedConcat.kt")
        public void testNestedConcat() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/nestedConcat.kt");
        }

        @Test
        @TestMetadata(value="nonNullableStringPlus.kt")
        public void testNonNullableStringPlus() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/nonNullableStringPlus.kt");
        }

        @Test
        @TestMetadata(value="nullableStringPlus.kt")
        public void testNullableStringPlus() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/nullableStringPlus.kt");
        }

        @Test
        @TestMetadata(value="partiallyConstConcat.kt")
        public void testPartiallyConstConcat() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/partiallyConstConcat.kt");
        }

        @Test
        @TestMetadata(value="plusAssign.kt")
        public void testPlusAssign() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/plusAssign.kt");
        }

        @Test
        @TestMetadata(value="primitiveToString.kt")
        public void testPrimitiveToString() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitiveToString.kt");
        }

        @Test
        @TestMetadata(value="primitiveToStringNotOptimizable.kt")
        public void testPrimitiveToStringNotOptimizable() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitiveToStringNotOptimizable.kt");
        }

        @Test
        @TestMetadata(value="primitivesAsStringTemplates.kt")
        public void testPrimitivesAsStringTemplates() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/primitivesAsStringTemplates.kt");
        }

        @Test
        @TestMetadata(value="singleConcat.kt")
        public void testSingleConcat() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/singleConcat.kt");
        }

        @Test
        @TestMetadata(value="stringBuilderToString.kt")
        public void testStringBuilderToString() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/stringBuilderToString.kt");
        }

        @Test
        @TestMetadata(value="stringPlus.kt")
        public void testStringPlus() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/stringPlus.kt");
        }

        @Test
        @TestMetadata(value="useAppendCharForOneCharStringInTemplate.kt")
        public void testUseAppendCharForOneCharStringInTemplate() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/useAppendCharForOneCharStringInTemplate.kt");
        }

        @Test
        @TestMetadata(value="useAppendCharForOneCharStringInTemplate_2.kt")
        public void testUseAppendCharForOneCharStringInTemplate_2() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/useAppendCharForOneCharStringInTemplate_2.kt");
        }

        @Test
        @TestMetadata(value="useAppendCharForOneCharStringUsingPlus.kt")
        public void testUseAppendCharForOneCharStringUsingPlus() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/stringOperations/useAppendCharForOneCharStringUsingPlus.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/storeStackBeforeInline")
    @TestDataPath(value="$PROJECT_ROOT")
    public class StoreStackBeforeInline {
        @Test
        public void testAllFilesPresentInStoreStackBeforeInline() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/storeStackBeforeInline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="arrayConstructor.kt")
        public void testArrayConstructor() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/arrayConstructor.kt");
        }

        @Test
        @TestMetadata(value="differentTypes.kt")
        public void testDifferentTypes() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/differentTypes.kt");
        }

        @Test
        @TestMetadata(value="primitiveMerge.kt")
        public void testPrimitiveMerge() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/primitiveMerge.kt");
        }

        @Test
        @TestMetadata(value="simple.kt")
        public void testSimple() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/simple.kt");
        }

        @Test
        @TestMetadata(value="unreachableMarker.kt")
        public void testUnreachableMarker() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/unreachableMarker.kt");
        }

        @Test
        @TestMetadata(value="withLambda.kt")
        public void testWithLambda() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/storeStackBeforeInline/withLambda.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/staticFields")
    @TestDataPath(value="$PROJECT_ROOT")
    public class StaticFields {
        @Test
        public void testAllFilesPresentInStaticFields() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/staticFields"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="classObject.kt")
        public void testClassObject() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/staticFields/classObject.kt");
        }

        @Test
        @TestMetadata(value="object.kt")
        public void testObject() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/staticFields/object.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/statements")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Statements {
        @Test
        public void testAllFilesPresentInStatements() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/statements"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="ifSingleBranch.kt")
        public void testIfSingleBranch() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/ifSingleBranch.kt");
        }

        @Test
        @TestMetadata(value="ifThenElse.kt")
        public void testIfThenElse() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/ifThenElse.kt");
        }

        @Test
        @TestMetadata(value="ifThenElseEmpty.kt")
        public void testIfThenElseEmpty() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/ifThenElseEmpty.kt");
        }

        @Test
        @TestMetadata(value="labeled.kt")
        public void testLabeled() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/labeled.kt");
        }

        @Test
        @TestMetadata(value="statementsComposition.kt")
        public void testStatementsComposition() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/statementsComposition.kt");
        }

        @Test
        @TestMetadata(value="tryCatchFinally.kt")
        public void testTryCatchFinally() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/tryCatchFinally.kt");
        }

        @Test
        @TestMetadata(value="when.kt")
        public void testWhen() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/when.kt");
        }

        @Test
        @TestMetadata(value="whenSubject.kt")
        public void testWhenSubject() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/statements/whenSubject.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/sam")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Sam {
        @Test
        public void testAllFilesPresentInSam() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/sam"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="samWrapperForNullInitialization.kt")
        public void testSamWrapperForNullInitialization() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperForNullInitialization.kt");
        }

        @Test
        @TestMetadata(value="samWrapperForNullableInitialization.kt")
        public void testSamWrapperForNullableInitialization() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperForNullableInitialization.kt");
        }

        @Test
        @TestMetadata(value="samWrapperInInlineLambda.kt")
        public void testSamWrapperInInlineLambda() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperInInlineLambda.kt");
        }

        @Test
        @TestMetadata(value="samWrapperInInlineLambda2.kt")
        public void testSamWrapperInInlineLambda2() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperInInlineLambda2.kt");
        }

        @Test
        @TestMetadata(value="samWrapperOfLambda.kt")
        public void testSamWrapperOfLambda() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperOfLambda.kt");
        }

        @Test
        @TestMetadata(value="samWrapperOfReference.kt")
        public void testSamWrapperOfReference() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperOfReference.kt");
        }

        @Test
        @TestMetadata(value="samWrapperRawTypes.kt")
        public void testSamWrapperRawTypes() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/sam/samWrapperRawTypes.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/ranges")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Ranges {
        @Test
        public void testAllFilesPresentInRanges() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/ranges"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="ifNotInRange.kt")
        public void testIfNotInRange() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/ifNotInRange.kt");
        }

        @Test
        @TestMetadata(value="inArrayIndices.kt")
        public void testInArrayIndices() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inArrayIndices.kt");
        }

        @Test
        @TestMetadata(value="inCharSequenceIndices.kt")
        public void testInCharSequenceIndices() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inCharSequenceIndices.kt");
        }

        @Test
        @TestMetadata(value="inCollectionIndices.kt")
        public void testInCollectionIndices() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inCollectionIndices.kt");
        }

        @Test
        @TestMetadata(value="inComparableRangeLiteral.kt")
        public void testInComparableRangeLiteral() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inComparableRangeLiteral.kt");
        }

        @Test
        @TestMetadata(value="inMixedUnsignedRange.kt")
        public void testInMixedUnsignedRange() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inMixedUnsignedRange.kt");
        }

        @Test
        @TestMetadata(value="inMixedUnsignedRange_2.kt")
        public void testInMixedUnsignedRange_2() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inMixedUnsignedRange_2.kt");
        }

        @Test
        @TestMetadata(value="inNonMatchingRangeIntrinsified.kt")
        public void testInNonMatchingRangeIntrinsified() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inNonMatchingRangeIntrinsified.kt");
        }

        @Test
        @TestMetadata(value="inOptimizableRange.kt")
        public void testInOptimizableRange() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inOptimizableRange.kt");
        }

        @Test
        @TestMetadata(value="inOptimizableUnsignedRange.kt")
        public void testInOptimizableUnsignedRange() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inOptimizableUnsignedRange.kt");
        }

        @Test
        @TestMetadata(value="inRangeUntil.kt")
        public void testInRangeUntil() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inRangeUntil.kt");
        }

        @Test
        @TestMetadata(value="inUntil.kt")
        public void testInUntil() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/inUntil.kt");
        }

        @Test
        @TestMetadata(value="noDupXForLiteralRangeContains.kt")
        public void testNoDupXForLiteralRangeContains() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ranges/noDupXForLiteralRangeContains.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/properties")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Properties {
        @Test
        public void testAllFilesPresentInProperties() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/properties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="dataClass.kt")
        public void testDataClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/properties/dataClass.kt");
        }

        @Test
        @TestMetadata(value="openDataClass.kt")
        public void testOpenDataClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/properties/openDataClass.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/properties/lateinit")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Lateinit {
            @Test
            public void testAllFilesPresentInLateinit() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/properties/lateinit"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="companionObject.kt")
            public void testCompanionObject() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/properties/lateinit/companionObject.kt");
            }

            @Test
            @TestMetadata(value="companionObjectFromLambda.kt")
            public void testCompanionObjectFromLambda() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/properties/lateinit/companionObjectFromLambda.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/parameterlessMain")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ParameterlessMain {
        @Test
        public void testAllFilesPresentInParameterlessMain() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/parameterlessMain"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="dontGenerateOnExtensionReceiver.kt")
        public void testDontGenerateOnExtensionReceiver() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnExtensionReceiver.kt");
        }

        @Test
        @TestMetadata(value="dontGenerateOnJvmNameMain.kt")
        public void testDontGenerateOnJvmNameMain() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnJvmNameMain.kt");
        }

        @Test
        @TestMetadata(value="dontGenerateOnJvmOverloads.kt")
        public void testDontGenerateOnJvmOverloads() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnJvmOverloads.kt");
        }

        @Test
        @TestMetadata(value="dontGenerateOnMain.kt")
        public void testDontGenerateOnMain() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnMain.kt");
        }

        @Test
        @TestMetadata(value="dontGenerateOnMainExtension.kt")
        public void testDontGenerateOnMainExtension() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnMainExtension.kt");
        }

        @Test
        @TestMetadata(value="dontGenerateOnNullableArray.kt")
        public void testDontGenerateOnNullableArray() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnNullableArray.kt");
        }

        @Test
        @TestMetadata(value="dontGenerateOnNullableString.kt")
        public void testDontGenerateOnNullableString() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnNullableString.kt");
        }

        @Test
        @TestMetadata(value="dontGenerateOnVarargsString.kt")
        public void testDontGenerateOnVarargsString() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/parameterlessMain/dontGenerateOnVarargsString.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/outerClass")
    @TestDataPath(value="$PROJECT_ROOT")
    public class OuterClass {
        @Test
        public void testAllFilesPresentInOuterClass() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/outerClass"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="classInClinit.kt")
        public void testClassInClinit() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/outerClass/classInClinit.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties")
    @TestDataPath(value="$PROJECT_ROOT")
    public class OptimizedDelegatedProperties {
        @Test
        public void testAllFilesPresentInOptimizedDelegatedProperties() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="definedInSources.kt")
        public void testDefinedInSources() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/definedInSources.kt");
        }

        @Test
        @TestMetadata(value="delegateToAnother.kt")
        public void testDelegateToAnother() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/delegateToAnother.kt");
        }

        @Test
        @TestMetadata(value="inSeparateModule.kt")
        public void testInSeparateModule() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/inSeparateModule.kt");
        }

        @Test
        @TestMetadata(value="lazy.kt")
        public void testLazy() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/lazy.kt");
        }

        @Test
        @TestMetadata(value="withNonNullMetadataParameter.kt")
        public void testWithNonNullMetadataParameter() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/optimizedDelegatedProperties/withNonNullMetadataParameter.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/nullCheckOptimization")
    @TestDataPath(value="$PROJECT_ROOT")
    public class NullCheckOptimization {
        @Test
        public void testAllFilesPresentInNullCheckOptimization() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/nullCheckOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="alreadyCheckedForIs.kt")
        public void testAlreadyCheckedForIs() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/alreadyCheckedForIs.kt");
        }

        @Test
        @TestMetadata(value="alreadyCheckedForNull.kt")
        public void testAlreadyCheckedForNull() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/alreadyCheckedForNull.kt");
        }

        @Test
        @TestMetadata(value="deterministicNotNullChecks.kt")
        public void testDeterministicNotNullChecks() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/deterministicNotNullChecks.kt");
        }

        @Test
        @TestMetadata(value="exclExclAsNotNullType.kt")
        public void testExclExclAsNotNullType() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/exclExclAsNotNullType.kt");
        }

        @Test
        @TestMetadata(value="expressionValueIsNotNull.kt")
        public void testExpressionValueIsNotNull() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNull.kt");
        }

        @Test
        @TestMetadata(value="expressionValueIsNotNullAfterExclExcl.kt")
        public void testExpressionValueIsNotNullAfterExclExcl() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNullAfterExclExcl.kt");
        }

        @Test
        @TestMetadata(value="expressionValueIsNotNullTwice.kt")
        public void testExpressionValueIsNotNullTwice() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/expressionValueIsNotNullTwice.kt");
        }

        @Test
        @TestMetadata(value="ifNullEqualsNull.kt")
        public void testIfNullEqualsNull() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifNullEqualsNull.kt");
        }

        @Test
        @TestMetadata(value="ifNullEqualsNullInline.kt")
        public void testIfNullEqualsNullInline() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifNullEqualsNullInline.kt");
        }

        @Test
        @TestMetadata(value="ifUnitEqualsNull.kt")
        public void testIfUnitEqualsNull() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifUnitEqualsNull.kt");
        }

        @Test
        @TestMetadata(value="ifUnitEqualsNullInline.kt")
        public void testIfUnitEqualsNullInline() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/ifUnitEqualsNullInline.kt");
        }

        @Test
        @TestMetadata(value="kt12839.kt")
        public void testKt12839() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/kt12839.kt");
        }

        @Test
        @TestMetadata(value="multipleExclExcl_1_4.kt")
        public void testMultipleExclExcl_1_4() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/multipleExclExcl_1_4.kt");
        }

        @Test
        @TestMetadata(value="noNullCheckAfterCast.kt")
        public void testNoNullCheckAfterCast() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/noNullCheckAfterCast.kt");
        }

        @Test
        @TestMetadata(value="notNullAsNotNullable.kt")
        public void testNotNullAsNotNullable() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/notNullAsNotNullable.kt");
        }

        @Test
        @TestMetadata(value="notNullExpressionValueTwice_1_4.kt")
        public void testNotNullExpressionValueTwice_1_4() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/notNullExpressionValueTwice_1_4.kt");
        }

        @Test
        @TestMetadata(value="nullCheckAfterExclExcl_1_4.kt")
        public void testNullCheckAfterExclExcl_1_4() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/nullCheckAfterExclExcl_1_4.kt");
        }

        @Test
        @TestMetadata(value="nullabilityAssertionOnDispatchReceiver.kt")
        public void testNullabilityAssertionOnDispatchReceiver() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/nullabilityAssertionOnDispatchReceiver.kt");
        }

        @Test
        @TestMetadata(value="primitiveCheck.kt")
        public void testPrimitiveCheck() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/primitiveCheck.kt");
        }

        @Test
        @TestMetadata(value="redundantSafeCall.kt")
        public void testRedundantSafeCall() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/redundantSafeCall.kt");
        }

        @Test
        @TestMetadata(value="redundantSafeCall_1_4.kt")
        public void testRedundantSafeCall_1_4() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/redundantSafeCall_1_4.kt");
        }

        @Test
        @TestMetadata(value="reifiedIs.kt")
        public void testReifiedIs() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/reifiedIs.kt");
        }

        @Test
        @TestMetadata(value="reifiedNullIs.kt")
        public void testReifiedNullIs() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/reifiedNullIs.kt");
        }

        @Test
        @TestMetadata(value="safeCallAndElvisChains.kt")
        public void testSafeCallAndElvisChains() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/safeCallAndElvisChains.kt");
        }

        @Test
        @TestMetadata(value="trivialInstanceOf.kt")
        public void testTrivialInstanceOf() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/trivialInstanceOf.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LocalLateinit {
            @Test
            public void testAllFilesPresentInLocalLateinit() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="checkedAlways.kt")
            public void testCheckedAlways() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/checkedAlways.kt");
            }

            @Test
            @TestMetadata(value="checkedOnce.kt")
            public void testCheckedOnce() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/checkedOnce.kt");
            }

            @Test
            @TestMetadata(value="initialized.kt")
            public void testInitialized() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/nullCheckOptimization/localLateinit/initialized.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/notNullAssertions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class NotNullAssertions {
        @Test
        public void testAllFilesPresentInNotNullAssertions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/notNullAssertions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="arrayListGet.kt")
        public void testArrayListGet() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/arrayListGet.kt");
        }

        @Test
        @TestMetadata(value="assertionForNotNullCaptured.kt")
        public void testAssertionForNotNullCaptured() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/assertionForNotNullCaptured.kt");
        }

        @Test
        @TestMetadata(value="assertionForNotNullTypeParam.kt")
        public void testAssertionForNotNullTypeParam() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/assertionForNotNullTypeParam.kt");
        }

        @Test
        @TestMetadata(value="assertionForNotNullTypeParam_1_4.kt")
        public void testAssertionForNotNullTypeParam_1_4() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/assertionForNotNullTypeParam_1_4.kt");
        }

        @Test
        @TestMetadata(value="doNotGenerateParamAssertions.kt")
        public void testDoNotGenerateParamAssertions() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/doNotGenerateParamAssertions.kt");
        }

        @Test
        @TestMetadata(value="javaMultipleSubstitutions.kt")
        public void testJavaMultipleSubstitutions() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/javaMultipleSubstitutions.kt");
        }

        @Test
        @TestMetadata(value="noAssertionForNullableCaptured.kt")
        public void testNoAssertionForNullableCaptured() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForNullableCaptured.kt");
        }

        @Test
        @TestMetadata(value="noAssertionForNullableGenericMethod.kt")
        public void testNoAssertionForNullableGenericMethod() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForNullableGenericMethod.kt");
        }

        @Test
        @TestMetadata(value="noAssertionForNullableGenericMethodCall.kt")
        public void testNoAssertionForNullableGenericMethodCall() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForNullableGenericMethodCall.kt");
        }

        @Test
        @TestMetadata(value="noAssertionForPrivateMethod.kt")
        public void testNoAssertionForPrivateMethod() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionForPrivateMethod.kt");
        }

        @Test
        @TestMetadata(value="noAssertionsForKotlin.kt")
        public void testNoAssertionsForKotlin() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noAssertionsForKotlin.kt");
        }

        @Test
        @TestMetadata(value="noTemporaryVariableInNullCheckOnExpression.kt")
        public void testNoTemporaryVariableInNullCheckOnExpression() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/notNullAssertions/noTemporaryVariableInNullCheckOnExpression.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/multifileClasses")
    @TestDataPath(value="$PROJECT_ROOT")
    public class MultifileClasses {
        @Test
        public void testAllFilesPresentInMultifileClasses() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/multifileClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="defaultFunctionInMultifileClass.kt")
        public void testDefaultFunctionInMultifileClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/multifileClasses/defaultFunctionInMultifileClass.kt");
        }

        @Test
        @TestMetadata(value="optimizedMultifileClassFacadeMethods.kt")
        public void testOptimizedMultifileClassFacadeMethods() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/multifileClasses/optimizedMultifileClassFacadeMethods.kt");
        }

        @Test
        @TestMetadata(value="privateFunctionName.kt")
        public void testPrivateFunctionName() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/multifileClasses/privateFunctionName.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/mangling")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Mangling {
        @Test
        public void testAllFilesPresentInMangling() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/mangling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="parentheses.kt")
        public void testParentheses() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/mangling/parentheses.kt");
        }

        @Test
        @TestMetadata(value="parenthesesNoSanitize.kt")
        public void testParenthesesNoSanitize() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/mangling/parenthesesNoSanitize.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/localInitializationLVT")
    @TestDataPath(value="$PROJECT_ROOT")
    public class LocalInitializationLVT {
        @Test
        public void testAllFilesPresentInLocalInitializationLVT() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/localInitializationLVT"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="boxing.kt")
        public void testBoxing() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/boxing.kt");
        }

        @Test
        @TestMetadata(value="boxingVar.kt")
        public void testBoxingVar() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/boxingVar.kt");
        }

        @Test
        @TestMetadata(value="contract.kt")
        public void testContract() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/contract.kt");
        }

        @Test
        @TestMetadata(value="contractVar.kt")
        public void testContractVar() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/contractVar.kt");
        }

        @Test
        @TestMetadata(value="generics.kt")
        public void testGenerics() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/generics.kt");
        }

        @Test
        @TestMetadata(value="genericsVar.kt")
        public void testGenericsVar() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/genericsVar.kt");
        }

        @Test
        @TestMetadata(value="ifStatement.kt")
        public void testIfStatement() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatement.kt");
        }

        @Test
        @TestMetadata(value="ifStatementVar.kt")
        public void testIfStatementVar() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementVar.kt");
        }

        @Test
        @TestMetadata(value="ifStatementWithoutBlock.kt")
        public void testIfStatementWithoutBlock() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementWithoutBlock.kt");
        }

        @Test
        @TestMetadata(value="ifStatementWithoutBlockVar.kt")
        public void testIfStatementWithoutBlockVar() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/ifStatementWithoutBlockVar.kt");
        }

        @Test
        @TestMetadata(value="inlineClass.kt")
        public void testInlineClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/inlineClass.kt");
        }

        @Test
        @TestMetadata(value="inlineClassVar.kt")
        public void testInlineClassVar() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/inlineClassVar.kt");
        }

        @Test
        @TestMetadata(value="lateinit.kt")
        public void testLateinit() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/lateinit.kt");
        }

        @Test
        @TestMetadata(value="run.kt")
        public void testRun() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/run.kt");
        }

        @Test
        @TestMetadata(value="runVar.kt")
        public void testRunVar() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/runVar.kt");
        }

        @Test
        @TestMetadata(value="singleBlock.kt")
        public void testSingleBlock() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/singleBlock.kt");
        }

        @Test
        @TestMetadata(value="singleBlockVar.kt")
        public void testSingleBlockVar() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/singleBlockVar.kt");
        }

        @Test
        @TestMetadata(value="whenStatement.kt")
        public void testWhenStatement() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/whenStatement.kt");
        }

        @Test
        @TestMetadata(value="whenStatementVar.kt")
        public void testWhenStatementVar() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/localInitializationLVT/whenStatementVar.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/lineNumbers")
    @TestDataPath(value="$PROJECT_ROOT")
    public class LineNumbers {
        @Test
        public void testAllFilesPresentInLineNumbers() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/lineNumbers"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="delegationToList.kt")
        public void testDelegationToList() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/delegationToList.kt");
        }

        @Test
        @TestMetadata(value="ifConsts.kt")
        public void testIfConsts() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifConsts.kt");
        }

        @Test
        @TestMetadata(value="ifElse.kt")
        public void testIfElse() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifElse.kt");
        }

        @Test
        @TestMetadata(value="ifFalse.kt")
        public void testIfFalse() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifFalse.kt");
        }

        @Test
        @TestMetadata(value="ifFalseElse.kt")
        public void testIfFalseElse() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifFalseElse.kt");
        }

        @Test
        @TestMetadata(value="ifTrue.kt")
        public void testIfTrue() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifTrue.kt");
        }

        @Test
        @TestMetadata(value="ifTrueElse.kt")
        public void testIfTrueElse() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/ifTrueElse.kt");
        }

        @Test
        @TestMetadata(value="inlineCondition.kt")
        public void testInlineCondition() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/inlineCondition.kt");
        }

        @Test
        @TestMetadata(value="inlineCondition2.kt")
        public void testInlineCondition2() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/inlineCondition2.kt");
        }

        @Test
        @TestMetadata(value="inlineLambdaObjectInit.kt")
        public void testInlineLambdaObjectInit() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/inlineLambdaObjectInit.kt");
        }

        @Test
        @TestMetadata(value="kt61768.kt")
        public void testKt61768() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/kt61768.kt");
        }

        @Test
        @TestMetadata(value="singleThen.kt")
        public void testSingleThen() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/singleThen.kt");
        }

        @Test
        @TestMetadata(value="tryCatch.kt")
        public void testTryCatch() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/tryCatch.kt");
        }

        @Test
        @TestMetadata(value="tryFinally.kt")
        public void testTryFinally() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/tryFinally.kt");
        }

        @Test
        @TestMetadata(value="when.kt")
        public void testWhen() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lineNumbers/when.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/lazyCodegen")
    @TestDataPath(value="$PROJECT_ROOT")
    public class LazyCodegen {
        @Test
        public void testAllFilesPresentInLazyCodegen() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/lazyCodegen"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="inlineConstInsideComparison.kt")
        public void testInlineConstInsideComparison() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/inlineConstInsideComparison.kt");
        }

        @Test
        @TestMetadata(value="negateConst.kt")
        public void testNegateConst() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateConst.kt");
        }

        @Test
        @TestMetadata(value="negateObjectComp.kt")
        public void testNegateObjectComp() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateObjectComp.kt");
        }

        @Test
        @TestMetadata(value="negateObjectCompChaing.kt")
        public void testNegateObjectCompChaing() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateObjectCompChaing.kt");
        }

        @Test
        @TestMetadata(value="negateVar.kt")
        public void testNegateVar() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateVar.kt");
        }

        @Test
        @TestMetadata(value="negateVarChain.kt")
        public void testNegateVarChain() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/lazyCodegen/negateVarChain.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/jvm8")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Jvm8 {
        @Test
        public void testAllFilesPresentInJvm8() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/jvm8/jvmDefault")
        @TestDataPath(value="$PROJECT_ROOT")
        public class JvmDefault {
            @Test
            public void testAllFilesPresentInJvmDefault() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility")
            @TestDataPath(value="$PROJECT_ROOT")
            public class AllCompatibility {
                @Test
                public void testAllFilesPresentInAllCompatibility() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
                }

                @Test
                @TestMetadata(value="defaultArgs.kt")
                public void testDefaultArgs() {
                    IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/defaultArgs.kt");
                }

                @Test
                @TestMetadata(value="simpleDiamond.kt")
                public void testSimpleDiamond() {
                    IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleDiamond.kt");
                }

                @Test
                @TestMetadata(value="simpleFunction.kt")
                public void testSimpleFunction() {
                    IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleFunction.kt");
                }

                @Test
                @TestMetadata(value="simpleFunctionWithAbstractOverride.kt")
                public void testSimpleFunctionWithAbstractOverride() {
                    IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleFunctionWithAbstractOverride.kt");
                }

                @Test
                @TestMetadata(value="simpleProperty.kt")
                public void testSimpleProperty() {
                    IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/jvmDefault/allCompatibility/simpleProperty.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/jvm8/hashCode")
        @TestDataPath(value="$PROJECT_ROOT")
        public class HashCode {
            @Test
            public void testAllFilesPresentInHashCode() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/jvm8/hashCode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="dataClass.kt")
            public void testDataClass() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/hashCode/dataClass.kt");
            }

            @Test
            @TestMetadata(value="hashCode.kt")
            public void testHashCode() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/jvm8/hashCode/hashCode.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/invokedynamic")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Invokedynamic {
        @Test
        public void testAllFilesPresentInInvokedynamic() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/invokedynamic"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="extensionReceiversNames.kt")
        public void testExtensionReceiversNames() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/invokedynamic/extensionReceiversNames.kt");
        }

        @Test
        @TestMetadata(value="functionRefToJavaInterface.kt")
        public void testFunctionRefToJavaInterface() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/invokedynamic/functionRefToJavaInterface.kt");
        }

        @Test
        @TestMetadata(value="lambdas.kt")
        public void testLambdas() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/invokedynamic/lambdas.kt");
        }

        @Test
        @TestMetadata(value="streamApi.kt")
        public void testStreamApi() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/invokedynamic/streamApi.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/intrinsicsTrim")
    @TestDataPath(value="$PROJECT_ROOT")
    public class IntrinsicsTrim {
        @Test
        public void testAllFilesPresentInIntrinsicsTrim() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsicsTrim"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="trimIndentNegative.kt")
        public void testTrimIndentNegative() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimIndentNegative.kt");
        }

        @Test
        @TestMetadata(value="trimIndentPositive.kt")
        public void testTrimIndentPositive() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimIndentPositive.kt");
        }

        @Test
        @TestMetadata(value="trimMarginNegative.kt")
        public void testTrimMarginNegative() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimMarginNegative.kt");
        }

        @Test
        @TestMetadata(value="trimMarginPositive.kt")
        public void testTrimMarginPositive() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsTrim/trimMarginPositive.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/intrinsicsCompare")
    @TestDataPath(value="$PROJECT_ROOT")
    public class IntrinsicsCompare {
        @Test
        public void testAllFilesPresentInIntrinsicsCompare() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsicsCompare"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="byteSmartCast_after.kt")
        public void testByteSmartCast_after() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/byteSmartCast_after.kt");
        }

        @Test
        @TestMetadata(value="charSmartCast.kt")
        public void testCharSmartCast() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/charSmartCast.kt");
        }

        @Test
        @TestMetadata(value="differentTypes_after.kt")
        public void testDifferentTypes_after() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/differentTypes_after.kt");
        }

        @Test
        @TestMetadata(value="intSmartCast_after.kt")
        public void testIntSmartCast_after() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/intSmartCast_after.kt");
        }

        @Test
        @TestMetadata(value="longSmartCast.kt")
        public void testLongSmartCast() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/longSmartCast.kt");
        }

        @Test
        @TestMetadata(value="shortSmartCast_after.kt")
        public void testShortSmartCast_after() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsicsCompare/shortSmartCast_after.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/intrinsics")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Intrinsics {
        @Test
        public void testAllFilesPresentInIntrinsics() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/intrinsics"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="javaObjectType.kt")
        public void testJavaObjectType() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsics/javaObjectType.kt");
        }

        @Test
        @TestMetadata(value="javaPrimitiveType.kt")
        public void testJavaPrimitiveType() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsics/javaPrimitiveType.kt");
        }

        @Test
        @TestMetadata(value="postfixIncrDecr.kt")
        public void testPostfixIncrDecr() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/intrinsics/postfixIncrDecr.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/interfaces")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Interfaces {
        @Test
        @TestMetadata(value="addedInterfaceBridge.kt")
        public void testAddedInterfaceBridge() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/addedInterfaceBridge.kt");
        }

        @Test
        public void testAllFilesPresentInInterfaces() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/interfaces"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="firstInheritedMethodIsAbstract.kt")
        public void testFirstInheritedMethodIsAbstract() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/firstInheritedMethodIsAbstract.kt");
        }

        @Test
        @TestMetadata(value="firstInheritedMethodIsAbstractJvmDefaultDisable.kt")
        public void testFirstInheritedMethodIsAbstractJvmDefaultDisable() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/firstInheritedMethodIsAbstractJvmDefaultDisable.kt");
        }

        @Test
        @TestMetadata(value="noAnyMethodsOnInterfaceInheritance.kt")
        public void testNoAnyMethodsOnInterfaceInheritance() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/noAnyMethodsOnInterfaceInheritance.kt");
        }

        @Test
        @TestMetadata(value="noNullCheckOnThisInDefaultMethod.kt")
        public void testNoNullCheckOnThisInDefaultMethod() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/noNullCheckOnThisInDefaultMethod.kt");
        }

        @Test
        @TestMetadata(value="noNullCheckOnThisInDefaultMethodJvmDefaultDisable.kt")
        public void testNoNullCheckOnThisInDefaultMethodJvmDefaultDisable() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/noNullCheckOnThisInDefaultMethodJvmDefaultDisable.kt");
        }

        @Test
        @TestMetadata(value="noPrivateMemberInJavaInterface.kt")
        public void testNoPrivateMemberInJavaInterface() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/noPrivateMemberInJavaInterface.kt");
        }

        @Test
        @TestMetadata(value="traitImplGeneratedOnce.kt")
        public void testTraitImplGeneratedOnce() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/interfaces/traitImplGeneratedOnce.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/innerClasses")
    @TestDataPath(value="$PROJECT_ROOT")
    public class InnerClasses {
        @Test
        public void testAllFilesPresentInInnerClasses() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/innerClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="kt27936.kt")
        public void testKt27936() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/innerClasses/kt27936.kt");
        }

        @Test
        @TestMetadata(value="kt56104.kt")
        public void testKt56104() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/innerClasses/kt56104.kt");
        }

        @Test
        @TestMetadata(value="kt57714.kt")
        public void testKt57714() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/innerClasses/kt57714.kt");
        }

        @Test
        @TestMetadata(value="nestedClassInAnnotationArgument.kt")
        public void testNestedClassInAnnotationArgument() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/innerClasses/nestedClassInAnnotationArgument.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/inlineClasses")
    @TestDataPath(value="$PROJECT_ROOT")
    public class InlineClasses {
        @Test
        public void testAllFilesPresentInInlineClasses() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="asCastForInlineClass.kt")
        public void testAsCastForInlineClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/asCastForInlineClass.kt");
        }

        @Test
        @TestMetadata(value="assertionsForParametersOfInlineClassTypes.kt")
        public void testAssertionsForParametersOfInlineClassTypes() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/assertionsForParametersOfInlineClassTypes.kt");
        }

        @Test
        @TestMetadata(value="boxInlineClassInsideElvisWithNullConstant.kt")
        public void testBoxInlineClassInsideElvisWithNullConstant() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxInlineClassInsideElvisWithNullConstant.kt");
        }

        @Test
        @TestMetadata(value="boxInlineClassesOnPassingToVarargs.kt")
        public void testBoxInlineClassesOnPassingToVarargs() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxInlineClassesOnPassingToVarargs.kt");
        }

        @Test
        @TestMetadata(value="boxMethodCalledByInlineClass.kt")
        public void testBoxMethodCalledByInlineClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxMethodCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata(value="boxResultAfterConstructorCall.kt")
        public void testBoxResultAfterConstructorCall() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxResultAfterConstructorCall.kt");
        }

        @Test
        @TestMetadata(value="boxResultInlineClassOfConstructorCall.kt")
        public void testBoxResultInlineClassOfConstructorCall() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxResultInlineClassOfConstructorCall.kt");
        }

        @Test
        @TestMetadata(value="boxThisOfInlineClass.kt")
        public void testBoxThisOfInlineClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxThisOfInlineClass.kt");
        }

        @Test
        @TestMetadata(value="boxUnboxInlineClassFromMethodReturnType.kt")
        public void testBoxUnboxInlineClassFromMethodReturnType() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxInlineClassFromMethodReturnType.kt");
        }

        @Test
        @TestMetadata(value="boxUnboxInsideLambdaAsLastExpression.kt")
        public void testBoxUnboxInsideLambdaAsLastExpression() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxInsideLambdaAsLastExpression.kt");
        }

        @Test
        @TestMetadata(value="boxUnboxOfInlineClassesWithFunctionalTypes.kt")
        public void testBoxUnboxOfInlineClassesWithFunctionalTypes() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxOfInlineClassesWithFunctionalTypes.kt");
        }

        @Test
        @TestMetadata(value="boxUnboxOnInlinedParameters.kt")
        public void testBoxUnboxOnInlinedParameters() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxUnboxOnInlinedParameters.kt");
        }

        @Test
        @TestMetadata(value="boxingForNonLocalAndLabeledReturnsOfInlineClasses.kt")
        public void testBoxingForNonLocalAndLabeledReturnsOfInlineClasses() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/boxingForNonLocalAndLabeledReturnsOfInlineClasses.kt");
        }

        @Test
        @TestMetadata(value="callMemberMethodsInsideInlineClass.kt")
        public void testCallMemberMethodsInsideInlineClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/callMemberMethodsInsideInlineClass.kt");
        }

        @Test
        @TestMetadata(value="checkBoxingInInlineClass.kt")
        public void testCheckBoxingInInlineClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/checkBoxingInInlineClass.kt");
        }

        @Test
        @TestMetadata(value="checkOuterInlineFunctionCall.kt")
        public void testCheckOuterInlineFunctionCall() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/checkOuterInlineFunctionCall.kt");
        }

        @Test
        @TestMetadata(value="constructorBridge.kt")
        public void testConstructorBridge() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/constructorBridge.kt");
        }

        @Test
        @TestMetadata(value="constructorWithDefaultArguments.kt")
        public void testConstructorWithDefaultArguments() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/constructorWithDefaultArguments.kt");
        }

        @Test
        @TestMetadata(value="defaultParametersDontBox.kt")
        public void testDefaultParametersDontBox() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/defaultParametersDontBox.kt");
        }

        @Test
        @TestMetadata(value="delegatedPropertyMangling.kt")
        public void testDelegatedPropertyMangling() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/delegatedPropertyMangling.kt");
        }

        @Test
        @TestMetadata(value="equalsDoesNotBox.kt")
        public void testEqualsDoesNotBox() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/equalsDoesNotBox.kt");
        }

        @Test
        @TestMetadata(value="equalsIsCalledByInlineClass.kt")
        public void testEqualsIsCalledByInlineClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/equalsIsCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata(value="factoryMethodForSecondaryConstructorsCalledByInlineClass.kt")
        public void testFactoryMethodForSecondaryConstructorsCalledByInlineClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/factoryMethodForSecondaryConstructorsCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata(value="functionsWithInlineClassParametersHaveStableMangledNames.kt")
        public void testFunctionsWithInlineClassParametersHaveStableMangledNames() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/functionsWithInlineClassParametersHaveStableMangledNames.kt");
        }

        @Test
        @TestMetadata(value="generationOfAccessorToUnderlyingValue.kt")
        public void testGenerationOfAccessorToUnderlyingValue() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/generationOfAccessorToUnderlyingValue.kt");
        }

        @Test
        @TestMetadata(value="genericNoUnbox.kt")
        public void testGenericNoUnbox() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/genericNoUnbox.kt");
        }

        @Test
        @TestMetadata(value="hashCodeIsCalledByInlineClass.kt")
        public void testHashCodeIsCalledByInlineClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/hashCodeIsCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata(value="inlineClassBoxingOnAssignment.kt")
        public void testInlineClassBoxingOnAssignment() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingOnAssignment.kt");
        }

        @Test
        @TestMetadata(value="inlineClassBoxingOnFunctionCall.kt")
        public void testInlineClassBoxingOnFunctionCall() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingOnFunctionCall.kt");
        }

        @Test
        @TestMetadata(value="inlineClassBoxingUnboxingInsideInlinedLambda.kt")
        public void testInlineClassBoxingUnboxingInsideInlinedLambda() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassBoxingUnboxingInsideInlinedLambda.kt");
        }

        @Test
        @TestMetadata(value="inlineClassInGeneratedToString.kt")
        public void testInlineClassInGeneratedToString() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassInGeneratedToString.kt");
        }

        @Test
        @TestMetadata(value="inlineClassInStringTemplate.kt")
        public void testInlineClassInStringTemplate() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassInStringTemplate.kt");
        }

        @Test
        @TestMetadata(value="inlineClassesUnboxingAfterAssertionOperator.kt")
        public void testInlineClassesUnboxingAfterAssertionOperator() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/inlineClassesUnboxingAfterAssertionOperator.kt");
        }

        @Test
        @TestMetadata(value="interfaceDefaultImplStubs.kt")
        public void testInterfaceDefaultImplStubs() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/interfaceDefaultImplStubs.kt");
        }

        @Test
        @TestMetadata(value="isCheckForInlineClass.kt")
        public void testIsCheckForInlineClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/isCheckForInlineClass.kt");
        }

        @Test
        @TestMetadata(value="kt33722.kt")
        public void testKt33722() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/kt33722.kt");
        }

        @Test
        @TestMetadata(value="mangledInlineClassInterfaceImplementation.kt")
        public void testMangledInlineClassInterfaceImplementation() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledInlineClassInterfaceImplementation.kt");
        }

        @Test
        @TestMetadata(value="mangledSamWrappers.kt")
        public void testMangledSamWrappers() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledSamWrappers.kt");
        }

        @Test
        @TestMetadata(value="mangledSamWrappersIndy.kt")
        public void testMangledSamWrappersIndy() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledSamWrappersIndy.kt");
        }

        @Test
        @TestMetadata(value="mangledSamWrappersOld.kt")
        public void testMangledSamWrappersOld() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/mangledSamWrappersOld.kt");
        }

        @Test
        @TestMetadata(value="noActualCallsOfInlineFunctionsOfInlineClass.kt")
        public void testNoActualCallsOfInlineFunctionsOfInlineClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noActualCallsOfInlineFunctionsOfInlineClass.kt");
        }

        @Test
        @TestMetadata(value="noAssertionsForInlineClassesBasedOnNullableTypes.kt")
        public void testNoAssertionsForInlineClassesBasedOnNullableTypes() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noAssertionsForInlineClassesBasedOnNullableTypes.kt");
        }

        @Test
        @TestMetadata(value="noBoxingInMethod.kt")
        public void testNoBoxingInMethod() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingInMethod.kt");
        }

        @Test
        @TestMetadata(value="noBoxingOnCastOperations.kt")
        public void testNoBoxingOnCastOperations() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingOnCastOperations.kt");
        }

        @Test
        @TestMetadata(value="noBoxingOperationsOnNonTrivialSpread.kt")
        public void testNoBoxingOperationsOnNonTrivialSpread() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingOperationsOnNonTrivialSpread.kt");
        }

        @Test
        @TestMetadata(value="noBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate.kt")
        public void testNoBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noBoxingUnboxingInAccessorsForDelegatedPropertyWithInlineClassDelegate.kt");
        }

        @Test
        @TestMetadata(value="noManglingForFunctionsWithJvmName.kt")
        public void testNoManglingForFunctionsWithJvmName() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/noManglingForFunctionsWithJvmName.kt");
        }

        @Test
        @TestMetadata(value="nonOverridingMethodsAreCalledByInlineClass.kt")
        public void testNonOverridingMethodsAreCalledByInlineClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/nonOverridingMethodsAreCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata(value="overridingMethodsAreCalledByInlineClass.kt")
        public void testOverridingMethodsAreCalledByInlineClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/overridingMethodsAreCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata(value="passInlineClassesWithSpreadOperatorToVarargs.kt")
        public void testPassInlineClassesWithSpreadOperatorToVarargs() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/passInlineClassesWithSpreadOperatorToVarargs.kt");
        }

        @Test
        @TestMetadata(value="primaryConstructorCalledByInlineClass.kt")
        public void testPrimaryConstructorCalledByInlineClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/primaryConstructorCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata(value="propertyAccessorsAreCalledByInlineClass.kt")
        public void testPropertyAccessorsAreCalledByInlineClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/propertyAccessorsAreCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata(value="propertySetterWithInlineClassTypeArgument.kt")
        public void testPropertySetterWithInlineClassTypeArgument() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/propertySetterWithInlineClassTypeArgument.kt");
        }

        @Test
        @TestMetadata(value="resultApiDoesntCallSpecializedEquals.kt")
        public void testResultApiDoesntCallSpecializedEquals() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiDoesntCallSpecializedEquals.kt");
        }

        @Test
        @TestMetadata(value="resultApiDoesntUseBox.kt")
        public void testResultApiDoesntUseBox() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiDoesntUseBox.kt");
        }

        @Test
        @TestMetadata(value="resultApiEqualsDoesntBox.kt")
        public void testResultApiEqualsDoesntBox() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiEqualsDoesntBox.kt");
        }

        @Test
        @TestMetadata(value="resultApiRunCatchingDoesntBox.kt")
        public void testResultApiRunCatchingDoesntBox() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiRunCatchingDoesntBox.kt");
        }

        @Test
        @TestMetadata(value="resultApiStringInterpolationDoesntBox.kt")
        public void testResultApiStringInterpolationDoesntBox() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultApiStringInterpolationDoesntBox.kt");
        }

        @Test
        @TestMetadata(value="resultMangling.kt")
        public void testResultMangling() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/resultMangling.kt");
        }

        @Test
        @TestMetadata(value="skipCallToUnderlyingValueOfInlineClass.kt")
        public void testSkipCallToUnderlyingValueOfInlineClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/skipCallToUnderlyingValueOfInlineClass.kt");
        }

        @Test
        @TestMetadata(value="suspendFunctionMangling.kt")
        public void testSuspendFunctionMangling() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/suspendFunctionMangling.kt");
        }

        @Test
        @TestMetadata(value="toStringOfInlineClassValue.kt")
        public void testToStringOfInlineClassValue() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/toStringOfInlineClassValue.kt");
        }

        @Test
        @TestMetadata(value="toStringOfReferenceInlineClassValue.kt")
        public void testToStringOfReferenceInlineClassValue() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/toStringOfReferenceInlineClassValue.kt");
        }

        @Test
        @TestMetadata(value="uIntArrayIteratorWithoutBoxing.kt")
        public void testUIntArrayIteratorWithoutBoxing() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/uIntArrayIteratorWithoutBoxing.kt");
        }

        @Test
        @TestMetadata(value="uIntArraySwapBoxing.kt")
        public void testUIntArraySwapBoxing() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/uIntArraySwapBoxing.kt");
        }

        @Test
        @TestMetadata(value="unboxInlineClassAfterElvis.kt")
        public void testUnboxInlineClassAfterElvis() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassAfterElvis.kt");
        }

        @Test
        @TestMetadata(value="unboxInlineClassAfterSafeCall.kt")
        public void testUnboxInlineClassAfterSafeCall() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassAfterSafeCall.kt");
        }

        @Test
        @TestMetadata(value="unboxInlineClassFromParameterizedType.kt")
        public void testUnboxInlineClassFromParameterizedType() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassFromParameterizedType.kt");
        }

        @Test
        @TestMetadata(value="unboxInlineClassesAfterSmartCasts.kt")
        public void testUnboxInlineClassesAfterSmartCasts() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxInlineClassesAfterSmartCasts.kt");
        }

        @Test
        @TestMetadata(value="unboxMethodCalledByInlineClass.kt")
        public void testUnboxMethodCalledByInlineClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/unboxMethodCalledByInlineClass.kt");
        }

        @Test
        @TestMetadata(value="withReturnTypeMangling.kt")
        public void testWithReturnTypeMangling() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineClasses/withReturnTypeMangling.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/inlineArgsInPlace")
    @TestDataPath(value="$PROJECT_ROOT")
    public class InlineArgsInPlace {
        @Test
        public void testAllFilesPresentInInlineArgsInPlace() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inlineArgsInPlace"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="kotlinMathMax.kt")
        public void testKotlinMathMax() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineArgsInPlace/kotlinMathMax.kt");
        }

        @Test
        @TestMetadata(value="println.kt")
        public void testPrintln() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineArgsInPlace/println.kt");
        }

        @Test
        @TestMetadata(value="sin.kt")
        public void testSin() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inlineArgsInPlace/sin.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/inline")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Inline {
        @Test
        public void testAllFilesPresentInInline() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inline"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="defaultLambda.kt")
        public void testDefaultLambda() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/defaultLambda.kt");
        }

        @Test
        @TestMetadata(value="deleteClassOnTransformation.kt")
        public void testDeleteClassOnTransformation() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/deleteClassOnTransformation.kt");
        }

        @Test
        @TestMetadata(value="entriesMappingOnCallSite.kt")
        public void testEntriesMappingOnCallSite() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/entriesMappingOnCallSite.kt");
        }

        @Test
        @TestMetadata(value="finallyMarkers.kt")
        public void testFinallyMarkers() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/finallyMarkers.kt");
        }

        @Test
        @TestMetadata(value="inlineArgumentSlots.kt")
        public void testInlineArgumentSlots() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineArgumentSlots.kt");
        }

        @Test
        @TestMetadata(value="inlineReturnsNothing1.kt")
        public void testInlineReturnsNothing1() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing1.kt");
        }

        @Test
        @TestMetadata(value="inlineReturnsNothing2.kt")
        public void testInlineReturnsNothing2() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing2.kt");
        }

        @Test
        @TestMetadata(value="inlineReturnsNothing3.kt")
        public void testInlineReturnsNothing3() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineReturnsNothing3.kt");
        }

        @Test
        @TestMetadata(value="inlineSuspendReifiedNoSpilling.kt")
        public void testInlineSuspendReifiedNoSpilling() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/inlineSuspendReifiedNoSpilling.kt");
        }

        @Test
        @TestMetadata(value="interfaceDefaultMethod.kt")
        public void testInterfaceDefaultMethod() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/interfaceDefaultMethod.kt");
        }

        @Test
        @TestMetadata(value="linenumberForOneParametersArgumentCall.kt")
        public void testLinenumberForOneParametersArgumentCall() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/linenumberForOneParametersArgumentCall.kt");
        }

        @Test
        @TestMetadata(value="noFakeVariableForInlineOnlyFun.kt")
        public void testNoFakeVariableForInlineOnlyFun() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFun.kt");
        }

        @Test
        @TestMetadata(value="noFakeVariableForInlineOnlyFunFromStdlib.kt")
        public void testNoFakeVariableForInlineOnlyFunFromStdlib() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFunFromStdlib.kt");
        }

        @Test
        @TestMetadata(value="noFakeVariableForInlineOnlyFunMap.kt")
        public void testNoFakeVariableForInlineOnlyFunMap() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFunMap.kt");
        }

        @Test
        @TestMetadata(value="noFakeVariableForInlineOnlyFunWithLambda.kt")
        public void testNoFakeVariableForInlineOnlyFunWithLambda() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noFakeVariableForInlineOnlyFunWithLambda.kt");
        }

        @Test
        @TestMetadata(value="noSynAccessor.kt")
        public void testNoSynAccessor() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessor.kt");
        }

        @Test
        @TestMetadata(value="noSynAccessorToDirectFieldAccess.kt")
        public void testNoSynAccessorToDirectFieldAccess() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessorToDirectFieldAccess.kt");
        }

        @Test
        @TestMetadata(value="noSynAccessorToSuper.kt")
        public void testNoSynAccessorToSuper() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/noSynAccessorToSuper.kt");
        }

        @Test
        @TestMetadata(value="notSplitedExceptionTable.kt")
        public void testNotSplitedExceptionTable() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/notSplitedExceptionTable.kt");
        }

        @Test
        @TestMetadata(value="reifiedSafeAsWithMutable.kt")
        public void testReifiedSafeAsWithMutable() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/reifiedSafeAsWithMutable.kt");
        }

        @Test
        @TestMetadata(value="remappedLocalVar.kt")
        public void testRemappedLocalVar() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/remappedLocalVar.kt");
        }

        @Test
        @TestMetadata(value="removedFinallyMarkers.kt")
        public void testRemovedFinallyMarkers() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/removedFinallyMarkers.kt");
        }

        @Test
        @TestMetadata(value="specialEnumFunction.kt")
        public void testSpecialEnumFunction() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/specialEnumFunction.kt");
        }

        @Test
        @TestMetadata(value="splitedExceptionTable.kt")
        public void testSplitedExceptionTable() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/splitedExceptionTable.kt");
        }

        @Test
        @TestMetadata(value="syntheticPropertyReference.kt")
        public void testSyntheticPropertyReference() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/syntheticPropertyReference.kt");
        }

        @Test
        @TestMetadata(value="whenMappingOnCallSite.kt")
        public void testWhenMappingOnCallSite() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/whenMappingOnCallSite.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/inline/property")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Property {
            @Test
            public void testAllFilesPresentInProperty() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/inline/property"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="simple.kt")
            public void testSimple() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/inline/property/simple.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/ieee754")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Ieee754 {
        @Test
        public void testAllFilesPresentInIeee754() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/ieee754"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="nullableDoubleEquals.kt")
        public void testNullableDoubleEquals() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableDoubleEquals.kt");
        }

        @Test
        @TestMetadata(value="nullableDoubleNotEquals.kt")
        public void testNullableDoubleNotEquals() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableDoubleNotEquals.kt");
        }

        @Test
        @TestMetadata(value="nullableFloatEquals.kt")
        public void testNullableFloatEquals() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableFloatEquals.kt");
        }

        @Test
        @TestMetadata(value="nullableFloatNotEquals.kt")
        public void testNullableFloatNotEquals() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/nullableFloatNotEquals.kt");
        }

        @Test
        @TestMetadata(value="smartCastsForDouble.kt")
        public void testSmartCastsForDouble() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/smartCastsForDouble.kt");
        }

        @Test
        @TestMetadata(value="smartCastsForFloat.kt")
        public void testSmartCastsForFloat() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/smartCastsForFloat.kt");
        }

        @Test
        @TestMetadata(value="when.kt")
        public void testWhen() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/when.kt");
        }

        @Test
        @TestMetadata(value="whenNullableSmartCast.kt")
        public void testWhenNullableSmartCast() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/ieee754/whenNullableSmartCast.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/hashCode")
    @TestDataPath(value="$PROJECT_ROOT")
    public class HashCode {
        @Test
        public void testAllFilesPresentInHashCode() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/hashCode"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="interfaceHashCode.kt")
        public void testInterfaceHashCode() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/hashCode/interfaceHashCode.kt");
        }

        @Test
        @TestMetadata(value="interfaceHashCodeWithSmartCast.kt")
        public void testInterfaceHashCodeWithSmartCast() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/hashCode/interfaceHashCodeWithSmartCast.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ForLoop {
        @Test
        public void testAllFilesPresentInForLoop() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="forInCharSequence.kt")
        public void testForInCharSequence() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequence.kt");
        }

        @Test
        @TestMetadata(value="forInCharSequenceTypeParameter.kt")
        public void testForInCharSequenceTypeParameter() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceTypeParameter.kt");
        }

        @Test
        @TestMetadata(value="forInDownToCharMinValue.kt")
        public void testForInDownToCharMinValue() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToCharMinValue.kt");
        }

        @Test
        @TestMetadata(value="forInDownToIntMinValue.kt")
        public void testForInDownToIntMinValue() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToIntMinValue.kt");
        }

        @Test
        @TestMetadata(value="forInDownToLongConstNoUnderflow.kt")
        public void testForInDownToLongConstNoUnderflow() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToLongConstNoUnderflow.kt");
        }

        @Test
        @TestMetadata(value="forInDownToLongMinValue.kt")
        public void testForInDownToLongMinValue() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInDownToLongMinValue.kt");
        }

        @Test
        @TestMetadata(value="forInObjectArray.kt")
        public void testForInObjectArray() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInObjectArray.kt");
        }

        @Test
        @TestMetadata(value="forInPrimitiveArray.kt")
        public void testForInPrimitiveArray() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInPrimitiveArray.kt");
        }

        @Test
        @TestMetadata(value="forInRangeInlinedFromStdlib.kt")
        public void testForInRangeInlinedFromStdlib() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeInlinedFromStdlib.kt");
        }

        @Test
        @TestMetadata(value="forInRangeSpecializedToUntil.kt")
        public void testForInRangeSpecializedToUntil() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeSpecializedToUntil.kt");
        }

        @Test
        @TestMetadata(value="forInRangeToCharConst.kt")
        public void testForInRangeToCharConst() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToCharConst.kt");
        }

        @Test
        @TestMetadata(value="forInRangeToCharMaxValue.kt")
        public void testForInRangeToCharMaxValue() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToCharMaxValue.kt");
        }

        @Test
        @TestMetadata(value="forInRangeToConst.kt")
        public void testForInRangeToConst() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToConst.kt");
        }

        @Test
        @TestMetadata(value="forInRangeToIntMaxValue.kt")
        public void testForInRangeToIntMaxValue() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToIntMaxValue.kt");
        }

        @Test
        @TestMetadata(value="forInRangeToLongConst.kt")
        public void testForInRangeToLongConst() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToLongConst.kt");
        }

        @Test
        @TestMetadata(value="forInRangeToLongMaxValue.kt")
        public void testForInRangeToLongMaxValue() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToLongMaxValue.kt");
        }

        @Test
        @TestMetadata(value="forInRangeToQualifiedConst.kt")
        public void testForInRangeToQualifiedConst() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeToQualifiedConst.kt");
        }

        @Test
        @TestMetadata(value="forInRangeWithImplicitReceiver.kt")
        public void testForInRangeWithImplicitReceiver() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithImplicitReceiver.kt");
        }

        @Test
        @TestMetadata(value="forInStringSpecialized.kt")
        public void testForInStringSpecialized() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInStringSpecialized.kt");
        }

        @Test
        @TestMetadata(value="forIntInDownTo.kt")
        public void testForIntInDownTo() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forIntInDownTo.kt");
        }

        @Test
        @TestMetadata(value="iincGeneration.kt")
        public void testIincGeneration() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/iincGeneration.kt");
        }

        @Test
        @TestMetadata(value="intrinsicArrayConstructorsUseCounterLoop.kt")
        public void testIntrinsicArrayConstructorsUseCounterLoop() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/intrinsicArrayConstructorsUseCounterLoop.kt");
        }

        @Test
        @TestMetadata(value="loopVarInterval.kt")
        public void testLoopVarInterval() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/loopVarInterval.kt");
        }

        @Test
        @TestMetadata(value="primitiveLiteralRange1.kt")
        public void testPrimitiveLiteralRange1() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveLiteralRange1.kt");
        }

        @Test
        @TestMetadata(value="primitiveLiteralRange2.kt")
        public void testPrimitiveLiteralRange2() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveLiteralRange2.kt");
        }

        @Test
        @TestMetadata(value="primitiveProgression.kt")
        public void testPrimitiveProgression() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveProgression.kt");
        }

        @Test
        @TestMetadata(value="primitiveRange.kt")
        public void testPrimitiveRange() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/primitiveRange.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/unsigned")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Unsigned {
            @Test
            public void testAllFilesPresentInUnsigned() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/unsigned"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInConstBoundUnsignedRange.kt")
            public void testForInConstBoundUnsignedRange() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInConstBoundUnsignedRange.kt");
            }

            @Test
            @TestMetadata(value="forInDownToUIntMinValue.kt")
            public void testForInDownToUIntMinValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInDownToUIntMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInDownToULongMinValue.kt")
            public void testForInDownToULongMinValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInDownToULongMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInOptimizableUnsignedRange.kt")
            public void testForInOptimizableUnsignedRange() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInOptimizableUnsignedRange.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToUByteMaxValue.kt")
            public void testForInRangeToUByteMaxValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInRangeToUByteMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToUIntMaxValue.kt")
            public void testForInRangeToUIntMaxValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInRangeToUIntMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToULongMaxValue.kt")
            public void testForInRangeToULongMaxValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInRangeToULongMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToUShortMaxValue.kt")
            public void testForInRangeToUShortMaxValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInRangeToUShortMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInUnsignedArray.kt")
            public void testForInUnsignedArray() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUnsignedArray.kt");
            }

            @Test
            @TestMetadata(value="forInUnsignedArrayIndices.kt")
            public void testForInUnsignedArrayIndices() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUnsignedArrayIndices.kt");
            }

            @Test
            @TestMetadata(value="forInUnsignedArrayWithIndex.kt")
            public void testForInUnsignedArrayWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUnsignedArrayWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInUntilUIntMaxValue.kt")
            public void testForInUntilUIntMaxValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilUIntMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInUntilUIntMinValue.kt")
            public void testForInUntilUIntMinValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilUIntMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInUntilULongMaxValue.kt")
            public void testForInUntilULongMaxValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilULongMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInUntilULongMinValue.kt")
            public void testForInUntilULongMinValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/forInUntilULongMinValue.kt");
            }

            @Test
            @TestMetadata(value="illegalStepConst.kt")
            public void testIllegalStepConst() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/illegalStepConst.kt");
            }

            @Test
            @TestMetadata(value="reversedThenStep.kt")
            public void testReversedThenStep() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/reversedThenStep.kt");
            }

            @Test
            @TestMetadata(value="stepConstOnNonLiteralProgression.kt")
            public void testStepConstOnNonLiteralProgression() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepConstOnNonLiteralProgression.kt");
            }

            @Test
            @TestMetadata(value="stepNonConstOnNonLiteralProgression.kt")
            public void testStepNonConstOnNonLiteralProgression() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepNonConstOnNonLiteralProgression.kt");
            }

            @Test
            @TestMetadata(value="stepOnNonLiteralRange.kt")
            public void testStepOnNonLiteralRange() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepOnNonLiteralRange.kt");
            }

            @Test
            @TestMetadata(value="stepThenDifferentStep.kt")
            public void testStepThenDifferentStep() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/unsigned/stepThenDifferentStep.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/stepped")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Stepped {
            @Test
            public void testAllFilesPresentInStepped() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/stepped"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="illegalStepConst.kt")
            public void testIllegalStepConst() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/illegalStepConst.kt");
            }

            @Test
            @TestMetadata(value="reversedThenStep.kt")
            public void testReversedThenStep() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/reversedThenStep.kt");
            }

            @Test
            @TestMetadata(value="stepConst.kt")
            public void testStepConst() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepConst.kt");
            }

            @Test
            @TestMetadata(value="stepConstOnNonLiteralProgression.kt")
            public void testStepConstOnNonLiteralProgression() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepConstOnNonLiteralProgression.kt");
            }

            @Test
            @TestMetadata(value="stepNonConst.kt")
            public void testStepNonConst() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepNonConst.kt");
            }

            @Test
            @TestMetadata(value="stepNonConstOnNonLiteralProgression.kt")
            public void testStepNonConstOnNonLiteralProgression() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepNonConstOnNonLiteralProgression.kt");
            }

            @Test
            @TestMetadata(value="stepOnNonLiteralRange.kt")
            public void testStepOnNonLiteralRange() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepOnNonLiteralRange.kt");
            }

            @Test
            @TestMetadata(value="stepOne.kt")
            public void testStepOne() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepOne.kt");
            }

            @Test
            @TestMetadata(value="stepOneThenStepOne.kt")
            public void testStepOneThenStepOne() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepOneThenStepOne.kt");
            }

            @Test
            @TestMetadata(value="stepThenDifferentStep.kt")
            public void testStepThenDifferentStep() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenDifferentStep.kt");
            }

            @Test
            @TestMetadata(value="stepThenReversed.kt")
            public void testStepThenReversed() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenReversed.kt");
            }

            @Test
            @TestMetadata(value="stepThenSameStep.kt")
            public void testStepThenSameStep() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenSameStep.kt");
            }

            @Test
            @TestMetadata(value="stepThenStepNonConst.kt")
            public void testStepThenStepNonConst() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenStepNonConst.kt");
            }

            @Test
            @TestMetadata(value="stepThenStepOne.kt")
            public void testStepThenStepOne() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/stepped/stepThenStepOne.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInUntil")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInUntil {
            @Test
            public void testAllFilesPresentInForInUntil() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInUntil"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInUntilChar.kt")
            public void testForInUntilChar() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilChar.kt");
            }

            @Test
            @TestMetadata(value="forInUntilCharMaxValue.kt")
            public void testForInUntilCharMaxValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilCharMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInUntilCharMinValue.kt")
            public void testForInUntilCharMinValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilCharMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInUntilInt.kt")
            public void testForInUntilInt() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilInt.kt");
            }

            @Test
            @TestMetadata(value="forInUntilIntMaxValue.kt")
            public void testForInUntilIntMaxValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilIntMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInUntilIntMinValue.kt")
            public void testForInUntilIntMinValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilIntMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInUntilLong.kt")
            public void testForInUntilLong() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilLong.kt");
            }

            @Test
            @TestMetadata(value="forInUntilLongMaxValue.kt")
            public void testForInUntilLongMaxValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilLongMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInUntilLongMinValue.kt")
            public void testForInUntilLongMinValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInUntil/forInUntilLongMinValue.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInSequenceWithIndex {
            @Test
            public void testAllFilesPresentInForInSequenceWithIndex() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInEmptySequenceWithIndex.kt")
            public void testForInEmptySequenceWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInEmptySequenceWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInSequenceTypeParameterWithIndex.kt")
            public void testForInSequenceTypeParameterWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceTypeParameterWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInSequenceWithIndex.kt")
            public void testForInSequenceWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInSequenceWithIndexNoElementVar.kt")
            public void testForInSequenceWithIndexNoElementVar() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexNoElementVar.kt");
            }

            @Test
            @TestMetadata(value="forInSequenceWithIndexNoIndexVar.kt")
            public void testForInSequenceWithIndexNoIndexVar() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexNoIndexVar.kt");
            }

            @Test
            @TestMetadata(value="forInSequenceWithIndexThrowsCME.kt")
            public void testForInSequenceWithIndexThrowsCME() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexThrowsCME.kt");
            }

            @Test
            @TestMetadata(value="forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInSequenceWithIndexWithExplicitlyTypedIndexVariable() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInSequenceWithIndex/forInSequenceWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInReversed")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInReversed {
            @Test
            public void testAllFilesPresentInForInReversed() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInReversed"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInReversedArrayIndices.kt")
            public void testForInReversedArrayIndices() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedArrayIndices.kt");
            }

            @Test
            @TestMetadata(value="forInReversedCharSequenceIndices.kt")
            public void testForInReversedCharSequenceIndices() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedCharSequenceIndices.kt");
            }

            @Test
            @TestMetadata(value="forInReversedCollectionIndices.kt")
            public void testForInReversedCollectionIndices() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedCollectionIndices.kt");
            }

            @Test
            @TestMetadata(value="forInReversedDownTo.kt")
            public void testForInReversedDownTo() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedDownTo.kt");
            }

            @Test
            @TestMetadata(value="forInReversedEmptyRangeLiteral.kt")
            public void testForInReversedEmptyRangeLiteral() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedEmptyRangeLiteral.kt");
            }

            @Test
            @TestMetadata(value="forInReversedRange.kt")
            public void testForInReversedRange() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedRange.kt");
            }

            @Test
            @TestMetadata(value="forInReversedRangeLiteral.kt")
            public void testForInReversedRangeLiteral() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedRangeLiteral.kt");
            }

            @Test
            @TestMetadata(value="forInReversedReversedArrayIndices.kt")
            public void testForInReversedReversedArrayIndices() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedArrayIndices.kt");
            }

            @Test
            @TestMetadata(value="forInReversedReversedDownTo.kt")
            public void testForInReversedReversedDownTo() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedDownTo.kt");
            }

            @Test
            @TestMetadata(value="forInReversedReversedRange.kt")
            public void testForInReversedReversedRange() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedRange.kt");
            }

            @Test
            @TestMetadata(value="forInReversedReversedReversedRange.kt")
            public void testForInReversedReversedReversedRange() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedReversedRange.kt");
            }

            @Test
            @TestMetadata(value="forInReversedReversedUntil.kt")
            public void testForInReversedReversedUntil() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedReversedUntil.kt");
            }

            @Test
            @TestMetadata(value="forInReversedUntil.kt")
            public void testForInReversedUntil() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInReversed/forInReversedUntil.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInRangeWithUpperBoundMinus1 {
            @Test
            public void testAllFilesPresentInForInRangeWithUpperBoundMinus1() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="booleanArray.kt")
            public void testBooleanArray() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/booleanArray.kt");
            }

            @Test
            @TestMetadata(value="byteArray.kt")
            public void testByteArray() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/byteArray.kt");
            }

            @Test
            @TestMetadata(value="charArray.kt")
            public void testCharArray() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/charArray.kt");
            }

            @Test
            @TestMetadata(value="charSequence.kt")
            public void testCharSequence() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/charSequence.kt");
            }

            @Test
            @TestMetadata(value="doubleArray.kt")
            public void testDoubleArray() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/doubleArray.kt");
            }

            @Test
            @TestMetadata(value="emptyList.kt")
            public void testEmptyList() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/emptyList.kt");
            }

            @Test
            @TestMetadata(value="emptyMap.kt")
            public void testEmptyMap() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/emptyMap.kt");
            }

            @Test
            @TestMetadata(value="emptySet.kt")
            public void testEmptySet() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/emptySet.kt");
            }

            @Test
            @TestMetadata(value="floatArray.kt")
            public void testFloatArray() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/floatArray.kt");
            }

            @Test
            @TestMetadata(value="intArray.kt")
            public void testIntArray() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/intArray.kt");
            }

            @Test
            @TestMetadata(value="list.kt")
            public void testList() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/list.kt");
            }

            @Test
            @TestMetadata(value="longArray.kt")
            public void testLongArray() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/longArray.kt");
            }

            @Test
            @TestMetadata(value="map.kt")
            public void testMap() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/map.kt");
            }

            @Test
            @TestMetadata(value="mutableList.kt")
            public void testMutableList() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/mutableList.kt");
            }

            @Test
            @TestMetadata(value="mutableMap.kt")
            public void testMutableMap() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/mutableMap.kt");
            }

            @Test
            @TestMetadata(value="mutableSet.kt")
            public void testMutableSet() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/mutableSet.kt");
            }

            @Test
            @TestMetadata(value="set.kt")
            public void testSet() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/set.kt");
            }

            @Test
            @TestMetadata(value="shortArray.kt")
            public void testShortArray() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/shortArray.kt");
            }

            @Test
            @TestMetadata(value="string.kt")
            public void testString() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeWithUpperBoundMinus1/string.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInRangeUntil {
            @Test
            public void testAllFilesPresentInForInRangeUntil() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInRangeUntilChar.kt")
            public void testForInRangeUntilChar() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilChar.kt");
            }

            @Test
            @TestMetadata(value="forInRangeUntilCharMaxValue.kt")
            public void testForInRangeUntilCharMaxValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilCharMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeUntilCharMinValue.kt")
            public void testForInRangeUntilCharMinValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilCharMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeUntilInt.kt")
            public void testForInRangeUntilInt() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilInt.kt");
            }

            @Test
            @TestMetadata(value="forInRangeUntilIntMaxValue.kt")
            public void testForInRangeUntilIntMaxValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilIntMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeUntilIntMinValue.kt")
            public void testForInRangeUntilIntMinValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilIntMinValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeUntilLong.kt")
            public void testForInRangeUntilLong() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilLong.kt");
            }

            @Test
            @TestMetadata(value="forInRangeUntilLongMaxValue.kt")
            public void testForInRangeUntilLongMaxValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilLongMaxValue.kt");
            }

            @Test
            @TestMetadata(value="forInRangeUntilLongMinValue.kt")
            public void testForInRangeUntilLongMinValue() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInRangeUntil/forInRangeUntilLongMinValue.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInProgressionWithIndex {
            @Test
            public void testAllFilesPresentInForInProgressionWithIndex() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInDownToWithIndex.kt")
            public void testForInDownToWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInDownToWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInIndicesWithIndex.kt")
            public void testForInIndicesWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInIndicesWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInRangeToWithIndex.kt")
            public void testForInRangeToWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInRangeToWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInReversedStepWithIndex.kt")
            public void testForInReversedStepWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInReversedStepWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInReversedWithIndex.kt")
            public void testForInReversedWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInReversedWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInStepReversedWithIndex.kt")
            public void testForInStepReversedWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInStepReversedWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInStepWithIndex.kt")
            public void testForInStepWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInStepWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInUntilWithIndex.kt")
            public void testForInUntilWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInUntilWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInWithIndexNoIndexOrElementVar.kt")
            public void testForInWithIndexNoIndexOrElementVar() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexNoIndexOrElementVar.kt");
            }

            @Test
            @TestMetadata(value="forInWithIndexNotDestructured.kt")
            public void testForInWithIndexNotDestructured() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexNotDestructured.kt");
            }

            @Test
            @TestMetadata(value="forInWithIndexReversed.kt")
            public void testForInWithIndexReversed() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexReversed.kt");
            }

            @Test
            @TestMetadata(value="forInWithIndexWithIndex.kt")
            public void testForInWithIndexWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInProgressionWithIndex/forInWithIndexWithIndex.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInIterableWithIndex {
            @Test
            public void testAllFilesPresentInForInIterableWithIndex() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInEmptyListWithIndex.kt")
            public void testForInEmptyListWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInEmptyListWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInIterableTypeParameterWithIndex.kt")
            public void testForInIterableTypeParameterWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInIterableTypeParameterWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInListWithIndex.kt")
            public void testForInListWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInListWithIndexNoElementVar.kt")
            public void testForInListWithIndexNoElementVar() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexNoElementVar.kt");
            }

            @Test
            @TestMetadata(value="forInListWithIndexNoIndexVar.kt")
            public void testForInListWithIndexNoIndexVar() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexNoIndexVar.kt");
            }

            @Test
            @TestMetadata(value="forInListWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInListWithIndexWithExplicitlyTypedIndexVariable() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIterableWithIndex/forInListWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInIndices")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInIndices {
            @Test
            public void testAllFilesPresentInForInIndices() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInIndices"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInArrayListIndices.kt")
            public void testForInArrayListIndices() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInArrayListIndices.kt");
            }

            @Test
            @TestMetadata(value="forInCharSequenceIndices.kt")
            public void testForInCharSequenceIndices() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCharSequenceIndices.kt");
            }

            @Test
            @TestMetadata(value="forInCharSequenceTypeParameterIndices.kt")
            public void testForInCharSequenceTypeParameterIndices() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCharSequenceTypeParameterIndices.kt");
            }

            @Test
            @TestMetadata(value="forInCollectionImplicitReceiverIndices.kt")
            public void testForInCollectionImplicitReceiverIndices() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionImplicitReceiverIndices.kt");
            }

            @Test
            @TestMetadata(value="forInCollectionIndices.kt")
            public void testForInCollectionIndices() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionIndices.kt");
            }

            @Test
            @TestMetadata(value="forInCollectionTypeParameterIndices.kt")
            public void testForInCollectionTypeParameterIndices() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInCollectionTypeParameterIndices.kt");
            }

            @Test
            @TestMetadata(value="forInNonOptimizedIndices.kt")
            public void testForInNonOptimizedIndices() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInNonOptimizedIndices.kt");
            }

            @Test
            @TestMetadata(value="forInObjectArrayIndices.kt")
            public void testForInObjectArrayIndices() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInObjectArrayIndices.kt");
            }

            @Test
            @TestMetadata(value="forInPrimitiveArrayIndices.kt")
            public void testForInPrimitiveArrayIndices() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInIndices/forInPrimitiveArrayIndices.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInCharSequenceWithIndex {
            @Test
            public void testAllFilesPresentInForInCharSequenceWithIndex() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInCharSequenceWithIndex.kt")
            public void testForInCharSequenceWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInCharSequenceWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInEmptyStringWithIndex.kt")
            public void testForInEmptyStringWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInEmptyStringWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInStringWithIndex.kt")
            public void testForInStringWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInStringWithIndexNoElementVar.kt")
            public void testForInStringWithIndexNoElementVar() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexNoElementVar.kt");
            }

            @Test
            @TestMetadata(value="forInStringWithIndexNoIndexVar.kt")
            public void testForInStringWithIndexNoIndexVar() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexNoIndexVar.kt");
            }

            @Test
            @TestMetadata(value="forInStringWithIndexWithExplicitlyTypedIndexVariable.kt")
            public void testForInStringWithIndexWithExplicitlyTypedIndexVariable() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInCharSequenceWithIndex/forInStringWithIndexWithExplicitlyTypedIndexVariable.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ForInArrayWithIndex {
            @Test
            public void testAllFilesPresentInForInArrayWithIndex() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="forInArrayWithIndexNoElementVar.kt")
            public void testForInArrayWithIndexNoElementVar() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInArrayWithIndexNoElementVar.kt");
            }

            @Test
            @TestMetadata(value="forInArrayWithIndexNoIndexVar.kt")
            public void testForInArrayWithIndexNoIndexVar() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInArrayWithIndexNoIndexVar.kt");
            }

            @Test
            @TestMetadata(value="forInEmptyArrayWithIndex.kt")
            public void testForInEmptyArrayWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInEmptyArrayWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInIntArrayWithIndex.kt")
            public void testForInIntArrayWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInIntArrayWithIndex.kt");
            }

            @Test
            @TestMetadata(value="forInObjectArrayWithIndex.kt")
            public void testForInObjectArrayWithIndex() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/forLoop/forInArrayWithIndex/forInObjectArrayWithIndex.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/fieldsForCapturedValues")
    @TestDataPath(value="$PROJECT_ROOT")
    public class FieldsForCapturedValues {
        @Test
        public void testAllFilesPresentInFieldsForCapturedValues() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="constructorOnly.kt")
        public void testConstructorOnly() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/constructorOnly.kt");
        }

        @Test
        @TestMetadata(value="extensionLambdaExtensionReceiver.kt")
        public void testExtensionLambdaExtensionReceiver() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/extensionLambdaExtensionReceiver.kt");
        }

        @Test
        @TestMetadata(value="extensionReceiver.kt")
        public void testExtensionReceiver() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/extensionReceiver.kt");
        }

        @Test
        @TestMetadata(value="innerAndOuterThis.kt")
        public void testInnerAndOuterThis() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/innerAndOuterThis.kt");
        }

        @Test
        @TestMetadata(value="labeledExtensionLambdaExtensionReceiver.kt")
        public void testLabeledExtensionLambdaExtensionReceiver() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/labeledExtensionLambdaExtensionReceiver.kt");
        }

        @Test
        @TestMetadata(value="multipleExtensionReceivers.kt")
        public void testMultipleExtensionReceivers() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/multipleExtensionReceivers.kt");
        }

        @Test
        @TestMetadata(value="outerThis.kt")
        public void testOuterThis() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/outerThis.kt");
        }

        @Test
        @TestMetadata(value="outerThisInInnerConstructor.kt")
        public void testOuterThisInInnerConstructor() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/outerThisInInnerConstructor.kt");
        }

        @Test
        @TestMetadata(value="outerThisInInnerInitBlock.kt")
        public void testOuterThisInInnerInitBlock() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/outerThisInInnerInitBlock.kt");
        }

        @Test
        @TestMetadata(value="this.kt")
        public void testThis() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/fieldsForCapturedValues/this.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/exclExcl")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ExclExcl {
        @Test
        public void testAllFilesPresentInExclExcl() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/exclExcl"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="exclExclOnPlatformType.kt")
        public void testExclExclOnPlatformType() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/exclExcl/exclExclOnPlatformType.kt");
        }

        @Test
        @TestMetadata(value="primitive.kt")
        public void testPrimitive() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/exclExcl/primitive.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/enum")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Enum {
        @Test
        public void testAllFilesPresentInEnum() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/enum"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="constructorAccessors.kt")
        public void testConstructorAccessors() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/constructorAccessors.kt");
        }

        @Test
        @TestMetadata(value="enumCheckcasts.kt")
        public void testEnumCheckcasts() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumCheckcasts.kt");
        }

        @Test
        @TestMetadata(value="enumEntries.kt")
        public void testEnumEntries() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumEntries.kt");
        }

        @Test
        @TestMetadata(value="enumEntriesIntrinsic.kt")
        public void testEnumEntriesIntrinsic() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesIntrinsic.kt");
        }

        @Test
        @TestMetadata(value="enumEntriesIntrinsicForJava.kt")
        public void testEnumEntriesIntrinsicForJava() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesIntrinsicForJava.kt");
        }

        @Test
        @TestMetadata(value="enumEntriesMapping.kt")
        public void testEnumEntriesMapping() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesMapping.kt");
        }

        @Test
        @TestMetadata(value="enumEntriesMultiMapping.kt")
        public void testEnumEntriesMultiMapping() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesMultiMapping.kt");
        }

        @Test
        @TestMetadata(value="enumEntriesNoMapping.kt")
        public void testEnumEntriesNoMapping() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/enumEntriesNoMapping.kt");
        }

        @Test
        @TestMetadata(value="kt18731.kt")
        public void testKt18731() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/kt18731.kt");
        }

        @Test
        @TestMetadata(value="kt18731_2.kt")
        public void testKt18731_2() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/kt18731_2.kt");
        }

        @Test
        @TestMetadata(value="kt57671_1.kt")
        public void testKt57671_1() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/kt57671_1.kt");
        }

        @Test
        @TestMetadata(value="kt57671_2.kt")
        public void testKt57671_2() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/enum/kt57671_2.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/disabledOptimizations")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DisabledOptimizations {
        @Test
        public void testAllFilesPresentInDisabledOptimizations() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/disabledOptimizations"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="noJumpInLastBranch.kt")
        public void testNoJumpInLastBranch() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noJumpInLastBranch.kt");
        }

        @Test
        @TestMetadata(value="noJumpInSingleBranch.kt")
        public void testNoJumpInSingleBranch() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noJumpInSingleBranch.kt");
        }

        @Test
        @TestMetadata(value="noObjectCastAfterReification.kt")
        public void testNoObjectCastAfterReification() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noObjectCastAfterReification.kt");
        }

        @Test
        @TestMetadata(value="noUnitInstanceInDefaultParameterInitialization.kt")
        public void testNoUnitInstanceInDefaultParameterInitialization() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noUnitInstanceInDefaultParameterInitialization.kt");
        }

        @Test
        @TestMetadata(value="noUnitInstanceOnVoidFunctionCall.kt")
        public void testNoUnitInstanceOnVoidFunctionCall() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noUnitInstanceOnVoidFunctionCall.kt");
        }

        @Test
        @TestMetadata(value="noUnusedLabel.kt")
        public void testNoUnusedLabel() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/disabledOptimizations/noUnusedLabel.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/directInvoke")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DirectInvoke {
        @Test
        public void testAllFilesPresentInDirectInvoke() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/directInvoke"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="callableReference.kt")
        public void testCallableReference() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/directInvoke/callableReference.kt");
        }

        @Test
        @TestMetadata(value="inplaceClosure.kt")
        public void testInplaceClosure() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/directInvoke/inplaceClosure.kt");
        }

        @Test
        @TestMetadata(value="localFun.kt")
        public void testLocalFun() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/directInvoke/localFun.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/defaultArguments")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DefaultArguments {
        @Test
        public void testAllFilesPresentInDefaultArguments() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/defaultArguments"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="inheritedInterfaceFunction.kt")
        public void testInheritedInterfaceFunction() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/inheritedInterfaceFunction.kt");
        }

        @Test
        @TestMetadata(value="inheritedInterfaceFunctionJvmDefaultDisable.kt")
        public void testInheritedInterfaceFunctionJvmDefaultDisable() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/inheritedInterfaceFunctionJvmDefaultDisable.kt");
        }

        @Test
        @TestMetadata(value="kt11962.kt")
        public void testKt11962() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/kt11962.kt");
        }

        @Test
        @TestMetadata(value="localVariablesInInlinedDefaultStubs.kt")
        public void testLocalVariablesInInlinedDefaultStubs() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/localVariablesInInlinedDefaultStubs.kt");
        }

        @Test
        @TestMetadata(value="maskAndArgumentElimination.kt")
        public void testMaskAndArgumentElimination() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/maskAndArgumentElimination.kt");
        }

        @Test
        @TestMetadata(value="maskCheckSequence.kt")
        public void testMaskCheckSequence() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/maskCheckSequence.kt");
        }

        @Test
        @TestMetadata(value="methodHandlerElimination.kt")
        public void testMethodHandlerElimination() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/methodHandlerElimination.kt");
        }

        @Test
        @TestMetadata(value="noAccessorForDefault.kt")
        public void testNoAccessorForDefault() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noAccessorForDefault.kt");
        }

        @Test
        @TestMetadata(value="noAnonymousObjectRegenerationInDefaultStub.kt")
        public void testNoAnonymousObjectRegenerationInDefaultStub() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noAnonymousObjectRegenerationInDefaultStub.kt");
        }

        @Test
        @TestMetadata(value="noEmptyArray.kt")
        public void testNoEmptyArray() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noEmptyArray.kt");
        }

        @Test
        @TestMetadata(value="noSyntheticParameters.kt")
        public void testNoSyntheticParameters() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/defaultArguments/noSyntheticParameters.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/deadCodeElimination")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DeadCodeElimination {
        @Test
        public void testAllFilesPresentInDeadCodeElimination() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/deadCodeElimination"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="arrayConstructor.kt")
        public void testArrayConstructor() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/arrayConstructor.kt");
        }

        @Test
        @TestMetadata(value="boxing.kt")
        public void testBoxing() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/boxing.kt");
        }

        @Test
        @TestMetadata(value="boxingNotOptimizable.kt")
        public void testBoxingNotOptimizable() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/boxingNotOptimizable.kt");
        }

        @Test
        @TestMetadata(value="emptyVariableRange.kt")
        public void testEmptyVariableRange() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/emptyVariableRange.kt");
        }

        @Test
        @TestMetadata(value="kt14357.kt")
        public void testKt14357() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/kt14357.kt");
        }

        @Test
        @TestMetadata(value="lastReturn.kt")
        public void testLastReturn() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/lastReturn.kt");
        }

        @Test
        @TestMetadata(value="literal.kt")
        public void testLiteral() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/literal.kt");
        }

        @Test
        @TestMetadata(value="simpleConstructor.kt")
        public void testSimpleConstructor() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructor.kt");
        }

        @Test
        @TestMetadata(value="simpleConstructorNotRedundant.kt")
        public void testSimpleConstructorNotRedundant() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructorNotRedundant.kt");
        }

        @Test
        @TestMetadata(value="simpleConstructorNotRedundantNotOptimizable.kt")
        public void testSimpleConstructorNotRedundantNotOptimizable() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/simpleConstructorNotRedundantNotOptimizable.kt");
        }

        @Test
        @TestMetadata(value="unusedPrimitiveAndObjectEquals.kt")
        public void testUnusedPrimitiveAndObjectEquals() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/deadCodeElimination/unusedPrimitiveAndObjectEquals.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Coroutines {
        @Test
        public void testAllFilesPresentInCoroutines() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="crossinlineSuspendContinuation_1_3.kt")
        public void testCrossinlineSuspendContinuation_1_3() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/crossinlineSuspendContinuation_1_3.kt");
        }

        @Test
        @TestMetadata(value="doNotReassignContinuation.kt")
        public void testDoNotReassignContinuation() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/doNotReassignContinuation.kt");
        }

        @Test
        @TestMetadata(value="effectivelyInlineOnly.kt")
        public void testEffectivelyInlineOnly() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/effectivelyInlineOnly.kt");
        }

        @Test
        @TestMetadata(value="internalInlineSuspend.kt")
        public void testInternalInlineSuspend() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/internalInlineSuspend.kt");
        }

        @Test
        @TestMetadata(value="mergeLvt.kt")
        public void testMergeLvt() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/mergeLvt.kt");
        }

        @Test
        @TestMetadata(value="nonLocalReturn.kt")
        public void testNonLocalReturn() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/nonLocalReturn.kt");
        }

        @Test
        @TestMetadata(value="returnUnitInLambda.kt")
        public void testReturnUnitInLambda() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/returnUnitInLambda.kt");
        }

        @Test
        @TestMetadata(value="suspendMain.kt")
        public void testSuspendMain() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/suspendMain.kt");
        }

        @Test
        @TestMetadata(value="throwOnFailure.kt")
        public void testThrowOnFailure() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/throwOnFailure.kt");
        }

        @Test
        @TestMetadata(value="varValueConflictsWithTable.kt")
        public void testVarValueConflictsWithTable() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/varValueConflictsWithTable.kt");
        }

        @Test
        @TestMetadata(value="varValueConflictsWithTableSameSort.kt")
        public void testVarValueConflictsWithTableSameSort() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/varValueConflictsWithTableSameSort.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/stateMachine")
        @TestDataPath(value="$PROJECT_ROOT")
        public class StateMachine {
            @Test
            public void testAllFilesPresentInStateMachine() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/stateMachine"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="kt25893.kt")
            public void testKt25893() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/stateMachine/kt25893.kt");
            }

            @Test
            @TestMetadata(value="withTypeParameter.kt")
            public void testWithTypeParameter() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/stateMachine/withTypeParameter.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling")
        @TestDataPath(value="$PROJECT_ROOT")
        public class IntLikeVarSpilling {
            @Test
            public void testAllFilesPresentInIntLikeVarSpilling() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="complicatedMerge.kt")
            public void testComplicatedMerge() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/complicatedMerge.kt");
            }

            @Test
            @TestMetadata(value="i2bResult.kt")
            public void testI2bResult() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/i2bResult.kt");
            }

            @Test
            @TestMetadata(value="loadFromBooleanArray.kt")
            public void testLoadFromBooleanArray() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/loadFromBooleanArray.kt");
            }

            @Test
            @TestMetadata(value="loadFromByteArray.kt")
            public void testLoadFromByteArray() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/loadFromByteArray.kt");
            }

            @Test
            @TestMetadata(value="noVariableInTable.kt")
            public void testNoVariableInTable() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/noVariableInTable.kt");
            }

            @Test
            @TestMetadata(value="sameIconst1ManyVars.kt")
            public void testSameIconst1ManyVars() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/sameIconst1ManyVars.kt");
            }

            @Test
            @TestMetadata(value="usedInArrayStore.kt")
            public void testUsedInArrayStore() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInArrayStore.kt");
            }

            @Test
            @TestMetadata(value="usedInMethodCall.kt")
            public void testUsedInMethodCall() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInMethodCall.kt");
            }

            @Test
            @TestMetadata(value="usedInPutfield.kt")
            public void testUsedInPutfield() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInPutfield.kt");
            }

            @Test
            @TestMetadata(value="usedInVarStore.kt")
            public void testUsedInVarStore() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/intLikeVarSpilling/usedInVarStore.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/inlineClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InlineClasses {
            @Test
            public void testAllFilesPresentInInlineClasses() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="inlineClassBoxingInSuspendFunReturn_Primitive.kt")
            public void testInlineClassBoxingInSuspendFunReturn_Primitive() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/inlineClassBoxingInSuspendFunReturn_Primitive.kt");
            }

            @Test
            @TestMetadata(value="noInlineClassBoxingInSuspendFunReturn_Any.kt")
            public void testNoInlineClassBoxingInSuspendFunReturn_Any() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_Any.kt");
            }

            @Test
            @TestMetadata(value="noInlineClassBoxingInSuspendFunReturn_InlineAny.kt")
            public void testNoInlineClassBoxingInSuspendFunReturn_InlineAny() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_InlineAny.kt");
            }

            @Test
            @TestMetadata(value="noInlineClassBoxingInSuspendFunReturn_SameJvmType.kt")
            public void testNoInlineClassBoxingInSuspendFunReturn_SameJvmType() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_SameJvmType.kt");
            }

            @Test
            @TestMetadata(value="noInlineClassBoxingInSuspendFunReturn_String.kt")
            public void testNoInlineClassBoxingInSuspendFunReturn_String() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/noInlineClassBoxingInSuspendFunReturn_String.kt");
            }

            @Test
            @TestMetadata(value="returnResult.kt")
            public void testReturnResult() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/returnResult.kt");
            }

            @Test
            @TestMetadata(value="returnStringOverride.kt")
            public void testReturnStringOverride() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/inlineClasses/returnStringOverride.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda")
        @TestDataPath(value="$PROJECT_ROOT")
        public class DestructuringInLambda {
            @Test
            public void testAllFilesPresentInDestructuringInLambda() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="inlineSeparateFiles.kt")
            public void testInlineSeparateFiles() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/destructuringInLambda/inlineSeparateFiles.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/coroutines/debug")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Debug {
            @Test
            public void testAllFilesPresentInDebug() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coroutines/debug"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="continuationInLvt.kt")
            public void testContinuationInLvt() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/continuationInLvt.kt");
            }

            @Test
            @TestMetadata(value="localVariableCorrectLabel.kt")
            public void testLocalVariableCorrectLabel() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/localVariableCorrectLabel.kt");
            }

            @Test
            @TestMetadata(value="probeCoroutineSuspended.kt")
            public void testProbeCoroutineSuspended() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/probeCoroutineSuspended.kt");
            }

            @Test
            @TestMetadata(value="shrinkLvtTopLevel.kt")
            public void testShrinkLvtTopLevel() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/shrinkLvtTopLevel.kt");
            }

            @Test
            @TestMetadata(value="thisAndResultInLvt.kt")
            public void testThisAndResultInLvt() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coroutines/debug/thisAndResultInLvt.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/controlStructures")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ControlStructures {
        @Test
        public void testAllFilesPresentInControlStructures() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/controlStructures"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="ifConsts.kt")
        public void testIfConsts() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/controlStructures/ifConsts.kt");
        }

        @Test
        @TestMetadata(value="kt17110.kt")
        public void testKt17110() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/controlStructures/kt17110.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/constructors")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Constructors {
        @Test
        public void testAllFilesPresentInConstructors() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constructors"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="enumPrimaryDefaults.kt")
        public void testEnumPrimaryDefaults() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/enumPrimaryDefaults.kt");
        }

        @Test
        @TestMetadata(value="inlineArgumentPrimaryDefaults.kt")
        public void testInlineArgumentPrimaryDefaults() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/inlineArgumentPrimaryDefaults.kt");
        }

        @Test
        @TestMetadata(value="inlinePrimaryDefaults.kt")
        public void testInlinePrimaryDefaults() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/inlinePrimaryDefaults.kt");
        }

        @Test
        @TestMetadata(value="innerClassConstructor.kt")
        public void testInnerClassConstructor() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/innerClassConstructor.kt");
        }

        @Test
        @TestMetadata(value="innerPrimaryDefaults.kt")
        public void testInnerPrimaryDefaults() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/innerPrimaryDefaults.kt");
        }

        @Test
        @TestMetadata(value="internalPrimaryDefaults.kt")
        public void testInternalPrimaryDefaults() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/internalPrimaryDefaults.kt");
        }

        @Test
        @TestMetadata(value="localPrimaryDefaults.kt")
        public void testLocalPrimaryDefaults() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/localPrimaryDefaults.kt");
        }

        @Test
        @TestMetadata(value="parameterlessPrimary.kt")
        public void testParameterlessPrimary() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/parameterlessPrimary.kt");
        }

        @Test
        @TestMetadata(value="privatePrimaryDefaults.kt")
        public void testPrivatePrimaryDefaults() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/privatePrimaryDefaults.kt");
        }

        @Test
        @TestMetadata(value="protectedPrimaryDefaults.kt")
        public void testProtectedPrimaryDefaults() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constructors/protectedPrimaryDefaults.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/constants")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Constants {
        @Test
        public void testAllFilesPresentInConstants() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constants"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="byte.kt")
        public void testByte() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/byte.kt");
        }

        @Test
        @TestMetadata(value="comparisonFalse.kt")
        public void testComparisonFalse() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/comparisonFalse.kt");
        }

        @Test
        @TestMetadata(value="comparisonTrue.kt")
        public void testComparisonTrue() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/comparisonTrue.kt");
        }

        @Test
        @TestMetadata(value="floatingPoints.kt")
        public void testFloatingPoints() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/floatingPoints.kt");
        }

        @Test
        @TestMetadata(value="inlineUnsignedIntConstant.kt")
        public void testInlineUnsignedIntConstant() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/inlineUnsignedIntConstant.kt");
        }

        @Test
        @TestMetadata(value="kt9532.kt")
        public void testKt9532() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/kt9532.kt");
        }

        @Test
        @TestMetadata(value="noInlineNonConst.kt")
        public void testNoInlineNonConst() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/noInlineNonConst.kt");
        }

        @Test
        @TestMetadata(value="noInlineNonStaticJavaField.kt")
        public void testNoInlineNonStaticJavaField() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/noInlineNonStaticJavaField.kt");
        }

        @Test
        @TestMetadata(value="nullableByteAndShort.kt")
        public void testNullableByteAndShort() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/nullableByteAndShort.kt");
        }

        @Test
        @TestMetadata(value="partialString.kt")
        public void testPartialString() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/partialString.kt");
        }

        @Test
        @TestMetadata(value="short.kt")
        public void testShort() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/short.kt");
        }

        @Test
        @TestMetadata(value="string.kt")
        public void testString() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constants/string.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/constantConditions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ConstantConditions {
        @Test
        public void testAllFilesPresentInConstantConditions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constantConditions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="cmpIntWith0.kt")
        public void testCmpIntWith0() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/cmpIntWith0.kt");
        }

        @Test
        @TestMetadata(value="constantFlag.kt")
        public void testConstantFlag() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/constantFlag.kt");
        }

        @Test
        @TestMetadata(value="constantInt.kt")
        public void testConstantInt() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/constantInt.kt");
        }

        @Test
        @TestMetadata(value="inlineIfFalse.kt")
        public void testInlineIfFalse() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/inlineIfFalse.kt");
        }

        @Test
        @TestMetadata(value="kt3098.kt")
        public void testKt3098() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constantConditions/kt3098.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/constProperty")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ConstProperty {
        @Test
        public void testAllFilesPresentInConstProperty() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/constProperty"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="noAccessorsForPrivateConstants.kt")
        public void testNoAccessorsForPrivateConstants() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constProperty/noAccessorsForPrivateConstants.kt");
        }

        @Test
        @TestMetadata(value="nonConstValHasNoDefaultValue_after.kt")
        public void testNonConstValHasNoDefaultValue_after() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/constProperty/nonConstValHasNoDefaultValue_after.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/conditions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Conditions {
        @Test
        public void testAllFilesPresentInConditions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/conditions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="conjunction.kt")
        public void testConjunction() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/conjunction.kt");
        }

        @Test
        @TestMetadata(value="conjunctionInDoWhile.kt")
        public void testConjunctionInDoWhile() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/conjunctionInDoWhile.kt");
        }

        @Test
        @TestMetadata(value="conjunctionInWhile.kt")
        public void testConjunctionInWhile() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/conjunctionInWhile.kt");
        }

        @Test
        @TestMetadata(value="disjunction.kt")
        public void testDisjunction() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/disjunction.kt");
        }

        @Test
        @TestMetadata(value="negatedConjuction.kt")
        public void testNegatedConjuction() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedConjuction.kt");
        }

        @Test
        @TestMetadata(value="negatedDisjunction.kt")
        public void testNegatedDisjunction() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedDisjunction.kt");
        }

        @Test
        @TestMetadata(value="negatedNonZeroCompareInDoWhile.kt")
        public void testNegatedNonZeroCompareInDoWhile() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNonZeroCompareInDoWhile.kt");
        }

        @Test
        @TestMetadata(value="negatedNonZeroCompareInIf.kt")
        public void testNegatedNonZeroCompareInIf() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNonZeroCompareInIf.kt");
        }

        @Test
        @TestMetadata(value="negatedNonZeroCompareInWhile.kt")
        public void testNegatedNonZeroCompareInWhile() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNonZeroCompareInWhile.kt");
        }

        @Test
        @TestMetadata(value="negatedNullCompareInDoWhile.kt")
        public void testNegatedNullCompareInDoWhile() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompareInDoWhile.kt");
        }

        @Test
        @TestMetadata(value="negatedNullCompareInIf.kt")
        public void testNegatedNullCompareInIf() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompareInIf.kt");
        }

        @Test
        @TestMetadata(value="negatedNullCompareInWhile.kt")
        public void testNegatedNullCompareInWhile() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedNullCompareInWhile.kt");
        }

        @Test
        @TestMetadata(value="negatedZeroCompareInDoWhile.kt")
        public void testNegatedZeroCompareInDoWhile() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompareInDoWhile.kt");
        }

        @Test
        @TestMetadata(value="negatedZeroCompareInIf.kt")
        public void testNegatedZeroCompareInIf() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompareInIf.kt");
        }

        @Test
        @TestMetadata(value="negatedZeroCompareInWhile.kt")
        public void testNegatedZeroCompareInWhile() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/negatedZeroCompareInWhile.kt");
        }

        @Test
        @TestMetadata(value="noBoxingForBoxedEqPrimitive.kt")
        public void testNoBoxingForBoxedEqPrimitive() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForBoxedEqPrimitive.kt");
        }

        @Test
        @TestMetadata(value="noBoxingForPrimitiveEqBoxed.kt")
        public void testNoBoxingForPrimitiveEqBoxed() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForPrimitiveEqBoxed.kt");
        }

        @Test
        @TestMetadata(value="noBoxingForPrimitiveEqObject.kt")
        public void testNoBoxingForPrimitiveEqObject() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/noBoxingForPrimitiveEqObject.kt");
        }

        @Test
        @TestMetadata(value="nonZeroCompareInDoWhile.kt")
        public void testNonZeroCompareInDoWhile() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nonZeroCompareInDoWhile.kt");
        }

        @Test
        @TestMetadata(value="nonZeroCompareInIf.kt")
        public void testNonZeroCompareInIf() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nonZeroCompareInIf.kt");
        }

        @Test
        @TestMetadata(value="nonZeroCompareInWhile.kt")
        public void testNonZeroCompareInWhile() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nonZeroCompareInWhile.kt");
        }

        @Test
        @TestMetadata(value="nullCompareConst.kt")
        public void testNullCompareConst() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareConst.kt");
        }

        @Test
        @TestMetadata(value="nullCompareInDoWhile.kt")
        public void testNullCompareInDoWhile() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareInDoWhile.kt");
        }

        @Test
        @TestMetadata(value="nullCompareInIf.kt")
        public void testNullCompareInIf() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareInIf.kt");
        }

        @Test
        @TestMetadata(value="nullCompareInWhile.kt")
        public void testNullCompareInWhile() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/nullCompareInWhile.kt");
        }

        @Test
        @TestMetadata(value="zeroCompareInDoWhile.kt")
        public void testZeroCompareInDoWhile() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompareInDoWhile.kt");
        }

        @Test
        @TestMetadata(value="zeroCompareInIf.kt")
        public void testZeroCompareInIf() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompareInIf.kt");
        }

        @Test
        @TestMetadata(value="zeroCompareInWhile.kt")
        public void testZeroCompareInWhile() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/conditions/zeroCompareInWhile.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/companion")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Companion {
        @Test
        public void testAllFilesPresentInCompanion() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/companion"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="directAccessToBackingField.kt")
        public void testDirectAccessToBackingField() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/directAccessToBackingField.kt");
        }

        @Test
        @TestMetadata(value="floatingPointCompanionAccess.kt")
        public void testFloatingPointCompanionAccess() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/floatingPointCompanionAccess.kt");
        }

        @Test
        @TestMetadata(value="inlineFunctionCompanionPropertyAccess.kt")
        public void testInlineFunctionCompanionPropertyAccess() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/inlineFunctionCompanionPropertyAccess.kt");
        }

        @Test
        @TestMetadata(value="inlineFunctionObjectCompanionPropertyAccess.kt")
        public void testInlineFunctionObjectCompanionPropertyAccess() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/inlineFunctionObjectCompanionPropertyAccess.kt");
        }

        @Test
        @TestMetadata(value="kt14258_1.kt")
        public void testKt14258_1() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_1.kt");
        }

        @Test
        @TestMetadata(value="kt14258_2.kt")
        public void testKt14258_2() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_2.kt");
        }

        @Test
        @TestMetadata(value="kt14258_3.kt")
        public void testKt14258_3() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_3.kt");
        }

        @Test
        @TestMetadata(value="kt14258_4.kt")
        public void testKt14258_4() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_4.kt");
        }

        @Test
        @TestMetadata(value="kt14258_5.kt")
        public void testKt14258_5() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/kt14258_5.kt");
        }

        @Test
        @TestMetadata(value="nonDefaultAccessors.kt")
        public void testNonDefaultAccessors() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/nonDefaultAccessors.kt");
        }

        @Test
        @TestMetadata(value="privateCompanionObjectAccessors_after.kt")
        public void testPrivateCompanionObjectAccessors_after() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/privateCompanionObjectAccessors_after.kt");
        }

        @Test
        @TestMetadata(value="protectedCompanionObjectAccessors_after.kt")
        public void testProtectedCompanionObjectAccessors_after() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/companion/protectedCompanionObjectAccessors_after.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/coercionToUnitOptimization")
    @TestDataPath(value="$PROJECT_ROOT")
    public class CoercionToUnitOptimization {
        @Test
        public void testAllFilesPresentInCoercionToUnitOptimization() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="inRangeCheckWithConst.kt")
        public void testInRangeCheckWithConst() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/inRangeCheckWithConst.kt");
        }

        @Test
        @TestMetadata(value="kt14360.kt")
        public void testKt14360() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/kt14360.kt");
        }

        @Test
        @TestMetadata(value="largeMethodWithCoercionToUnit.kt")
        public void testLargeMethodWithCoercionToUnit() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/largeMethodWithCoercionToUnit.kt");
        }

        @Test
        @TestMetadata(value="nopInlineFuns.kt")
        public void testNopInlineFuns() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/nopInlineFuns.kt");
        }

        @Test
        @TestMetadata(value="returnsUnit.kt")
        public void testReturnsUnit() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/returnsUnit.kt");
        }

        @Test
        @TestMetadata(value="safeCall.kt")
        public void testSafeCall() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeCall.kt");
        }

        @Test
        @TestMetadata(value="safeCallWithReturnValue.kt")
        public void testSafeCallWithReturnValue() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeCallWithReturnValue.kt");
        }

        @Test
        @TestMetadata(value="safeLet.kt")
        public void testSafeLet() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/safeLet.kt");
        }

        @Test
        @TestMetadata(value="tryInlined.kt")
        public void testTryInlined() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/coercionToUnitOptimization/tryInlined.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/checkcast")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Checkcast {
        @Test
        public void testAllFilesPresentInCheckcast() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/checkcast"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="kt14811.kt")
        public void testKt14811() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt14811.kt");
        }

        @Test
        @TestMetadata(value="kt14963.kt")
        public void testKt14963() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt14963.kt");
        }

        @Test
        @TestMetadata(value="kt15411.kt")
        public void testKt15411() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt15411.kt");
        }

        @Test
        @TestMetadata(value="kt22714.kt")
        public void testKt22714() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt22714.kt");
        }

        @Test
        @TestMetadata(value="kt53465.kt")
        public void testKt53465() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/kt53465.kt");
        }

        @Test
        @TestMetadata(value="noCheckcastOnDelegatingDefaultImplsCall.kt")
        public void testNoCheckcastOnDelegatingDefaultImplsCall() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/noCheckcastOnDelegatingDefaultImplsCall.kt");
        }

        @Test
        @TestMetadata(value="noCheckcastOnSuper.kt")
        public void testNoCheckcastOnSuper() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/checkcast/noCheckcastOnSuper.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/capturedVarsOptimization")
    @TestDataPath(value="$PROJECT_ROOT")
    public class CapturedVarsOptimization {
        @Test
        public void testAllFilesPresentInCapturedVarsOptimization() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/capturedVarsOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="capturedInChainOfInlineFuns.kt")
        public void testCapturedInChainOfInlineFuns() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInChainOfInlineFuns.kt");
        }

        @Test
        @TestMetadata(value="capturedInInlineOnly.kt")
        public void testCapturedInInlineOnly() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInInlineOnly.kt");
        }

        @Test
        @TestMetadata(value="capturedInLocalObject.kt")
        public void testCapturedInLocalObject() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInLocalObject.kt");
        }

        @Test
        @TestMetadata(value="capturedInNoInlineOnly.kt")
        public void testCapturedInNoInlineOnly() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInNoInlineOnly.kt");
        }

        @Test
        @TestMetadata(value="capturedInNoInlneInsideChainOfInlineFuns.kt")
        public void testCapturedInNoInlneInsideChainOfInlineFuns() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedInNoInlneInsideChainOfInlineFuns.kt");
        }

        @Test
        @TestMetadata(value="capturedValInLambdaInitializedInside.kt")
        public void testCapturedValInLambdaInitializedInside() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedValInLambdaInitializedInside.kt");
        }

        @Test
        @TestMetadata(value="capturedValInLambdaInitializedOutside.kt")
        public void testCapturedValInLambdaInitializedOutside() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedValInLambdaInitializedOutside.kt");
        }

        @Test
        @TestMetadata(value="capturedVarsOfSize2.kt")
        public void testCapturedVarsOfSize2() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/capturedVarsOfSize2.kt");
        }

        @Test
        @TestMetadata(value="returnValueOfArrayConstructor.kt")
        public void testReturnValueOfArrayConstructor() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/returnValueOfArrayConstructor.kt");
        }

        @Test
        @TestMetadata(value="sharedSlotsWithCapturedVars.kt")
        public void testSharedSlotsWithCapturedVars() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/sharedSlotsWithCapturedVars.kt");
        }

        @Test
        @TestMetadata(value="withStackNormalization.kt")
        public void testWithStackNormalization() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/capturedVarsOptimization/withStackNormalization.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/callableReference")
    @TestDataPath(value="$PROJECT_ROOT")
    public class CallableReference {
        @Test
        public void testAllFilesPresentInCallableReference() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/callableReference"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="boundFieldReferenceInInline.kt")
        public void testBoundFieldReferenceInInline() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/boundFieldReferenceInInline.kt");
        }

        @Test
        @TestMetadata(value="boundFunReferenceInInline.kt")
        public void testBoundFunReferenceInInline() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/boundFunReferenceInInline.kt");
        }

        @Test
        @TestMetadata(value="boundPropertyReferenceInInline.kt")
        public void testBoundPropertyReferenceInInline() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/boundPropertyReferenceInInline.kt");
        }

        @Test
        @TestMetadata(value="kt36975.kt")
        public void testKt36975() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/kt36975.kt");
        }

        @Test
        @TestMetadata(value="kt39612.kt")
        public void testKt39612() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/kt39612.kt");
        }

        @Test
        @TestMetadata(value="nameIntrinsicWithImplicitThis.kt")
        public void testNameIntrinsicWithImplicitThis() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/nameIntrinsicWithImplicitThis.kt");
        }

        @Test
        @TestMetadata(value="noMetadata.kt")
        public void testNoMetadata() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/noMetadata.kt");
        }

        @Test
        @TestMetadata(value="unboundFieldReferenceInInline.kt")
        public void testUnboundFieldReferenceInInline() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/unboundFieldReferenceInInline.kt");
        }

        @Test
        @TestMetadata(value="unboundFunReferenceInInline.kt")
        public void testUnboundFunReferenceInInline() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/unboundFunReferenceInInline.kt");
        }

        @Test
        @TestMetadata(value="unboundPropertyReferenceInInline.kt")
        public void testUnboundPropertyReferenceInInline() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/callableReference/unboundPropertyReferenceInInline.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/builtinFunctions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class BuiltinFunctions {
        @Test
        public void testAllFilesPresentInBuiltinFunctions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/builtinFunctions"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="charSequence.kt")
        public void testCharSequence() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/charSequence.kt");
        }

        @Test
        @TestMetadata(value="contains.kt")
        public void testContains() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/contains.kt");
        }

        @Test
        @TestMetadata(value="removeAt.kt")
        public void testRemoveAt() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/removeAt.kt");
        }

        @Test
        @TestMetadata(value="size.kt")
        public void testSize() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/size.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge")
        @TestDataPath(value="$PROJECT_ROOT")
        public class GenericParameterBridge {
            @Test
            @TestMetadata(value="abstractList.kt")
            public void testAbstractList() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/abstractList.kt");
            }

            @Test
            public void testAllFilesPresentInGenericParameterBridge() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="IntMC.kt")
            public void testIntMC() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/IntMC.kt");
            }

            @Test
            @TestMetadata(value="mutableCollection.kt")
            public void testMutableCollection() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/mutableCollection.kt");
            }

            @Test
            @TestMetadata(value="mutableSetInterfaces.kt")
            public void testMutableSetInterfaces() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/mutableSetInterfaces.kt");
            }

            @Test
            @TestMetadata(value="notNullAnyMC.kt")
            public void testNotNullAnyMC() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/notNullAnyMC.kt");
            }

            @Test
            @TestMetadata(value="notNullParamMC.kt")
            public void testNotNullParamMC() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/notNullParamMC.kt");
            }

            @Test
            @TestMetadata(value="nullableAnyMC.kt")
            public void testNullableAnyMC() {
                IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/builtinFunctions/genericParameterBridge/nullableAnyMC.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/boxingOptimization")
    @TestDataPath(value="$PROJECT_ROOT")
    public class BoxingOptimization {
        @Test
        public void testAllFilesPresentInBoxingOptimization() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/boxingOptimization"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="boxingAndEquals.kt")
        public void testBoxingAndEquals() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/boxingAndEquals.kt");
        }

        @Test
        @TestMetadata(value="casts.kt")
        public void testCasts() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/casts.kt");
        }

        @Test
        @TestMetadata(value="checkcastAndInstanceOf.kt")
        public void testCheckcastAndInstanceOf() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/checkcastAndInstanceOf.kt");
        }

        @Test
        @TestMetadata(value="checkcastAndInstanceOf_before.kt")
        public void testCheckcastAndInstanceOf_before() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/checkcastAndInstanceOf_before.kt");
        }

        @Test
        @TestMetadata(value="fold.kt")
        public void testFold() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/fold.kt");
        }

        @Test
        @TestMetadata(value="hashCodeOnNonNull.kt")
        public void testHashCodeOnNonNull() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/hashCodeOnNonNull.kt");
        }

        @Test
        @TestMetadata(value="inlineClassesAndInlinedLambda.kt")
        public void testInlineClassesAndInlinedLambda() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/inlineClassesAndInlinedLambda.kt");
        }

        @Test
        @TestMetadata(value="intCompareTo.kt")
        public void testIntCompareTo() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/intCompareTo.kt");
        }

        @Test
        @TestMetadata(value="kClassInAnnotation.kt")
        public void testKClassInAnnotation() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kClassInAnnotation.kt");
        }

        @Test
        @TestMetadata(value="kClassInAnnotationEscaping.kt")
        public void testKClassInAnnotationEscaping() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kClassInAnnotationEscaping.kt");
        }

        @Test
        @TestMetadata(value="kt15862.kt")
        public void testKt15862() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt15862.kt");
        }

        @Test
        @TestMetadata(value="kt15862_2.kt")
        public void testKt15862_2() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt15862_2.kt");
        }

        @Test
        @TestMetadata(value="kt6842.kt")
        public void testKt6842() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt6842.kt");
        }

        @Test
        @TestMetadata(value="kt7224.kt")
        public void testKt7224() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/kt7224.kt");
        }

        @Test
        @TestMetadata(value="maxMinByOrNull.kt")
        public void testMaxMinByOrNull() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/maxMinByOrNull.kt");
        }

        @Test
        @TestMetadata(value="nullCheck.kt")
        public void testNullCheck() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/nullCheck.kt");
        }

        @Test
        @TestMetadata(value="progressions.kt")
        public void testProgressions() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/progressions.kt");
        }

        @Test
        @TestMetadata(value="safeCallToPrimitiveEquality1.kt")
        public void testSafeCallToPrimitiveEquality1() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality1.kt");
        }

        @Test
        @TestMetadata(value="safeCallToPrimitiveEquality2.kt")
        public void testSafeCallToPrimitiveEquality2() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality2.kt");
        }

        @Test
        @TestMetadata(value="safeCallToPrimitiveEquality3.kt")
        public void testSafeCallToPrimitiveEquality3() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallToPrimitiveEquality3.kt");
        }

        @Test
        @TestMetadata(value="safeCallWithElvis.kt")
        public void testSafeCallWithElvis() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallWithElvis.kt");
        }

        @Test
        @TestMetadata(value="safeCallWithElvisMultipleFiles.kt")
        public void testSafeCallWithElvisMultipleFiles() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/safeCallWithElvisMultipleFiles.kt");
        }

        @Test
        @TestMetadata(value="severalInlines.kt")
        public void testSeveralInlines() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/severalInlines.kt");
        }

        @Test
        @TestMetadata(value="simple.kt")
        public void testSimple() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/simple.kt");
        }

        @Test
        @TestMetadata(value="simpleUninitializedMerge.kt")
        public void testSimpleUninitializedMerge() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/simpleUninitializedMerge.kt");
        }

        @Test
        @TestMetadata(value="suspendBoxing.kt")
        public void testSuspendBoxing() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/suspendBoxing.kt");
        }

        @Test
        @TestMetadata(value="unsafeRemoving.kt")
        public void testUnsafeRemoving() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/unsafeRemoving.kt");
        }

        @Test
        @TestMetadata(value="unsignedRangeIteratorSpecialization.kt")
        public void testUnsignedRangeIteratorSpecialization() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/unsignedRangeIteratorSpecialization.kt");
        }

        @Test
        @TestMetadata(value="variableClash.kt")
        public void testVariableClash() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/variableClash.kt");
        }

        @Test
        @TestMetadata(value="variables.kt")
        public void testVariables() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxingOptimization/variables.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/boxing")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Boxing {
        @Test
        public void testAllFilesPresentInBoxing() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/boxing"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="crossinlineSuspend.kt")
        public void testCrossinlineSuspend() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxing/crossinlineSuspend.kt");
        }

        @Test
        @TestMetadata(value="inlineSuspend.kt")
        public void testInlineSuspend() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxing/inlineSuspend.kt");
        }

        @Test
        @TestMetadata(value="suspend.kt")
        public void testSuspend() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/boxing/suspend.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/assert")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Assert {
        @Test
        public void testAllFilesPresentInAssert() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/assert"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="jvmCrossinline.kt")
        public void testJvmCrossinline() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmCrossinline.kt");
        }

        @Test
        @TestMetadata(value="jvmCrossinlineAssertInLambda.kt")
        public void testJvmCrossinlineAssertInLambda() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmCrossinlineAssertInLambda.kt");
        }

        @Test
        @TestMetadata(value="jvmInline.kt")
        public void testJvmInline() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmInline.kt");
        }

        @Test
        @TestMetadata(value="jvmInlineLambda.kt")
        public void testJvmInlineLambda() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmInlineLambda.kt");
        }

        @Test
        @TestMetadata(value="jvmNestedClass.kt")
        public void testJvmNestedClass() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/assert/jvmNestedClass.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/codegen/bytecodeText/argumentOrder")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ArgumentOrder {
        @Test
        public void testAllFilesPresentInArgumentOrder() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/codegen/bytecodeText/argumentOrder"), Pattern.compile("^(.+)\\.kt$"), null, TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="sameOrder.kt")
        public void testSameOrder() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/argumentOrder/sameOrder.kt");
        }

        @Test
        @TestMetadata(value="sameOrderWithDefault.kt")
        public void testSameOrderWithDefault() {
            IrBytecodeTextTestGenerated.this.runTest("compiler/testData/codegen/bytecodeText/argumentOrder/sameOrderWithDefault.kt");
        }
    }
}

