/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.runners;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.runners.AbstractDiagnosticsTestWithJvmIrBackend;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend")
@TestDataPath(value="$PROJECT_ROOT")
public class DiagnosticsTestWithJvmIrBackendGenerated
extends AbstractDiagnosticsTestWithJvmIrBackend {
    @Test
    public void testAllFilesPresentInTestsWithJvmBackend() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
    }

    @Test
    @TestMetadata(value="indirectInlineCycle.kt")
    public void testIndirectInlineCycle() {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/indirectInlineCycle.kt");
    }

    @Test
    @TestMetadata(value="inlineCycle.kt")
    public void testInlineCycle() {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/inlineCycle.kt");
    }

    @Test
    @TestMetadata(value="kt57104.kt")
    public void testKt57104() {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/kt57104.kt");
    }

    @Test
    @TestMetadata(value="kt57104_2.kt")
    public void testKt57104_2() {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/kt57104_2.kt");
    }

    @Test
    @TestMetadata(value="multipleBigArityFunsImplemented.kt")
    public void testMultipleBigArityFunsImplemented() {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/multipleBigArityFunsImplemented.kt");
    }

    @Test
    @TestMetadata(value="noWarningInLV1_5.kt")
    public void testNoWarningInLV1_5() {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/noWarningInLV1_5.kt");
    }

    @Test
    @TestMetadata(value="nothingToOverrideWithRawParameter.kt")
    public void testNothingToOverrideWithRawParameter() {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/nothingToOverrideWithRawParameter.kt");
    }

    @Test
    @TestMetadata(value="propertyInlineCycle.kt")
    public void testPropertyInlineCycle() {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/propertyInlineCycle.kt");
    }

    @Test
    @TestMetadata(value="signatureConflictHiddenByTypeParameter.kt")
    public void testSignatureConflictHiddenByTypeParameter() {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/signatureConflictHiddenByTypeParameter.kt");
    }

    @Test
    @TestMetadata(value="suspendInlineCycle.kt")
    public void testSuspendInlineCycle() {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/suspendInlineCycle.kt");
    }

    @Test
    @TestMetadata(value="suspensionPointInMonitor.kt")
    public void testSuspensionPointInMonitor() {
        this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/suspensionPointInMonitor.kt");
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/valueClasses")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ValueClasses {
        @Test
        public void testAllFilesPresentInValueClasses() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/valueClasses"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="cloneable.kt")
        public void testCloneable() {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/valueClasses/cloneable.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/typeOf")
    @TestDataPath(value="$PROJECT_ROOT")
    public class TypeOf {
        @Test
        public void testAllFilesPresentInTypeOf() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/typeOf"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="nonReifiedTypeParameterWithRecursiveBound.kt")
        public void testNonReifiedTypeParameterWithRecursiveBound() {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/typeOf/nonReifiedTypeParameterWithRecursiveBound.kt");
        }

        @Test
        @TestMetadata(value="suspendType.kt")
        public void testSuspendType() {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/typeOf/suspendType.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/multifileClasses")
    @TestDataPath(value="$PROJECT_ROOT")
    public class MultifileClasses {
        @Test
        public void testAllFilesPresentInMultifileClasses() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/multifileClasses"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="jvmSynthetic.kt")
        public void testJvmSynthetic() {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/multifileClasses/jvmSynthetic.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DuplicateJvmSignature {
        @Test
        public void testAllFilesPresentInDuplicateJvmSignature() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="caseInProperties.kt")
        public void testCaseInProperties() {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/caseInProperties.kt");
        }

        @Test
        @TestMetadata(value="changingNullabilityOfOrdinaryClassIsBinaryCompatibleChange.kt")
        public void testChangingNullabilityOfOrdinaryClassIsBinaryCompatibleChange() {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/changingNullabilityOfOrdinaryClassIsBinaryCompatibleChange.kt");
        }

        @Test
        @TestMetadata(value="vararg.kt")
        public void testVararg() {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/vararg.kt");
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/valueClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ValueClasses {
            @Test
            public void testAllFilesPresentInValueClasses() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/valueClasses"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="changingNullabilityOfOrdinaryClassIsBinaryCompatibleChange.kt")
            public void testChangingNullabilityOfOrdinaryClassIsBinaryCompatibleChange() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/valueClasses/changingNullabilityOfOrdinaryClassIsBinaryCompatibleChange.kt");
            }

            @Test
            @TestMetadata(value="constructorsJvmSignaturesClash.kt")
            public void testConstructorsJvmSignaturesClash() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/valueClasses/constructorsJvmSignaturesClash.kt");
            }

            @Test
            @TestMetadata(value="constructorsJvmSignaturesClashInlineClass.kt")
            public void testConstructorsJvmSignaturesClashInlineClass() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/valueClasses/constructorsJvmSignaturesClashInlineClass.kt");
            }

            @Test
            @TestMetadata(value="declarationClash.kt")
            public void testDeclarationClash() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/valueClasses/declarationClash.kt");
            }

            @Test
            @TestMetadata(value="functionsJvmSignaturesClash.kt")
            public void testFunctionsJvmSignaturesClash() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/valueClasses/functionsJvmSignaturesClash.kt");
            }

            @Test
            @TestMetadata(value="functionsJvmSignaturesClashInlineClass.kt")
            public void testFunctionsJvmSignaturesClashInlineClass() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/valueClasses/functionsJvmSignaturesClashInlineClass.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TraitImpl {
            @Test
            public void testAllFilesPresentInTraitImpl() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="defaultVsNonDefault.kt")
            public void testDefaultVsNonDefault() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/defaultVsNonDefault.kt");
            }

            @Test
            @TestMetadata(value="kt43611.kt")
            public void testKt43611() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/kt43611.kt");
            }

            @Test
            @TestMetadata(value="oneTrait.kt")
            public void testOneTrait() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/oneTrait.kt");
            }

            @Test
            @TestMetadata(value="traitFunctionOverriddenByPropertyInTrait.kt")
            public void testTraitFunctionOverriddenByPropertyInTrait() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/traitFunctionOverriddenByPropertyInTrait.kt");
            }

            @Test
            @TestMetadata(value="traitPropertyOverriddenByFunctionInTrait.kt")
            public void testTraitPropertyOverriddenByFunctionInTrait() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/traitPropertyOverriddenByFunctionInTrait.kt");
            }

            @Test
            @TestMetadata(value="twoTraits.kt")
            public void testTwoTraits() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/traitImpl/twoTraits.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/synthesized")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Synthesized {
            @Test
            public void testAllFilesPresentInSynthesized() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/synthesized"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="enumValuesValueOf.kt")
            public void testEnumValuesValueOf() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/synthesized/enumValuesValueOf.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Statics {
            @Test
            public void testAllFilesPresentInStatics() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="jkjk.kt")
            public void testJkjk() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/jkjk.kt");
            }

            @Test
            @TestMetadata(value="kotlinClassExtendsJavaClass.kt")
            public void testKotlinClassExtendsJavaClass() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinClassExtendsJavaClass.kt");
            }

            @Test
            @TestMetadata(value="kotlinClassExtendsJavaClassExtendsJavaClass.kt")
            public void testKotlinClassExtendsJavaClassExtendsJavaClass() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinClassExtendsJavaClassExtendsJavaClass.kt");
            }

            @Test
            @TestMetadata(value="kotlinClassImplementsJavaInterface.kt")
            public void testKotlinClassImplementsJavaInterface() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinClassImplementsJavaInterface.kt");
            }

            @Test
            @TestMetadata(value="kotlinClassImplementsJavaInterfaceExtendsJavaInteface.kt")
            public void testKotlinClassImplementsJavaInterfaceExtendsJavaInteface() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinClassImplementsJavaInterfaceExtendsJavaInteface.kt");
            }

            @Test
            @TestMetadata(value="kotlinMembersVsJavaNonVisibleStatics.kt")
            public void testKotlinMembersVsJavaNonVisibleStatics() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/statics/kotlinMembersVsJavaNonVisibleStatics.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames")
        @TestDataPath(value="$PROJECT_ROOT")
        public class SpecialNames {
            @Test
            public void testAllFilesPresentInSpecialNames() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="classInitializer.kt")
            public void testClassInitializer() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/classInitializer.kt");
            }

            @Test
            @TestMetadata(value="classObject.kt")
            public void testClassObject() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/classObject.kt");
            }

            @Test
            @TestMetadata(value="classObjectCopiedField.kt")
            public void testClassObjectCopiedField() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/classObjectCopiedField.kt");
            }

            @Test
            @TestMetadata(value="classObjectCopiedFieldObject.kt")
            public void testClassObjectCopiedFieldObject() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/classObjectCopiedFieldObject.kt");
            }

            @Test
            @TestMetadata(value="dataClassCopy.kt")
            public void testDataClassCopy() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/dataClassCopy.kt");
            }

            @Test
            @TestMetadata(value="defaults.kt")
            public void testDefaults() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/defaults.kt");
            }

            @Test
            @TestMetadata(value="delegationBy.kt")
            public void testDelegationBy() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/delegationBy.kt");
            }

            @Test
            @TestMetadata(value="enum.kt")
            public void testEnum() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/enum.kt");
            }

            @Test
            @TestMetadata(value="innerClass.kt")
            public void testInnerClass() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/innerClass.kt");
            }

            @Test
            @TestMetadata(value="innerClassField.kt")
            public void testInnerClassField() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/innerClassField.kt");
            }

            @Test
            @TestMetadata(value="instance.kt")
            public void testInstance() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/instance.kt");
            }

            @Test
            @TestMetadata(value="propertyMetadataCache.kt")
            public void testPropertyMetadataCache() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/specialNames/propertyMetadataCache.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmStatic")
        @TestDataPath(value="$PROJECT_ROOT")
        public class JvmStatic {
            @Test
            public void testAllFilesPresentInJvmStatic() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmStatic"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="jjk.kt")
            public void testJjk() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmStatic/jjk.kt");
            }

            @Test
            @TestMetadata(value="jk.kt")
            public void testJk() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmStatic/jk.kt");
            }

            @Test
            @TestMetadata(value="jkjk.kt")
            public void testJkjk() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmStatic/jkjk.kt");
            }

            @Test
            @TestMetadata(value="jvmStaticInCompanionObject.kt")
            public void testJvmStaticInCompanionObject() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmStatic/jvmStaticInCompanionObject.kt");
            }

            @Test
            @TestMetadata(value="jvmStaticInObject.kt")
            public void testJvmStaticInObject() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmStatic/jvmStaticInObject.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmOverloads")
        @TestDataPath(value="$PROJECT_ROOT")
        public class JvmOverloads {
            @Test
            public void testAllFilesPresentInJvmOverloads() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmOverloads"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="jvmOverloads.kt")
            public void testJvmOverloads() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmOverloads/jvmOverloads.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmName")
        @TestDataPath(value="$PROJECT_ROOT")
        public class JvmName {
            @Test
            public void testAllFilesPresentInJvmName() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmName"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="conflictsWIthJvmNameInClass.kt")
            public void testConflictsWIthJvmNameInClass() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/jvmName/conflictsWIthJvmNameInClass.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop")
        @TestDataPath(value="$PROJECT_ROOT")
        public class JavaInterop {
            @Test
            public void testAllFilesPresentInJavaInterop() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="charAtAndOverload.kt")
            public void testCharAtAndOverload() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/charAtAndOverload.kt");
            }

            @Test
            @TestMetadata(value="charAtAndOverloadWithAbstractGet.kt")
            public void testCharAtAndOverloadWithAbstractGet() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/charAtAndOverloadWithAbstractGet.kt");
            }

            @Test
            @TestMetadata(value="charAtAndOverloadWithAbstractGetAndProxy.kt")
            public void testCharAtAndOverloadWithAbstractGetAndProxy() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/charAtAndOverloadWithAbstractGetAndProxy.kt");
            }

            @Test
            @TestMetadata(value="charAtAndOverloadWithAbstractGetOpenCharAt.kt")
            public void testCharAtAndOverloadWithAbstractGetOpenCharAt() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/charAtAndOverloadWithAbstractGetOpenCharAt.kt");
            }

            @Test
            @TestMetadata(value="charAtAndOverloadWithFinalGet.kt")
            public void testCharAtAndOverloadWithFinalGet() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/charAtAndOverloadWithFinalGet.kt");
            }

            @Test
            @TestMetadata(value="charAtFinalAndOverload.kt")
            public void testCharAtFinalAndOverload() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/charAtFinalAndOverload.kt");
            }

            @Test
            @TestMetadata(value="inheritFromJavaCollectionSubclassWithContainsOverload.kt")
            public void testInheritFromJavaCollectionSubclassWithContainsOverload() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/inheritFromJavaCollectionSubclassWithContainsOverload.kt");
            }

            @Test
            @TestMetadata(value="kjkPropertyAndExtensionProperty.kt")
            public void testKjkPropertyAndExtensionProperty() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/kjkPropertyAndExtensionProperty.kt");
            }

            @Test
            @TestMetadata(value="overridesBuiltinNoMagic.kt")
            public void testOverridesBuiltinNoMagic() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/overridesBuiltinNoMagic.kt");
            }

            @Test
            @TestMetadata(value="supertypeDifferentParameterNullability.kt")
            public void testSupertypeDifferentParameterNullability() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/javaInterop/supertypeDifferentParameterNullability.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/inlineClasses")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InlineClasses {
            @Test
            public void testAllFilesPresentInInlineClasses() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/inlineClasses"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="declarationClash.kt")
            public void testDeclarationClash() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/inlineClasses/declarationClash.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty")
        @TestDataPath(value="$PROJECT_ROOT")
        public class FunctionAndProperty {
            @Test
            public void testAllFilesPresentInFunctionAndProperty() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="class.kt")
            public void testClass() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/class.kt");
            }

            @Test
            @TestMetadata(value="classObject.kt")
            public void testClassObject() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/classObject.kt");
            }

            @Test
            @TestMetadata(value="classPropertyInConstructor.kt")
            public void testClassPropertyInConstructor() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/classPropertyInConstructor.kt");
            }

            @Test
            @TestMetadata(value="extensionFunctionAndNormalFunction.kt")
            public void testExtensionFunctionAndNormalFunction() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/extensionFunctionAndNormalFunction.kt");
            }

            @Test
            @TestMetadata(value="extensionPropertyAndFunction.kt")
            public void testExtensionPropertyAndFunction() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/extensionPropertyAndFunction.kt");
            }

            @Test
            @TestMetadata(value="functionAndSetter.kt")
            public void testFunctionAndSetter() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/functionAndSetter.kt");
            }

            @Test
            @TestMetadata(value="functionAndVar.kt")
            public void testFunctionAndVar() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/functionAndVar.kt");
            }

            @Test
            @TestMetadata(value="localClass.kt")
            public void testLocalClass() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/localClass.kt");
            }

            @Test
            @TestMetadata(value="localClassInClass.kt")
            public void testLocalClassInClass() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/localClassInClass.kt");
            }

            @Test
            @TestMetadata(value="nestedClass.kt")
            public void testNestedClass() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/nestedClass.kt");
            }

            @Test
            @TestMetadata(value="object.kt")
            public void testObject() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/object.kt");
            }

            @Test
            @TestMetadata(value="objectExpression.kt")
            public void testObjectExpression() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/objectExpression.kt");
            }

            @Test
            @TestMetadata(value="objectExpressionInConstructor.kt")
            public void testObjectExpressionInConstructor() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/objectExpressionInConstructor.kt");
            }

            @Test
            @TestMetadata(value="privateClassPropertyNoClash.kt")
            public void testPrivateClassPropertyNoClash() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/privateClassPropertyNoClash.kt");
            }

            @Test
            @TestMetadata(value="topLevel.kt")
            public void testTopLevel() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/topLevel.kt");
            }

            @Test
            @TestMetadata(value="topLevelDifferentFiles.kt")
            public void testTopLevelDifferentFiles() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/topLevelDifferentFiles.kt");
            }

            @Test
            @TestMetadata(value="topLevelGetter.kt")
            public void testTopLevelGetter() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/topLevelGetter.kt");
            }

            @Test
            @TestMetadata(value="trait.kt")
            public void testTrait() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/functionAndProperty/trait.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/finalMembersFromBuiltIns")
        @TestDataPath(value="$PROJECT_ROOT")
        public class FinalMembersFromBuiltIns {
            @Test
            public void testAllFilesPresentInFinalMembersFromBuiltIns() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/finalMembersFromBuiltIns"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="enumMembers.kt")
            public void testEnumMembers() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/finalMembersFromBuiltIns/enumMembers.kt");
            }

            @Test
            @TestMetadata(value="waitNotifyGetClass.kt")
            public void testWaitNotifyGetClass() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/finalMembersFromBuiltIns/waitNotifyGetClass.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Erasure {
            @Test
            public void testAllFilesPresentInErasure() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="clashFromInterfaceAndSuperClass.kt")
            public void testClashFromInterfaceAndSuperClass() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/clashFromInterfaceAndSuperClass.kt");
            }

            @Test
            @TestMetadata(value="collections.kt")
            public void testCollections() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/collections.kt");
            }

            @Test
            @TestMetadata(value="delegateToTwoTraits.kt")
            public void testDelegateToTwoTraits() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/delegateToTwoTraits.kt");
            }

            @Test
            @TestMetadata(value="delegationAndOwnMethod.kt")
            public void testDelegationAndOwnMethod() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/delegationAndOwnMethod.kt");
            }

            @Test
            @TestMetadata(value="delegationToTraitImplAndOwnMethod.kt")
            public void testDelegationToTraitImplAndOwnMethod() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/delegationToTraitImplAndOwnMethod.kt");
            }

            @Test
            @TestMetadata(value="differentTypeParameterLists.kt")
            public void testDifferentTypeParameterLists() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/differentTypeParameterLists.kt");
            }

            @Test
            @TestMetadata(value="extensionProperties.kt")
            public void testExtensionProperties() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/extensionProperties.kt");
            }

            @Test
            @TestMetadata(value="genericFunctions.kt")
            public void testGenericFunctions() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/genericFunctions.kt");
            }

            @Test
            @TestMetadata(value="genericType.kt")
            public void testGenericType() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/genericType.kt");
            }

            @Test
            @TestMetadata(value="inheritFromTwoTraits.kt")
            public void testInheritFromTwoTraits() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/inheritFromTwoTraits.kt");
            }

            @Test
            @TestMetadata(value="inheritGenericMethodsWithDifferentSubstitution.kt")
            public void testInheritGenericMethodsWithDifferentSubstitution() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/inheritGenericMethodsWithDifferentSubstitution.kt");
            }

            @Test
            @TestMetadata(value="kotlinAndJavaCollections.kt")
            public void testKotlinAndJavaCollections() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/kotlinAndJavaCollections.kt");
            }

            @Test
            @TestMetadata(value="nullableType.kt")
            public void testNullableType() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/nullableType.kt");
            }

            @Test
            @TestMetadata(value="superTraitAndDelegationToTraitImpl.kt")
            public void testSuperTraitAndDelegationToTraitImpl() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/superTraitAndDelegationToTraitImpl.kt");
            }

            @Test
            @TestMetadata(value="twoTraitsAndOwnFunction.kt")
            public void testTwoTraitsAndOwnFunction() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/twoTraitsAndOwnFunction.kt");
            }

            @Test
            @TestMetadata(value="typeMappedToJava.kt")
            public void testTypeMappedToJava() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeMappedToJava.kt");
            }

            @Test
            @TestMetadata(value="typeParameter.kt")
            public void testTypeParameter() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeParameter.kt");
            }

            @Test
            @TestMetadata(value="typeParameterWithBound.kt")
            public void testTypeParameterWithBound() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeParameterWithBound.kt");
            }

            @Test
            @TestMetadata(value="typeParameterWithTwoBounds.kt")
            public void testTypeParameterWithTwoBounds() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeParameterWithTwoBounds.kt");
            }

            @Test
            @TestMetadata(value="typeParameterWithTwoBoundsInWhere.kt")
            public void testTypeParameterWithTwoBoundsInWhere() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/erasure/typeParameterWithTwoBoundsInWhere.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/commonAtomicTypes")
        @TestDataPath(value="$PROJECT_ROOT")
        public class CommonAtomicTypes {
            @Test
            public void testAllFilesPresentInCommonAtomicTypes() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/commonAtomicTypes"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="intersectionWithExplicitOverride.kt")
            public void testIntersectionWithExplicitOverride() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/commonAtomicTypes/intersectionWithExplicitOverride.kt");
            }

            @Test
            @TestMetadata(value="KJKHierarchy.kt")
            public void testKJKHierarchy() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/commonAtomicTypes/KJKHierarchy.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Bridges {
            @Test
            public void testAllFilesPresentInBridges() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="class.kt")
            public void testClass() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges/class.kt");
            }

            @Test
            @TestMetadata(value="fakeOverrideTrait.kt")
            public void testFakeOverrideTrait() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges/fakeOverrideTrait.kt");
            }

            @Test
            @TestMetadata(value="trait.kt")
            public void testTrait() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/bridges/trait.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides")
        @TestDataPath(value="$PROJECT_ROOT")
        public class AccidentalOverrides {
            @Test
            @TestMetadata(value="accidentalOverrideFromGrandparent.kt")
            public void testAccidentalOverrideFromGrandparent() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/accidentalOverrideFromGrandparent.kt");
            }

            @Test
            public void testAllFilesPresentInAccidentalOverrides() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
            }

            @Test
            @TestMetadata(value="classFunctionOverriddenByProperty.kt")
            public void testClassFunctionOverriddenByProperty() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByProperty.kt");
            }

            @Test
            @TestMetadata(value="classFunctionOverriddenByPropertyInConstructor.kt")
            public void testClassFunctionOverriddenByPropertyInConstructor() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByPropertyInConstructor.kt");
            }

            @Test
            @TestMetadata(value="classFunctionOverriddenByPropertyNoGetter.kt")
            public void testClassFunctionOverriddenByPropertyNoGetter() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/classFunctionOverriddenByPropertyNoGetter.kt");
            }

            @Test
            @TestMetadata(value="classPropertyOverriddenByFunction.kt")
            public void testClassPropertyOverriddenByFunction() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/classPropertyOverriddenByFunction.kt");
            }

            @Test
            @TestMetadata(value="defaultFunction.kt")
            public void testDefaultFunction() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/defaultFunction.kt");
            }

            @Test
            @TestMetadata(value="delegatedFunctionOverriddenByProperty.kt")
            public void testDelegatedFunctionOverriddenByProperty() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/delegatedFunctionOverriddenByProperty.kt");
            }

            @Test
            @TestMetadata(value="genericClassFunction.kt")
            public void testGenericClassFunction() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/genericClassFunction.kt");
            }

            @Test
            @TestMetadata(value="overridesNothing.kt")
            public void testOverridesNothing() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/overridesNothing.kt");
            }

            @Test
            @TestMetadata(value="privateClassFunctionOverriddenByProperty.kt")
            public void testPrivateClassFunctionOverriddenByProperty() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/privateClassFunctionOverriddenByProperty.kt");
            }

            @Test
            @TestMetadata(value="traitFunctionOverriddenByProperty.kt")
            public void testTraitFunctionOverriddenByProperty() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/traitFunctionOverriddenByProperty.kt");
            }

            @Test
            @TestMetadata(value="traitFunctionOverriddenByPropertyNoImpl.kt")
            public void testTraitFunctionOverriddenByPropertyNoImpl() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/traitFunctionOverriddenByPropertyNoImpl.kt");
            }

            @Test
            @TestMetadata(value="traitPropertyOverriddenByFunction.kt")
            public void testTraitPropertyOverriddenByFunction() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/traitPropertyOverriddenByFunction.kt");
            }

            @Test
            @TestMetadata(value="traitPropertyOverriddenByFunctionNoImpl.kt")
            public void testTraitPropertyOverriddenByFunctionNoImpl() {
                DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/duplicateJvmSignature/accidentalOverrides/traitPropertyOverriddenByFunctionNoImpl.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/contextReceivers")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ContextReceivers {
        @Test
        public void testAllFilesPresentInContextReceivers() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/contextReceivers"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="kt59590.kt")
        public void testKt59590() {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/contextReceivers/kt59590.kt");
        }

        @Test
        @TestMetadata(value="kt59590WithContextReceiver.kt")
        public void testKt59590WithContextReceiver() {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/contextReceivers/kt59590WithContextReceiver.kt");
        }
    }

    @Nested
    @TestMetadata(value="compiler/testData/diagnostics/testsWithJvmBackend/contextParameters")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ContextParameters {
        @Test
        public void testAllFilesPresentInContextParameters() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), new File("compiler/testData/diagnostics/testsWithJvmBackend/contextParameters"), Pattern.compile("^(.+)\\.kts?$"), Pattern.compile("^(.+)\\.(reversed|fir|ll|latestLV)\\.kts?$"), TargetBackend.JVM_IR, true, new String[0]);
        }

        @Test
        @TestMetadata(value="extensionAndContextParameters.kt")
        public void testExtensionAndContextParameters() {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/contextParameters/extensionAndContextParameters.kt");
        }

        @Test
        @TestMetadata(value="intersectionContextValueJava.kt")
        public void testIntersectionContextValueJava() {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/contextParameters/intersectionContextValueJava.kt");
        }

        @Test
        @TestMetadata(value="intersectionExtensionValueContext.kt")
        public void testIntersectionExtensionValueContext() {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/contextParameters/intersectionExtensionValueContext.kt");
        }

        @Test
        @TestMetadata(value="intersectionExtensionValueContextJava.kt")
        public void testIntersectionExtensionValueContextJava() {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/contextParameters/intersectionExtensionValueContextJava.kt");
        }

        @Test
        @TestMetadata(value="valueAndContextParameter.kt")
        public void testValueAndContextParameter() {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/contextParameters/valueAndContextParameter.kt");
        }

        @Test
        @TestMetadata(value="valueAndContextParametersWithJava.kt")
        public void testValueAndContextParametersWithJava() {
            DiagnosticsTestWithJvmIrBackendGenerated.this.runTest("compiler/testData/diagnostics/testsWithJvmBackend/contextParameters/valueAndContextParametersWithJava.kt");
        }
    }
}

