/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.CompilerTestUtil;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.backend.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.test.cli.CliDirectives;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.AssertionsService;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.MessageCollectorForCompilerTests;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0016J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/NonSourceErrorMessagesHandler;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "check", "", "failedAssertions", "Lorg/jetbrains/kotlin/test/WrappedException;", "resultingDump", "", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nNonSourceErrorMessagesHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonSourceErrorMessagesHandler.kt\norg/jetbrains/kotlin/test/frontend/fir/handlers/NonSourceErrorMessagesHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1563#2:79\n1634#2,3:80\n774#2:83\n865#2,2:84\n*S KotlinDebug\n*F\n+ 1 NonSourceErrorMessagesHandler.kt\norg/jetbrains/kotlin/test/frontend/fir/handlers/NonSourceErrorMessagesHandler\n*L\n37#1:79\n37#1:80,3\n41#1:83\n41#1:84,2\n*E\n"})
public final class NonSourceErrorMessagesHandler
extends AfterAnalysisChecker {
    public NonSourceErrorMessagesHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)CodegenTestDirectives.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull List<? extends WrappedException> failedAssertions) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        if (!TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(CliDirectives.INSTANCE.getCHECK_COMPILER_OUTPUT())) {
            return;
        }
        Iterable $this$map$iv = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void module;
            TestModule testModule = (TestModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CompilerConfiguration configuration2 = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.getTestServices()).getCompilerConfiguration((TestModule)module);
            MessageCollector messageCollector = CommonConfigurationKeysKt.getMessageCollector((CompilerConfiguration)configuration2);
            Intrinsics.checkNotNull((Object)messageCollector, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.test.utils.MessageCollectorForCompilerTests");
            MessageCollectorForCompilerTests messageCollector2 = (MessageCollectorForCompilerTests)messageCollector;
            collection.add(CollectionsKt.joinToString$default((Iterable)messageCollector2.getNonSourceMessages(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String dump = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        this.check(dump);
    }

    public final void check(@NotNull String resultingDump) {
        Intrinsics.checkNotNullParameter((Object)resultingDump, (String)"resultingDump");
        File sourceFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        File defaultOutFile = FileUtilsKt.withExtension(sourceFile, ".cli.out");
        File firOutFile = FileUtilsKt.withExtension(sourceFile, ".cli.fir.out");
        boolean isFir = Intrinsics.areEqual(DefaultsProviderKt.getDefaultsProvider(this.getTestServices()).getFrontendKind(), (Object)FrontendKinds.FIR.INSTANCE);
        File outFile = isFir && firOutFile.exists() ? firOutFile : defaultOutFile;
        AssertionsService assertions = AssertionsKt.getAssertions(this.getTestServices());
        if (((CharSequence)resultingDump).length() == 0) {
            if (Intrinsics.areEqual((Object)outFile, (Object)firOutFile) || defaultOutFile.exists()) {
                Assertions.assertEqualsToFile$default((Assertions)assertions, firOutFile, "", null, 4, null);
            } else {
                HandlerUtilsKt.assertFileDoesntExist(assertions, outFile, CliDirectives.INSTANCE.getCHECK_COMPILER_OUTPUT());
            }
            return;
        }
        String string = TemporaryDirectoryManagerKt.getTemporaryDirectoryManager(this.getTestServices()).getRootDir().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String actualOutput = CompilerTestUtil.normalizeCompilerOutput(resultingDump, string);
        Assertions.assertEqualsToFile$default((Assertions)assertions, outFile, actualOutput, null, 4, null);
        if (!Intrinsics.areEqual((Object)outFile, (Object)defaultOutFile) && Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)outFile, null, (int)1, null))).toString(), (Object)((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)defaultOutFile, null, (int)1, null))).toString())) {
            assertions.fail((Function0<String>)((Function0)() -> NonSourceErrorMessagesHandler.check$lambda$2(outFile)));
            throw new KotlinNothingValueException();
        }
    }

    private static final String check$lambda$2(File $outFile) {
        return "Classic and FIR golden files are identical. Remove " + $outFile + '.';
    }
}

