/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.utils.IrElementsCreationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifact;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputPartForDependsOnModule;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirAnalysisHandler;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirVFirDumpHandler;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "dumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/frontend/fir/FirOutputArtifact;", "processAfterAllModules", "someAssertionWasFailed", "", "FirVerboseRenderer", "FirVerbosePrinter", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nFirVFirDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirVFirDumpHandler.kt\norg/jetbrains/kotlin/test/frontend/fir/handlers/FirVFirDumpHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n1869#2,2:103\n*S KotlinDebug\n*F\n+ 1 FirVFirDumpHandler.kt\norg/jetbrains/kotlin/test/frontend/fir/handlers/FirVFirDumpHandler\n*L\n40#1:103,2\n*E\n"})
public final class FirVFirDumpHandler
extends FirAnalysisHandler {
    @NotNull
    private final MultiModuleInfoDumper dumper;

    public FirVFirDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, false, 6, null);
        this.dumper = new MultiModuleInfoDumper(null, 1, null);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull FirOutputArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        for (FirOutputPartForDependsOnModule part : info.getPartsForDependsOnModules()) {
            List list;
            TestModule currentModule = part.getModule();
            if (!currentModule.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getDUMP_VFIR())) {
                return;
            }
            StringBuilder builderForModule = this.dumper.builderForModule(currentModule);
            Map<TestFile, FirFile> firFiles = info.getMainFirFiles();
            List $this$processModule_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$processModule_u24lambda_u240.addAll(firFiles.values());
            $this$processModule_u24lambda_u240.addAll(IrElementsCreationUtilsKt.createFilesWithGeneratedDeclarations((FirSession)part.getSession()));
            List allFiles = CollectionsKt.build((List)list);
            FirLazyDeclarationResolverKt.getLazyDeclarationResolver((FirSession)part.getSession()).startResolvingPhase(FirResolvePhase.BODY_RESOLVE);
            FirVerboseRenderer renderer = new FirVerboseRenderer(new FirVerbosePrinter(builderForModule));
            Iterable $this$forEach$iv = allFiles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirFile it = (FirFile)element$iv;
                boolean bl2 = false;
                it.accept((FirVisitorVoid)renderer);
            }
            FirLazyDeclarationResolverKt.getLazyDeclarationResolver((FirSession)part.getSession()).finishResolvingPhase(FirResolvePhase.BODY_RESOLVE);
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        File file = testDataFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        File expectedFile = FilesKt.resolve((File)file, (String)(this.getNameWithoutFirExtension(testDataFile) + ".vfir.txt"));
        if (this.dumper.isEmpty()) {
            HandlerUtilsKt.assertFileDoesntExist(this.getAssertions(), expectedFile, FirDiagnosticsDirectives.INSTANCE.getDUMP_VFIR());
        } else {
            String actualText = this.dumper.generateResultingDump();
            Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile, actualText, null, FirVFirDumpHandler::processAfterAllModules$lambda$2, 4, null);
        }
    }

    private static final String processAfterAllModules$lambda$2() {
        return "Content is not equal";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\u00020\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u000eR\u0012\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirVFirDumpHandler$FirVerbosePrinter;", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "<init>", "(Ljava/lang/StringBuilder;)V", "indentation", "", "print", "", "text", "", "printIndented", "Lkotlin/Function0;", "tests-common-new_test"})
    private static final class FirVerbosePrinter {
        @NotNull
        private final StringBuilder builder;
        private int indentation;

        public FirVerbosePrinter(@NotNull StringBuilder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            this.builder = builder;
        }

        public final void print(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.builder.append(StringsKt.repeat((CharSequence)" ", (int)this.indentation));
            this.builder.append(text);
            this.builder.append("\n");
        }

        public final void printIndented(@NotNull Function0<Unit> print) {
            Intrinsics.checkNotNullParameter(print, (String)"print");
            ++this.indentation;
            print.invoke();
            --this.indentation;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirVFirDumpHandler$FirVerboseRenderer;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "printer", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirVFirDumpHandler$FirVerbosePrinter;", "<init>", "(Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirVFirDumpHandler$FirVerbosePrinter;)V", "visitElement", "", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "renderInDetailsSection", "render", "Lkotlin/Function0;", "renderInChildrenSection", "tests-common-new_test"})
    private static final class FirVerboseRenderer
    extends FirVisitorVoid {
        @NotNull
        private final FirVerbosePrinter printer;

        public FirVerboseRenderer(@NotNull FirVerbosePrinter printer) {
            Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
            this.printer = printer;
        }

        public void visitElement(@NotNull FirElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String string = element.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            this.printer.print(string);
            this.renderInChildrenSection((Function0<Unit>)((Function0)() -> FirVerboseRenderer.visitElement$lambda$0(element, this)));
        }

        public void visitBlock(@NotNull FirBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            String string = block.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
            this.printer.print(string);
            this.renderInDetailsSection((Function0<Unit>)((Function0)() -> FirVerboseRenderer.visitBlock$lambda$1(this, block)));
            this.renderInChildrenSection((Function0<Unit>)((Function0)() -> FirVerboseRenderer.visitBlock$lambda$2(block, this)));
        }

        private final void renderInDetailsSection(Function0<Unit> render) {
            this.printer.print("{");
            this.printer.printIndented((Function0<Unit>)((Function0)() -> FirVerboseRenderer.renderInDetailsSection$lambda$3(render)));
            this.printer.print("}");
        }

        private final void renderInChildrenSection(Function0<Unit> render) {
            this.printer.printIndented((Function0<Unit>)((Function0)() -> FirVerboseRenderer.renderInChildrenSection$lambda$4(render)));
        }

        private static final Unit visitElement$lambda$0(FirElement $element, FirVerboseRenderer this$0) {
            $element.acceptChildren((FirVisitorVoid)this$0);
            return Unit.INSTANCE;
        }

        private static final Unit visitBlock$lambda$1(FirVerboseRenderer this$0, FirBlock $block) {
            FirVerbosePrinter firVerbosePrinter = this$0.printer;
            StringBuilder stringBuilder = new StringBuilder().append("source.kind: ");
            KtSourceElement ktSourceElement = $block.getSource();
            Intrinsics.checkNotNull((Object)ktSourceElement);
            firVerbosePrinter.print(stringBuilder.append(ktSourceElement.getKind().getClass().getSimpleName()).toString());
            return Unit.INSTANCE;
        }

        private static final Unit visitBlock$lambda$2(FirBlock $block, FirVerboseRenderer this$0) {
            $block.acceptChildren((FirVisitorVoid)this$0);
            return Unit.INSTANCE;
        }

        private static final Unit renderInDetailsSection$lambda$3(Function0 $render) {
            $render.invoke();
            return Unit.INSTANCE;
        }

        private static final Unit renderInChildrenSection$lambda$4(Function0 $render) {
            $render.invoke();
            return Unit.INSTANCE;
        }
    }
}

