/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphRenderOptions;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphRendererKt;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifact;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirAnalysisHandler;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FirIdenticalCheckerHelper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000fH\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00060\fj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirCfgDumpHandler;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "alreadyDumped", "", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/frontend/fir/FirOutputArtifact;", "processAfterAllModules", "someAssertionWasFailed", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nFirCfgDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirCfgDumpHandler.kt\norg/jetbrains/kotlin/test/frontend/fir/handlers/FirCfgDumpHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1563#2:78\n1634#2,3:79\n1#3:82\n*S KotlinDebug\n*F\n+ 1 FirCfgDumpHandler.kt\norg/jetbrains/kotlin/test/frontend/fir/handlers/FirCfgDumpHandler\n*L\n33#1:78\n33#1:79,3\n*E\n"})
public final class FirCfgDumpHandler
extends FirAnalysisHandler {
    @NotNull
    private final StringBuilder builder;
    private boolean alreadyDumped;

    public FirCfgDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, false, 6, null);
        this.builder = new StringBuilder();
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)FirDiagnosticsDirectives.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processModule(@NotNull TestModule module, @NotNull FirOutputArtifact info) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (this.alreadyDumped || !module.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getDUMP_CFG())) {
            return;
        }
        Iterable $this$map$iv = module.getDirectives().get(FirDiagnosticsDirectives.INSTANCE.getDUMP_CFG());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            collection.add(string2);
        }
        List options = (List)destination$iv$iv;
        FirFile file = (FirFile)CollectionsKt.first((Iterable)info.getMainFirFiles().values());
        boolean renderLevels = options.contains("LEVELS");
        boolean renderFlow = options.contains("FLOW");
        ControlFlowGraphRendererKt.renderControlFlowGraphTo((FirElement)((FirElement)file), (StringBuilder)this.builder, (ControlFlowGraphRenderOptions)new ControlFlowGraphRenderOptions(renderLevels, renderFlow, null, 4, null));
        this.alreadyDumped = true;
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        File expectedFile;
        File file;
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        String nameWithoutExtension = this.getNameWithoutFirExtension(testDataFile);
        File file2 = testDataFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getParentFile(...)");
        File basicExpectedFile = FilesKt.resolve((File)file2, (String)(nameWithoutExtension + ".dot"));
        if (TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getUSE_LATEST_LANGUAGE_VERSION())) {
            File file3;
            File file4 = testDataFile.getParentFile();
            Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"getParentFile(...)");
            File it = file3 = FilesKt.resolve((File)file4, (String)(nameWithoutExtension + ".latestLV.dot"));
            boolean bl = false;
            file = it.exists() ? file3 : null;
            if (file == null) {
                file = basicExpectedFile;
            }
        } else {
            file = expectedFile = basicExpectedFile;
        }
        if (!this.alreadyDumped) {
            HandlerUtilsKt.assertFileDoesntExist(this.getAssertions(), expectedFile, FirDiagnosticsDirectives.INSTANCE.getDUMP_CFG());
        } else {
            Assertions assertions = this.getAssertions();
            String string = this.builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            Assertions.assertEqualsToFile$default(assertions, expectedFile, string, null, 4, null);
        }
        if (!Intrinsics.areEqual((Object)basicExpectedFile, (Object)expectedFile) && Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)basicExpectedFile, null, (int)1, null))).toString(), (Object)((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)expectedFile, null, (int)1, null))).toString())) {
            if (!FirIdenticalCheckerHelper.Companion.isTeamCityBuild()) {
                expectedFile.delete();
            }
            String message = FirIdenticalCheckerHelper.Companion.isTeamCityBuild() ? "Please remove `" + expectedFile.getPath() + '`' : "Deleted `" + expectedFile.getPath() + '`';
            AssertionsKt.getAssertions(this.getTestServices()).fail((Function0<String>)((Function0)() -> FirCfgDumpHandler.processAfterAllModules$lambda$2(message)));
            throw new KotlinNothingValueException();
        }
    }

    private static final String processAfterAllModules$lambda$2(String $message) {
        return $message + "\nPlease re-run the test";
    }
}

