/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.directives.model;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.StringDirective;
import org.jetbrains.kotlin.test.directives.model.ValueDirective;
import org.jetbrains.kotlin.test.util.StringUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a4\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n\u001a\u0012\u0010\u000b\u001a\u00020\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e\u001a\u0014\u0010\u000f\u001a\u0004\u0018\u00010\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e\u001a\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e\u001a'\u0010\u000b\u001a\u0002H\u0012\"\b\b\u0000\u0010\u0012*\u00020\u0013*\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014\u00a2\u0006\u0002\u0010\u0015\u001a)\u0010\u000f\u001a\u0004\u0018\u0001H\u0012\"\b\b\u0000\u0010\u0012*\u00020\u0013*\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014\u00a2\u0006\u0002\u0010\u0015\u001a(\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0011\"\b\b\u0000\u0010\u0012*\u00020\u0013*\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014\u00a8\u0006\u0016"}, d2={"suppressIf", "", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "suppressionDirective", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "filter", "Lkotlin/Function1;", "", "", "action", "Lkotlin/Function0;", "singleValue", "", "directive", "Lorg/jetbrains/kotlin/test/directives/model/StringDirective;", "singleOrZeroValue", "notEmptyValues", "", "T", "", "Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;", "(Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;)Ljava/lang/Object;", "test-infrastructure_test"})
public final class DirectiveKt {
    public static final void suppressIf(@NotNull RegisteredDirectives $this$suppressIf, @NotNull Directive suppressionDirective, @NotNull Function1<? super Throwable, Boolean> filter, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$suppressIf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)suppressionDirective, (String)"suppressionDirective");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        boolean hasSuppressionDirective = $this$suppressIf.contains(suppressionDirective);
        Throwable exception = null;
        try {
            action.invoke();
        }
        catch (Throwable e) {
            exception = e;
        }
        if (exception != null) {
            if (!((Boolean)filter.invoke((Object)exception)).booleanValue() || !hasSuppressionDirective) {
                throw exception;
            }
            return;
        }
        if (hasSuppressionDirective) {
            throw new AssertionError((Object)('\'' + suppressionDirective.getName() + "' directive present but no exception thrown. Please remove directive"));
        }
    }

    @NotNull
    public static final String singleValue(@NotNull RegisteredDirectives $this$singleValue, @NotNull StringDirective directive) {
        Intrinsics.checkNotNullParameter((Object)$this$singleValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        String string = DirectiveKt.singleOrZeroValue($this$singleValue, directive);
        if (string == null) {
            throw new IllegalStateException(("No values passed to " + directive).toString());
        }
        return string;
    }

    @Nullable
    public static final String singleOrZeroValue(@NotNull RegisteredDirectives $this$singleOrZeroValue, @NotNull StringDirective directive) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$singleOrZeroValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        List<String> values = $this$singleOrZeroValue.get(directive);
        switch (values.size()) {
            case 0: {
                string = null;
                break;
            }
            case 1: {
                string = (String)CollectionsKt.single(values);
                break;
            }
            default: {
                throw new IllegalStateException(("Too many values passed to " + directive).toString());
            }
        }
        return string;
    }

    @NotNull
    public static final List<String> notEmptyValues(@NotNull RegisteredDirectives $this$notEmptyValues, @NotNull StringDirective directive) {
        Intrinsics.checkNotNullParameter((Object)$this$notEmptyValues, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        Collection collection = $this$notEmptyValues.get(directive);
        if (collection.isEmpty()) {
            boolean bl = false;
            throw new IllegalStateException(("No values passed to " + directive).toString());
        }
        return (List)collection;
    }

    @NotNull
    public static final <T> T singleValue(@NotNull RegisteredDirectives $this$singleValue, @NotNull ValueDirective<T> directive) {
        Intrinsics.checkNotNullParameter((Object)$this$singleValue, (String)"<this>");
        Intrinsics.checkNotNullParameter(directive, (String)"directive");
        T t = DirectiveKt.singleOrZeroValue($this$singleValue, directive);
        if (t == null) {
            throw new IllegalStateException(("No values passed to " + directive).toString());
        }
        return t;
    }

    @Nullable
    public static final <T> T singleOrZeroValue(@NotNull RegisteredDirectives $this$singleOrZeroValue, @NotNull ValueDirective<T> directive) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$singleOrZeroValue, (String)"<this>");
        Intrinsics.checkNotNullParameter(directive, (String)"directive");
        List<T> values = $this$singleOrZeroValue.get(directive);
        switch (values.size()) {
            case 0: {
                object = null;
                break;
            }
            case 1: {
                object = CollectionsKt.single(values);
                break;
            }
            default: {
                throw new IllegalStateException(("Too many values passed to " + directive + ": " + StringUtilsKt.joinToArrayString((Iterable)values)).toString());
            }
        }
        return (T)object;
    }

    @NotNull
    public static final <T> List<T> notEmptyValues(@NotNull RegisteredDirectives $this$notEmptyValues, @NotNull ValueDirective<T> directive) {
        Intrinsics.checkNotNullParameter((Object)$this$notEmptyValues, (String)"<this>");
        Intrinsics.checkNotNullParameter(directive, (String)"directive");
        Collection collection = $this$notEmptyValues.get(directive);
        if (collection.isEmpty()) {
            boolean bl = false;
            throw new IllegalStateException(("No values passed to " + directive).toString());
        }
        return (List)collection;
    }
}

