/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.ir;

import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtPsiSourceFile;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.backend.common.BackendException;
import org.jetbrains.kotlin.backend.jvm.MultifileFacadeFileEntry;
import org.jetbrains.kotlin.backend.jvm.lower.FileClassLoweringKt;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.PsiIrFileEntry;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.util.NaiveSourceBasedFileEntryImpl;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.backend.ir.IrBackendFacade;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.java.JavaCompilerFacade;
import org.jetbrains.kotlin.test.model.ArtifactKinds;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.SourceFileInfo;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH$J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/test/backend/ir/AbstractJvmIrBackendFacade;", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendFacade;", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "javaCompilerFacade", "Lorg/jetbrains/kotlin/test/java/JavaCompilerFacade;", "produceGenerationState", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "inputArtifact", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "sourceFiles", "", "Lorg/jetbrains/kotlin/KtSourceFile;", "getSourceFiles", "(Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;)Ljava/util/Collection;", "transform", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nJvmIrBackendFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmIrBackendFacade.kt\norg/jetbrains/kotlin/test/backend/ir/AbstractJvmIrBackendFacade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1374#2:104\n1460#2,5:105\n1374#2:111\n1460#2,5:112\n1#3:110\n*S KotlinDebug\n*F\n+ 1 JvmIrBackendFacade.kt\norg/jetbrains/kotlin/test/backend/ir/AbstractJvmIrBackendFacade\n*L\n83#1:104\n83#1:105,5\n74#1:111\n74#1:112,5\n*E\n"})
public abstract class AbstractJvmIrBackendFacade
extends IrBackendFacade<BinaryArtifacts.Jvm> {
    @NotNull
    private final JavaCompilerFacade javaCompilerFacade;

    public AbstractJvmIrBackendFacade(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, ArtifactKinds.Jvm.INSTANCE);
        this.javaCompilerFacade = new JavaCompilerFacade(testServices);
    }

    @Nullable
    protected abstract GenerationState produceGenerationState(@NotNull IrBackendInput var1);

    @NotNull
    protected abstract Collection<KtSourceFile> getSourceFiles(@NotNull IrBackendInput var1);

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public BinaryArtifacts.Jvm transform(@NotNull TestModule module, @NotNull IrBackendInput inputArtifact) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object configuration2;
        GenerationState generationState;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)inputArtifact, (String)"inputArtifact");
        try {
            generationState = this.produceGenerationState(inputArtifact);
        }
        catch (BackendException e) {
            if (module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getIGNORE_ERRORS())) {
                return null;
            }
            throw e;
        }
        GenerationState generationState2 = generationState;
        if (generationState2 == null) {
            return null;
        }
        GenerationState state = generationState2;
        if (!module.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getDISABLE_JAVA_FACADE())) {
            configuration2 = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.getTestServices()).getCompilerConfiguration(module);
            this.javaCompilerFacade.compileJavaFiles(module, (CompilerConfiguration)configuration2, state.getFactory());
        }
        configuration2 = inputArtifact.getIrModuleFragment().getFiles();
        ClassFileFactory classFileFactory = state.getFactory();
        boolean $i$f$flatMap = false;
        void e = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrFile it = (IrFile)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = AbstractJvmIrBackendFacade.transform$sourceFileInfos(this, inputArtifact, it, true);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection collection = (List)destination$iv$iv;
        ClassFileFactory classFileFactory2 = classFileFactory;
        return new BinaryArtifacts.Jvm(classFileFactory2, collection);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<SourceFileInfo> transform$sourceFileInfos(AbstractJvmIrBackendFacade this$0, IrBackendInput $inputArtifact, IrFile irFile, boolean allowNestedMultifileFacades) {
        List list;
        IrFileEntry fileEntry = irFile.getFileEntry();
        if (fileEntry instanceof PsiIrFileEntry) {
            KtSourceFile ktSourceFile = (KtSourceFile)new KtPsiSourceFile(((PsiIrFileEntry)fileEntry).getPsiFile());
            PsiFile psiFile = ((PsiIrFileEntry)fileEntry).getPsiFile();
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
            list = CollectionsKt.listOf((Object)new SourceFileInfo(ktSourceFile, JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)((KtFile)psiFile))));
        } else if (fileEntry instanceof NaiveSourceBasedFileEntryImpl) {
            Object v3;
            block9: {
                Iterable iterable = this$0.getSourceFiles($inputArtifact);
                for (Object t : iterable) {
                    KtSourceFile it = (KtSourceFile)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getPath(), (Object)((NaiveSourceBasedFileEntryImpl)fileEntry).getName())) continue;
                    v3 = t;
                    break block9;
                }
                v3 = null;
            }
            KtSourceFile sourceFile = v3;
            list = sourceFile == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)new SourceFileInfo(sourceFile, FileClassLoweringKt.getFileClassInfoFromIrFile((IrFile)irFile, (String)sourceFile.getName())));
        } else if (fileEntry instanceof MultifileFacadeFileEntry) {
            void $this$flatMapTo$iv$iv;
            if (!allowNestedMultifileFacades) {
                throw new IllegalStateException("nested multi-file facades are not allowed".toString());
            }
            Iterable $this$flatMap$iv = ((MultifileFacadeFileEntry)fileEntry).getPartFiles();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                IrFile it = (IrFile)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = AbstractJvmIrBackendFacade.transform$sourceFileInfos(this$0, $inputArtifact, it, false);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            throw new IllegalStateException(("unknown kind of file entry: " + fileEntry).toString());
        }
        return list;
    }
}

