/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.signature.PublicIdSignatureComputer;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithVisibility;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.overrides.IrVisibilityUtilKt;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeOptions;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IdSignatureRendererKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.AbstractIrHandler;
import org.jetbrains.kotlin.test.backend.handlers.FlagsFilterImpl;
import org.jetbrains.kotlin.test.backend.handlers.IrTextDumpHandler;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.directives.KlibBasedCompilerTestDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.TemporaryDirectoryManagerKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/SerializedIrDumpHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/AbstractIrHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "isAfterDeserialization", "", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Z)V", "dumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "processAfterAllModules", "someAssertionWasFailed", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nSerializedIrDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerializedIrDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/SerializedIrDumpHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,381:1\n1056#2:382\n1761#2,3:383\n231#3:386\n1#4:387\n*S KotlinDebug\n*F\n+ 1 SerializedIrDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/SerializedIrDumpHandler\n*L\n259#1:382\n269#1:383,3\n241#1:386\n*E\n"})
public final class SerializedIrDumpHandler
extends AbstractIrHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isAfterDeserialization;
    @NotNull
    private final MultiModuleInfoDumper dumper;

    public SerializedIrDumpHandler(@NotNull TestServices testServices, boolean isAfterDeserialization) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, null, false, false, 14, null);
        this.isAfterDeserialization = isAfterDeserialization;
        this.dumper = new MultiModuleInfoDumper(null, 1, null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)KlibBasedCompilerTestDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull IrBackendInput info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (SerializedIrDumpHandler.Companion.isSkipped(module)) {
            return;
        }
        boolean isFirFrontend = Intrinsics.areEqual(DefaultsProviderKt.getDefaultsProvider(this.getTestServices()).getFrontendKind(), (Object)FrontendKinds.FIR.INSTANCE);
        PublicIdSignatureComputer signatureComputer = new PublicIdSignatureComputer(info.getIrMangler());
        boolean bl = this.isAfterDeserialization;
        FlagsFilterImpl flagsFilterImpl = new FlagsFilterImpl(this.isAfterDeserialization);
        boolean bl2 = this.isAfterDeserialization;
        Name name = StandardNames.DEFAULT_VALUE_PARAMETER;
        DumpIrTreeOptions.ReferenceRenderingStrategy.Custom custom = arg_0 -> SerializedIrDumpHandler.processModule$lambda$2(signatureComputer, arg_0);
        DumpIrTreeOptions dumpOptions = new DumpIrTreeOptions(true, true, true, false, false, (DumpIrTreeOptions.FlagsFilter)flagsFilterImpl, bl, false, false, false, false, false, false, false, false, false, false, bl2, name, arg_0 -> SerializedIrDumpHandler.processModule$lambda$3(info, this, arg_0), null, isFirFrontend, true, (DumpIrTreeOptions.ReferenceRenderingStrategy)custom, 1050520, null);
        StringBuilder builder = this.dumper.builderForModule(module.getName());
        Iterable $this$sortedBy$iv = info.getIrModuleFragment().getFiles();
        boolean $i$f$sortedBy = false;
        List irFiles = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IrFile it = (IrFile)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getFileEntry().getName());
                it = (IrFile)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getFileEntry().getName())));
            }
        });
        for (IrFile irFile : irFiles) {
            String actualDump = (String)signatureComputer.inFile(irFile.getSymbol(), () -> SerializedIrDumpHandler.processModule$lambda$5(irFile, dumpOptions));
            builder.append(actualDump);
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        boolean bl;
        block6: {
            Iterable $this$any$iv = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TestModule it = (TestModule)element$iv;
                    boolean bl2 = false;
                    if (!SerializedIrDumpHandler.Companion.isSkipped(it)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        String dump = this.dumper.generateResultingDump();
        File dumpFile = SerializedIrDumpHandler.Companion.getDumpFile(this.getTestServices());
        if (!this.isAfterDeserialization) {
            this.getAssertions().assertFileDoesntExist(dumpFile, (Function0<String>)((Function0)() -> SerializedIrDumpHandler.processAfterAllModules$lambda$7(dumpFile)));
            FilesKt.writeText$default((File)dumpFile, (String)dump, null, (int)2, null);
        } else {
            Assertions.assertEqualsToFile$default(this.getAssertions(), dumpFile, dump, null, 4, null);
        }
    }

    private static final String processModule$lambda$2(PublicIdSignatureComputer $signatureComputer, IrSymbol symbol) {
        IdSignature signature;
        IrDeclaration declaration;
        IrDeclaration irDeclaration;
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        boolean condition$iv = symbol.isBound();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            IrSymbolOwner irSymbolOwner = symbol.getOwner();
            irDeclaration = irSymbolOwner instanceof IrDeclaration ? (IrDeclaration)irSymbolOwner : null;
        } else {
            irDeclaration = declaration = null;
        }
        if (declaration != null) {
            KotlinMangler.IrMangler $this$processModule_u24lambda_u242_u24lambda_u241 = $signatureComputer.getMangler();
            boolean bl = false;
            boolean bl2 = !$this$processModule_u24lambda_u242_u24lambda_u241.isExported((Object)declaration, false);
            if (bl2) {
                return null;
            }
        }
        if (declaration instanceof IrDeclarationWithVisibility && IrVisibilityUtilKt.isEffectivelyPrivate((IrDeclarationWithVisibility)((IrDeclarationWithVisibility)declaration))) {
            return null;
        }
        IdSignature idSignature = symbol.getSignature();
        if (idSignature == null) {
            IrDeclaration irDeclaration2 = declaration;
            if (irDeclaration2 != null) {
                IrDeclaration p0 = irDeclaration2;
                boolean bl = false;
                idSignature = $signatureComputer.computeSignature(p0);
            } else {
                idSignature = null;
            }
        }
        if ((signature = idSignature) == null || signature.isLocal()) {
            return null;
        }
        return IdSignatureRendererKt.render$default((IdSignature)signature, null, (int)1, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean processModule$lambda$3(IrBackendInput $info, SerializedIrDumpHandler this$0, IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (IrTextDumpHandler.Companion.isHiddenDeclaration(declaration, $info.getIrPluginContext().getIrBuiltIns())) {
            return true;
        }
        if (!this$0.isAfterDeserialization) return false;
        if (!(declaration instanceof IrSimpleFunction)) return false;
        if (!((IrSimpleFunction)declaration).isFakeOverride()) return false;
        IrSimpleFunction irSimpleFunction = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverride$default((IrOverridableDeclaration)((IrOverridableDeclaration)declaration), null, (int)1, null);
        if (!Intrinsics.areEqual((Object)(irSimpleFunction != null ? irSimpleFunction.getOrigin() : null), (Object)IrDeclarationOrigin.Companion.getSYNTHETIC_ACCESSOR())) return false;
        return true;
    }

    private static final String processModule$lambda$5(IrFile $irFile, DumpIrTreeOptions $dumpOptions) {
        return DumpIrTreeKt.dumpTreesFromLineNumber((IrFile)$irFile, (int)0, (DumpIrTreeOptions)$dumpOptions);
    }

    private static final String processAfterAllModules$lambda$7(File $dumpFile) {
        return "Dump file already exists: " + $dumpFile;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007R\u0018\u0010\b\u001a\u00020\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/SerializedIrDumpHandler$Companion;", "", "<init>", "()V", "isSkipped", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "(Lorg/jetbrains/kotlin/test/model/TestModule;)Z", "dumpFile", "Ljava/io/File;", "Lorg/jetbrains/kotlin/test/services/TestServices;", "getDumpFile", "(Lorg/jetbrains/kotlin/test/services/TestServices;)Ljava/io/File;", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isSkipped(TestModule $this$isSkipped) {
            return $this$isSkipped.getDirectives().contains(KlibBasedCompilerTestDirectives.INSTANCE.getSKIP_IR_DESERIALIZATION_CHECKS());
        }

        private final File getDumpFile(TestServices $this$dumpFile) {
            return FilesKt.resolve((File)TemporaryDirectoryManagerKt.getTemporaryDirectoryManager($this$dumpFile).getRootDir(), (String)"ir_pre_serialization_dump.txt");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

