/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.library.KotlinIrSignatureVersion;
import org.jetbrains.kotlin.library.abi.AbiReadingFilter;
import org.jetbrains.kotlin.library.abi.AbiRenderingSettings;
import org.jetbrains.kotlin.library.abi.AbiSignatureVersion;
import org.jetbrains.kotlin.library.abi.LibraryAbi;
import org.jetbrains.kotlin.library.abi.LibraryAbiReader;
import org.jetbrains.kotlin.library.abi.LibraryAbiRenderer;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.directives.KlibAbiDumpDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.model.ArtifactKinds;
import org.jetbrains.kotlin.test.model.BinaryArtifactHandler;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/KlibAbiDumpHandler;", "Lorg/jetbrains/kotlin/test/model/BinaryArtifactHandler;", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$KLib;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/KlibAbiDumpDirectives;", "getDirectiveContainers", "()Ljava/util/List;", "dumpers", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/library/abi/AbiSignatureVersion;", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "Lkotlin/collections/HashMap;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "processAfterAllModules", "someAssertionWasFailed", "", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nKlibAbiDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KlibAbiDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/KlibAbiDumpHandler\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,83:1\n384#2,7:84\n126#3:91\n153#3,3:92\n*S KotlinDebug\n*F\n+ 1 KlibAbiDumpHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/KlibAbiDumpHandler\n*L\n50#1:84,7\n59#1:91\n59#1:92,3\n*E\n"})
public final class KlibAbiDumpHandler
extends BinaryArtifactHandler<BinaryArtifacts.KLib> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<AbiSignatureVersion, MultiModuleInfoDumper> dumpers;
    @NotNull
    private static final KotlinIrSignatureVersion DEFAULT_ABI_SIGNATURE_VERSION = KotlinIrSignatureVersion.Companion.getV2();

    public KlibAbiDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, ArtifactKinds.KLib.INSTANCE, true, true);
        this.dumpers = new HashMap();
    }

    @NotNull
    public List<KlibAbiDumpDirectives> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)KlibAbiDumpDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull BinaryArtifacts.KLib info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        KlibAbiDumpDirectives.KlibAbiDumpMode klibAbiDumpMode = DirectiveKt.singleOrZeroValue(module.getDirectives(), KlibAbiDumpDirectives.INSTANCE.getDUMP_KLIB_ABI());
        if (klibAbiDumpMode == null) {
            return;
        }
        KlibAbiDumpDirectives.KlibAbiDumpMode dumpMode = klibAbiDumpMode;
        AbiReadingFilter[] abiReadingFilterArray = new AbiReadingFilter[]{new AbiReadingFilter.ExcludedPackages((Collection)module.getDirectives().get(KlibAbiDumpDirectives.INSTANCE.getKLIB_ABI_DUMP_EXCLUDED_PACKAGES())), new AbiReadingFilter.ExcludedClasses((Collection)module.getDirectives().get(KlibAbiDumpDirectives.INSTANCE.getKLIB_ABI_DUMP_EXCLUDED_CLASSES())), new AbiReadingFilter.NonPublicMarkerAnnotations((Collection)module.getDirectives().get(KlibAbiDumpDirectives.INSTANCE.getKLIB_ABI_DUMP_NON_PUBLIC_MARKERS()))};
        LibraryAbi libraryAbi = LibraryAbiReader.INSTANCE.readAbiInfo(info.getOutputFile(), abiReadingFilterArray);
        for (AbiSignatureVersion abiSignatureVersion : dumpMode.getAbiSignatureVersions()) {
            Object object;
            Map $this$getOrPut$iv = this.dumpers;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(abiSignatureVersion);
            if (value$iv == null) {
                boolean bl = false;
                MultiModuleInfoDumper answer$iv = new MultiModuleInfoDumper(null, 1, null);
                $this$getOrPut$iv.put(abiSignatureVersion, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            MultiModuleInfoDumper dumper = (MultiModuleInfoDumper)object;
            LibraryAbiRenderer.INSTANCE.render(libraryAbi, (Appendable)dumper.builderForModule(module), new AbiRenderingSettings(abiSignatureVersion, false, false, null, null, 30, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (this.dumpers.isEmpty()) {
            return;
        }
        Map map = this.dumpers;
        Assertions assertions = this.getAssertions();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AbiSignatureVersion abiSignatureVersion = (AbiSignatureVersion)entry.getKey();
            MultiModuleInfoDumper dumper = (MultiModuleInfoDumper)entry.getValue();
            String dumpFileExtension = Companion.abiDumpFileExtension(abiSignatureVersion.getVersionNumber());
            Function0 lambda = () -> KlibAbiDumpHandler.processAfterAllModules$lambda$2$lambda$1(this, dumpFileExtension, dumper);
            collection.add(lambda);
        }
        assertions.assertAll((List)destination$iv$iv);
    }

    private static final Unit processAfterAllModules$lambda$2$lambda$1(KlibAbiDumpHandler this$0, String $dumpFileExtension, MultiModuleInfoDumper $dumper) {
        File expectedFile = FileUtilsKt.withExtension((File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this$0.getTestServices()).getOriginalTestDataFiles()), $dumpFileExtension);
        Assertions.assertEqualsToFile$default(this$0.getAssertions(), expectedFile, $dumper.generateResultingDump(), null, 4, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/KlibAbiDumpHandler$Companion;", "", "<init>", "()V", "DEFAULT_ABI_SIGNATURE_VERSION", "Lorg/jetbrains/kotlin/library/KotlinIrSignatureVersion;", "getDEFAULT_ABI_SIGNATURE_VERSION", "()Lorg/jetbrains/kotlin/library/KotlinIrSignatureVersion;", "abiDumpFileExtension", "", "abiSignatureVersion", "", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinIrSignatureVersion getDEFAULT_ABI_SIGNATURE_VERSION() {
            return DEFAULT_ABI_SIGNATURE_VERSION;
        }

        @NotNull
        public final String abiDumpFileExtension(int abiSignatureVersion) {
            String suffix = abiSignatureVersion == this.getDEFAULT_ABI_SIGNATURE_VERSION().getNumber() ? "" : "sig_v" + abiSignatureVersion + '.';
            return suffix + "klib_abi.txt";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

