/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.lazy.AbstractIrLazyFunction;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.StubGeneratorExtensionsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.AbstractIrHandler;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.frontend.fir.Fir2IrCliBasedJvmOutputArtifact;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R!\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrInlineBodiesHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/AbstractIrHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "declaredInlineFunctions", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lkotlin/collections/HashSet;", "getDeclaredInlineFunctions", "()Ljava/util/HashSet;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "processAfterAllModules", "someAssertionWasFailed", "", "InlineFunctionsCollector", "InlineCallBodiesCheck", "tests-common-new_test"})
public final class IrInlineBodiesHandler
extends AbstractIrHandler {
    @NotNull
    private final HashSet<IrSimpleFunction> declaredInlineFunctions;

    public IrInlineBodiesHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, null, false, false, 14, null);
        this.declaredInlineFunctions = new HashSet();
    }

    @NotNull
    public final HashSet<IrSimpleFunction> getDeclaredInlineFunctions() {
        return this.declaredInlineFunctions;
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull IrBackendInput info) {
        SymbolTable symbolTable;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        IrVisitorsKt.acceptChildrenVoid((IrElement)((IrElement)info.getIrModuleFragment()), (IrVisitorVoid)new InlineFunctionsCollector());
        IrVisitorsKt.acceptChildrenVoid((IrElement)((IrElement)info.getIrModuleFragment()), (IrVisitorVoid)new InlineCallBodiesCheck(Intrinsics.areEqual(DefaultsProviderKt.getDefaultsProvider(this.getTestServices()).getFrontendKind(), (Object)FrontendKinds.FIR.INSTANCE)));
        IrBackendInput irBackendInput = info;
        if (irBackendInput instanceof IrBackendInput.JvmIrBackendInput) {
            symbolTable = ((IrBackendInput.JvmIrBackendInput)info).getBackendInput().getSymbolTable();
        } else if (irBackendInput instanceof Fir2IrCliBasedJvmOutputArtifact) {
            symbolTable = ((Fir2IrCliBasedJvmOutputArtifact)info).getCliArtifact().getResult().getSymbolTable();
        } else {
            throw new IllegalStateException(("Unknown backend input kind: " + Reflection.getOrCreateKotlinClass(info.getClass()).getSimpleName()).toString());
        }
        SymbolTable symbolTable2 = symbolTable;
        Assertions.assertTrue$default(this.getAssertions(), symbolTable2.getDescriptorExtension().getAllUnboundSymbols().isEmpty(), null, 2, null);
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        Assertions.assertTrue$default(this.getAssertions(), !((Collection)this.declaredInlineFunctions).isEmpty(), null, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\t2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\f\u0010\u000f\u001a\u00020\u0003*\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrInlineBodiesHandler$InlineCallBodiesCheck;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "firEnabled", "", "<init>", "(Lorg/jetbrains/kotlin/test/backend/handlers/IrInlineBodiesHandler;Z)V", "getFirEnabled", "()Z", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitMemberAccess", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "hasBody", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "tests-common-new_test"})
    public final class InlineCallBodiesCheck
    extends IrVisitorVoid {
        private final boolean firEnabled;

        public InlineCallBodiesCheck(boolean firEnabled) {
            this.firEnabled = firEnabled;
        }

        public final boolean getFirEnabled() {
            return this.firEnabled;
        }

        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            IrVisitorsKt.acceptChildrenVoid((IrElement)element, (IrVisitorVoid)this);
        }

        public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression) {
            Intrinsics.checkNotNullParameter(expression, (String)"expression");
            IrSymbol symbol = expression.getSymbol();
            Assertions.assertTrue$default(IrInlineBodiesHandler.this.getAssertions(), symbol.isBound(), null, 2, null);
            IrSymbolOwner callee = symbol.getOwner();
            if (callee instanceof IrSimpleFunction && IrInlineBodiesHandler.this.getDeclaredInlineFunctions().contains(callee)) {
                IrSimpleFunction trueCallee = (IrSimpleFunction)IrFakeOverrideUtilsKt.resolveFakeOverrideOrFail((IrOverridableDeclaration)((IrOverridableDeclaration)callee));
                IrInlineBodiesHandler.this.getAssertions().assertTrue(this.hasBody(trueCallee), (Function0<String>)((Function0)InlineCallBodiesCheck::visitMemberAccess$lambda$0));
            }
            super.visitMemberAccess(expression);
        }

        private final boolean hasBody(IrSimpleFunction $this$hasBody) {
            boolean bl;
            if (!($this$hasBody instanceof AbstractIrLazyFunction)) {
                return $this$hasBody.getBody() != null;
            }
            if (!((AbstractIrLazyFunction)$this$hasBody).isDeserializationEnabled()) {
                return false;
            }
            if (!$this$hasBody.isInline() || $this$hasBody.isFakeOverride()) {
                return false;
            }
            IrDeclaration topLevelDeclaration = ((AbstractIrLazyFunction)$this$hasBody).getTopLevelDeclaration();
            if (topLevelDeclaration instanceof IrClass && StubGeneratorExtensionsKt.getDeserializedIr((IrClass)((IrClass)topLevelDeclaration)) != null) {
                return true;
            }
            boolean bl2 = this.firEnabled;
            if (bl2) {
                bl = topLevelDeclaration.getParent() instanceof IrExternalPackageFragment;
            } else if (!bl2) {
                bl = false;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return bl;
        }

        private static final String visitMemberAccess$lambda$0() {
            return "IrInlineBodiesHandler: function with body expected";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/IrInlineBodiesHandler$InlineFunctionsCollector;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "<init>", "(Lorg/jetbrains/kotlin/test/backend/handlers/IrInlineBodiesHandler;)V", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitSimpleFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "tests-common-new_test"})
    public final class InlineFunctionsCollector
    extends IrVisitorVoid {
        public void visitElement(@NotNull IrElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            IrVisitorsKt.acceptChildrenVoid((IrElement)element, (IrVisitorVoid)this);
        }

        public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            if (declaration.isInline()) {
                IrInlineBodiesHandler.this.getDeclaredInlineFunctions().add(declaration);
            }
            super.visitSimpleFunction(declaration);
        }
    }
}

