/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.fir.SequentialPositionFinder;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.codeMetaInfo.model.CodeMetaInfo;
import org.jetbrains.kotlin.codeMetaInfo.model.DiagnosticCodeMetaInfo;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.diagnostics.rendering.RootDiagnosticRendererFactory;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.FirParser;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.DiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirDiagnosticCodeMetaInfo;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirDiagnosticsHandlerKt;
import org.jetbrains.kotlin.test.model.BinaryArtifactHandler;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.DiagnosticsService;
import org.jetbrains.kotlin.test.services.DiagnosticsServiceKt;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandler;
import org.jetbrains.kotlin.test.services.GlobalMetadataInfoHandlerKt;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002\u001a2\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u001a\u001a\u0010\u0011\u001a\u00020\u0001*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a5\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\u0004\b\u0000\u0010\u0018*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u0001H\u00180\u001d\u00a2\u0006\u0002\u0010\u001e\u001a&\u0010\u001f\u001a\u00020 *\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020 0\u001d\u00a8\u0006\""}, d2={"reportKtDiagnostics", "", "Lorg/jetbrains/kotlin/test/model/BinaryArtifactHandler;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "ktDiagnosticReporter", "Lorg/jetbrains/kotlin/diagnostics/impl/BaseDiagnosticsCollector;", "checkFullDiagnosticRender", "renderDiagnosticMessage", "", "fileName", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "message", "line", "", "column", "assertFileDoesntExist", "Lorg/jetbrains/kotlin/test/Assertions;", "file", "Ljava/io/File;", "directive", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "findByPath", "R", "Lorg/jetbrains/kotlin/test/model/TestFile;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "finder", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/test/model/TestFile;Lorg/jetbrains/kotlin/test/services/TestServices;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "matchPath", "", "matcher", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nHandlerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HandlerUtils.kt\norg/jetbrains/kotlin/test/backend/handlers/HandlerUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1056#2:145\n1761#2,3:146\n1869#2,2:150\n1#3:149\n*S KotlinDebug\n*F\n+ 1 HandlerUtils.kt\norg/jetbrains/kotlin/test/backend/handlers/HandlerUtilsKt\n*L\n80#1:145\n109#1:146,3\n54#1:150,2\n*E\n"})
public final class HandlerUtilsKt {
    public static final void reportKtDiagnostics(@NotNull BinaryArtifactHandler<?> $this$reportKtDiagnostics, @NotNull TestModule module, @NotNull BaseDiagnosticsCollector ktDiagnosticReporter) {
        Intrinsics.checkNotNullParameter($this$reportKtDiagnostics, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)ktDiagnosticReporter, (String)"ktDiagnosticReporter");
        if (module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getIGNORE_BACKEND_DIAGNOSTICS())) {
            return;
        }
        GlobalMetadataInfoHandler globalMetadataInfoHandler = GlobalMetadataInfoHandlerKt.getGlobalMetadataInfoHandler($this$reportKtDiagnostics.getTestServices());
        FirParser firParser = DirectiveKt.singleOrZeroValue(module.getDirectives(), FirDiagnosticsDirectives.INSTANCE.getFIR_PARSER());
        boolean lightTreeComparingModeEnabled = firParser != null && module.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getCOMPARE_WITH_LIGHT_TREE());
        boolean lightTreeEnabled = firParser == FirParser.LightTree;
        Set processedModules = new LinkedHashSet();
        DiagnosticsService diagnosticsService = DiagnosticsServiceKt.getDiagnosticsService($this$reportKtDiagnostics.getTestServices());
        HandlerUtilsKt.reportKtDiagnostics$processModule(processedModules, $this$reportKtDiagnostics, ktDiagnosticReporter, diagnosticsService, globalMetadataInfoHandler, lightTreeEnabled, lightTreeComparingModeEnabled, module);
    }

    public static final void checkFullDiagnosticRender(@NotNull BinaryArtifactHandler<?> $this$checkFullDiagnosticRender) {
        Intrinsics.checkNotNullParameter($this$checkFullDiagnosticRender, (String)"<this>");
        MultiModuleInfoDumper dumper = new MultiModuleInfoDumper(null, 1, null);
        TestModuleStructure moduleStructure = TestModuleStructureKt.getModuleStructure($this$checkFullDiagnosticRender.getTestServices());
        boolean needToVerifyDiagnostics = false;
        for (TestModule module : moduleStructure.getModules()) {
            if (!module.getDirectives().contains(DiagnosticsDirectives.INSTANCE.getRENDER_ALL_DIAGNOSTICS_FULL_TEXT())) continue;
            needToVerifyDiagnostics = true;
            List reportedDiagnostics = new ArrayList();
            for (TestFile testFile : module.getFiles()) {
                Iterator iterator = SourceFileProviderKt.getSourceFileProvider($this$checkFullDiagnosticRender.getTestServices()).getContentOfSourceFile(testFile);
                Charset charset = Charsets.UTF_8;
                byte[] byArray = ((String)((Object)iterator)).getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                iterator = new ByteArrayInputStream(byArray);
                charset = Charsets.UTF_8;
                SequentialPositionFinder finder = new SequentialPositionFinder(new InputStreamReader((InputStream)((Object)iterator), charset));
                Iterable $this$sortedBy$iv = GlobalMetadataInfoHandlerKt.getGlobalMetadataInfoHandler($this$checkFullDiagnosticRender.getTestServices()).getReportedMetaInfosForFile(testFile);
                boolean $i$f$sortedBy = false;
                for (CodeMetaInfo metaInfo : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        CodeMetaInfo it = (CodeMetaInfo)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getStart());
                        it = (CodeMetaInfo)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getStart()));
                    }
                })) {
                    String message;
                    PsiDiagnosticUtils.LineAndColumn position;
                    Diagnostic it;
                    CodeMetaInfo codeMetaInfo = metaInfo;
                    if (codeMetaInfo instanceof DiagnosticCodeMetaInfo) {
                        it = ((DiagnosticCodeMetaInfo)metaInfo).getDiagnostic();
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)it)), (String)"render(...)");
                        position = DiagnosticUtils.getLineAndColumnRange((PsiFile)it.getPsiFile(), (List)it.getTextRanges()).getStart();
                        Collection collection = reportedDiagnostics;
                        String string = it.getPsiFile().getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        String string2 = HandlerUtilsKt.renderDiagnosticMessage(string, it.getSeverity(), message, position.getLine(), position.getColumn());
                        collection.add(string2);
                        continue;
                    }
                    if (!(codeMetaInfo instanceof FirDiagnosticCodeMetaInfo)) continue;
                    it = ((FirDiagnosticCodeMetaInfo)metaInfo).getDiagnostic();
                    boolean bl = false;
                    message = RootDiagnosticRendererFactory.INSTANCE.invoke((KtDiagnostic)it).render((KtDiagnostic)it);
                    position = finder.findNextPosition(DiagnosticUtils.firstRange((List)it.getTextRanges()).getStartOffset(), false);
                    ((Collection)reportedDiagnostics).add(HandlerUtilsKt.renderDiagnosticMessage(testFile.getRelativePath(), it.getSeverity(), message, position.getLine(), position.getColumn()));
                }
            }
            if (!(!((Collection)reportedDiagnostics).isEmpty())) continue;
            CollectionsKt.joinTo$default((Iterable)reportedDiagnostics, (Appendable)dumper.builderForModule(module), (CharSequence)"\n\n", null, (CharSequence)"\n", (int)0, null, null, (int)116, null);
        }
        File expectedFile = new File(FileUtil.getNameWithoutExtension((String)((File)CollectionsKt.first(moduleStructure.getOriginalTestDataFiles())).getAbsolutePath()) + ".diag.txt");
        if (needToVerifyDiagnostics) {
            Assertions.assertEqualsToFile$default((Assertions)AssertionsKt.getAssertions($this$checkFullDiagnosticRender.getTestServices()), expectedFile, dumper.generateResultingDump(), null, 4, null);
        } else {
            boolean renderAtLeastFrontendDiagnostics;
            block10: {
                boolean bl;
                Iterable $this$any$iv = moduleStructure.getModules();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TestModule it = (TestModule)element$iv;
                        boolean bl2 = false;
                        if (!it.getDirectives().contains(DiagnosticsDirectives.INSTANCE.getRENDER_DIAGNOSTICS_FULL_TEXT())) continue;
                        bl = true;
                        break block10;
                    }
                    bl = renderAtLeastFrontendDiagnostics = false;
                }
            }
            if (!renderAtLeastFrontendDiagnostics) {
                HandlerUtilsKt.assertFileDoesntExist(AssertionsKt.getAssertions($this$checkFullDiagnosticRender.getTestServices()), expectedFile, DiagnosticsDirectives.INSTANCE.getRENDER_ALL_DIAGNOSTICS_FULL_TEXT());
            }
        }
    }

    private static final String renderDiagnosticMessage(String fileName, Severity severity, String message, int line, int column) {
        String severityString = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)AnalyzerWithCompilerReport.Companion.convertSeverity(severity).toString());
        return '/' + fileName + ':' + line + ':' + column + ": " + severityString + ": " + message;
    }

    public static final void assertFileDoesntExist(@NotNull Assertions $this$assertFileDoesntExist, @NotNull File file, @NotNull Directive directive) {
        Intrinsics.checkNotNullParameter((Object)$this$assertFileDoesntExist, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        $this$assertFileDoesntExist.assertFileDoesntExist(file, (Function0<String>)((Function0)() -> HandlerUtilsKt.assertFileDoesntExist$lambda$6(directive)));
    }

    @Nullable
    public static final <R> R findByPath(@NotNull TestFile $this$findByPath, @NotNull TestServices testServices, @NotNull Function1<? super String, ? extends R> finder) {
        Intrinsics.checkNotNullParameter((Object)$this$findByPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter(finder, (String)"finder");
        Object object = finder.invoke((Object)('/' + $this$findByPath.getName()));
        if (object != null) {
            Object it = object;
            boolean bl = false;
            return (R)it;
        }
        File realFile = SourceFileProviderKt.getSourceFileProvider(testServices).getOrCreateRealFileForSourceFile($this$findByPath);
        String string = FileUtil.toSystemIndependentName((String)realFile.getCanonicalPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        String normalizedPath = string;
        return (R)finder.invoke((Object)normalizedPath);
    }

    public static final boolean matchPath(@NotNull TestFile $this$matchPath, @NotNull TestServices testServices, @NotNull Function1<? super String, Boolean> matcher) {
        Intrinsics.checkNotNullParameter((Object)$this$matchPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        Boolean bl = (Boolean)HandlerUtilsKt.findByPath($this$matchPath, testServices, arg_0 -> HandlerUtilsKt.matchPath$lambda$9(matcher, arg_0));
        return bl != null ? bl : false;
    }

    private static final List reportKtDiagnostics$processModule$lambda$0(BaseDiagnosticsCollector $ktDiagnosticReporter, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)$ktDiagnosticReporter.getDiagnosticsByFilePath().get(it);
    }

    private static final void reportKtDiagnostics$processModule(Set<TestModule> processedModules, BinaryArtifactHandler<?> $this_reportKtDiagnostics, BaseDiagnosticsCollector $ktDiagnosticReporter, DiagnosticsService diagnosticsService, GlobalMetadataInfoHandler globalMetadataInfoHandler, boolean lightTreeEnabled, boolean lightTreeComparingModeEnabled, TestModule module) {
        if (!processedModules.add(module)) {
            return;
        }
        for (TestFile testFile : module.getFiles()) {
            List ktDiagnostics;
            if ((List)HandlerUtilsKt.findByPath(testFile, $this_reportKtDiagnostics.getTestServices(), arg_0 -> HandlerUtilsKt.reportKtDiagnostics$processModule$lambda$0($ktDiagnosticReporter, arg_0)) == null) continue;
            Iterable $this$forEach$iv = ktDiagnostics;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtDiagnostic it = (KtDiagnostic)element$iv;
                boolean bl = false;
                if (!diagnosticsService.shouldRenderDiagnostic(module, it.getFactoryName(), it.getSeverity())) continue;
                List metaInfos = FirDiagnosticsHandlerKt.toMetaInfos$default(it, module, testFile, globalMetadataInfoHandler, lightTreeEnabled, lightTreeComparingModeEnabled, false, null, 96, null);
                globalMetadataInfoHandler.addMetadataInfosForFile(testFile, metaInfos);
            }
        }
        Iterator<Object> iterator = module.getDependsOnDependencies().iterator();
        while (iterator.hasNext()) {
            TestModule dependantModule = ((DependencyDescription)iterator.next()).component1();
            HandlerUtilsKt.reportKtDiagnostics$processModule(processedModules, $this_reportKtDiagnostics, $ktDiagnosticReporter, diagnosticsService, globalMetadataInfoHandler, lightTreeEnabled, lightTreeComparingModeEnabled, dependantModule);
        }
    }

    private static final String assertFileDoesntExist$lambda$6(Directive $directive) {
        return "Dump file detected but no '" + $directive + "' directive specified or nothing to dump.";
    }

    /*
     * WARNING - void declaration
     */
    private static final Boolean matchPath$lambda$9(Function1 $matcher, String path) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = $matcher.invoke((Object)path);
        boolean it = (Boolean)object;
        boolean bl = false;
        return (Boolean)(var3_3 != false ? object : null);
    }
}

