/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.BytecodeListingTextCollectingVisitor;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.backend.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.test.backend.handlers.JvmBinaryArtifactHandler;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000eH\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/BytecodeListingHandler;", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmBinaryArtifactHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "multiModuleInfoDumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "irDumpEnabled", "", "firDumpEnabled", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "processAfterAllModules", "someAssertionWasFailed", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nBytecodeListingHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BytecodeListingHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/BytecodeListingHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1056#2:108\n1563#2:109\n1634#2,3:110\n1617#2,9:113\n1869#2:122\n1870#2:124\n1626#2:125\n1#3:123\n1#3:126\n*S KotlinDebug\n*F\n+ 1 BytecodeListingHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/BytecodeListingHandler\n*L\n45#1:108\n46#1:109\n46#1:110,3\n53#1:113,9\n53#1:122\n53#1:124\n53#1:125\n53#1:123\n*E\n"})
public final class BytecodeListingHandler
extends JvmBinaryArtifactHandler {
    @NotNull
    private final MultiModuleInfoDumper multiModuleInfoDumper;
    private boolean irDumpEnabled;
    private boolean firDumpEnabled;

    public BytecodeListingHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, 2, null);
        this.multiModuleInfoDumper = new MultiModuleInfoDumper(null, 1, null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)CodegenTestDirectives.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processModule(@NotNull TestModule module, @NotNull BinaryArtifacts.Jvm info) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.irDumpEnabled = this.irDumpEnabled || module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDUMP_IR());
        boolean bl = this.firDumpEnabled = this.firDumpEnabled || module.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getFIR_DUMP());
        if (!module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getCHECK_BYTECODE_LISTING())) {
            return;
        }
        Iterable iterable = ClassFileUtilsKt.getClassFiles((ClassFileFactory)info.getClassFileFactory());
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                OutputFile it = (OutputFile)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getRelativePath());
                it = (OutputFile)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getRelativePath())));
            }
        });
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OutputFile outputFile = (OutputFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            object = new ClassNode(589824);
            ClassNode node = object;
            boolean bl3 = false;
            new ClassReader(it.asByteArray()).accept((ClassVisitor)node, 1);
            collection.add(object);
        }
        List classes = (List)destination$iv$iv;
        BytecodeListingTextCollectingVisitor.Filter.ForCodegenTests filter = BytecodeListingTextCollectingVisitor.Filter.ForCodegenTests.INSTANCE;
        Iterable $this$mapNotNull$iv = classes;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$mapTo22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl4 = false;
            ClassNode node = (ClassNode)element$iv$iv;
            boolean bl5 = false;
            BytecodeListingTextCollectingVisitor visitor = new BytecodeListingTextCollectingVisitor(filter, module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getWITH_SIGNATURES()), !module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getIGNORE_ANNOTATIONS()), !module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getDONT_SORT_DECLARATIONS()));
            node.accept((ClassVisitor)visitor);
            String string = node.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            if ((!filter.shouldWriteClass(string) ? null : visitor.getText()) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl6 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        String dump = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"\n\n", null, (CharSequence)"\n", (int)0, null, null, (int)58, null);
        this.multiModuleInfoDumper.builderForModule(module).append(dump);
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        File goldenFile;
        File file;
        File file2;
        File it;
        File file3;
        File sourceFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        File defaultTxtFile = FileUtilsKt.withExtension(sourceFile, ".txt");
        File irTxtFile = FileUtilsKt.withExtension(sourceFile, ".ir.txt");
        File firTxtFile = FileUtilsKt.withExtension(sourceFile, ".fir.txt");
        boolean isFir = Intrinsics.areEqual(DefaultsProviderKt.getDefaultsProvider(this.getTestServices()).getFrontendKind(), (Object)FrontendKinds.FIR.INSTANCE);
        TargetBackend targetBackend = DefaultsProviderKt.getDefaultsProvider(this.getTestServices()).getTargetBackend();
        boolean isIr = targetBackend != null ? targetBackend.isIR() : false;
        if (isFir) {
            it = file3 = firTxtFile;
            boolean bl = false;
            file2 = it.exists() ? file3 : null;
            if (file2 == null) {
                File it2 = it = irTxtFile;
                boolean bl2 = false;
                file2 = it2.exists() ? it : null;
                if (file2 == null) {
                    file2 = defaultTxtFile;
                }
            }
        } else if (isIr) {
            it = file3 = irTxtFile;
            boolean bl = false;
            file2 = it.exists() ? file3 : null;
            if (file2 == null) {
                file2 = defaultTxtFile;
            }
        } else {
            file2 = defaultTxtFile;
        }
        File actualFile = file2;
        if (isFir) {
            File file4;
            File it3 = file4 = irTxtFile;
            boolean bl = false;
            file = it3.exists() ? file4 : null;
            if (file == null) {
                file = defaultTxtFile;
            }
        } else {
            file = goldenFile = defaultTxtFile;
        }
        if (this.multiModuleInfoDumper.isEmpty()) {
            if (!this.irDumpEnabled && Intrinsics.areEqual((Object)actualFile, (Object)irTxtFile) || !this.firDumpEnabled && Intrinsics.areEqual((Object)actualFile, (Object)firTxtFile) || Intrinsics.areEqual((Object)actualFile, (Object)defaultTxtFile)) {
                HandlerUtilsKt.assertFileDoesntExist(this.getAssertions(), actualFile, CodegenTestDirectives.INSTANCE.getCHECK_BYTECODE_LISTING());
            }
            return;
        }
        Assertions.assertEqualsToFile$default(this.getAssertions(), actualFile, this.multiModuleInfoDumper.generateResultingDump(), null, 4, null);
        if (!Intrinsics.areEqual((Object)actualFile, (Object)goldenFile) && Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)actualFile, null, (int)1, null))).toString(), (Object)((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)goldenFile, null, (int)1, null))).toString())) {
            this.getAssertions().fail((Function0<String>)((Function0)() -> BytecodeListingHandler.processAfterAllModules$lambda$8(actualFile)));
            throw new KotlinNothingValueException();
        }
    }

    private static final String processAfterAllModules$lambda$8(File $actualFile) {
        return "JVM and JVM_IR golden files are identical. Remove " + $actualFile + '.';
    }
}

