/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.TestRunner;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.model.AbstractTestFacade;
import org.jetbrains.kotlin.test.model.AnalysisHandler;
import org.jetbrains.kotlin.test.model.ResultingArtifact;
import org.jetbrains.kotlin.test.model.TestArtifactKind;
import org.jetbrains.kotlin.test.model.TestModule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u00022\u00020\u0004:\u0003\u0014\u0015\u0016B\t\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J-\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\fH&\u00a2\u0006\u0002\u0010\u0013R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0002\u0017\u0018\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/test/TestStep;", "InputArtifact", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "OutputArtifact", "", "<init>", "()V", "inputArtifactKind", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "getInputArtifactKind", "()Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "shouldProcessModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "inputArtifact", "processModule", "Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "thereWereExceptionsOnPreviousSteps", "(Lorg/jetbrains/kotlin/test/model/TestModule;Lorg/jetbrains/kotlin/test/model/ResultingArtifact;Z)Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "FacadeStep", "HandlersStep", "StepResult", "Lorg/jetbrains/kotlin/test/TestStep$FacadeStep;", "Lorg/jetbrains/kotlin/test/TestStep$HandlersStep;", "test-infrastructure_test"})
public abstract class TestStep<InputArtifact extends ResultingArtifact<InputArtifact>, OutputArtifact extends ResultingArtifact<OutputArtifact>> {
    private TestStep() {
    }

    @NotNull
    public abstract TestArtifactKind<InputArtifact> getInputArtifactKind();

    public boolean shouldProcessModule(@NotNull TestModule module, @NotNull ResultingArtifact<?> inputArtifact) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(inputArtifact, (String)"inputArtifact");
        return Intrinsics.areEqual(inputArtifact.getKind(), this.getInputArtifactKind());
    }

    @NotNull
    public abstract StepResult<? extends OutputArtifact> processModule(@NotNull TestModule var1, @NotNull InputArtifact var2, boolean var3);

    public /* synthetic */ TestStep(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u000e\b\u0002\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u000e\b\u0003\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00030\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u001b\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J-\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00030\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u00022\u0006\u0010\u0018\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0019R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00030\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/test/TestStep$FacadeStep;", "InputArtifact", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "OutputArtifact", "Lorg/jetbrains/kotlin/test/TestStep;", "facade", "Lorg/jetbrains/kotlin/test/model/AbstractTestFacade;", "<init>", "(Lorg/jetbrains/kotlin/test/model/AbstractTestFacade;)V", "getFacade", "()Lorg/jetbrains/kotlin/test/model/AbstractTestFacade;", "inputArtifactKind", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "getInputArtifactKind", "()Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "outputArtifactKind", "getOutputArtifactKind", "shouldProcessModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "inputArtifact", "processModule", "Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "thereWereExceptionsOnPreviousSteps", "(Lorg/jetbrains/kotlin/test/model/TestModule;Lorg/jetbrains/kotlin/test/model/ResultingArtifact;Z)Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "test-infrastructure_test"})
    public static final class FacadeStep<InputArtifact extends ResultingArtifact<InputArtifact>, OutputArtifact extends ResultingArtifact<OutputArtifact>>
    extends TestStep<InputArtifact, OutputArtifact> {
        @NotNull
        private final AbstractTestFacade<InputArtifact, OutputArtifact> facade;

        public FacadeStep(@NotNull AbstractTestFacade<InputArtifact, OutputArtifact> facade) {
            Intrinsics.checkNotNullParameter(facade, (String)"facade");
            super(null);
            this.facade = facade;
        }

        @NotNull
        public final AbstractTestFacade<InputArtifact, OutputArtifact> getFacade() {
            return this.facade;
        }

        @Override
        @NotNull
        public TestArtifactKind<InputArtifact> getInputArtifactKind() {
            return this.facade.getInputKind();
        }

        @NotNull
        public final TestArtifactKind<OutputArtifact> getOutputArtifactKind() {
            return this.facade.getOutputKind();
        }

        @Override
        public boolean shouldProcessModule(@NotNull TestModule module, @NotNull ResultingArtifact<?> inputArtifact) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(inputArtifact, (String)"inputArtifact");
            return super.shouldProcessModule(module, inputArtifact) && this.facade.shouldTransform(module);
        }

        @Override
        @NotNull
        public StepResult<? extends OutputArtifact> processModule(@NotNull TestModule module, @NotNull InputArtifact inputArtifact, boolean thereWereExceptionsOnPreviousSteps) {
            OutputArtifact OutputArtifact;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(inputArtifact, (String)"inputArtifact");
            try {
                OutputArtifact OutputArtifact2 = this.facade.transform(module, inputArtifact);
                if (OutputArtifact2 == null) {
                    return StepResult.NoArtifactFromFacade.INSTANCE;
                }
                OutputArtifact = OutputArtifact2;
            }
            catch (Throwable e) {
                return new StepResult.ErrorFromFacade(new WrappedException.FromFacade(e, module, this.facade));
            }
            OutputArtifact outputArtifact = OutputArtifact;
            return new StepResult.Artifact<OutputArtifact>(outputArtifact);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000*\u000e\b\u0002\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003B)\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ%\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/test/TestStep$HandlersStep;", "InputArtifact", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "Lorg/jetbrains/kotlin/test/TestStep;", "", "inputArtifactKind", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "handlers", "", "Lorg/jetbrains/kotlin/test/model/AnalysisHandler;", "<init>", "(Lorg/jetbrains/kotlin/test/model/TestArtifactKind;Ljava/util/List;)V", "getInputArtifactKind", "()Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "getHandlers", "()Ljava/util/List;", "processModule", "Lorg/jetbrains/kotlin/test/TestStep$StepResult$HandlersResult;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "inputArtifact", "thereWereExceptionsOnPreviousSteps", "", "(Lorg/jetbrains/kotlin/test/model/TestModule;Lorg/jetbrains/kotlin/test/model/ResultingArtifact;Z)Lorg/jetbrains/kotlin/test/TestStep$StepResult$HandlersResult;", "test-infrastructure_test"})
    public static final class HandlersStep<InputArtifact extends ResultingArtifact<InputArtifact>>
    extends TestStep {
        @NotNull
        private final TestArtifactKind<InputArtifact> inputArtifactKind;
        @NotNull
        private final List<AnalysisHandler<InputArtifact>> handlers;

        public HandlersStep(@NotNull TestArtifactKind<InputArtifact> inputArtifactKind, @NotNull List<? extends AnalysisHandler<InputArtifact>> handlers) {
            Intrinsics.checkNotNullParameter(inputArtifactKind, (String)"inputArtifactKind");
            Intrinsics.checkNotNullParameter(handlers, (String)"handlers");
            super(null);
            this.inputArtifactKind = inputArtifactKind;
            this.handlers = handlers;
            for (AnalysisHandler<InputArtifact> handler : this.handlers) {
                if (Intrinsics.areEqual(handler.getArtifactKind(), this.getInputArtifactKind())) continue;
                boolean bl = false;
                String string = "Artifact kind mismatch. Artifact kind of each handler must match input artifact kind (" + this.getInputArtifactKind() + "). In handler " + handler + " artifact kind is " + handler.getArtifactKind();
                throw new IllegalArgumentException(string.toString());
            }
        }

        @Override
        @NotNull
        public TestArtifactKind<InputArtifact> getInputArtifactKind() {
            return this.inputArtifactKind;
        }

        @NotNull
        public final List<AnalysisHandler<InputArtifact>> getHandlers() {
            return this.handlers;
        }

        @NotNull
        public StepResult.HandlersResult processModule(@NotNull TestModule module, @NotNull InputArtifact inputArtifact, boolean thereWereExceptionsOnPreviousSteps) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(inputArtifact, (String)"inputArtifact");
            List exceptions = new ArrayList();
            for (AnalysisHandler<InputArtifact> outputHandler : this.handlers) {
                if (!TestRunner.Companion.shouldRun(outputHandler, thereWereExceptionsOnPreviousSteps || !((Collection)exceptions).isEmpty())) continue;
                try {
                    outputHandler.processModule(module, inputArtifact);
                }
                catch (Throwable e) {
                    ((Collection)exceptions).add(new WrappedException.FromHandler(e, module, outputHandler));
                    if (!outputHandler.getFailureDisablesNextSteps()) continue;
                    return new StepResult.HandlersResult(exceptions, false);
                }
            }
            return new StepResult.HandlersResult(exceptions, true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u000e\b\u0002\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0004\u0006\u0007\b\tB\t\b\u0004\u00a2\u0006\u0004\b\u0004\u0010\u0005\u0082\u0001\u0004\n\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "OutputArtifact", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "", "<init>", "()V", "Artifact", "ErrorFromFacade", "HandlersResult", "NoArtifactFromFacade", "Lorg/jetbrains/kotlin/test/TestStep$StepResult$Artifact;", "Lorg/jetbrains/kotlin/test/TestStep$StepResult$ErrorFromFacade;", "Lorg/jetbrains/kotlin/test/TestStep$StepResult$HandlersResult;", "Lorg/jetbrains/kotlin/test/TestStep$StepResult$NoArtifactFromFacade;", "test-infrastructure_test"})
    public static abstract class StepResult<OutputArtifact extends ResultingArtifact<OutputArtifact>> {
        private StepResult() {
        }

        public /* synthetic */ StepResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\u000e\b\u0003\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0004\u001a\u00028\u0003\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/test/TestStep$StepResult$Artifact;", "OutputArtifact", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "outputArtifact", "<init>", "(Lorg/jetbrains/kotlin/test/model/ResultingArtifact;)V", "getOutputArtifact", "()Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "test-infrastructure_test"})
        public static final class Artifact<OutputArtifact extends ResultingArtifact<OutputArtifact>>
        extends StepResult<OutputArtifact> {
            @NotNull
            private final OutputArtifact outputArtifact;

            public Artifact(@NotNull OutputArtifact outputArtifact) {
                Intrinsics.checkNotNullParameter(outputArtifact, (String)"outputArtifact");
                super(null);
                this.outputArtifact = outputArtifact;
            }

            @NotNull
            public final OutputArtifact getOutputArtifact() {
                return this.outputArtifact;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\u000e\b\u0003\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/test/TestStep$StepResult$ErrorFromFacade;", "OutputArtifact", "Lorg/jetbrains/kotlin/test/model/ResultingArtifact;", "Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "exception", "Lorg/jetbrains/kotlin/test/WrappedException;", "<init>", "(Lorg/jetbrains/kotlin/test/WrappedException;)V", "getException", "()Lorg/jetbrains/kotlin/test/WrappedException;", "test-infrastructure_test"})
        public static final class ErrorFromFacade<OutputArtifact extends ResultingArtifact<OutputArtifact>>
        extends StepResult<OutputArtifact> {
            @NotNull
            private final WrappedException exception;

            public ErrorFromFacade(@NotNull WrappedException exception) {
                Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
                super(null);
                this.exception = exception;
            }

            @NotNull
            public final WrappedException getException() {
                return this.exception;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0007H\u00c6\u0003J#\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/test/TestStep$StepResult$HandlersResult;", "Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "", "exceptionsFromHandlers", "", "Lorg/jetbrains/kotlin/test/WrappedException;", "shouldRunNextSteps", "", "<init>", "(Ljava/util/Collection;Z)V", "getExceptionsFromHandlers", "()Ljava/util/Collection;", "getShouldRunNextSteps", "()Z", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "test-infrastructure_test"})
        public static final class HandlersResult
        extends StepResult {
            @NotNull
            private final Collection<WrappedException> exceptionsFromHandlers;
            private final boolean shouldRunNextSteps;

            public HandlersResult(@NotNull Collection<? extends WrappedException> exceptionsFromHandlers, boolean shouldRunNextSteps) {
                Intrinsics.checkNotNullParameter(exceptionsFromHandlers, (String)"exceptionsFromHandlers");
                super(null);
                this.exceptionsFromHandlers = exceptionsFromHandlers;
                this.shouldRunNextSteps = shouldRunNextSteps;
            }

            @NotNull
            public final Collection<WrappedException> getExceptionsFromHandlers() {
                return this.exceptionsFromHandlers;
            }

            public final boolean getShouldRunNextSteps() {
                return this.shouldRunNextSteps;
            }

            @NotNull
            public final Collection<WrappedException> component1() {
                return this.exceptionsFromHandlers;
            }

            public final boolean component2() {
                return this.shouldRunNextSteps;
            }

            @NotNull
            public final HandlersResult copy(@NotNull Collection<? extends WrappedException> exceptionsFromHandlers, boolean shouldRunNextSteps) {
                Intrinsics.checkNotNullParameter(exceptionsFromHandlers, (String)"exceptionsFromHandlers");
                return new HandlersResult(exceptionsFromHandlers, shouldRunNextSteps);
            }

            public static /* synthetic */ HandlersResult copy$default(HandlersResult handlersResult, Collection collection, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    collection = handlersResult.exceptionsFromHandlers;
                }
                if ((n & 2) != 0) {
                    bl = handlersResult.shouldRunNextSteps;
                }
                return handlersResult.copy(collection, bl);
            }

            @NotNull
            public String toString() {
                return "HandlersResult(exceptionsFromHandlers=" + this.exceptionsFromHandlers + ", shouldRunNextSteps=" + this.shouldRunNextSteps + ')';
            }

            public int hashCode() {
                int result = ((Object)this.exceptionsFromHandlers).hashCode();
                result = result * 31 + Boolean.hashCode(this.shouldRunNextSteps);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof HandlersResult)) {
                    return false;
                }
                HandlersResult handlersResult = (HandlersResult)other;
                if (!Intrinsics.areEqual(this.exceptionsFromHandlers, handlersResult.exceptionsFromHandlers)) {
                    return false;
                }
                return this.shouldRunNextSteps == handlersResult.shouldRunNextSteps;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0013\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00d6\u0003J\t\u0010\t\u001a\u00020\nH\u00d6\u0001J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/test/TestStep$StepResult$NoArtifactFromFacade;", "Lorg/jetbrains/kotlin/test/TestStep$StepResult;", "", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "test-infrastructure_test"})
        public static final class NoArtifactFromFacade
        extends StepResult {
            @NotNull
            public static final NoArtifactFromFacade INSTANCE = new NoArtifactFromFacade();

            private NoArtifactFromFacade() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "NoArtifactFromFacade";
            }

            public int hashCode() {
                return 978463293;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NoArtifactFromFacade)) {
                    return false;
                }
                NoArtifactFromFacade cfr_ignored_0 = (NoArtifactFromFacade)other;
                return true;
            }
        }
    }
}

