/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0002\u001a/\u0010\u0004\u001a\u0002H\u0005\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"initIdeaConfiguration", "", "computeHomeDirectory", "", "runWithEnablingFirUseOption", "T", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "lambda", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lorg/jetbrains/kotlin/test/model/TestModule;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "tests-common-new_test"})
public final class TestSetupUtilsKt {
    public static final void initIdeaConfiguration() {
        System.setProperty("idea.home", TestSetupUtilsKt.computeHomeDirectory());
        System.setProperty("idea.ignore.disabled.plugins", "true");
    }

    private static final String computeHomeDirectory() {
        String userDir = System.getProperty("user.dir");
        String string = userDir;
        if (string == null) {
            string = ".";
        }
        String string2 = new File(string).getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalPath(...)");
        return string2;
    }

    public static final <T> T runWithEnablingFirUseOption(@NotNull TestServices testServices, @NotNull TestModule module, @NotNull Function0<? extends T> lambda) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(lambda, (String)"lambda");
        CompilerConfiguration compilerConfiguration = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(testServices).getCompilerConfiguration(module);
        compilerConfiguration.put(CommonConfigurationKeys.USE_FIR, (Object)true);
        LanguageVersionSettings previousLanguageSettings = CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)compilerConfiguration);
        CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)compilerConfiguration, (LanguageVersionSettings)new LanguageVersionSettings(previousLanguageSettings){
            private final /* synthetic */ LanguageVersionSettings $$delegate_0;
            {
                this.$$delegate_0 = $previousLanguageSettings;
            }

            public LanguageVersion getLanguageVersion() {
                return LanguageVersion.LATEST_STABLE;
            }

            public LanguageFeature.State getFeatureSupport(LanguageFeature feature) {
                Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
                return this.$$delegate_0.getFeatureSupport(feature);
            }

            public boolean supportsFeature(LanguageFeature feature) {
                Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
                return this.$$delegate_0.supportsFeature(feature);
            }

            public boolean isPreRelease() {
                return this.$$delegate_0.isPreRelease();
            }

            public <T> T getFlag(AnalysisFlag<? extends T> flag) {
                Intrinsics.checkNotNullParameter(flag, (String)"flag");
                return (T)this.$$delegate_0.getFlag(flag);
            }

            public ApiVersion getApiVersion() {
                return this.$$delegate_0.getApiVersion();
            }
        });
        Object result = lambda.invoke();
        CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)compilerConfiguration, (LanguageVersionSettings)previousLanguageSettings);
        compilerConfiguration.put(CommonConfigurationKeys.USE_FIR, (Object)false);
        return (T)result;
    }
}

