/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.io.FilesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.forTestCompile.ForTestCompileRuntime;
import org.jetbrains.kotlin.test.KtAssert;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.StringsKt;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Analyzer;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicVerifier;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.util.Printer;
import org.jetbrains.org.objectweb.asm.util.Textifier;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public class CodegenTestUtil {
    private CodegenTestUtil() {
    }

    public static void assertThrows(@NotNull Method foo, @NotNull Class<? extends Throwable> exceptionClass, @Nullable Object instance, Object ... args2) throws IllegalAccessException {
        if (foo == null) {
            CodegenTestUtil.$$$reportNull$$$0(0);
        }
        if (exceptionClass == null) {
            CodegenTestUtil.$$$reportNull$$$0(1);
        }
        if (args2 == null) {
            CodegenTestUtil.$$$reportNull$$$0(2);
        }
        boolean caught = false;
        try {
            foo.invoke(instance, args2);
        }
        catch (InvocationTargetException ex) {
            caught = exceptionClass.isInstance(ex.getTargetException());
        }
        KtAssert.assertTrue(String.format("Exception of class %s must be thrown", exceptionClass.getName()), caught);
    }

    @NotNull
    public static Method findDeclaredMethodByName(@NotNull Class<?> aClass, @NotNull String name) {
        Method result;
        if (aClass == null) {
            CodegenTestUtil.$$$reportNull$$$0(3);
        }
        if (name == null) {
            CodegenTestUtil.$$$reportNull$$$0(4);
        }
        if ((result = CodegenTestUtil.findDeclaredMethodByNameOrNull(aClass, name)) == null) {
            throw new AssertionError((Object)("Method " + name + " is not found in " + aClass));
        }
        Method method = result;
        if (method == null) {
            CodegenTestUtil.$$$reportNull$$$0(5);
        }
        return method;
    }

    public static Method findDeclaredMethodByNameOrNull(@NotNull Class<?> aClass, @NotNull String name) {
        if (aClass == null) {
            CodegenTestUtil.$$$reportNull$$$0(6);
        }
        if (name == null) {
            CodegenTestUtil.$$$reportNull$$$0(7);
        }
        for (Method method : aClass.getDeclaredMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    @NotNull
    public static List<String> prepareJavacOptions(@NotNull List<String> additionalClasspath, @NotNull List<String> additionalOptions, @NotNull File outDirectory, boolean isJava9Module) {
        if (additionalClasspath == null) {
            CodegenTestUtil.$$$reportNull$$$0(8);
        }
        if (additionalOptions == null) {
            CodegenTestUtil.$$$reportNull$$$0(9);
        }
        if (outDirectory == null) {
            CodegenTestUtil.$$$reportNull$$$0(10);
        }
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(ForTestCompileRuntime.runtimeJarForTests().getPath());
        classpath.add(ForTestCompileRuntime.reflectJarForTests().getPath());
        classpath.add(KtTestUtil.getAnnotationsJar().getPath());
        classpath.addAll(additionalClasspath);
        String classPathOrModulePath = isJava9Module ? "--module-path" : "-classpath";
        ArrayList<String> options = new ArrayList<String>(Arrays.asList(classPathOrModulePath, StringsKt.join(classpath, (String)File.pathSeparator), "-d", outDirectory.getPath()));
        options.addAll(additionalOptions);
        ArrayList<String> arrayList = options;
        if (arrayList == null) {
            CodegenTestUtil.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    public static Method findTheOnlyMethod(@NotNull Class<?> aClass) {
        if (aClass == null) {
            CodegenTestUtil.$$$reportNull$$$0(12);
        }
        Method r = null;
        for (Method method : aClass.getMethods()) {
            if (method.getDeclaringClass().equals(Object.class)) continue;
            if (r != null) {
                throw new AssertionError((Object)("More than one public method in class " + aClass));
            }
            r = method;
        }
        if (r == null) {
            throw new AssertionError((Object)("No public methods in class " + aClass));
        }
        Method method = r;
        if (method == null) {
            CodegenTestUtil.$$$reportNull$$$0(13);
        }
        return method;
    }

    @Nullable
    public static Object getAnnotationAttribute(@NotNull Object annotation, @NotNull String name) {
        if (annotation == null) {
            CodegenTestUtil.$$$reportNull$$$0(14);
        }
        if (name == null) {
            CodegenTestUtil.$$$reportNull$$$0(15);
        }
        try {
            return annotation.getClass().getMethod(name, new Class[0]).invoke(annotation, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
    }

    @NotNull
    public static List<String> findJavaSourcesInDirectory(@NotNull File directory) {
        if (directory == null) {
            CodegenTestUtil.$$$reportNull$$$0(16);
        }
        ArrayList<String> javaFilePaths = new ArrayList<String>(1);
        FileUtil.processFilesRecursively((File)directory, file -> {
            if (file.isFile() && FilesKt.getExtension((File)file).equals("java")) {
                javaFilePaths.add(file.getPath());
            }
            return true;
        });
        ArrayList<String> arrayList = javaFilePaths;
        if (arrayList == null) {
            CodegenTestUtil.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    public static boolean verifyAllFilesWithAsm(ClassFileFactory factory, boolean reportProblems) {
        boolean noErrors = true;
        for (OutputFile file : ClassFileUtilsKt.getClassFiles((ClassFileFactory)factory)) {
            noErrors &= CodegenTestUtil.verifyWithAsm(file, reportProblems);
        }
        return noErrors;
    }

    private static boolean verifyWithAsm(@NotNull OutputFile file, boolean reportProblems) {
        if (file == null) {
            CodegenTestUtil.$$$reportNull$$$0(18);
        }
        ClassNode classNode = new ClassNode();
        new ClassReader(file.asByteArray()).accept((ClassVisitor)classNode, 0);
        BasicVerifier verifier = new BasicVerifier();
        Analyzer analyzer = new Analyzer((Interpreter)verifier);
        boolean noErrors = true;
        for (MethodNode method : classNode.methods) {
            try {
                analyzer.analyze(classNode.name, method);
            }
            catch (Throwable e) {
                if (reportProblems) {
                    try {
                        System.err.println(file.asText());
                        System.err.println(classNode.name + "::" + method.name + method.desc);
                    }
                    catch (Throwable ex) {
                        System.err.println("Exception thrown while trying to generate text:");
                        ex.printStackTrace();
                        System.err.println("---");
                    }
                    if (e instanceof AnalyzerException) {
                        TraceMethodVisitor tmv = new TraceMethodVisitor((Printer)new Textifier());
                        ((AnalyzerException)e).node.accept((MethodVisitor)tmv);
                        PrintWriter pw = new PrintWriter(System.err);
                        tmv.p.print(pw);
                        pw.flush();
                    }
                    e.printStackTrace();
                }
                noErrors = false;
            }
        }
        return noErrors;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 3: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/CodegenTestUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalClasspath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalOptions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDirectory";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/CodegenTestUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeclaredMethodByName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareJavacOptions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findTheOnlyMethod";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findJavaSourcesInDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "assertThrows";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaredMethodByName";
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 17: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaredMethodByNameOrNull";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareJavacOptions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findTheOnlyMethod";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationAttribute";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findJavaSourcesInDirectory";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "verifyWithAsm";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

