/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codeMetaInfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codeMetaInfo.model.ParsedCodeMetaInfo;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/codeMetaInfo/CodeMetaInfoParser;", "", "<init>", "()V", "openingRegex", "Lkotlin/text/Regex;", "getOpeningRegex", "()Lkotlin/text/Regex;", "closingRegex", "getClosingRegex", "openingOrClosingRegex", "getOpeningOrClosingRegex", "tagRegex", "getCodeMetaInfoFromText", "", "Lorg/jetbrains/kotlin/codeMetaInfo/model/ParsedCodeMetaInfo;", "renderedText", "", "Opening", "test-infrastructure-utils_test"})
@SourceDebugExtension(value={"SMAP\nCodeMetaInfoParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeMetaInfoParser.kt\norg/jetbrains/kotlin/codeMetaInfo/CodeMetaInfoParser\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,107:1\n1321#2,2:108\n*S KotlinDebug\n*F\n+ 1 CodeMetaInfoParser.kt\norg/jetbrains/kotlin/codeMetaInfo/CodeMetaInfoParser\n*L\n88#1:108,2\n*E\n"})
public final class CodeMetaInfoParser {
    @NotNull
    public static final CodeMetaInfoParser INSTANCE = new CodeMetaInfoParser();
    @NotNull
    private static final Regex openingRegex = new Regex("(<!([^\"]*?((\".*?\")(, \".*?\")*?)?[^\"]*?)!>)");
    @NotNull
    private static final Regex closingRegex = new Regex("(<!>)");
    @NotNull
    private static final Regex openingOrClosingRegex = new Regex('(' + closingRegex.getPattern() + '|' + openingRegex.getPattern() + ')');
    @NotNull
    private static final Regex tagRegex = new Regex("([\\S&&[^,(){}]]+)([{](.*?)[}])?(\\(\"((?:\\\\\"|.)*?)\"\\))?(, )?");

    private CodeMetaInfoParser() {
    }

    @NotNull
    public final Regex getOpeningRegex() {
        return openingRegex;
    }

    @NotNull
    public final Regex getClosingRegex() {
        return closingRegex;
    }

    @NotNull
    public final Regex getOpeningOrClosingRegex() {
        return openingOrClosingRegex;
    }

    @NotNull
    public final List<ParsedCodeMetaInfo> getCodeMetaInfoFromText(@NotNull String renderedText) {
        Intrinsics.checkNotNullParameter((Object)renderedText, (String)"renderedText");
        String text = renderedText;
        ArrayDeque openings = new ArrayDeque();
        ArrayDeque stackOfOpenings = new ArrayDeque();
        Map closingOffsets = new LinkedHashMap();
        List result = new ArrayList();
        int counter = 0;
        while (true) {
            String string;
            Object openingMatch;
            int openingStartOffset = Integer.MAX_VALUE;
            int closingStartOffset = Integer.MAX_VALUE;
            MatchResult opening = Regex.find$default((Regex)openingRegex, (CharSequence)text, (int)0, (int)2, null);
            MatchResult closing = Regex.find$default((Regex)closingRegex, (CharSequence)text, (int)0, (int)2, null);
            if (opening == null && closing == null) break;
            if (opening != null) {
                openingStartOffset = opening.getRange().getFirst();
            }
            if (closing != null) {
                closingStartOffset = closing.getRange().getFirst();
            }
            if (openingStartOffset < closingStartOffset) {
                if (opening == null) {
                    String string2 = "Required value was null.";
                    throw new IllegalArgumentException(string2.toString());
                }
                int n = counter++;
                MatchGroup matchGroup = opening.getGroups().get(2);
                Intrinsics.checkNotNull((Object)matchGroup);
                openingMatch = new Opening(n, matchGroup.getValue(), opening.getRange().getFirst());
                openings.addLast(openingMatch);
                stackOfOpenings.addLast(openingMatch);
                String string3 = text;
                int n2 = opening.getRange().getLast() + 1;
                string = ((Object)StringsKt.removeRange((CharSequence)string3, (int)openingStartOffset, (int)n2)).toString();
            } else {
                if (closing == null) {
                    openingMatch = "Required value was null.";
                    throw new IllegalArgumentException(openingMatch.toString());
                }
                closingOffsets.put(stackOfOpenings.removeLast(), closing.getRange().getFirst());
                openingMatch = text;
                int n = closing.getRange().getLast() + 1;
                string = ((Object)StringsKt.removeRange((CharSequence)((CharSequence)openingMatch), (int)closingStartOffset, (int)n)).toString();
            }
            text = string;
        }
        if (openings.size() != closingOffsets.size()) {
            throw new IllegalStateException("Opening and closing tags counts are not equals".toString());
        }
        while (!openings.isEmpty()) {
            Opening openingMatchResult = (Opening)openings.removeLast();
            int closingMatchResult = ((Number)MapsKt.getValue((Map)closingOffsets, (Object)openingMatchResult)).intValue();
            String allMetaInfos = openingMatchResult.getTags();
            Sequence $this$forEach$iv = SequencesKt.map((Sequence)Regex.findAll$default((Regex)tagRegex, (CharSequence)allMetaInfos, (int)0, (int)2, null), CodeMetaInfoParser::getCodeMetaInfoFromText$lambda$0);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String[] stringArray;
                MatchGroupCollection it = (MatchGroupCollection)element$iv;
                boolean bl = false;
                MatchGroup matchGroup = it.get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                String tag = matchGroup.getValue();
                Object object = it.get(3);
                if (object == null || (object = object.getValue()) == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{";"}), (boolean)false, (int)0, (int)6, null)) == null) {
                    object = CollectionsKt.emptyList();
                }
                Object attributes = object;
                MatchGroup matchGroup2 = it.get(5);
                String description = matchGroup2 != null ? matchGroup2.getValue() : null;
                result.add(new ParsedCodeMetaInfo(openingMatchResult.getStartOffset(), closingMatchResult, CollectionsKt.toMutableList((Collection)((Collection)attributes)), tag, description));
            }
        }
        return result;
    }

    private static final MatchGroupCollection getCodeMetaInfoFromText$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getGroups();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/codeMetaInfo/CodeMetaInfoParser$Opening;", "", "index", "", "tags", "", "startOffset", "<init>", "(ILjava/lang/String;I)V", "getIndex", "()I", "getTags", "()Ljava/lang/String;", "getStartOffset", "equals", "", "other", "hashCode", "test-infrastructure-utils_test"})
    private static final class Opening {
        private final int index;
        @NotNull
        private final String tags;
        private final int startOffset;

        public Opening(int index, @NotNull String tags, int startOffset) {
            Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
            this.index = index;
            this.tags = tags;
            this.startOffset = startOffset;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final String getTags() {
            return this.tags;
        }

        public final int getStartOffset() {
            return this.startOffset;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.codeMetaInfo.CodeMetaInfoParser.Opening");
            Opening cfr_ignored_0 = (Opening)other;
            return this.index == ((Opening)other).index;
        }

        public int hashCode() {
            return this.index;
        }
    }
}

