/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.ir;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrTypeVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/test/backend/ir/IrConstChecker;", "Lorg/jetbrains/kotlin/ir/visitors/IrTypeVisitorVoid;", "<init>", "()V", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitFile", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitType", "container", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "checkAnnotations", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nIrConstCheckerHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrConstCheckerHandler.kt\norg/jetbrains/kotlin/test/backend/ir/IrConstChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1869#2:82\n1869#2:83\n1869#2,2:84\n1870#2:86\n1870#2:87\n*S KotlinDebug\n*F\n+ 1 IrConstCheckerHandler.kt\norg/jetbrains/kotlin/test/backend/ir/IrConstChecker\n*L\n63#1:82\n70#1:83\n74#1:84,2\n70#1:86\n63#1:87\n*E\n"})
final class IrConstChecker
extends IrTypeVisitorVoid {
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IrVisitorsKt.acceptChildrenVoid((IrElement)element, (IrElementVisitorVoid)((IrElementVisitorVoid)this));
    }

    public void visitFile(@NotNull IrFile declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.checkAnnotations((IrAnnotationContainer)declaration);
        IrVisitorsKt.acceptChildrenVoid((IrElement)((IrElement)declaration), (IrElementVisitorVoid)((IrElementVisitorVoid)this));
    }

    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.checkAnnotations((IrAnnotationContainer)declaration);
        IrVisitorsKt.acceptChildrenVoid((IrElement)((IrElement)declaration), (IrElementVisitorVoid)((IrElementVisitorVoid)this));
    }

    public void visitType(@NotNull IrElement container, @NotNull IrType type) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.checkAnnotations((IrAnnotationContainer)type);
    }

    public void visitField(@NotNull IrField declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        IrPropertySymbol irPropertySymbol = declaration.getCorrespondingPropertySymbol();
        boolean bl = irPropertySymbol != null && (irPropertySymbol = (IrProperty)irPropertySymbol.getOwner()) != null ? irPropertySymbol.isConst() : false;
        if (bl) {
            IrExpressionBody irExpressionBody = declaration.getInitializer();
            if (!((irExpressionBody != null ? irExpressionBody.getExpression() : null) instanceof IrConst)) {
                IrExpressionBody irExpressionBody2 = declaration.getInitializer();
                String string = "Const field is not containing const expression. Got " + (irExpressionBody2 != null ? DumpIrTreeKt.dump$default((IrElement)((IrElement)irExpressionBody2), null, (int)1, null) : null);
                throw new IllegalStateException(string.toString());
            }
        }
        super.visitField(declaration);
    }

    private final void checkAnnotations(IrAnnotationContainer container) {
        Iterable $this$forEach$iv = container.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrConstructorCall annotation = (IrConstructorCall)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = IrUtilsKt.getAllArgumentsWithIr((IrMemberAccessExpression)((IrMemberAccessExpression)annotation));
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IrExpression actualArg;
                IrExpression irExpression;
                Pair pair = (Pair)element$iv2;
                boolean bl2 = false;
                IrValueParameter param = (IrValueParameter)pair.component1();
                IrExpression arg = (IrExpression)pair.component2();
                Object object = arg;
                if (object == null) {
                    IrExpressionBody irExpressionBody = param.getDefaultValue();
                    object = irExpressionBody != null ? irExpressionBody.getExpression() : null;
                }
                if ((irExpression = (actualArg = object)) == null) {
                    throw new IllegalStateException(("IR annotation has null argument.\n Annotation: " + DumpIrTreeKt.dump$default((IrElement)((IrElement)annotation), null, (int)1, null) + '.').toString());
                }
                if (irExpression instanceof IrVararg) {
                    Iterable $this$forEach$iv3 = ((IrVararg)actualArg).getElements();
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        IrVarargElement element = (IrVarargElement)element$iv3;
                        boolean bl3 = false;
                        IrConstChecker.checkAnnotations$lambda$2$checkIsConst((IrElement)element, annotation);
                    }
                    continue;
                }
                IrConstChecker.checkAnnotations$lambda$2$checkIsConst((IrElement)actualArg, annotation);
            }
        }
    }

    private static final boolean checkAnnotations$isConst(IrElement $this$checkAnnotations_u24isConst) {
        return $this$checkAnnotations_u24isConst instanceof IrConst || $this$checkAnnotations_u24isConst instanceof IrGetEnumValue || $this$checkAnnotations_u24isConst instanceof IrClassReference || $this$checkAnnotations_u24isConst instanceof IrConstructorCall && IrTypeUtilsKt.isAnnotation((IrType)((IrConstructorCall)$this$checkAnnotations_u24isConst).getType());
    }

    private static final void checkAnnotations$lambda$2$checkIsConst(IrElement $this$checkAnnotations_u24lambda_u242_u24checkIsConst, IrConstructorCall $annotation) {
        if (IrConstChecker.checkAnnotations$isConst($this$checkAnnotations_u24lambda_u242_u24checkIsConst)) {
            return;
        }
        if ($this$checkAnnotations_u24lambda_u242_u24checkIsConst instanceof IrErrorExpression && StringsKt.startsWith$default((String)((IrErrorExpression)$this$checkAnnotations_u24lambda_u242_u24checkIsConst).getDescription(), (String)"Stub expression", (boolean)false, (int)2, null)) {
            return;
        }
        throw new IllegalStateException(("IR annotation has non constant argument.\n Annotation: " + DumpIrTreeKt.dump$default((IrElement)((IrElement)$annotation), null, (int)1, null) + ".\n Argument: " + DumpIrTreeKt.dump$default((IrElement)$this$checkAnnotations_u24lambda_u242_u24checkIsConst, null, (int)1, null)).toString());
    }
}

