/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.ir;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.backend.BlackBoxCodegenSuppressor;
import org.jetbrains.kotlin.test.backend.ir.AbiCheckerSuppressor;
import org.jetbrains.kotlin.test.backend.ir.AbiCheckerSuppressorKt;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.utils.FunctionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/test/backend/ir/AbiCheckerSuppressor;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "additionalServices", "", "Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;", "getAdditionalServices", "()Ljava/util/List;", "suppressIfNeeded", "Lorg/jetbrains/kotlin/test/WrappedException;", "failedAssertions", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nAbiCheckerSuppressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbiCheckerSuppressor.kt\norg/jetbrains/kotlin/test/backend/ir/AbiCheckerSuppressor\n+ 2 TestServices.kt\norg/jetbrains/kotlin/test/services/TestServicesKt\n*L\n1#1,60:1\n25#2:61\n*S KotlinDebug\n*F\n+ 1 AbiCheckerSuppressor.kt\norg/jetbrains/kotlin/test/backend/ir/AbiCheckerSuppressor\n*L\n33#1:61\n*E\n"})
public final class AbiCheckerSuppressor
extends AfterAnalysisChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public AbiCheckerSuppressor(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<ServiceRegistrationData> getAdditionalServices() {
        Function1 serviceConstructor$iv = FunctionsKt.bind((Function2)additionalServices.1.INSTANCE, null);
        boolean $i$f$service = false;
        return CollectionsKt.listOf((Object)new ServiceRegistrationData((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(BlackBoxCodegenSuppressor.SuppressionChecker.class), (Function1<? super TestServices, ? extends TestService>)serviceConstructor$iv));
    }

    @Override
    @NotNull
    public List<WrappedException> suppressIfNeeded(@NotNull List<? extends WrappedException> failedAssertions) {
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        boolean isDifferenceExplained = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(CodegenTestDirectives.INSTANCE.getJVM_ABI_K1_K2_DIFF());
        if (Companion.ignoredByBackendOrInliner(this.getTestServices())) {
            if (isDifferenceExplained) {
                return CollectionsKt.listOf((Object)this.wrap((Throwable)((Object)new AssertionError((Object)("No K1/K2 JVM ABI comparison done for this test. Please remove " + CodegenTestDirectives.INSTANCE.getJVM_ABI_K1_K2_DIFF().getName() + " directive.")))));
            }
            return CollectionsKt.emptyList();
        }
        return failedAssertions;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/test/backend/ir/AbiCheckerSuppressor$Companion;", "", "<init>", "()V", "ignoredByBackendOrInliner", "", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean ignoredByBackendOrInliner(@NotNull TestServices testServices) {
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            return AbiCheckerSuppressorKt.access$getIgnoredByBackend(testServices) || AbiCheckerSuppressorKt.access$getIgnoredByInliner(testServices);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

