/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.classic;

import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.CompilerEnvironment;
import org.jetbrains.kotlin.resolve.TargetEnvironment;
import org.jetbrains.kotlin.resolve.multiplatform.IsCommonSourceKt;
import org.jetbrains.kotlin.test.frontend.K1AndK2OutputArtifact;
import org.jetbrains.kotlin.test.frontend.classic.ClassicFrontendOutputArtifact;
import org.jetbrains.kotlin.test.frontend.classic.ModuleDescriptorProvider;
import org.jetbrains.kotlin.test.frontend.classic.ModuleDescriptorProviderKt;
import org.jetbrains.kotlin.test.frontend.classic.MultiplatformAnalysisConfiguration;
import org.jetbrains.kotlin.test.frontend.classic.MultiplatformAnalysisConfigurationKt;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.ArtifactsProvider;
import org.jetbrains.kotlin.test.services.ArtifactsProviderKt;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.SourceFileProvider;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/MultiplatformSeparateAnalysisConfiguration;", "Lorg/jetbrains/kotlin/test/frontend/classic/MultiplatformAnalysisConfiguration;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "artifactsProvider", "Lorg/jetbrains/kotlin/test/services/ArtifactsProvider;", "sourceFileProvider", "Lorg/jetbrains/kotlin/test/services/SourceFileProvider;", "moduleDescriptorProvider", "Lorg/jetbrains/kotlin/test/frontend/classic/ModuleDescriptorProvider;", "getCompilerEnvironment", "Lorg/jetbrains/kotlin/resolve/TargetEnvironment;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "getDependencyDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getDependsOnDescriptors", "getFriendDescriptors", "getKtFilesForForSourceFiles", "", "Lorg/jetbrains/kotlin/test/model/TestFile;", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nMultiplatformAnalysisConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiplatformAnalysisConfiguration.kt\norg/jetbrains/kotlin/test/frontend/classic/MultiplatformSeparateAnalysisConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n1869#2,2:185\n*S KotlinDebug\n*F\n+ 1 MultiplatformAnalysisConfiguration.kt\norg/jetbrains/kotlin/test/frontend/classic/MultiplatformSeparateAnalysisConfiguration\n*L\n95#1:185,2\n*E\n"})
public final class MultiplatformSeparateAnalysisConfiguration
implements MultiplatformAnalysisConfiguration {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final ArtifactsProvider artifactsProvider;
    @NotNull
    private final SourceFileProvider sourceFileProvider;
    @NotNull
    private final ModuleDescriptorProvider moduleDescriptorProvider;

    public MultiplatformSeparateAnalysisConfiguration(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
        this.artifactsProvider = ArtifactsProviderKt.getArtifactsProvider(this.testServices);
        this.sourceFileProvider = SourceFileProviderKt.getSourceFileProvider(this.testServices);
        this.moduleDescriptorProvider = ModuleDescriptorProviderKt.getModuleDescriptorProvider(this.testServices);
    }

    @Override
    @NotNull
    public TargetEnvironment getCompilerEnvironment(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return (TargetEnvironment)CompilerEnvironment.INSTANCE;
    }

    @Override
    @NotNull
    public List<ModuleDescriptor> getDependencyDescriptors(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return MultiplatformAnalysisConfigurationKt.access$getDescriptors(CollectionsKt.minus((Iterable)module.getAllDependencies(), (Iterable)CollectionsKt.toSet((Iterable)module.getDependsOnDependencies())), this.moduleDescriptorProvider);
    }

    @Override
    @NotNull
    public List<ModuleDescriptor> getDependsOnDescriptors(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public List<ModuleDescriptor> getFriendDescriptors(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return MultiplatformAnalysisConfigurationKt.access$getDescriptors(module.getFriendDependencies(), this.moduleDescriptorProvider);
    }

    @Override
    @NotNull
    public Map<TestFile, KtFile> getKtFilesForForSourceFiles(@NotNull Project project, @NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Map ktFilesMap = MapsKt.toMutableMap((Map)SourceFileProviderKt.getKtFilesForSourceFiles$default(this.sourceFileProvider, module.getFiles(), project, false, 4, null));
        MultiplatformSeparateAnalysisConfiguration.getKtFilesForForSourceFiles$addDependsOnSources(this, project, ktFilesMap, module.getDependsOnDependencies());
        return ktFilesMap;
    }

    private static final void getKtFilesForForSourceFiles$addDependsOnSources(MultiplatformSeparateAnalysisConfiguration this$0, Project $project, Map<TestFile, KtFile> ktFilesMap, List<DependencyDescription> dependencies) {
        if (dependencies.isEmpty()) {
            return;
        }
        for (DependencyDescription dependency : dependencies) {
            TestModule dependencyModule = dependency.getDependencyModule();
            ClassicFrontendOutputArtifact artifact = Intrinsics.areEqual(DefaultsProviderKt.getDefaultsProvider(this$0.testServices).getFrontendKind(), (Object)FrontendKinds.ClassicAndFIR.INSTANCE) ? ((K1AndK2OutputArtifact)this$0.artifactsProvider.getArtifact(dependencyModule, FrontendKinds.ClassicAndFIR.INSTANCE)).getK1Artifact() : (ClassicFrontendOutputArtifact)this$0.artifactsProvider.getArtifact(dependencyModule, FrontendKinds.ClassicFrontend.INSTANCE);
            Map ktFiles = SourceFileProviderKt.getKtFilesForSourceFiles$default(this$0.sourceFileProvider, artifact.getAllKtFiles().keySet(), $project, false, 4, null);
            Iterable $this$forEach$iv = ktFiles.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtFile ktFile = (KtFile)element$iv;
                boolean bl = false;
                IsCommonSourceKt.setCommonSource((KtFile)ktFile, (Boolean)true);
            }
            ktFilesMap.putAll(ktFiles);
            MultiplatformSeparateAnalysisConfiguration.getKtFilesForForSourceFiles$addDependsOnSources(this$0, $project, ktFilesMap, dependencyModule.getDependsOnDependencies());
        }
    }
}

