/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.directives;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.backend.TargetInliner;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.model.ValueDirective;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.FrontendKinds;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a8\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u0002\u00a8\u0006\u000e"}, d2={"isApplicableTo", "", "Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;", "Lorg/jetbrains/kotlin/test/TargetBackend;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "extractIgnoredDirectiveForTargetBackend", "targetBackend", "customIgnoreDirective", "tryRetrieveIgnoredInliner", "Lorg/jetbrains/kotlin/test/backend/TargetInliner;", "directive", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nCodegenTestDirectives.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodegenTestDirectives.kt\norg/jetbrains/kotlin/test/directives/CodegenTestDirectivesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,304:1\n1#2:305\n*E\n"})
public final class CodegenTestDirectivesKt {
    public static final boolean isApplicableTo(@NotNull ValueDirective<TargetBackend> $this$isApplicableTo, @NotNull TestModule module, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter($this$isApplicableTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        List<TargetBackend> specifiedBackends = module.getDirectives().get($this$isApplicableTo);
        return CollectionsKt.contains((Iterable)specifiedBackends, (Object)((Object)DefaultsProviderKt.getDefaultsProvider(testServices).getTargetBackend())) || specifiedBackends.contains((Object)TargetBackend.ANY);
    }

    @Nullable
    public static final ValueDirective<TargetBackend> extractIgnoredDirectiveForTargetBackend(@NotNull TestServices testServices, @NotNull TestModule module, @NotNull TargetBackend targetBackend, @Nullable ValueDirective<TargetBackend> customIgnoreDirective) {
        ValueDirective<TargetBackend> valueDirective;
        ValueDirective<TargetBackend> valueDirective2;
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)((Object)targetBackend), (String)"targetBackend");
        FrontendKind<?> frontendKind = DefaultsProviderKt.getDefaultsProvider(testServices).getFrontendKind();
        ValueDirective<TargetBackend> valueDirective3 = Intrinsics.areEqual(frontendKind, (Object)FrontendKinds.ClassicFrontend.INSTANCE) ? CodegenTestDirectives.INSTANCE.getIGNORE_BACKEND_K1() : (valueDirective2 = Intrinsics.areEqual(frontendKind, (Object)FrontendKinds.FIR.INSTANCE) ? CodegenTestDirectives.INSTANCE.getIGNORE_BACKEND_K2() : null);
        if (valueDirective2 != null) {
            ValueDirective<TargetBackend> specificIgnoreDirective = valueDirective2;
            boolean bl = false;
            valueDirective = customIgnoreDirective;
            if (valueDirective == null) {
                if (!module.getDirectives().contains(specificIgnoreDirective)) {
                    valueDirective = CodegenTestDirectives.INSTANCE.getIGNORE_BACKEND();
                } else {
                    List<TargetBackend> it = module.getDirectives().get(CodegenTestDirectives.INSTANCE.getIGNORE_BACKEND());
                    boolean bl2 = false;
                    boolean inCommonIgnored = it.contains((Object)targetBackend) || it.contains((Object)TargetBackend.ANY);
                    List<TargetBackend> it2 = module.getDirectives().get(specificIgnoreDirective);
                    boolean bl3 = false;
                    boolean inSpecificIgnored = it2.contains((Object)targetBackend) || it2.contains((Object)TargetBackend.ANY);
                    if (inCommonIgnored && inSpecificIgnored) {
                        throw new AssertionError((Object)("Both, IGNORE_BACKEND and " + specificIgnoreDirective.getName() + " contain target backend " + targetBackend.name() + ". Please remove one of them."));
                    }
                    valueDirective = inCommonIgnored ? CodegenTestDirectives.INSTANCE.getIGNORE_BACKEND() : specificIgnoreDirective;
                }
            }
        } else {
            valueDirective = null;
        }
        return valueDirective;
    }

    public static /* synthetic */ ValueDirective extractIgnoredDirectiveForTargetBackend$default(TestServices testServices, TestModule testModule, TargetBackend targetBackend, ValueDirective valueDirective, int n, Object object) {
        if ((n & 8) != 0) {
            valueDirective = null;
        }
        return CodegenTestDirectivesKt.extractIgnoredDirectiveForTargetBackend(testServices, testModule, targetBackend, valueDirective);
    }

    @Nullable
    public static final TargetInliner tryRetrieveIgnoredInliner(@NotNull TestServices $this$tryRetrieveIgnoredInliner, @NotNull ValueDirective<TargetInliner> directive) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$tryRetrieveIgnoredInliner), (String)"<this>");
        Intrinsics.checkNotNullParameter(directive, (String)"directive");
        String directiveName = directive.getName();
        List<TargetInliner> ignoreDirectives = TestModuleStructureKt.getModuleStructure($this$tryRetrieveIgnoredInliner).getAllDirectives().get(directive);
        if (ignoreDirectives.size() > 1) {
            throw new IllegalArgumentException("Directive " + directiveName + " should contains only one value");
        }
        return (TargetInliner)((Object)CollectionsKt.singleOrNull(ignoreDirectives));
    }
}

