/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.directives.TestPhaseDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.model.ArtifactKind;
import org.jetbrains.kotlin.test.model.BackendKind;
import org.jetbrains.kotlin.test.model.FrontendKind;
import org.jetbrains.kotlin.test.model.TestArtifactKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestPhaseLabel;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.CustomTestDataUtilsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u0006\u0012\u0002\b\u00030\u0014H\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bH\u0002J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bH\u0002J*\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000bH\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/test/services/PhasedPipelineChecker;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "order", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker$Order;", "getOrder", "()Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker$Order;", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "suppressIfNeeded", "Lorg/jetbrains/kotlin/test/WrappedException;", "failedAssertions", "toPhase", "Lorg/jetbrains/kotlin/test/services/TestPhaseLabel;", "Lorg/jetbrains/kotlin/test/model/TestArtifactKind;", "checkLatestPhaseDirective", "checkPhaseConsistency", "reportMissingDirective", "createDiffsForAllTestDataFiles", "message", "", "newContent", "Lkotlin/Function1;", "sortFailures", "Lorg/jetbrains/kotlin/test/services/PhasedPipelineChecker$SortedFailures;", "SortedFailures", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nPhasedPipelineChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhasedPipelineChecker.kt\norg/jetbrains/kotlin/test/services/PhasedPipelineChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n1#2:185\n1#2:196\n1#2:212\n1617#3,9:186\n1869#3:195\n1870#3:197\n1626#3:198\n774#3:199\n865#3,2:200\n1617#3,9:202\n1869#3:211\n1870#3:213\n1626#3:214\n*S KotlinDebug\n*F\n+ 1 PhasedPipelineChecker.kt\norg/jetbrains/kotlin/test/services/PhasedPipelineChecker\n*L\n90#1:196\n120#1:212\n90#1:186,9\n90#1:195\n90#1:197\n90#1:198\n120#1:199\n120#1:200,2\n120#1:202,9\n120#1:211\n120#1:213\n120#1:214\n*E\n"})
public final class PhasedPipelineChecker
extends AfterAnalysisChecker {
    public PhasedPipelineChecker(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public AfterAnalysisChecker.Order getOrder() {
        return AfterAnalysisChecker.Order.P4;
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)TestPhaseDirectives.INSTANCE);
    }

    @Override
    @NotNull
    public List<WrappedException> suppressIfNeeded(@NotNull List<? extends WrappedException> failedAssertions) {
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        WrappedException wrappedException = this.checkLatestPhaseDirective();
        if (wrappedException != null) {
            WrappedException it = wrappedException;
            boolean bl = false;
            return CollectionsKt.plus((Collection)failedAssertions, (Object)it);
        }
        TestPhaseLabel targetedPhase = (TestPhaseLabel)((Object)CollectionsKt.firstOrNull(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().get(TestPhaseDirectives.INSTANCE.getRUN_PIPELINE_TILL())));
        if (targetedPhase == null) {
            return CollectionsKt.plus((Collection)failedAssertions, (Iterable)this.reportMissingDirective(failedAssertions));
        }
        SortedFailures sortedFailures = this.sortFailures(failedAssertions);
        List<WrappedException> suppressibleFailures = sortedFailures.component1();
        List<WrappedException> nonSuppressibleFailures = sortedFailures.component2();
        boolean hasFailuresInNonLeafModule = sortedFailures.component3();
        return CollectionsKt.plus((Collection)nonSuppressibleFailures, (Iterable)(suppressibleFailures.isEmpty() && !hasFailuresInNonLeafModule ? this.checkPhaseConsistency() : CollectionsKt.emptyList()));
    }

    private final TestPhaseLabel toPhase(TestArtifactKind<?> $this$toPhase) {
        TestArtifactKind<?> testArtifactKind = $this$toPhase;
        return testArtifactKind instanceof FrontendKind ? TestPhaseLabel.FRONTEND : (testArtifactKind instanceof BackendKind ? TestPhaseLabel.FIR2IR : (testArtifactKind instanceof ArtifactKind ? TestPhaseLabel.BACKEND : null));
    }

    private final WrappedException checkLatestPhaseDirective() {
        String string;
        List latestPhases = CollectionsKt.distinct((Iterable)TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().get(TestPhaseDirectives.INSTANCE.getLATEST_PHASE_IN_PIPELINE()));
        switch (latestPhases.size()) {
            case 0: {
                string = "LATEST_PHASE_IN_PIPELINE directive is not specified for the test";
                break;
            }
            case 1: {
                return null;
            }
            default: {
                string = "LATEST_PHASE_IN_PIPELINE directive defined multiple times: " + latestPhases;
            }
        }
        String message = string;
        return new WrappedException.FromAfterAnalysisChecker(new IllegalStateException(message));
    }

    private final List<WrappedException> checkPhaseConsistency() {
        RegisteredDirectives directives = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives();
        if (directives.contains(TestPhaseDirectives.INSTANCE.getDISABLE_NEXT_PHASE_SUGGESTION())) {
            return CollectionsKt.emptyList();
        }
        TestPhaseLabel expectedLastPhase = (TestPhaseLabel)((Object)CollectionsKt.first(directives.get(TestPhaseDirectives.INSTANCE.getLATEST_PHASE_IN_PIPELINE())));
        TestPhaseLabel targetedPhase = (TestPhaseLabel)((Object)CollectionsKt.firstOrNull(directives.get(TestPhaseDirectives.INSTANCE.getRUN_PIPELINE_TILL())));
        if (targetedPhase != null && targetedPhase.compareTo((Enum)expectedLastPhase) > 0) {
            String message = "RUN_PIPELINE_TILL (" + (Object)((Object)targetedPhase) + ") cannot be greater than " + TestPhaseDirectives.INSTANCE.getLATEST_PHASE_IN_PIPELINE() + " (" + (Object)((Object)expectedLastPhase) + ')';
            return CollectionsKt.listOf((Object)new WrappedException.FromAfterAnalysisChecker(new IllegalStateException(message)));
        }
        return this.createDiffsForAllTestDataFiles("Phase " + (Object)((Object)targetedPhase) + " could be promoted to " + (Object)((Object)expectedLastPhase), (Function1<? super String, String>)((Function1)arg_0 -> PhasedPipelineChecker.checkPhaseConsistency$lambda$1(targetedPhase, expectedLastPhase, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<WrappedException> reportMissingDirective(List<? extends WrappedException> failedAssertions) {
        void $this$mapNotNullTo$iv$iv;
        Object message;
        List<TestPhaseLabel> latestPhases = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().get(TestPhaseDirectives.INSTANCE.getLATEST_PHASE_IN_PIPELINE());
        Object object = (TestPhaseLabel)((Object)CollectionsKt.singleOrNull(latestPhases));
        if (object == null) {
            PhasedPipelineChecker $this$reportMissingDirective_u24lambda_u242 = this;
            boolean bl = false;
            message = latestPhases.size() == 0 ? "LATEST_PHASE_IN_PIPELINE directive is not specified for the test" : "LATEST_PHASE_IN_PIPELINE directive defined multiple times: " + latestPhases;
            object = new WrappedException.FromAfterAnalysisChecker(new IllegalStateException((String)message));
        }
        TestPhaseLabel expectedLastPhase = object;
        Iterable $this$mapNotNull$iv = failedAssertions;
        boolean $i$f$mapNotNull = false;
        message = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            TestPhaseLabel it$iv$iv;
            TestArtifactKind<?> testArtifactKind;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            WrappedException it = (WrappedException)element$iv$iv;
            boolean bl2 = false;
            WrappedException wrappedException = it;
            TestArtifactKind<Object> testArtifactKind2 = testArtifactKind = wrappedException instanceof WrappedException.FromFacade ? ((WrappedException.FromFacade)it).getFacade().getOutputKind() : (wrappedException instanceof WrappedException.FromHandler && ((WrappedException.FromHandler)it).getFailureDisablesNextSteps() ? ((WrappedException.FromHandler)it).getHandler().getArtifactKind() : null);
            if ((testArtifactKind != null ? this.toPhase(testArtifactKind) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        TestPhaseLabel testPhaseLabel = (TestPhaseLabel)((Object)CollectionsKt.minOrNull((Iterable)((List)destination$iv$iv)));
        if (testPhaseLabel == null) {
            testPhaseLabel = expectedLastPhase;
        }
        TestPhaseLabel proposedPhase = testPhaseLabel;
        return this.createDiffsForAllTestDataFiles("Please specify the test phase in `// RUN_PIPELINE_TILL` directive", (Function1<? super String, String>)((Function1)arg_0 -> PhasedPipelineChecker.reportMissingDirective$lambda$4((Object)((Object)proposedPhase), arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<WrappedException> createDiffsForAllTestDataFiles(String message, Function1<? super String, String> newContent) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        List list;
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        File originalFile = CustomTestDataUtilsKt.getOriginalTestDataFile(testDataFile);
        if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)testDataFile), (Object)"nkt")) {
            list = CollectionsKt.listOf((Object)testDataFile);
        } else {
            Object[] objectArray = new File[]{originalFile, CustomTestDataUtilsKt.getFirTestDataFile(originalFile), CustomTestDataUtilsKt.getLlFirTestDataFile(originalFile), CustomTestDataUtilsKt.getLatestLVTestDataFile(originalFile), CustomTestDataUtilsKt.getReversedTestDataFile(originalFile)};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        List filesList = list;
        Iterable $this$filter$iv = filesList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.exists()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            WrappedException.FromAfterAnalysisChecker it$iv$iv;
            WrappedException.FromAfterAnalysisChecker fromAfterAnalysisChecker;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            File file = (File)element$iv$iv;
            boolean bl2 = false;
            String contentWithNewDirective = (String)newContent.invoke((Object)FilesKt.readText$default((File)file, null, (int)1, null));
            try {
                Assertions.assertEqualsToFile$default(AssertionsKt.getAssertions(this.getTestServices()), file, contentWithNewDirective, null, () -> PhasedPipelineChecker.createDiffsForAllTestDataFiles$lambda$7$lambda$6(message), 4, null);
                fromAfterAnalysisChecker = null;
            }
            catch (AssertionError e) {
                fromAfterAnalysisChecker = new WrappedException.FromAfterAnalysisChecker((Throwable)((Object)e));
            }
            if (fromAfterAnalysisChecker == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final SortedFailures sortFailures(List<? extends WrappedException> failedAssertions) {
        List suppressibleFailures = new ArrayList();
        List<WrappedException> nonSuppressibleFailures = new ArrayList();
        TestPhaseLabel targetedPhase = (TestPhaseLabel)((Object)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().get(TestPhaseDirectives.INSTANCE.getRUN_PIPELINE_TILL())));
        Ref.BooleanRef hasFailuresInNonLeafModule = new Ref.BooleanRef();
        for (WrappedException wrappedException : failedAssertions) {
            List<WrappedException> list;
            WrappedException wrappedException2 = wrappedException;
            if (wrappedException2 instanceof WrappedException.FromMetaInfoHandler) {
                list = nonSuppressibleFailures;
            } else if (wrappedException2 instanceof WrappedException.FromFacade) {
                list = PhasedPipelineChecker.sortFailures$processFailure(this, hasFailuresInNonLeafModule, nonSuppressibleFailures, targetedPhase, suppressibleFailures, ((WrappedException.FromFacade)wrappedException).getFailedModule(), ((WrappedException.FromFacade)wrappedException).getFacade().getOutputKind(), wrappedException);
            } else if (wrappedException2 instanceof WrappedException.WrappedExceptionWithoutModule) {
                list = nonSuppressibleFailures;
            } else if (wrappedException2 instanceof WrappedException.FromHandler) {
                list = PhasedPipelineChecker.sortFailures$processFailure(this, hasFailuresInNonLeafModule, nonSuppressibleFailures, targetedPhase, suppressibleFailures, ((WrappedException.FromHandler)wrappedException).getFailedModule(), ((WrappedException.FromHandler)wrappedException).getHandler().getArtifactKind(), wrappedException);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List<WrappedException> targetStorage = list;
            ((Collection)targetStorage).add(wrappedException);
        }
        return new SortedFailures(suppressibleFailures, (List<? extends WrappedException>)nonSuppressibleFailures, hasFailuresInNonLeafModule.element);
    }

    private static final String checkPhaseConsistency$lambda$1(TestPhaseLabel $targetedPhase, TestPhaseLabel $expectedLastPhase, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.replace$default((String)it, (String)("// RUN_PIPELINE_TILL: " + (Object)((Object)$targetedPhase)), (String)("// RUN_PIPELINE_TILL: " + (Object)((Object)$expectedLastPhase)), (boolean)false, (int)4, null);
    }

    private static final String reportMissingDirective$lambda$4(Object $proposedPhase, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "// RUN_PIPELINE_TILL: " + $proposedPhase + '\n' + it;
    }

    private static final String createDiffsForAllTestDataFiles$lambda$7$lambda$6(String $message) {
        return $message;
    }

    private static final List<WrappedException> sortFailures$processFailure(PhasedPipelineChecker this$0, Ref.BooleanRef hasFailuresInNonLeafModule, List<WrappedException> nonSuppressibleFailures, TestPhaseLabel targetedPhase, List<WrappedException> suppressibleFailures, TestModule module, TestArtifactKind<?> kind, WrappedException exception) {
        List<WrappedException> list;
        TestPhaseLabel actualPhase = this$0.toPhase(kind);
        if (module != null && !TestModuleStructureKt.isLeafModule(module, this$0.getTestServices())) {
            hasFailuresInNonLeafModule.element = true;
            list = nonSuppressibleFailures;
        } else if (actualPhase == null) {
            list = nonSuppressibleFailures;
        } else if (actualPhase == targetedPhase) {
            list = exception instanceof WrappedException.FromHandler && ((WrappedException.FromHandler)exception).getFailureDisablesNextSteps() ? suppressibleFailures : nonSuppressibleFailures;
        } else if (actualPhase.compareTo((Enum)targetedPhase) > 0) {
            list = suppressibleFailures;
        } else if (actualPhase.compareTo((Enum)targetedPhase) < 0) {
            list = nonSuppressibleFailures;
        } else {
            AddToStdlibKt.shouldNotBeCalled$default(null, (int)1, null);
            throw new KotlinNothingValueException();
        }
        return list;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/test/services/PhasedPipelineChecker$SortedFailures;", "", "suppressibleFailures", "", "Lorg/jetbrains/kotlin/test/WrappedException;", "nonSuppressibleFailures", "hasFailuresInNonLeafModule", "", "<init>", "(Ljava/util/List;Ljava/util/List;Z)V", "getSuppressibleFailures", "()Ljava/util/List;", "getNonSuppressibleFailures", "getHasFailuresInNonLeafModule", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "tests-common-new_test"})
    private static final class SortedFailures {
        @NotNull
        private final List<WrappedException> suppressibleFailures;
        @NotNull
        private final List<WrappedException> nonSuppressibleFailures;
        private final boolean hasFailuresInNonLeafModule;

        public SortedFailures(@NotNull List<? extends WrappedException> suppressibleFailures, @NotNull List<? extends WrappedException> nonSuppressibleFailures, boolean hasFailuresInNonLeafModule) {
            Intrinsics.checkNotNullParameter(suppressibleFailures, (String)"suppressibleFailures");
            Intrinsics.checkNotNullParameter(nonSuppressibleFailures, (String)"nonSuppressibleFailures");
            this.suppressibleFailures = suppressibleFailures;
            this.nonSuppressibleFailures = nonSuppressibleFailures;
            this.hasFailuresInNonLeafModule = hasFailuresInNonLeafModule;
        }

        @NotNull
        public final List<WrappedException> getSuppressibleFailures() {
            return this.suppressibleFailures;
        }

        @NotNull
        public final List<WrappedException> getNonSuppressibleFailures() {
            return this.nonSuppressibleFailures;
        }

        public final boolean getHasFailuresInNonLeafModule() {
            return this.hasFailuresInNonLeafModule;
        }

        @NotNull
        public final List<WrappedException> component1() {
            return this.suppressibleFailures;
        }

        @NotNull
        public final List<WrappedException> component2() {
            return this.nonSuppressibleFailures;
        }

        public final boolean component3() {
            return this.hasFailuresInNonLeafModule;
        }

        @NotNull
        public final SortedFailures copy(@NotNull List<? extends WrappedException> suppressibleFailures, @NotNull List<? extends WrappedException> nonSuppressibleFailures, boolean hasFailuresInNonLeafModule) {
            Intrinsics.checkNotNullParameter(suppressibleFailures, (String)"suppressibleFailures");
            Intrinsics.checkNotNullParameter(nonSuppressibleFailures, (String)"nonSuppressibleFailures");
            return new SortedFailures(suppressibleFailures, nonSuppressibleFailures, hasFailuresInNonLeafModule);
        }

        public static /* synthetic */ SortedFailures copy$default(SortedFailures sortedFailures, List list, List list2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                list = sortedFailures.suppressibleFailures;
            }
            if ((n & 2) != 0) {
                list2 = sortedFailures.nonSuppressibleFailures;
            }
            if ((n & 4) != 0) {
                bl = sortedFailures.hasFailuresInNonLeafModule;
            }
            return sortedFailures.copy(list, list2, bl);
        }

        @NotNull
        public String toString() {
            return "SortedFailures(suppressibleFailures=" + this.suppressibleFailures + ", nonSuppressibleFailures=" + this.nonSuppressibleFailures + ", hasFailuresInNonLeafModule=" + this.hasFailuresInNonLeafModule + ')';
        }

        public int hashCode() {
            int result = ((Object)this.suppressibleFailures).hashCode();
            result = result * 31 + ((Object)this.nonSuppressibleFailures).hashCode();
            result = result * 31 + Boolean.hashCode(this.hasFailuresInNonLeafModule);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SortedFailures)) {
                return false;
            }
            SortedFailures sortedFailures = (SortedFailures)other;
            if (!Intrinsics.areEqual(this.suppressibleFailures, sortedFailures.suppressibleFailures)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.nonSuppressibleFailures, sortedFailures.nonSuppressibleFailures)) {
                return false;
            }
            return this.hasFailuresInNonLeafModule == sortedFailures.hasFailuresInNonLeafModule;
        }
    }
}

