/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.java.FirProjectSessionProvider;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.DependencyKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\fJ\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\u0010\u001a\u00020\fJ\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\u0010\u001a\u00020\fJ\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\u0010\u001a\u00020\fJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\u0010\u001a\u00020\fJ\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/FirModuleInfoProvider;", "Lorg/jetbrains/kotlin/test/services/TestService;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "firSessionProvider", "Lorg/jetbrains/kotlin/fir/java/FirProjectSessionProvider;", "getFirSessionProvider", "()Lorg/jetbrains/kotlin/fir/java/FirProjectSessionProvider;", "firModuleDataByModule", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "registerModuleData", "", "module", "moduleData", "getCorrespondingModuleData", "getRegularDependentSourceModules", "", "getDependentFriendSourceModules", "getDependentFriendSourceModulesRecursively", "getDependentDependsOnSourceModules", "getDependentModulesImpl", "dependencies", "Lorg/jetbrains/kotlin/test/model/DependencyDescription;", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nFirModuleInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirModuleInfoProvider.kt\norg/jetbrains/kotlin/test/frontend/fir/FirModuleInfoProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1563#2:58\n1634#2,3:59\n774#2:62\n865#2,2:63\n1563#2:65\n1634#2,3:66\n*S KotlinDebug\n*F\n+ 1 FirModuleInfoProvider.kt\norg/jetbrains/kotlin/test/frontend/fir/FirModuleInfoProvider\n*L\n42#1:58\n42#1:59,3\n50#1:62\n50#1:63,2\n50#1:65\n50#1:66,3\n*E\n"})
public final class FirModuleInfoProvider
implements TestService {
    @NotNull
    private final TestServices testServices;
    @NotNull
    private final FirProjectSessionProvider firSessionProvider;
    @NotNull
    private final Map<TestModule, FirModuleData> firModuleDataByModule;

    public FirModuleInfoProvider(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
        this.firSessionProvider = new FirProjectSessionProvider();
        this.firModuleDataByModule = new LinkedHashMap();
    }

    @NotNull
    public final FirProjectSessionProvider getFirSessionProvider() {
        return this.firSessionProvider;
    }

    public final void registerModuleData(@NotNull TestModule module, @NotNull FirModuleData moduleData) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)moduleData, (String)"moduleData");
        this.firModuleDataByModule.put(module, moduleData);
    }

    @NotNull
    public final FirModuleData getCorrespondingModuleData(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        FirModuleData firModuleData = this.firModuleDataByModule.get(module);
        if (firModuleData == null) {
            throw new IllegalStateException(("module data for module " + module + " is not registered").toString());
        }
        return firModuleData;
    }

    @NotNull
    public final List<FirModuleData> getRegularDependentSourceModules(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.getDependentModulesImpl(module.getRegularDependencies());
    }

    @NotNull
    public final List<FirModuleData> getDependentFriendSourceModules(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.getDependentModulesImpl(module.getFriendDependencies());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirModuleData> getDependentFriendSourceModulesRecursively(@NotNull TestModule module) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Iterable $this$map$iv = TestModuleStructureKt.transitiveFriendDependencies$default(module, false, false, null, 7, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TestModule testModule = (TestModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getCorrespondingModuleData((TestModule)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<FirModuleData> getDependentDependsOnSourceModules(@NotNull TestModule module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return this.getDependentModulesImpl(module.getDependsOnDependencies());
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirModuleData> getDependentModulesImpl(List<DependencyDescription> dependencies) {
        void $this$mapTo$iv$iv;
        DependencyDescription it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = dependencies;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DependencyDescription)element$iv$iv;
            boolean bl = false;
            if (!(it.getKind() == DependencyKind.Source)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DependencyDescription)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getCorrespondingModuleData(it.getDependencyModule()));
        }
        return (List)destination$iv$iv;
    }
}

