/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.runners;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.directives.TestTierDirectives;
import org.jetbrains.kotlin.test.model.AnalysisHandler;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.runners.TestTier;
import org.jetbrains.kotlin.test.runners.TestTierCheckerKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/test/runners/TierPassesMarker;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "tier", "Lorg/jetbrains/kotlin/test/runners/TestTier;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "origin", "Lorg/jetbrains/kotlin/test/model/AnalysisHandler;", "<init>", "(Lorg/jetbrains/kotlin/test/runners/TestTier;Lorg/jetbrains/kotlin/test/model/TestModule;Lorg/jetbrains/kotlin/test/model/AnalysisHandler;)V", "getTier", "()Lorg/jetbrains/kotlin/test/runners/TestTier;", "getModule", "()Lorg/jetbrains/kotlin/test/model/TestModule;", "getOrigin", "()Lorg/jetbrains/kotlin/test/model/AnalysisHandler;", "message", "", "getMessage", "()Ljava/lang/String;", "tests-common-new_test"})
public final class TierPassesMarker
extends Exception {
    @NotNull
    private final TestTier tier;
    @NotNull
    private final TestModule module;
    @NotNull
    private final AnalysisHandler<?> origin;

    public TierPassesMarker(@NotNull TestTier tier, @NotNull TestModule module, @NotNull AnalysisHandler<?> origin) {
        Intrinsics.checkNotNullParameter((Object)tier, (String)"tier");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(origin, (String)"origin");
        this.tier = tier;
        this.module = module;
        this.origin = origin;
    }

    @NotNull
    public final TestTier getTier() {
        return this.tier;
    }

    @NotNull
    public final TestModule getModule() {
        return this.module;
    }

    @NotNull
    public final AnalysisHandler<?> getOrigin() {
        return this.origin;
    }

    @Override
    @NotNull
    public String getMessage() {
        return "Looks like tier " + this.tier + " passes with no error diagnostics. Please update the tier directive to `// " + TestTierDirectives.INSTANCE.getRUN_PIPELINE_TILL() + ": " + this.tier.getNext() + '`' + TestTierCheckerKt.access$suggestSubsequentTiersIfAppropriate(this.tier.getNext()) + " and regenerate tests.";
    }
}

