/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.runners;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.directives.TestTierDirectives;
import org.jetbrains.kotlin.test.model.AnalysisHandler;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.runners.PartialTestTierChecker;
import org.jetbrains.kotlin.test.runners.TestTier;
import org.jetbrains.kotlin.test.runners.TestTierCheckerKt;
import org.jetbrains.kotlin.test.runners.TestTierLabel;
import org.jetbrains.kotlin.test.runners.TierPassesMarker;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\n\u001a\u0004\u0018\u00010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u0004\u0018\u00010\u000bH\u0002J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/test/runners/TestTierChecker;", "Lorg/jetbrains/kotlin/test/runners/PartialTestTierChecker;", "lastTierCurrentPipelineExecutes", "Lorg/jetbrains/kotlin/test/runners/TestTierLabel;", "numberOfMarkerHandlersPerModule", "", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/runners/TestTierLabel;ILorg/jetbrains/kotlin/test/services/TestServices;)V", "checkDirectivesFullConsistency", "Lorg/jetbrains/kotlin/test/runners/PartialTestTierChecker$TieredHandlerException;", "successfulTierMarkers", "", "Lorg/jetbrains/kotlin/test/runners/TierPassesMarker;", "thereAreOtherFailures", "", "withFailFileFullCheck", "Lorg/jetbrains/kotlin/test/WrappedException$FromAfterAnalysisChecker;", "suppressIfNeeded", "Lorg/jetbrains/kotlin/test/WrappedException;", "failedAssertions", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nTestTierChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestTierChecker.kt\norg/jetbrains/kotlin/test/runners/TestTierChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 formattingHelpers.kt\norg/jetbrains/kotlin/utils/FormattingHelpersKt\n+ 5 formattingHelpers.kt\norg/jetbrains/kotlin/utils/FormattingHelpersKt$joinToEnglishAndString$1\n+ 6 Grouping.kt\nkotlin/collections/GroupingKt__GroupingKt\n+ 7 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,276:1\n1#2:277\n1557#3:278\n1628#3,3:279\n1755#3,3:282\n1544#3:302\n1734#3,3:310\n27#4,2:285\n9#4,3:287\n12#4,11:291\n27#5:290\n53#6:303\n80#6,6:304\n76#7,11:313\n*S KotlinDebug\n*F\n+ 1 TestTierChecker.kt\norg/jetbrains/kotlin/test/runners/TestTierChecker\n*L\n212#1:278\n212#1:279,3\n215#1:282,3\n226#1:302\n231#1:310,3\n221#1:285,2\n221#1:287,3\n221#1:291,11\n221#1:290\n227#1:303\n227#1:304,6\n268#1:313,11\n*E\n"})
public final class TestTierChecker
extends PartialTestTierChecker {
    @NotNull
    private final TestTierLabel lastTierCurrentPipelineExecutes;
    private final int numberOfMarkerHandlersPerModule;

    public TestTierChecker(@NotNull TestTierLabel lastTierCurrentPipelineExecutes, int numberOfMarkerHandlersPerModule, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)lastTierCurrentPipelineExecutes), (String)"lastTierCurrentPipelineExecutes");
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
        this.lastTierCurrentPipelineExecutes = lastTierCurrentPipelineExecutes;
        this.numberOfMarkerHandlersPerModule = numberOfMarkerHandlersPerModule;
    }

    /*
     * WARNING - void declaration
     */
    private final PartialTestTierChecker.TieredHandlerException checkDirectivesFullConsistency(List<TierPassesMarker> successfulTierMarkers, boolean thereAreOtherFailures) {
        boolean everyModuleIsSuccessful;
        TestTierLabel declaredTier;
        block27: {
            boolean bl;
            Iterator destination$iv$iv;
            void $this$aggregateTo$iv$iv;
            void $this$aggregate$iv;
            Grouping $this$groupingBy$iv;
            Object list$iv$iv;
            Object conjunction$iv$iv;
            boolean bl2;
            Iterable $this$any$iv;
            List applicableTierLabels;
            Object it;
            Object object;
            List<TestTier> applicableTiers;
            block26: {
                TestTierLabel testTierLabel;
                void $this$mapTo$iv$iv;
                PartialTestTierChecker.TieredHandlerException tieredHandlerException = this.checkDirectivesBasicConsistency();
                if (tieredHandlerException != null) {
                    PartialTestTierChecker.TieredHandlerException it2 = tieredHandlerException;
                    boolean bl3 = false;
                    return it2;
                }
                applicableTiers = TestTierCheckerKt.getApplicableTestTiers(TestModuleStructureKt.getModuleStructure(this.getTestServices()));
                Iterable $this$map$iv = applicableTiers;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    TestTier testTier = (TestTier)item$iv$iv;
                    object = destination$iv$iv2;
                    boolean bl4 = false;
                    object.add(((TestTier)it).getLabel());
                }
                applicableTierLabels = (List)destination$iv$iv2;
                String string = (String)CollectionsKt.firstOrNull(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().get(TestTierDirectives.INSTANCE.getRUN_PIPELINE_TILL()));
                if (string != null) {
                    String p0 = string;
                    boolean bl5 = false;
                    testTierLabel = TestTierLabel.valueOf(p0);
                } else {
                    testTierLabel = null;
                }
                declaredTier = testTierLabel;
                $this$any$iv = successfulTierMarkers;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        TierPassesMarker it3 = (TierPassesMarker)element$iv;
                        boolean bl6 = false;
                        if (!(it3.getTier().getLabel() != this.lastTierCurrentPipelineExecutes)) continue;
                        bl2 = true;
                        break block26;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                String p0 = "Markers of tiers other than " + (Object)((Object)this.lastTierCurrentPipelineExecutes) + " should not be thrown when using a " + (Object)((Object)this.lastTierCurrentPipelineExecutes) + " runner. The test runner probably contains some redundant early-tier handlers";
                boolean bl7 = false;
                return new PartialTestTierChecker.TieredHandlerException(p0);
            }
            if (!applicableTierLabels.contains((Object)this.lastTierCurrentPipelineExecutes)) {
                String string;
                void $this$joinToEnglishString$iv$iv;
                void $this$joinToEnglishAndString_u24default$iv;
                $this$any$iv = applicableTiers;
                object = new StringBuilder().append("This is a ").append((Object)this.lastTierCurrentPipelineExecutes).append(" test runner, it's not applicable for tests configured to run ");
                boolean $i$f$joinToEnglishAndString = false;
                void element$iv = $this$joinToEnglishAndString_u24default$iv;
                conjunction$iv$iv = "and";
                boolean $i$f$joinToEnglishString = false;
                if ($this$joinToEnglishString$iv$iv.isEmpty()) {
                    string = "";
                } else if ($this$joinToEnglishString$iv$iv.size() == 1) {
                    it = CollectionsKt.first((Iterable)((Iterable)$this$joinToEnglishString$iv$iv));
                    boolean bl8 = false;
                    string = String.valueOf(it);
                } else {
                    Object it4;
                    boolean bl9;
                    StringBuilder stringBuilder;
                    StringBuilder stringBuilder2;
                    StringBuilder $this$joinToEnglishString_u24lambda_u240$iv$iv = stringBuilder2 = new StringBuilder();
                    boolean bl10 = false;
                    list$iv$iv = CollectionsKt.toList((Iterable)((Iterable)$this$joinToEnglishString$iv$iv));
                    int n = list$iv$iv.size() - 1;
                    for (int it$iv$iv = 0; it$iv$iv < n; ++it$iv$iv) {
                        Object e = list$iv$iv.get(it$iv$iv);
                        stringBuilder = $this$joinToEnglishString_u24lambda_u240$iv$iv;
                        bl9 = false;
                        it4 = e;
                        stringBuilder.append(String.valueOf(it4));
                        $this$joinToEnglishString_u24lambda_u240$iv$iv.append(", ");
                    }
                    it4 = CollectionsKt.last((List)list$iv$iv);
                    StringBuilder stringBuilder3 = new StringBuilder().append((String)conjunction$iv$iv).append(' ');
                    stringBuilder = $this$joinToEnglishString_u24lambda_u240$iv$iv;
                    bl9 = false;
                    String string2 = String.valueOf(it4);
                    stringBuilder.append(stringBuilder3.append(string2).toString());
                    string = stringBuilder2.toString();
                }
                String p0 = ((StringBuilder)object).append(string).append(". Please regenerate tests").toString();
                boolean bl11 = false;
                throw (Throwable)new PartialTestTierChecker.TieredHandlerException(p0);
            }
            Iterable p0 = successfulTierMarkers;
            boolean $i$f$groupingBy = false;
            $this$groupingBy$iv = (Grouping)new Grouping<TierPassesMarker, TestModule>((Iterable)$this$groupingBy$iv){
                final /* synthetic */ Iterable $this_groupingBy;
                {
                    this.$this_groupingBy = $receiver;
                }

                public Iterator<TierPassesMarker> sourceIterator() {
                    return this.$this_groupingBy.iterator();
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public Object keyOf(Object element) {
                    TierPassesMarker it = (TierPassesMarker)element;
                    boolean bl = false;
                    return it.getModule();
                }
            };
            boolean $i$f$aggregate = false;
            void $this$joinToEnglishString$iv$iv = $this$aggregate$iv;
            conjunction$iv$iv = new LinkedHashMap();
            boolean $i$f$aggregateTo = false;
            list$iv$iv = $this$aggregateTo$iv$iv.sourceIterator();
            while (list$iv$iv.hasNext()) {
                Object[] objectArray;
                Object object2;
                block29: {
                    void element;
                    Object[] objectArray2;
                    block28: {
                        void acc;
                        Object e$iv$iv = list$iv$iv.next();
                        Object key$iv$iv = $this$aggregateTo$iv$iv.keyOf(e$iv$iv);
                        Object accumulator$iv$iv = destination$iv$iv.get(key$iv$iv);
                        if (accumulator$iv$iv != null || !destination$iv$iv.containsKey(key$iv$iv)) {
                            // empty if block
                        }
                        TierPassesMarker tierPassesMarker = (TierPassesMarker)e$iv$iv;
                        Set it5 = (Set)accumulator$iv$iv;
                        TestModule cfr_ignored_0 = (TestModule)key$iv$iv;
                        object2 = key$iv$iv;
                        object = destination$iv$iv;
                        boolean bl12 = false;
                        objectArray = acc;
                        if (objectArray == null) break block28;
                        objectArray2 = objectArray;
                        void $this$checkDirectivesFullConsistency_u24lambda_u247_u24lambda_u246 = objectArray2;
                        boolean bl13 = false;
                        $this$checkDirectivesFullConsistency_u24lambda_u247_u24lambda_u246.add(element.getOrigin());
                        objectArray = objectArray2;
                        if (objectArray2 != null) break block29;
                    }
                    objectArray2 = new AnalysisHandler[]{element.getOrigin()};
                    objectArray = SetsKt.mutableSetOf((Object[])objectArray2);
                }
                Object[] objectArray3 = objectArray;
                object.put(object2, objectArray3);
            }
            void moduleToSuccessMarkers = destination$iv$iv;
            Iterable $this$all$iv = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (TestModule)element$iv;
                    boolean bl14 = false;
                    Set set = (Set)moduleToSuccessMarkers.get(it);
                    if (set != null ? set.size() == this.numberOfMarkerHandlersPerModule : false) continue;
                    bl = false;
                    break block27;
                }
                bl = everyModuleIsSuccessful = true;
            }
        }
        if (declaredTier != null && this.lastTierCurrentPipelineExecutes.compareTo((Enum)declaredTier) < 0) {
            String p0 = "A " + (Object)((Object)this.lastTierCurrentPipelineExecutes) + " runner is not enough for a " + (Object)((Object)declaredTier) + " test. Please regenerate tests";
            boolean bl = false;
            return new PartialTestTierChecker.TieredHandlerException(p0);
        }
        if (everyModuleIsSuccessful && !thereAreOtherFailures) {
            if (TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(TestTierDirectives.INSTANCE.getDISABLE_NEXT_TIER_SUGGESTION())) {
                return null;
            }
            this.setTierIfNeeded(((TierPassesMarker)CollectionsKt.first(successfulTierMarkers)).getTier().getNext().getLabel());
            String p0 = ((TierPassesMarker)CollectionsKt.first(successfulTierMarkers)).getMessage();
            boolean bl = false;
            return new PartialTestTierChecker.TieredHandlerException(p0);
        }
        return null;
    }

    private final WrappedException.FromAfterAnalysisChecker withFailFileFullCheck(PartialTestTierChecker.TieredHandlerException $this$withFailFileFullCheck) {
        WrappedException.FromAfterAnalysisChecker fromAfterAnalysisChecker;
        File originalFile = ((TestFile)CollectionsKt.first(((TestModule)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules())).getFiles())).getOriginalFile();
        File failFile = FileUtilsKt.withExtension(originalFile, ".tiered-failure.txt");
        PartialTestTierChecker.TieredHandlerException tieredHandlerException = $this$withFailFileFullCheck;
        if (tieredHandlerException != null) {
            fromAfterAnalysisChecker = this.withFailFileDump(tieredHandlerException);
        } else if (failFile.exists()) {
            WrappedException.FromAfterAnalysisChecker fromAfterAnalysisChecker2;
            Object p0 = "There's no error from " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + ", removing the `.tiered-failure.txt` file. Please rerun the test";
            boolean bl = false;
            p0 = new Exception((String)p0);
            boolean bl2 = false;
            WrappedException.FromAfterAnalysisChecker it = fromAfterAnalysisChecker2 = new WrappedException.FromAfterAnalysisChecker((Throwable)p0);
            boolean bl3 = false;
            failFile.delete();
            fromAfterAnalysisChecker = fromAfterAnalysisChecker2;
        } else {
            fromAfterAnalysisChecker = null;
        }
        return fromAfterAnalysisChecker;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<WrappedException> suppressIfNeeded(@NotNull List<? extends WrappedException> failedAssertions) {
        void p0;
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        Iterable $this$partitionNotNull$iv = failedAssertions;
        boolean $i$f$partitionNotNull = false;
        ArrayList<TierPassesMarker> first$iv = new ArrayList<TierPassesMarker>();
        Serializable second$iv = new ArrayList();
        for (Object element$iv : $this$partitionNotNull$iv) {
            WrappedException it = (WrappedException)element$iv;
            boolean bl = false;
            WrappedException.FromHandler fromHandler = it instanceof WrappedException.FromHandler ? (WrappedException.FromHandler)it : null;
            Throwable throwable = fromHandler != null ? fromHandler.getCause() : null;
            TierPassesMarker result$iv = throwable instanceof TierPassesMarker ? (TierPassesMarker)throwable : null;
            boolean bl2 = result$iv != null ? first$iv.add(result$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List successfulTierMarkers = (List)pair.component1();
        List otherFailures = (List)pair.component2();
        second$iv = this.withFailFileFullCheck(this.checkDirectivesFullConsistency(successfulTierMarkers, !((Collection)otherFailures).isEmpty()));
        Collection collection = otherFailures;
        boolean bl = false;
        return CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOfNotNull((Object)p0));
    }
}

