/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.runners;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.directives.TestTierDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.runners.TestTier;
import org.jetbrains.kotlin.test.runners.TestTierCheckerKt;
import org.jetbrains.kotlin.test.runners.TestTierLabel;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.CustomTestDataUtilsKt;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;
import org.opentest4j.AssertionFailedError;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0004J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0010H\u0004J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0004J\u0014\u0010\u001e\u001a\u00020\u0018*\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0018\u0010\u001a\u001a\u00020\u001b*\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/test/runners/PartialTestTierChecker;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "check", "", "failedAssertions", "Lorg/jetbrains/kotlin/test/WrappedException;", "checkDirectivesBasicConsistency", "Lorg/jetbrains/kotlin/test/runners/PartialTestTierChecker$TieredHandlerException;", "withFailFileDump", "Lorg/jetbrains/kotlin/test/WrappedException$FromAfterAnalysisChecker;", "suppressIfNeeded", "setTierIfNeeded", "label", "Lorg/jetbrains/kotlin/test/runners/TestTierLabel;", "isDirectiveSetInTest", "", "()Z", "originalOrNktTestDataFile", "Ljava/io/File;", "getOriginalOrNktTestDataFile", "(Ljava/io/File;)Ljava/io/File;", "featuresDirective", "directive", "", "Companion", "TieredHandlerException", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nTestTierChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestTierChecker.kt\norg/jetbrains/kotlin/test/runners/PartialTestTierChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 formattingHelpers.kt\norg/jetbrains/kotlin/utils/FormattingHelpersKt\n+ 5 formattingHelpers.kt\norg/jetbrains/kotlin/utils/FormattingHelpersKt$joinToEnglishAndString$1\n*L\n1#1,276:1\n1557#2:277\n1628#2,3:278\n1863#2,2:299\n1755#2,3:301\n1#3:281\n27#4,2:282\n9#4,3:284\n12#4,11:288\n27#5:287\n*S KotlinDebug\n*F\n+ 1 TestTierChecker.kt\norg/jetbrains/kotlin/test/runners/PartialTestTierChecker\n*L\n100#1:277\n100#1:278,3\n171#1:299,2\n187#1:301,3\n117#1:282,2\n117#1:284,3\n117#1:288,11\n117#1:287\n*E\n"})
public class PartialTestTierChecker
extends AfterAnalysisChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String UPDATE_TIERS_AUTOMATICALLY_PROPERTY_NAME = "kotlin.test.update-tiers-automatically";
    private static final boolean UPDATE_TIERS_AUTOMATICALLY = Intrinsics.areEqual((Object)System.getProperty("kotlin.test.update-tiers-automatically", "true"), (Object)"true");
    @NotNull
    public static final String TIERED_FAILURE_EXTENSION = ".tiered-failure.txt";

    public PartialTestTierChecker(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)TestTierDirectives.INSTANCE);
    }

    @Override
    public void check(@NotNull List<? extends WrappedException> failedAssertions) {
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final TieredHandlerException checkDirectivesBasicConsistency() {
        String p0;
        TestTierLabel declaredTier;
        TestTierLabel testTierLabel;
        Object object;
        Collection $this$mapTo$iv$iv;
        List<TestTier> applicableTiers = TestTierCheckerKt.getApplicableTestTiers(TestModuleStructureKt.getModuleStructure(this.getTestServices()));
        Iterable $this$map$iv = applicableTiers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TestTier testTier = (TestTier)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            object.add(it.getLabel());
        }
        List applicableTierLabels = (List)destination$iv$iv;
        List<String> disableText = TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().get(TestTierDirectives.INSTANCE.getDISABLE_NEXT_TIER_SUGGESTION());
        String string = (String)CollectionsKt.firstOrNull(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().get(TestTierDirectives.INSTANCE.getRUN_PIPELINE_TILL()));
        if (string != null) {
            String p02 = string;
            boolean bl = false;
            testTierLabel = TestTierLabel.valueOf(p02);
        } else {
            testTierLabel = declaredTier = null;
        }
        if (!this.isDirectiveSetInTest()) {
            this.setTierIfNeeded((TestTierLabel)((Object)CollectionsKt.first((List)applicableTierLabels)));
            p0 = "There's no `// " + TestTierDirectives.INSTANCE.getRUN_PIPELINE_TILL() + "` directive in the test. Please set an appropriate tier and regenerate tests";
            boolean bl = false;
            return new TieredHandlerException(p0);
        }
        if (TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives().contains(TestTierDirectives.INSTANCE.getDISABLE_NEXT_TIER_SUGGESTION()) && disableText.isEmpty()) {
            p0 = "Please specify the reason why the tier upgrade suggestion is disabled in `// " + TestTierDirectives.INSTANCE.getDISABLE_NEXT_TIER_SUGGESTION() + '`';
            boolean bl = false;
            return new TieredHandlerException(p0);
        }
        if (declaredTier != null && !applicableTierLabels.contains((Object)declaredTier)) {
            String string2;
            void $this$joinToEnglishString$iv$iv;
            void $this$joinToEnglishAndString_u24default$iv;
            this.setTierIfNeeded((TestTierLabel)((Object)CollectionsKt.first((List)applicableTierLabels)));
            $this$mapTo$iv$iv = applicableTiers;
            object = new StringBuilder().append("The test declares the tier ").append((Object)declaredTier).append(", but is configured to only run ");
            boolean $i$f$joinToEnglishAndString = false;
            void bl = $this$joinToEnglishAndString_u24default$iv;
            String conjunction$iv$iv = "and";
            boolean $i$f$joinToEnglishString = false;
            if ($this$joinToEnglishString$iv$iv.isEmpty()) {
                string2 = "";
            } else if ($this$joinToEnglishString$iv$iv.size() == 1) {
                Object bl2 = CollectionsKt.first((Iterable)((Iterable)$this$joinToEnglishString$iv$iv));
                boolean bl3 = false;
                Object it = bl2;
                string2 = String.valueOf(it);
            } else {
                Object it;
                boolean bl4;
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2;
                StringBuilder $this$joinToEnglishString_u24lambda_u240$iv$iv = stringBuilder2 = new StringBuilder();
                boolean bl5 = false;
                List list$iv$iv = CollectionsKt.toList((Iterable)((Iterable)$this$joinToEnglishString$iv$iv));
                int n = list$iv$iv.size() - 1;
                for (int it$iv$iv = 0; it$iv$iv < n; ++it$iv$iv) {
                    Object e = list$iv$iv.get(it$iv$iv);
                    stringBuilder = $this$joinToEnglishString_u24lambda_u240$iv$iv;
                    bl4 = false;
                    it = e;
                    stringBuilder.append(String.valueOf(it));
                    $this$joinToEnglishString_u24lambda_u240$iv$iv.append(", ");
                }
                it = CollectionsKt.last((List)list$iv$iv);
                StringBuilder stringBuilder3 = new StringBuilder().append(conjunction$iv$iv).append(' ');
                stringBuilder = $this$joinToEnglishString_u24lambda_u240$iv$iv;
                bl4 = false;
                String string3 = String.valueOf(it);
                stringBuilder.append(stringBuilder3.append(string3).toString());
                string2 = stringBuilder2.toString();
            }
            p0 = ((StringBuilder)object).append(string2).append(". Please set an appropriate tier and regenerate tests").toString();
            boolean bl6 = false;
            return new TieredHandlerException(p0);
        }
        return null;
    }

    @Nullable
    protected final WrappedException.FromAfterAnalysisChecker withFailFileDump(@NotNull TieredHandlerException $this$withFailFileDump) {
        WrappedException.FromAfterAnalysisChecker fromAfterAnalysisChecker;
        Intrinsics.checkNotNullParameter((Object)$this$withFailFileDump, (String)"<this>");
        TieredHandlerException ownException = $this$withFailFileDump;
        File originalFile = ((TestFile)CollectionsKt.first(((TestModule)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules())).getFiles())).getOriginalFile();
        File failFile = FileUtilsKt.withExtension(originalFile, TIERED_FAILURE_EXTENSION);
        if (!failFile.exists()) {
            fromAfterAnalysisChecker = new WrappedException.FromAfterAnalysisChecker(ownException);
        } else {
            WrappedException.FromAfterAnalysisChecker fromAfterAnalysisChecker2;
            try {
                AssertionsKt.getAssertions(this.getTestServices()).assertEqualsToFile(failFile, ownException.getMessage(), (Function1<? super String, String>)((Function1)PartialTestTierChecker::withFailFileDump$lambda$4));
                fromAfterAnalysisChecker2 = null;
            }
            catch (AssertionFailedError a) {
                fromAfterAnalysisChecker2 = new WrappedException.FromAfterAnalysisChecker(a);
            }
            fromAfterAnalysisChecker = fromAfterAnalysisChecker2;
        }
        return fromAfterAnalysisChecker;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<WrappedException> suppressIfNeeded(@NotNull List<? extends WrappedException> failedAssertions) {
        void p0;
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        TieredHandlerException tieredHandlerException = this.checkDirectivesBasicConsistency();
        WrappedException.FromAfterAnalysisChecker fromAfterAnalysisChecker = tieredHandlerException != null ? this.withFailFileDump(tieredHandlerException) : null;
        Collection collection = failedAssertions;
        boolean bl = false;
        return CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOfNotNull((Object)p0));
    }

    /*
     * WARNING - void declaration
     */
    protected final void setTierIfNeeded(@NotNull TestTierLabel label) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)label), (String)"label");
        if (!UPDATE_TIERS_AUTOMATICALLY) {
            return;
        }
        File originalFile = this.getOriginalOrNktTestDataFile(((TestFile)CollectionsKt.first(((TestModule)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules())).getFiles())).getOriginalFile());
        File failFile = FileUtilsKt.withExtension(originalFile, TIERED_FAILURE_EXTENSION);
        if (failFile.exists()) {
            return;
        }
        Object object = new File[]{originalFile, CustomTestDataUtilsKt.getFirTestDataFile(originalFile), CustomTestDataUtilsKt.getLlFirTestDataFile(originalFile), CustomTestDataUtilsKt.getLatestLVTestDataFile(originalFile), CustomTestDataUtilsKt.getReversedTestDataFile(originalFile)};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File p0 = (File)element$iv;
            boolean bl = false;
            PartialTestTierChecker.setTierIfNeeded$writeDirective(p0, this, label);
        }
    }

    private final boolean isDirectiveSetInTest() {
        File originalFile = this.getOriginalOrNktTestDataFile(((TestFile)CollectionsKt.first(((TestModule)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules())).getFiles())).getOriginalFile());
        return this.featuresDirective(originalFile, TestTierDirectives.INSTANCE.getRUN_PIPELINE_TILL().getName());
    }

    private final File getOriginalOrNktTestDataFile(File $this$originalOrNktTestDataFile) {
        File baseFile;
        File file;
        File it = file = (baseFile = ((TestFile)CollectionsKt.first(((TestModule)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getModules())).getFiles())).getOriginalFile());
        boolean bl = false;
        String string = it.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        File file2 = StringsKt.endsWith$default((String)string, (String)".nkt", (boolean)false, (int)2, null) ? file : null;
        if (file2 == null) {
            file2 = CustomTestDataUtilsKt.getOriginalTestDataFile(baseFile);
        }
        return file2;
    }

    private final boolean featuresDirective(File $this$featuresDirective, String directive) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = FilesKt.readLines$default((File)$this$featuresDirective, null, (int)1, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    CharSequence charSequence = it;
                    if (!new Regex("^// " + directive + "\\b.*").matches(charSequence)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final String withFailFileDump$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)it, (String)"\r", (String)"", (boolean)false, (int)4, null))).toString();
    }

    private static final void setTierIfNeeded$writeDirective(File $this$setTierIfNeeded_u24writeDirective, PartialTestTierChecker this$0, TestTierLabel $label) {
        if ($this$setTierIfNeeded_u24writeDirective.exists()) {
            if (this$0.featuresDirective($this$setTierIfNeeded_u24writeDirective, TestTierDirectives.INSTANCE.getRUN_PIPELINE_TILL().getName())) {
                CharSequence charSequence = FilesKt.readText$default((File)$this$setTierIfNeeded_u24writeDirective, null, (int)1, null);
                Regex regex = new Regex("// " + TestTierDirectives.INSTANCE.getRUN_PIPELINE_TILL() + ": .*");
                String string = "// " + TestTierDirectives.INSTANCE.getRUN_PIPELINE_TILL() + ": " + (Object)((Object)$label);
                FilesKt.writeText$default((File)$this$setTierIfNeeded_u24writeDirective, (String)regex.replace(charSequence, string), null, (int)2, null);
            } else {
                FilesKt.writeText$default((File)$this$setTierIfNeeded_u24writeDirective, (String)("// " + TestTierDirectives.INSTANCE.getRUN_PIPELINE_TILL() + ": " + (Object)((Object)$label) + '\n' + FilesKt.readText$default((File)$this$setTierIfNeeded_u24writeDirective, null, (int)1, null)), null, (int)2, null);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/test/runners/PartialTestTierChecker$Companion;", "", "<init>", "()V", "UPDATE_TIERS_AUTOMATICALLY_PROPERTY_NAME", "", "UPDATE_TIERS_AUTOMATICALLY", "", "getUPDATE_TIERS_AUTOMATICALLY", "()Z", "TIERED_FAILURE_EXTENSION", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getUPDATE_TIERS_AUTOMATICALLY() {
            return UPDATE_TIERS_AUTOMATICALLY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/test/runners/PartialTestTierChecker$TieredHandlerException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "message", "", "<init>", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "tests-common-new_test"})
    protected static final class TieredHandlerException
    extends RuntimeException {
        @NotNull
        private final String message;

        public TieredHandlerException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
            this.message = message;
        }

        @Override
        @NotNull
        public String getMessage() {
            return this.message;
        }
    }
}

