/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.mutes;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.mutes.MutedSetKt;
import org.jetbrains.kotlin.test.mutes.MutedTest;
import org.jetbrains.kotlin.test.mutes.ParseError;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001c\u0010\u0000\u001a\u0004\u0018\u00010\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\b\u001a\u00020\t\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"getMutedTest", "Lorg/jetbrains/kotlin/test/mutes/MutedTest;", "testClass", "Ljava/lang/Class;", "methodKey", "", "loadMutedTests", "", "file", "Ljava/io/File;", "COLUMN_PARSE_REGEXP", "Lkotlin/text/Regex;", "MUTE_LINE_PARSE_REGEXP", "parseMutedTest", "str", "flakyTests", "tests-mutes"})
@SourceDebugExtension(value={"SMAP\nMutedTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MutedTest.kt\norg/jetbrains/kotlin/test/mutes/MutedTestKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1557#2:97\n1628#2,3:98\n774#2:101\n865#2,2:102\n*S KotlinDebug\n*F\n+ 1 MutedTest.kt\norg/jetbrains/kotlin/test/mutes/MutedTestKt\n*L\n62#1:97\n62#1:98,3\n95#1:101\n95#1:102,2\n*E\n"})
public final class MutedTestKt {
    @NotNull
    private static final Regex COLUMN_PARSE_REGEXP = new Regex("\\s*(?:(?:\"((?:[^\"]|\"\")*)\")|([^,]*))\\s*");
    @NotNull
    private static final Regex MUTE_LINE_PARSE_REGEXP = new Regex("" + COLUMN_PARSE_REGEXP + ',' + COLUMN_PARSE_REGEXP + ',' + COLUMN_PARSE_REGEXP + ',' + COLUMN_PARSE_REGEXP);

    @Nullable
    public static final MutedTest getMutedTest(@NotNull Class<?> testClass, @NotNull String methodKey) {
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        Intrinsics.checkNotNullParameter((Object)methodKey, (String)"methodKey");
        return MutedSetKt.getMutedSet().mutedTest(testClass, methodKey);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<MutedTest> loadMutedTests(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.exists()) {
            System.err.println("Can't find mute file: " + file.getAbsolutePath());
            return CollectionsKt.emptyList();
        }
        try {
            void $this$mapTo$iv$iv;
            List testLines = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)FilesKt.readLines$default((File)file, null, (int)1, null)), MutedTestKt::loadMutedTests$lambda$0), MutedTestKt::loadMutedTests$lambda$1));
            Iterable $this$map$iv = CollectionsKt.drop((Iterable)testLines, (int)1);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(MutedTestKt.parseMutedTest((String)it));
            }
            return (List)destination$iv$iv;
        }
        catch (Throwable ex) {
            throw new ParseError("Couldn't parse file with muted tests: " + file, ex);
        }
    }

    private static final MutedTest parseMutedTest(String str) {
        boolean bl;
        boolean bl2;
        MatchResult matchResult = MUTE_LINE_PARSE_REGEXP.matchEntire((CharSequence)str);
        if (matchResult == null) {
            throw new ParseError("Can't parse the line: " + str, null, 2, null);
        }
        MatchResult matchResult2 = matchResult;
        List resultValues = CollectionsKt.filterNotNull((Iterable)((Iterable)matchResult2.getGroups()));
        String testKey = ((MatchGroup)resultValues.get(1)).getValue();
        String issue = ((MatchGroup)resultValues.get(2)).getValue();
        String stateStr = ((MatchGroup)resultValues.get(3)).getValue();
        String statusStr = ((MatchGroup)resultValues.get(4)).getValue();
        switch (stateStr) {
            case "": 
            case "MUTE": {
                bl2 = false;
                break;
            }
            case "FAIL": {
                bl2 = true;
                break;
            }
            default: {
                throw new ParseError("Invalid state (`" + stateStr + "`), MUTE, FAIL or empty are expected: " + str, null, 2, null);
            }
        }
        boolean hasFailFile = bl2;
        String string = statusStr;
        if (Intrinsics.areEqual((Object)string, (Object)"FLAKY")) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)string, (Object)"")) {
            bl = false;
        } else {
            throw new ParseError("Invalid status (`" + statusStr + "`), FLAKY or empty are expected: " + str, null, 2, null);
        }
        boolean isFlaky = bl;
        return new MutedTest(testKey, issue, hasFailFile, isFlaky);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<MutedTest> flakyTests(@NotNull File file) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Iterable $this$filter$iv = MutedTestKt.loadMutedTests(file);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MutedTest it = (MutedTest)element$iv$iv;
            boolean bl = false;
            if (!it.isFlaky()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final String loadMutedTests$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }

    private static final boolean loadMutedTests$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((CharSequence)it).length() > 0;
    }
}

