/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.fir.handlers;

import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.utils.IrElementsCreationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.extensions.GeneratedDeclarationsUtilsKt;
import org.jetbrains.kotlin.fir.renderer.FirClassMemberRenderer;
import org.jetbrains.kotlin.fir.renderer.FirPackageDirectiveRenderer;
import org.jetbrains.kotlin.fir.renderer.FirRenderer;
import org.jetbrains.kotlin.fir.renderer.FirSymbolRenderer;
import org.jetbrains.kotlin.fir.renderer.FirSymbolRendererWithStaticFlag;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.HandlerUtilsKt;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.directives.ConfigurationDirectives;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputArtifact;
import org.jetbrains.kotlin.test.frontend.fir.FirOutputPartForDependsOnModule;
import org.jetbrains.kotlin.test.frontend.fir.handlers.FirAnalysisHandler;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.MultiModuleInfoDumper;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\tH\u0016J\f\u0010\u0017\u001a\u00020\t*\u00020\u0018H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirDumpHandler;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "dumper", "Lorg/jetbrains/kotlin/test/utils/MultiModuleInfoDumper;", "byteCodeListingEnabled", "", "directiveContainers", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectiveContainers", "()Ljava/util/List;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "Lorg/jetbrains/kotlin/test/frontend/fir/FirOutputArtifact;", "processAfterAllModules", "someAssertionWasFailed", "shouldSkip", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "FirClassMemberRendererWithGeneratedDeclarations", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nFirDumpHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDumpHandler.kt\norg/jetbrains/kotlin/test/frontend/fir/handlers/FirDumpHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1863#2,2:104\n*S KotlinDebug\n*F\n+ 1 FirDumpHandler.kt\norg/jetbrains/kotlin/test/frontend/fir/handlers/FirDumpHandler\n*L\n62#1:104,2\n*E\n"})
public final class FirDumpHandler
extends FirAnalysisHandler {
    @NotNull
    private final MultiModuleInfoDumper dumper;
    private boolean byteCodeListingEnabled;

    public FirDumpHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, false, false, 6, null);
        this.dumper = new MultiModuleInfoDumper(null, 1, null);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectiveContainers() {
        return CollectionsKt.listOf((Object)FirDiagnosticsDirectives.INSTANCE);
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull FirOutputArtifact info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        if (this.shouldSkip(module.getDirectives())) {
            return;
        }
        for (FirOutputPartForDependsOnModule part : info.getPartsForDependsOnModules()) {
            List list;
            TestModule currentModule = part.getModule();
            boolean bl = this.byteCodeListingEnabled = this.byteCodeListingEnabled || module.getDirectives().contains(CodegenTestDirectives.INSTANCE.getCHECK_BYTECODE_LISTING());
            if (!currentModule.getDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getFIR_DUMP())) {
                return;
            }
            StringBuilder builderForModule = this.dumper.builderForModule(currentModule);
            Map<TestFile, FirFile> firFiles = info.getMainFirFiles();
            List $this$processModule_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean $i$a$-buildList-FirDumpHandler$processModule$allFiles$22 = false;
            $this$processModule_u24lambda_u240.addAll(firFiles.values());
            $this$processModule_u24lambda_u240.addAll(IrElementsCreationUtilsKt.createFilesWithGeneratedDeclarations((FirSession)part.getSession()));
            List allFiles = CollectionsKt.build((List)list);
            FirLazyDeclarationResolverKt.getLazyDeclarationResolver((FirSession)part.getSession()).startResolvingPhase(FirResolvePhase.BODY_RESOLVE);
            $this$processModule_u24lambda_u240 = new FirPackageDirectiveRenderer();
            FirClassMemberRendererWithGeneratedDeclarations $i$a$-buildList-FirDumpHandler$processModule$allFiles$22 = new FirClassMemberRendererWithGeneratedDeclarations(part.getSession());
            FirSymbolRendererWithStaticFlag firSymbolRendererWithStaticFlag = new FirSymbolRendererWithStaticFlag();
            FirRenderer renderer = new FirRenderer(builderForModule, null, null, null, (FirClassMemberRenderer)$i$a$-buildList-FirDumpHandler$processModule$allFiles$22, null, null, null, null, (FirPackageDirectiveRenderer)$this$processModule_u24lambda_u240, null, null, null, (FirSymbolRenderer)firSymbolRendererWithStaticFlag, null, null, null, null, null, null, false, false, false, 8379886, null);
            Iterable $this$forEach$iv = allFiles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirFile it = (FirFile)element$iv;
                boolean bl2 = false;
                FirRenderer.renderElementAsString$default((FirRenderer)renderer, (FirElement)((FirElement)it), (boolean)false, (int)2, null);
            }
            FirLazyDeclarationResolverKt.getLazyDeclarationResolver((FirSession)part.getSession()).finishResolvingPhase(FirResolvePhase.BODY_RESOLVE);
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        if (this.shouldSkip(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getAllDirectives())) {
            return;
        }
        File testDataFile = (File)CollectionsKt.first(TestModuleStructureKt.getModuleStructure(this.getTestServices()).getOriginalTestDataFiles());
        String extension = this.byteCodeListingEnabled ? ".fir2.txt" : ".fir.txt";
        File file = testDataFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        File expectedFile = FilesKt.resolve((File)file, (String)(this.getNameWithoutFirExtension(testDataFile) + extension));
        if (this.dumper.isEmpty()) {
            HandlerUtilsKt.assertFileDoesntExist(this.getAssertions(), expectedFile, FirDiagnosticsDirectives.INSTANCE.getFIR_DUMP());
        } else {
            String actualText = this.dumper.generateResultingDump();
            Assertions.assertEqualsToFile$default(this.getAssertions(), expectedFile, actualText, null, FirDumpHandler::processAfterAllModules$lambda$2, 4, null);
        }
    }

    private final boolean shouldSkip(RegisteredDirectives $this$shouldSkip) {
        return $this$shouldSkip.contains(ConfigurationDirectives.INSTANCE.getDISABLE_TYPEALIAS_EXPANSION()) || $this$shouldSkip.contains(FirDiagnosticsDirectives.INSTANCE.getUSE_LATEST_LANGUAGE_VERSION());
    }

    private static final String processAfterAllModules$lambda$2() {
        return "Content is not equal";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/test/frontend/fir/handlers/FirDumpHandler$FirClassMemberRendererWithGeneratedDeclarations;", "Lorg/jetbrains/kotlin/fir/renderer/FirClassMemberRenderer;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "render", "", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "tests-common-new_test"})
    private static final class FirClassMemberRendererWithGeneratedDeclarations
    extends FirClassMemberRenderer {
        @NotNull
        private final FirSession session;

        public FirClassMemberRendererWithGeneratedDeclarations(@NotNull FirSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.session = session;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        public void render(@NotNull FirRegularClass regularClass) {
            List list;
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            List $this$render_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$render_u24lambda_u240.addAll(regularClass.getDeclarations());
            $this$render_u24lambda_u240.addAll(GeneratedDeclarationsUtilsKt.generatedMembers((FirRegularClass)regularClass, (FirSession)this.session));
            $this$render_u24lambda_u240.addAll(GeneratedDeclarationsUtilsKt.generatedNestedClassifiers((FirRegularClass)regularClass, (FirSession)this.session));
            List allDeclarations = CollectionsKt.build((List)list);
            this.render(allDeclarations);
        }
    }
}

