/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.diagnostics.rendering.RootDiagnosticRendererFactory;
import org.jetbrains.kotlin.test.backend.handlers.NoFir2IrCompilationErrorsHandler;
import org.jetbrains.kotlin.test.backend.ir.IrBackendInput;
import org.jetbrains.kotlin.test.model.BackendInputHandler;
import org.jetbrains.kotlin.test.model.BackendKinds;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.DiagnosticsService;
import org.jetbrains.kotlin.test.services.DiagnosticsServiceKt;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/NoFir2IrCompilationErrorsHandler;", "Lorg/jetbrains/kotlin/test/model/BackendInputHandler;", "Lorg/jetbrains/kotlin/test/backend/ir/IrBackendInput;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "additionalServices", "", "Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;", "getAdditionalServices", "()Ljava/util/List;", "processModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "info", "processAfterAllModules", "someAssertionWasFailed", "", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nNoFir2IrCompilationErrorsHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoFir2IrCompilationErrorsHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/NoFir2IrCompilationErrorsHandler\n+ 2 TestServices.kt\norg/jetbrains/kotlin/test/services/TestServicesKt\n*L\n1#1,51:1\n25#2:52\n*S KotlinDebug\n*F\n+ 1 NoFir2IrCompilationErrorsHandler.kt\norg/jetbrains/kotlin/test/backend/handlers/NoFir2IrCompilationErrorsHandler\n*L\n29#1:52\n*E\n"})
public final class NoFir2IrCompilationErrorsHandler
extends BackendInputHandler<IrBackendInput> {
    public NoFir2IrCompilationErrorsHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices, BackendKinds.IrBackend.INSTANCE, false, false);
    }

    @Override
    @NotNull
    public List<ServiceRegistrationData> getAdditionalServices() {
        Function1 serviceConstructor$iv = additionalServices.1.INSTANCE;
        boolean $i$f$service = false;
        return CollectionsKt.listOf((Object)new ServiceRegistrationData((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(DiagnosticsService.class), (Function1<? super TestServices, ? extends TestService>)serviceConstructor$iv));
    }

    @Override
    public void processModule(@NotNull TestModule module, @NotNull IrBackendInput info) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Map diagnosticsByFilePath = info.getDiagnosticReporter().getDiagnosticsByFilePath();
        DiagnosticsService diagnosticsService = DiagnosticsServiceKt.getDiagnosticsService(this.getTestServices());
        for (Map.Entry entry : diagnosticsByFilePath.entrySet()) {
            String file = (String)entry.getKey();
            List diagnostics = (List)entry.getValue();
            for (KtDiagnostic diagnostic : diagnostics) {
                if (diagnostic.getSeverity() != Severity.ERROR || !diagnosticsService.shouldRenderDiagnostic(module, diagnostic.getFactoryName(), diagnostic.getSeverity())) continue;
                String severity = CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly((String)AnalyzerWithCompilerReport.Companion.convertSeverity(diagnostic.getSeverity()).toString());
                String message = RootDiagnosticRendererFactory.INSTANCE.invoke(diagnostic).render(diagnostic);
                throw new IllegalStateException(('/' + file + ':' + CollectionsKt.first((List)diagnostic.getTextRanges()) + ": " + severity + ": " + message).toString());
            }
        }
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
    }
}

