/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMAssertionsMode;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmClosureGenerationScheme;
import org.jetbrains.kotlin.config.JvmSerializeIrMode;
import org.jetbrains.kotlin.config.JvmStringConcat;
import org.jetbrains.kotlin.test.BooleanPatternWithExtractor;
import org.jetbrains.kotlin.test.PatternWithExtractor;
import org.jetbrains.kotlin.test.ValuePatternWithExtractor;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0005\u001aR\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\n0\u0006\"\b\b\u0000\u0010\n*\u00020\u000b*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\n0\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u0001H\n0\u0012H\u0002\u001a2\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00130\u0006*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0002\u001a$\u0010\u0018\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u000b0\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005\u001aB\u0010\u001a\u001a\u00020\u001b2\u0016\u0010\u001c\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u000b0\u001d2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u00132\b\u0010 \u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\u000eH\u0002\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u001e\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\b\"\u0018\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"BOOLEAN_FLAG_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "patterns", "", "Lorg/jetbrains/kotlin/test/PatternWithExtractor;", "getPatterns$annotations", "()V", "createPattern", "E", "", "", "directive", "", "configurationKey", "Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "extractor", "Lkotlin/Function1;", "", "FLAG_CLASSES", "Ljava/lang/Class;", "FLAG_NAMESPACE_TO_CLASS", "", "parseAnalysisFlags", "rawFlags", "tryApplyBooleanFlag", "", "destination", "", "flag", "flagEnabled", "flagNamespace", "flagName", "tests-compiler-utils_test"})
@SourceDebugExtension(value={"SMAP\nAnalysisFlagExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalysisFlagExtractor.kt\norg/jetbrains/kotlin/test/AnalysisFlagExtractorKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
public final class AnalysisFlagExtractorKt {
    private static final Pattern BOOLEAN_FLAG_PATTERN;
    @NotNull
    private static final List<PatternWithExtractor<?>> patterns;
    @NotNull
    private static final List<Class<?>> FLAG_CLASSES;
    @NotNull
    private static final Map<String, Class<?>> FLAG_NAMESPACE_TO_CLASS;

    private static /* synthetic */ void getPatterns$annotations() {
    }

    private static final <E> PatternWithExtractor<E> createPattern(List<PatternWithExtractor<?>> $this$createPattern, String directive, CompilerConfigurationKey<E> configurationKey, Function1<? super String, ? extends E> extractor) {
        ValuePatternWithExtractor<? extends E> valuePatternWithExtractor;
        ValuePatternWithExtractor<? extends E> it = valuePatternWithExtractor = new ValuePatternWithExtractor<E>(directive, configurationKey, extractor);
        boolean bl = false;
        ((Collection)$this$createPattern).add(it);
        return valuePatternWithExtractor;
    }

    private static final PatternWithExtractor<Boolean> createPattern(List<PatternWithExtractor<?>> $this$createPattern, String directive, CompilerConfigurationKey<Boolean> configurationKey) {
        BooleanPatternWithExtractor booleanPatternWithExtractor;
        BooleanPatternWithExtractor it = booleanPatternWithExtractor = new BooleanPatternWithExtractor(directive, configurationKey);
        boolean bl = false;
        ((Collection)$this$createPattern).add(it);
        return booleanPatternWithExtractor;
    }

    @NotNull
    public static final Map<CompilerConfigurationKey<?>, Object> parseAnalysisFlags(@NotNull List<String> rawFlags) {
        Intrinsics.checkNotNullParameter(rawFlags, (String)"rawFlags");
        Map result = new LinkedHashMap();
        for (String flag : rawFlags) {
            Matcher m = BOOLEAN_FLAG_PATTERN.matcher(flag);
            if (m.matches()) {
                boolean flagEnabled = !Intrinsics.areEqual((Object)"-", (Object)m.group(1));
                String flagNamespace = m.group(3);
                String flagName = m.group(4);
                Intrinsics.checkNotNull((Object)flagName);
                AnalysisFlagExtractorKt.tryApplyBooleanFlag(result, flag, flagEnabled, flagNamespace, flagName);
                continue;
            }
            for (PatternWithExtractor<?> pattern : patterns) {
                m = pattern.getPattern().matcher(flag);
                if (!m.matches()) continue;
                Map map = result;
                CompilerConfigurationKey<?> compilerConfigurationKey = pattern.getConfigurationKey();
                Matcher matcher = m;
                Intrinsics.checkNotNull((Object)matcher);
                matcher = pattern.extract(matcher);
                map.put(compilerConfigurationKey, matcher);
            }
        }
        return result;
    }

    private static final void tryApplyBooleanFlag(Map<CompilerConfigurationKey<?>, Object> destination, String flag, boolean flagEnabled, String flagNamespace, String flagName) {
        block12: {
            boolean bl;
            Class<?> configurationKeysClass = null;
            Object configurationKeyField = null;
            if (flagNamespace == null) {
                for (Class<?> flagClass : FLAG_CLASSES) {
                    try {
                        configurationKeyField = flagClass.getField(flagName);
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            } else {
                Object object;
                boolean bl2;
                configurationKeysClass = FLAG_NAMESPACE_TO_CLASS.get(flagNamespace);
                boolean bl3 = bl2 = configurationKeysClass != null;
                if (_Assertions.ENABLED && !bl2) {
                    boolean $i$a$-assert-AnalysisFlagExtractorKt$tryApplyBooleanFlag$42 = false;
                    String $i$a$-assert-AnalysisFlagExtractorKt$tryApplyBooleanFlag$42 = "Expected [+|-][namespace.]configurationKey, got: " + flag;
                    throw new AssertionError((Object)$i$a$-assert-AnalysisFlagExtractorKt$tryApplyBooleanFlag$42);
                }
                try {
                    Class<?> clazz = configurationKeysClass;
                    Intrinsics.checkNotNull(clazz);
                    object = clazz.getField(flagName);
                }
                catch (Exception e) {
                    object = null;
                }
                configurationKeyField = object;
            }
            boolean bl4 = bl = configurationKeyField != null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl5 = false;
                String string = "Expected [+|-][namespace.]configurationKey, got: " + flag;
                throw new AssertionError((Object)string);
            }
            try {
                Field field = configurationKeyField;
                Intrinsics.checkNotNull((Object)field);
                Object object = field.get(null);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.config.CompilerConfigurationKey<kotlin.Boolean>");
                CompilerConfigurationKey configurationKey = (CompilerConfigurationKey)object;
                Boolean bl6 = flagEnabled;
                destination.put(configurationKey, bl6);
            }
            catch (Exception e) {
                if (!_Assertions.ENABLED) break block12;
                boolean bl7 = false;
                String string = "Expected [+|-][namespace.]configurationKey, got: " + flag;
                throw new AssertionError((Object)string);
            }
        }
    }

    static {
        Object[] objectArray;
        BOOLEAN_FLAG_PATTERN = Pattern.compile("([+-])(([a-zA-Z_0-9]*)\\.)?([a-zA-Z_0-9]*)");
        Object[] $this$patterns_u24lambda_u240 = objectArray = CollectionsKt.createListBuilder();
        boolean bl = false;
        AnalysisFlagExtractorKt.createPattern($this$patterns_u24lambda_u240, "ASSERTIONS_MODE", JVMConfigurationKeys.ASSERTIONS_MODE, (Function1)new Function1<String, JVMAssertionsMode>((Object)JVMAssertionsMode.Companion){

            public final JVMAssertionsMode invoke(String p0) {
                return ((JVMAssertionsMode.Companion)this.receiver).fromString(p0);
            }
        });
        AnalysisFlagExtractorKt.createPattern($this$patterns_u24lambda_u240, "STRING_CONCAT", JVMConfigurationKeys.STRING_CONCAT, (Function1)new Function1<String, JvmStringConcat>((Object)JvmStringConcat.Companion){

            public final JvmStringConcat invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((JvmStringConcat.Companion)this.receiver).fromString(p0);
            }
        });
        AnalysisFlagExtractorKt.createPattern($this$patterns_u24lambda_u240, "SAM_CONVERSIONS", JVMConfigurationKeys.SAM_CONVERSIONS, (Function1)new Function1<String, JvmClosureGenerationScheme>((Object)JvmClosureGenerationScheme.Companion){

            public final JvmClosureGenerationScheme invoke(String p0) {
                return ((JvmClosureGenerationScheme.Companion)this.receiver).fromString(p0);
            }
        });
        AnalysisFlagExtractorKt.createPattern($this$patterns_u24lambda_u240, "LAMBDAS", JVMConfigurationKeys.LAMBDAS, (Function1)new Function1<String, JvmClosureGenerationScheme>((Object)JvmClosureGenerationScheme.Companion){

            public final JvmClosureGenerationScheme invoke(String p0) {
                return ((JvmClosureGenerationScheme.Companion)this.receiver).fromString(p0);
            }
        });
        AnalysisFlagExtractorKt.createPattern($this$patterns_u24lambda_u240, "USE_OLD_INLINE_CLASSES_MANGLING_SCHEME", (CompilerConfigurationKey<Boolean>)JVMConfigurationKeys.USE_OLD_INLINE_CLASSES_MANGLING_SCHEME);
        AnalysisFlagExtractorKt.createPattern($this$patterns_u24lambda_u240, "SERIALIZE_IR", JVMConfigurationKeys.SERIALIZE_IR, (Function1)new Function1<String, JvmSerializeIrMode>((Object)JvmSerializeIrMode.Companion){

            public final JvmSerializeIrMode invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((JvmSerializeIrMode.Companion)this.receiver).fromString(p0);
            }
        });
        patterns = CollectionsKt.build((List)objectArray);
        objectArray = new Class[]{CLIConfigurationKeys.class, JVMConfigurationKeys.class};
        FLAG_CLASSES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"CLI", CLIConfigurationKeys.class), TuplesKt.to((Object)"JVM", JVMConfigurationKeys.class)};
        FLAG_NAMESPACE_TO_CLASS = MapsKt.mapOf((Pair[])objectArray);
    }
}

