/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public final class CommandLineWrapper {
    public static void main(String[] args2) throws Exception {
        try {
            Class.forName("java.lang.Module");
            System.err.println("`CommandLineWrapper` is ill-suited for launching apps on Java 9+.\nIf the run configuration uses \"classpath file\", please change it to \"@argfile\".\nOtherwise, please contact support.");
            System.exit(1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        File file = new File(args2[0]);
        AppData appData = args2[0].endsWith(".jar") ? CommandLineWrapper.loadMainClassFromClasspathJar(file, args2) : CommandLineWrapper.loadMainClassWithCustomLoader(file, args2);
        List properties = appData.properties;
        for (String property : properties) {
            if (!property.startsWith("-D")) continue;
            int p = property.indexOf(61);
            if (p > 0) {
                System.setProperty(property.substring(2, p), property.substring(p + 1));
                continue;
            }
            System.setProperty(property.substring(2), "");
        }
        Method main = appData.mainClass.getMethod("main", String[].class);
        main.setAccessible(true);
        main.invoke(null, new Object[]{appData.args});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AppData loadMainClassFromClasspathJar(File jarFile, String[] args2) throws Exception {
        String[] mainArgs;
        List<Object> properties = Collections.emptyList();
        try (JarInputStream inputStream = new JarInputStream(new FileInputStream(jarFile));){
            String programParameters;
            String vmOptions;
            Manifest manifest = inputStream.getManifest();
            String string = vmOptions = manifest != null ? manifest.getMainAttributes().getValue("VM-Options") : null;
            if (vmOptions != null) {
                properties = CommandLineWrapper.splitBySpaces(vmOptions);
            }
            String string2 = programParameters = manifest != null ? manifest.getMainAttributes().getValue("Program-Parameters") : null;
            if (programParameters == null) {
                mainArgs = Arrays.copyOfRange(args2, 2, args2.length);
            } else {
                List<String> list = CommandLineWrapper.splitBySpaces(programParameters);
                mainArgs = list.toArray(new String[0]);
            }
        }
        finally {
            jarFile.deleteOnExit();
        }
        return new AppData(properties, Class.forName(args2[1]), mainArgs);
    }

    private static List<String> splitBySpaces(String parameterString) {
        parameterString = parameterString.trim();
        ArrayList<String> params = new ArrayList<String>();
        StringBuilder token = new StringBuilder(128);
        boolean inQuotes = false;
        boolean escapedQuote = false;
        boolean nonEmpty = false;
        for (int i = 0; i < parameterString.length(); ++i) {
            char ch = parameterString.charAt(i);
            if (ch == '\"') {
                if (!escapedQuote) {
                    inQuotes = !inQuotes;
                    nonEmpty = true;
                    continue;
                }
                escapedQuote = false;
            } else if (Character.isWhitespace(ch)) {
                if (!inQuotes) {
                    if (token.length() <= 0 && !nonEmpty) continue;
                    params.add(token.toString());
                    token.setLength(0);
                    nonEmpty = false;
                    continue;
                }
            } else if (ch == '\\' && i < parameterString.length() - 1 && parameterString.charAt(i + 1) == '\"') {
                escapedQuote = true;
                continue;
            }
            token.append(ch);
        }
        if (token.length() > 0 || nonEmpty) {
            params.add(token.toString());
        }
        return params;
    }

    private static AppData loadMainClassWithCustomLoader(File classpathFile, String[] args2) throws Exception {
        String[] mainArgs;
        ArrayList<URL> classpathUrls = new ArrayList<URL>();
        StringBuilder classpathString = new StringBuilder();
        List<String> pathElements = CommandLineWrapper.readLinesAndDeleteFile(classpathFile);
        for (String pathElement : pathElements) {
            classpathUrls.add(CommandLineWrapper.toUrl(new File(pathElement)));
            if (classpathString.length() > 0) {
                classpathString.append(File.pathSeparator);
            }
            classpathString.append(pathElement);
        }
        System.setProperty("java.class.path", classpathString.toString());
        int startArgsIdx = 2;
        List<Object> properties = Collections.emptyList();
        if (args2.length > startArgsIdx && "@vm_params".equals(args2[startArgsIdx - 1])) {
            properties = CommandLineWrapper.readLinesAndDeleteFile(new File(args2[startArgsIdx]));
            startArgsIdx += 2;
        }
        if (args2.length > startArgsIdx && "@app_params".equals(args2[startArgsIdx - 1])) {
            List<String> lines2 = CommandLineWrapper.readLinesAndDeleteFile(new File(args2[startArgsIdx]));
            mainArgs = lines2.toArray(new String[0]);
            startArgsIdx += 2;
        } else {
            mainArgs = Arrays.copyOfRange(args2, startArgsIdx, args2.length);
        }
        String mainClassName = args2[startArgsIdx - 1];
        ClassLoader loader = new URLClassLoader(classpathUrls.toArray(new URL[0]), null);
        String systemLoaderName = System.getProperty("java.system.class.loader");
        if (systemLoaderName != null) {
            try {
                loader = (ClassLoader)Class.forName(systemLoaderName).getConstructor(ClassLoader.class).newInstance(loader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Class<?> mainClass = loader.loadClass(mainClassName);
        Thread.currentThread().setContextClassLoader(loader);
        return new AppData(properties, mainClass, mainArgs);
    }

    private static List<String> readLinesAndDeleteFile(File file) throws IOException {
        try {
            ArrayList<String> arrayList;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                String line;
                ArrayList<String> lines2 = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    lines2.add(line);
                }
                arrayList = lines2;
            }
            return arrayList;
        }
        finally {
            file.delete();
        }
    }

    private static URL toUrl(File classpathElement) throws MalformedURLException {
        URL url;
        try {
            url = classpathElement.toURI().toURL();
        }
        catch (NoSuchMethodError e) {
            url = classpathElement.toURL();
        }
        url = new URL("file", url.getHost(), url.getPort(), url.getFile());
        return url;
    }

    private static final class AppData {
        private final List<String> properties;
        private final Class<?> mainClass;
        private final String[] args;

        private AppData(List<String> properties, Class<?> mainClass, String[] args2) {
            this.properties = properties;
            this.mainClass = mainClass;
            this.args = args2;
        }
    }
}

