/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codeMetaInfo.model.CodeMetaInfo;
import org.jetbrains.kotlin.codeMetaInfo.model.ParsedCodeMetaInfo;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AdditionalMetaInfoProcessor;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH$J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH$J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/test/utils/AbstractTwoAttributesMetaInfoProcessor;", "Lorg/jetbrains/kotlin/test/services/AdditionalMetaInfoProcessor;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "firstAttribute", "", "getFirstAttribute", "()Ljava/lang/String;", "secondAttribute", "getSecondAttribute", "processorEnabled", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "firstAttributeEnabled", "processMetaInfos", "", "file", "Lorg/jetbrains/kotlin/test/model/TestFile;", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nAbstractTwoAttributesMetaInfoProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTwoAttributesMetaInfoProcessor.kt\norg/jetbrains/kotlin/test/utils/AbstractTwoAttributesMetaInfoProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1485#2:78\n1510#2,3:79\n1513#2,3:89\n1611#2,9:92\n1863#2:101\n1864#2:103\n1620#2:104\n381#3,7:82\n1#4:102\n*S KotlinDebug\n*F\n+ 1 AbstractTwoAttributesMetaInfoProcessor.kt\norg/jetbrains/kotlin/test/utils/AbstractTwoAttributesMetaInfoProcessor\n*L\n43#1:78\n43#1:79,3\n43#1:89,3\n65#1:92,9\n65#1:101\n65#1:103\n65#1:104\n43#1:82,7\n65#1:102\n*E\n"})
public abstract class AbstractTwoAttributesMetaInfoProcessor
extends AdditionalMetaInfoProcessor {
    public AbstractTwoAttributesMetaInfoProcessor(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @NotNull
    protected abstract String getFirstAttribute();

    @NotNull
    protected abstract String getSecondAttribute();

    protected abstract boolean processorEnabled(@NotNull TestModule var1);

    protected abstract boolean firstAttributeEnabled(@NotNull TestModule var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public void processMetaInfos(@NotNull TestModule module, @NotNull TestFile file) {
        void $this$mapNotNullTo$iv$iv;
        List<ParsedCodeMetaInfo> allExistedInfos;
        void $this$groupByTo$iv$iv;
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!this.processorEnabled(module)) {
            return;
        }
        boolean bl = this.firstAttributeEnabled(module);
        if (bl) {
            pair = TuplesKt.to((Object)this.getFirstAttribute(), (Object)this.getSecondAttribute());
        } else if (!bl) {
            pair = TuplesKt.to((Object)this.getSecondAttribute(), (Object)this.getFirstAttribute());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair pair2 = pair;
        String currentFlag = (String)pair2.component1();
        String otherFlag = (String)pair2.component2();
        Set matchedExistedInfos = new LinkedHashSet();
        Set matchedReportedInfos = new LinkedHashSet();
        List<CodeMetaInfo> allReportedInfos = this.getGlobalMetadataInfoHandler().getReportedMetaInfosForFile(file);
        Iterable $this$groupBy$iv = allReportedInfos;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo2 = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            CodeMetaInfo it = (CodeMetaInfo)element$iv$iv;
            boolean bl2 = false;
            Triple key$iv$iv = new Triple((Object)it.getStart(), (Object)it.getEnd(), (Object)it.getTag());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterator<Object> iterator = destination$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            List reportedInfos = (List)iterator.next().getValue();
            List<ParsedCodeMetaInfo> existedInfos = this.getGlobalMetadataInfoHandler().getExistingMetaInfosForActualMetadata(file, (CodeMetaInfo)CollectionsKt.first((List)reportedInfos));
            for (Pair $i$f$groupByTo2 : CollectionsKt.zip((Iterable)reportedInfos, (Iterable)existedInfos)) {
                CodeMetaInfo reportedInfo = (CodeMetaInfo)$i$f$groupByTo2.component1();
                ParsedCodeMetaInfo existedInfo = (ParsedCodeMetaInfo)$i$f$groupByTo2.component2();
                ((Collection)matchedExistedInfos).add(existedInfo);
                ((Collection)matchedReportedInfos).add(reportedInfo);
                if (!reportedInfo.getAttributes().contains(currentFlag) || existedInfo.getAttributes().contains(currentFlag)) continue;
                reportedInfo.getAttributes().remove(currentFlag);
            }
        }
        if (allReportedInfos.size() != matchedReportedInfos.size()) {
            for (CodeMetaInfo info : allReportedInfos) {
                if (matchedReportedInfos.contains(info)) continue;
                info.getAttributes().remove(currentFlag);
            }
        }
        if ((allExistedInfos = this.getGlobalMetadataInfoHandler().getExistingMetaInfosForFile(file)).size() == matchedExistedInfos.size()) {
            return;
        }
        Iterable $this$mapNotNull$iv = allExistedInfos;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ParsedCodeMetaInfo parsedCodeMetaInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl4 = false;
            ParsedCodeMetaInfo it = (ParsedCodeMetaInfo)element$iv$iv;
            boolean bl5 = false;
            if (matchedExistedInfos.contains(it)) {
                parsedCodeMetaInfo = null;
            } else if (it.getAttributes().contains(currentFlag)) {
                parsedCodeMetaInfo = null;
            } else {
                ParsedCodeMetaInfo parsedCodeMetaInfo2;
                ParsedCodeMetaInfo $this$processMetaInfos_u24lambda_u242_u24lambda_u241 = parsedCodeMetaInfo2 = it.copy();
                boolean bl6 = false;
                if (!$this$processMetaInfos_u24lambda_u242_u24lambda_u241.getAttributes().contains(otherFlag)) {
                    ((Collection)$this$processMetaInfos_u24lambda_u242_u24lambda_u241.getAttributes()).add(otherFlag);
                }
                parsedCodeMetaInfo = parsedCodeMetaInfo2;
            }
            if (parsedCodeMetaInfo == null) continue;
            ParsedCodeMetaInfo it$iv$iv = parsedCodeMetaInfo;
            boolean bl7 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List newInfos = (List)destination$iv$iv2;
        this.getGlobalMetadataInfoHandler().addMetadataInfosForFile(file, newInfos);
    }
}

