/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.fir;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.services.MetaTestConfigurator;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.CustomTestDataUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH$R\u0016\u0010\r\u001a\u00020\f*\u00020\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/test/services/fir/TestDataFileReplacer;", "Lorg/jetbrains/kotlin/test/services/MetaTestConfigurator;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "transformTestDataPath", "", "testDataFileName", "shouldReplaceFile", "", "originalFile", "Ljava/io/File;", "newFile", "getNewFile", "(Ljava/io/File;)Ljava/io/File;", "tests-common-new_test"})
public abstract class TestDataFileReplacer
extends MetaTestConfigurator {
    public TestDataFileReplacer(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public String transformTestDataPath(@NotNull String testDataFileName) {
        Intrinsics.checkNotNullParameter((Object)testDataFileName, (String)"testDataFileName");
        File originalFile = new File(testDataFileName);
        if (CustomTestDataUtilsKt.isCustomTestData(originalFile)) {
            return testDataFileName;
        }
        String string = originalFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)".reversed.", (boolean)false, (int)2, null)) {
            return testDataFileName;
        }
        if (!this.shouldReplaceFile(originalFile)) {
            return testDataFileName;
        }
        File newFile = this.getNewFile(originalFile);
        if (!newFile.exists()) {
            FilesKt.copyTo$default((File)originalFile, (File)newFile, (boolean)false, (int)0, (int)6, null);
        }
        String string2 = newFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        return string2;
    }

    protected abstract boolean shouldReplaceFile(@NotNull File var1);

    @NotNull
    protected abstract File getNewFile(@NotNull File var1);
}

