/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.directives.ConfigurationDirectives;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.EnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.RuntimeClasspathProvider;
import org.jetbrains.kotlin.test.services.RuntimeClasspathProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.KlibBasedEnvironmentConfiguratorUtils;
import org.jetbrains.kotlin.test.services.configuration.NativeEnvironmentConfiguratorKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/NativeEnvironmentConfigurator;", "Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "Companion", "tests-common-new_test"})
public final class NativeEnvironmentConfigurator
extends EnvironmentConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public NativeEnvironmentConfigurator(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        super(testServices);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/test/services/configuration/NativeEnvironmentConfigurator$Companion;", "Lorg/jetbrains/kotlin/test/services/configuration/KlibBasedEnvironmentConfiguratorUtils;", "<init>", "()V", "nativeHome", "", "getNativeHome", "()Ljava/lang/String;", "getRuntimePathsForModule", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "tests-common-new_test"})
    @SourceDebugExtension(value={"SMAP\nNativeEnvironmentConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/NativeEnvironmentConfigurator$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n13402#2,2:68\n1368#3:70\n1454#3,5:71\n1628#3,3:76\n*S KotlinDebug\n*F\n+ 1 NativeEnvironmentConfigurator.kt\norg/jetbrains/kotlin/test/services/configuration/NativeEnvironmentConfigurator$Companion\n*L\n31#1:68,2\n37#1:70\n37#1:71,5\n38#1:76,3\n*E\n"})
    public static final class Companion
    implements KlibBasedEnvironmentConfiguratorUtils {
        private Companion() {
        }

        private final String getNativeHome() {
            String string = System.getProperty("kotlin.internal.native.test.nativeHome");
            if (string == null) {
                throw new IllegalStateException("No nativeHome provided. Are you sure the test are executed within :native:native.tests?".toString());
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> getRuntimePathsForModule(@NotNull TestModule module, @NotNull TestServices testServices) {
            void $this$mapTo$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
            List result = new ArrayList();
            if (module.getDirectives().contains(ConfigurationDirectives.INSTANCE.getWITH_STDLIB())) {
                ((Collection)result).add(new File(this.getNativeHome() + "/klib/common/stdlib").getAbsolutePath());
            }
            if (module.getDirectives().contains(ConfigurationDirectives.INSTANCE.getWITH_PLATFORM_LIBS())) {
                File[] fileArray = new File(this.getNativeHome() + "/klib/platform/" + NativeEnvironmentConfiguratorKt.access$hostOsArch()).listFiles();
                if (fileArray != null) {
                    File[] $this$forEach$iv = fileArray;
                    boolean $i$f$forEach = false;
                    int n = $this$forEach$iv.length;
                    for (int i = 0; i < n; ++i) {
                        Object element$iv;
                        Object it = element$iv = $this$forEach$iv[i];
                        boolean bl = false;
                        ((Collection)result).add(((File)it).getAbsolutePath());
                    }
                }
            }
            Iterable iterable = RuntimeClasspathProviderKt.getRuntimeClasspathProviders(testServices);
            boolean $i$f$flatMap = false;
            void $i$f$forEach = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                RuntimeClasspathProvider it = (RuntimeClasspathProvider)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.runtimeClassPaths(module);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                File $i$f$flatMapTo2 = (File)item$iv;
                Collection collection = result;
                boolean bl = false;
                collection.add(it.getAbsolutePath());
            }
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

