/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H&J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H&J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u000bJ \u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u000bJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000bJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u0011J\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/test/utils/FirIdenticalCheckerHelper;", "", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "getClassicFileToCompare", "Ljava/io/File;", "testDataFile", "getFirFileToCompare", "firAndClassicContentsAreEquals", "", "trimLines", "contentsAreEquals", "classicFile", "firFile", "readContent", "", "file", "addDirectiveToClassicFileAndAssert", "", "directiveToAdd", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "removeDirectiveFromClassicFileAndAssert", "directiveToRemove", "header", "deleteFirFile", "Companion", "tests-common-new_test"})
@SourceDebugExtension(value={"SMAP\nFirIdenticalCheckerHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirIdenticalCheckerHelper.kt\norg/jetbrains/kotlin/test/utils/FirIdenticalCheckerHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1872#2,3:104\n1#3:107\n*S KotlinDebug\n*F\n+ 1 FirIdenticalCheckerHelper.kt\norg/jetbrains/kotlin/test/utils/FirIdenticalCheckerHelper\n*L\n75#1:104,3\n*E\n"})
public abstract class FirIdenticalCheckerHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TestServices testServices;
    private static final boolean isTeamCityBuild = System.getenv("TEAMCITY_VERSION") != null;

    public FirIdenticalCheckerHelper(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)((Object)testServices), (String)"testServices");
        this.testServices = testServices;
    }

    @Nullable
    public abstract File getClassicFileToCompare(@NotNull File var1);

    @Nullable
    public abstract File getFirFileToCompare(@NotNull File var1);

    public final boolean firAndClassicContentsAreEquals(@NotNull File testDataFile, boolean trimLines) {
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        File file = this.getClassicFileToCompare(testDataFile);
        if (file == null) {
            return false;
        }
        File classicFile = file;
        File file2 = this.getFirFileToCompare(testDataFile);
        if (file2 == null) {
            return true;
        }
        File firFile = file2;
        return this.contentsAreEquals(classicFile, firFile, trimLines);
    }

    public static /* synthetic */ boolean firAndClassicContentsAreEquals$default(FirIdenticalCheckerHelper firIdenticalCheckerHelper, File file, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: firAndClassicContentsAreEquals");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return firIdenticalCheckerHelper.firAndClassicContentsAreEquals(file, bl);
    }

    public final boolean contentsAreEquals(@NotNull File classicFile, @NotNull File firFile, boolean trimLines) {
        Intrinsics.checkNotNullParameter((Object)classicFile, (String)"classicFile");
        Intrinsics.checkNotNullParameter((Object)firFile, (String)"firFile");
        String classicFileContent = this.readContent(classicFile, trimLines);
        String firFileContent = this.readContent(firFile, trimLines);
        return Intrinsics.areEqual((Object)classicFileContent, (Object)firFileContent);
    }

    public static /* synthetic */ boolean contentsAreEquals$default(FirIdenticalCheckerHelper firIdenticalCheckerHelper, File file, File file2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: contentsAreEquals");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return firIdenticalCheckerHelper.contentsAreEquals(file, file2, bl);
    }

    @NotNull
    public final String readContent(@NotNull File file, boolean trimLines) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return trimLines ? ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)FilesKt.readLines$default((File)file, null, (int)1, null), (CharSequence)"\n", null, null, (int)0, null, FirIdenticalCheckerHelper::readContent$lambda$0, (int)30, null))).toString() : FilesKt.readText$default((File)file, null, (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDirectiveToClassicFileAndAssert(@NotNull File testDataFile, @NotNull Directive directiveToAdd) {
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        Intrinsics.checkNotNullParameter((Object)directiveToAdd, (String)"directiveToAdd");
        if (!isTeamCityBuild) {
            String classicFileContent = FilesKt.readText$default((File)testDataFile, null, (int)1, null);
            Object object = testDataFile;
            Object object2 = Charsets.UTF_8;
            object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)object2);
            object2 = null;
            try {
                OutputStreamWriter it = (OutputStreamWriter)object;
                boolean bl = false;
                ((Appendable)it).append("// " + directiveToAdd.getName()).append('\n');
                Writer writer = it.append(classicFileContent);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        String directiveName = directiveToAdd.getName();
        String message = isTeamCityBuild ? "Please remove .fir.txt dump and add // " + directiveName + " to test source" : "Deleted .fir.txt dump, added // " + directiveName + " to test source";
        AssertionsKt.getAssertions(this.testServices).fail((Function0<String>)((Function0)() -> FirIdenticalCheckerHelper.addDirectiveToClassicFileAndAssert$lambda$2(message)));
        throw new KotlinNothingValueException();
    }

    public static /* synthetic */ void addDirectiveToClassicFileAndAssert$default(FirIdenticalCheckerHelper firIdenticalCheckerHelper, File file, Directive directive, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addDirectiveToClassicFileAndAssert");
        }
        if ((n & 2) != 0) {
            directive = FirDiagnosticsDirectives.INSTANCE.getFIR_IDENTICAL();
        }
        firIdenticalCheckerHelper.addDirectiveToClassicFileAndAssert(file, directive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void removeDirectiveFromClassicFileAndAssert(@NotNull File testDataFile, @NotNull Directive directiveToRemove, @NotNull String header) {
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        Intrinsics.checkNotNullParameter((Object)directiveToRemove, (String)"directiveToRemove");
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        String directiveName = directiveToRemove.getName();
        if (!isTeamCityBuild) {
            List classicFileContent = FilesKt.readLines$default((File)testDataFile, null, (int)1, null);
            Object object = testDataFile;
            Object object2 = Charsets.UTF_8;
            object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)object2);
            object2 = null;
            try {
                OutputStreamWriter it = (OutputStreamWriter)object;
                boolean bl = false;
                Iterable $this$forEachIndexed$iv = classicFileContent;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void line;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string = (String)item$iv;
                    int index = n;
                    boolean bl2 = false;
                    if (StringsKt.startsWith$default((String)line, (String)("// " + directiveName), (boolean)false, (int)2, null) || index == classicFileContent.size() - 1 && StringsKt.isBlank((CharSequence)((CharSequence)line))) continue;
                    ((Appendable)it).append((CharSequence)line).append('\n');
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        String message = isTeamCityBuild ? "Please remove .fir.txt dump and remove // " + directiveName + " from test source" : "Deleted .fir.txt dump, removed // " + directiveName + " from test source";
        AssertionsKt.getAssertions(this.testServices).fail((Function0<String>)((Function0)() -> FirIdenticalCheckerHelper.removeDirectiveFromClassicFileAndAssert$lambda$5(header, message)));
        throw new KotlinNothingValueException();
    }

    public static /* synthetic */ void removeDirectiveFromClassicFileAndAssert$default(FirIdenticalCheckerHelper firIdenticalCheckerHelper, File file, Directive directive, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: removeDirectiveFromClassicFileAndAssert");
        }
        if ((n & 4) != 0) {
            string = "Dumps via FIR & via old FE are the same";
        }
        firIdenticalCheckerHelper.removeDirectiveFromClassicFileAndAssert(file, directive, string);
    }

    public final void deleteFirFile(@NotNull File testDataFile) {
        block1: {
            File file;
            File file2;
            Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
            if (isTeamCityBuild || (file2 = this.getFirFileToCompare(testDataFile)) == null) break block1;
            File it = file = file2;
            boolean bl = false;
            file2 = it.exists() ? file : null;
            if (file2 != null) {
                file2.delete();
            }
        }
    }

    private static final CharSequence readContent$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trimEnd((CharSequence)it)).toString();
    }

    private static final String addDirectiveToClassicFileAndAssert$lambda$2(String $message) {
        return StringsKt.trimIndent((String)("\n                    Dumps via FIR & via old FE are the same. \n                    " + $message + "\n                    Please re-run the test now\n                "));
    }

    private static final String removeDirectiveFromClassicFileAndAssert$lambda$5(String $header, String $message) {
        return StringsKt.trimIndent((String)("\n                    " + $header + ". \n                    " + $message + "\n                    Please re-run the test now\n                "));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/test/utils/FirIdenticalCheckerHelper$Companion;", "", "<init>", "()V", "isTeamCityBuild", "", "()Z", "tests-common-new_test"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isTeamCityBuild() {
            return isTeamCityBuild;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

